#include "seg_ext.h"

/*
** Implementation of MANUEL postsynaptic conductance transformation
** MANUEL simulation software by D.H Perkel
**
** Does not calculate channel current.
*/
/* 1/89 Matt Wilson */
ManuelConduct(channel,action)
register struct manuelconduct_type *channel;
Action		*action;
{
double 	h;
double 	z;
double 	c;
double 	W;
double 	dt;
double 	V;
MsgIn 	*msg;

    if(debug > 1){
	ActionHeader("ManuelConduct",channel,action);
    }
    SELECT_ACTION(action){
    case INIT:
	channel->activation = 0;
	break;
    case PROCESS:
	dt = Clockrate(channel);
	MSGLOOP(channel,msg){
	case 0:			/* membrane potential */
	    V = MSGVALUE(msg,0);
	    break;
	case 1:		/* channel activation */
	    channel->activation += MSGVALUE(msg,0);
	    break;
	case 2:			/* random channel activation */
	    /*
	    ** 0 = probability (1/time)   1 = amplitude
	    */
	    if(MSGVALUE(msg,0)*Clockrate(channel) > urandom()){
		channel->activation += MSGVALUE(msg,1);
	    }
	    break;
	}
	h = channel->H;
	z = channel->Z;

	W = 1 - h + z + channel->K_r;
	c = (2*z*(1-h))/(W + sqrt(W*W - 4*z*(1-h)));
	/*
	** dz/dt = activation - (z - c)/tau_d - c/tau_g
	** dz/dt = (activation + c/tau_d - c/tau_g) - z*(1/tau_d)
	*/
	z = IntegrateMethod(0,channel,z,
	channel->activation + c/channel->tau_d - c/channel->tau_g,
	1/channel->tau_d,dt,"z");

	/*
	** dh/dt = c/tau_g - h/tau_h
	*/
	h = IntegrateMethod(0,channel,h,
	c/channel->tau_g,
	1/channel->tau_h,dt,"h");

	/*
	** set the new values of the state variables
	*/
	channel->H = h;
	channel->Z = z;
	channel->Gk = channel->gmax*h;
	channel->Ik = (channel->Ek - V)*channel->Gk;
	break;
    case RESET:
	channel->activation = 0;
	channel->H = 0;
	channel->Z = 0;
	channel->Gk = 0;
	break;
    case CHECK:
	if(channel->tau_g <= 0 || channel->tau_h <= 0 || channel->tau_d <= 0){
	    ErrorMessage("ManuelConduct", "Invalid tau parameters.", channel);
	}
	break;
    }
}
