// genesis
/*
************************************************************************
**                       OLF SHELL COMMANDS                           **
************************************************************************
*/

// Function for setting the responses in a list of receptor2 elements
addfunc ranset do_ranset

addaction TABCREATE 200

/*
*************************************************************************
**                              OBJECT TABLE                           **
*************************************************************************
*/
//==========================================================================
//	name		data            function	class	
//==========================================================================

object	receptor	olf_receptor_type OlfReceptor 	segment \
	-author 	"U.S.Bhalla Caltech Jan/90" \
	-actions 	INIT PROCESS RESET CHECK RECALC SAVE2 RESTORE2 \
	-messages 	ODOR 0 	1 strength \		/* type 0: strength */
			GAIN 1	1 sensitivity \	/* type 1: sensitivity */
	-fields		"response[10]	:	weights for each odor" \
			"Vmin,Vmax	:	Range of membrane potentials" \
			"min_rate,max_rate :	range of firing rates" \
	-description	"Does weighted sum of odors to get activity." \
			"Generates both a memb voltage and a spike"

object	receptor2	olf_receptor2_type OlfReceptor2	segment channel \
	-author 	"U.S.Bhalla Caltech Jan/90" \
	-actions 	INIT PROCESS RESET SET CHECK RECALC SAVE2 RESTORE2 \
	-messages 	VOLTAGE		0 	1 Vm \
			ODOR 		1	2 activation odor_no \	
			MODULATION	2	1 modulation \
	-fields		"response[nodors] :	weights for each odor" \
			"nodors		:	Number of odors" \
			"tau1 tau2	:	Time constants of channel" \
			"gmax		:	peak conductance" \
			"Ik		:	channel current" \
			"modulation	:	gain control on responses" \
	-description	"Does weighted sum of odors to get activation" \
			"of a channel with usual conductance properties"

object	disk_in		disk_in_type	DiskIn	 	segment \
	-author 	"U.S.Bhalla Caltech Jan/90" \
	-actions 	INIT PROCESS RESET SET CHECK RECALC \
	-fields		"filename	:	name of data file" \
			"leave_open	:	leave file open between steps" \
			"nx,ny		:	dimensions of input array" \
			"loop		:	return to start of file on EOF"\
			"val		:	input array" \
	-description	"Reads in a 2-d array of data from an ascii file."

object	tabgate		tab_gate_type TabGate	segment gate \
	-author 	"U.S.Bhalla Caltech Feb/90" \
	-actions 	RESET \
			PROCESS \
			TABCREATE \
			*CALC_MINF TabGate_CALC_MINF \
	-messages 	VOLTAGE		0 	1 voltage \
			METHOD 		1	1 integration_method \	
			SUM_ALPHA	2	1 "sum onto alpha func" \
			PRD_ALPHA	3	1 "multiply onto alpha func" \
			SUM_BETA	4	1 "sum onto beta func" \
			PRD_BETA	5	1 "multiply onto beta func" \
	-fields		"m		:	state of gate" \
			"alpha		:	interpol struct for alpha" \
			"beta		:	interpol struct for beta" \
			"instantaneous	:	flag for looking at inst resp" \
	-description	"A gate with tabulated dependencies on any field for" \
			"opening and closing. Voltage and ion conc most" \
			"common fields for dependencies." \
			"The table for the object is created using tabcreate."

object	table		table_type TableFunc	segment \
	-author 	"U.S.Bhalla Caltech Feb/90" \
	-actions 	RESET \
			PROCESS \
			TABCREATE \
	-messages 	INPUT		0 	1 input \
			SUM		1	1 "sum onto table" \
			PRD		2	1 "multiply onto table" \
	-fields		"input		:	input to table" \
			"output		:	output of table" \
			"table		:	interpol struct for table" \
	-description	"A table with a couple of message slots for adding" \
			"dependencies on other fields." \
			"The table for the object is created using tabcreate."
