#include <stdio.h>
#include "olf_ext.h"

int	DEBUG_DiskIn = 0;
static double		savedata[4];

/*
** DiskIn : reads in data from an ascii file on disk to a 2d array
** of variable size. Array is allocated on reset.
*/
/* Jan 90 Upinder S. Bhalla */
DiskIn(disk_in,action)
register struct disk_in_type *disk_in;
Action 	*action;
{
	register float	**val;
	char	cbuf[201];
	char	*temp;
	register int	k,nnum;
	float	x[16];
	int		i,j;
	int		read;
	char	*field;
	int		setval;
	FILE	*fp,*fopen();

    if(Debug(DEBUG_DiskIn) > 1){
		ActionHeader("DiskIn",disk_in,action);
    }
    SELECT_ACTION(action){
    case INIT:
		break;
    case PROCESS:
		if (!disk_in->allocated)
			return;
		val = disk_in->val;
		if (disk_in->is_open) {
			fp = disk_in->fp;
		} else {
			if (!(fp = fopen(disk_in->filename,"r"))) {
				printf("cannot open filename %s\n",disk_in->filename);
				return;
			}
			disk_in->fp = fp;
			disk_in->is_open = 1;
		}
		i = j = 0;
		read = 0;
		while(!read) {
			do {
				temp = fgets(cbuf,200,fp);
				/* Assuming no one will be compulsive enough to put > 16 
				** numbers per line */
				nnum = sscanf(cbuf,"%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f",
					&x[0],&x[1],&x[2],&x[3],&x[4],&x[5],&x[6],&x[7],&x[8],
					&x[9],&x[10],&x[11],&x[12],&x[13],&x[14],&x[15]);
				for (k = 0 ; k < nnum ; k++) {
					val[i][j] = x[k];
					i++;
					if (i >= disk_in->nx) {
						i = 0 ; j++;
						if (j >= disk_in->ny) {
							read = 1;
							break;
						}
					}
				}
			} while((!read) && temp != NULL);
			if (disk_in->loop && temp == NULL && !read) {
				fseek(fp,0,0);
			} else {
				read = 1;
			}
		}
		if (!(disk_in->leave_open)) {
			fclose(fp);
		}

		break;
    case RESET:
		if (!disk_in->allocated) {
			if (disk_in->nx <= 0 || disk_in->ny <= 0)
				return;
			val = disk_in->val =
				(float **) calloc(disk_in->nx,sizeof(float *));
			for (i = 0 ; i < disk_in->nx ; i++)
				val[i] = (float *) calloc(disk_in->ny,sizeof(float));
			disk_in->allocated = 1;
		}
		if (disk_in->is_open) {
			fclose(disk_in->fp);
		}
		if (!(fp = fopen(disk_in->filename,"r"))) {
			printf("Error ... cannot open filename %s\n",
				disk_in->filename);
			return;
		}
		if (disk_in->leave_open) {
			disk_in->fp = fp;
			disk_in->is_open = 1;
		} else {
			fclose(fp);
		}
		break;

	case SET :
		if (action->argc != 2)
			return(0); /* do the normal set */
		field = action->argv[0];
		if (strcmp(field,"nx") != 0 && strcmp(field,"ny") != 0)
			return(0); /* do the normal set */
		setval = atoi(action->argv[1]);

		if (setval < 0) {
			printf("Cannot assign a negative size to array");
			return(1);
		}
		/* Checking if change is necessary */
		if (strcmp(field,"nx") == 0)
			if (setval == disk_in->nx)
				return(1);
		if (strcmp(field,"ny") == 0)
			if (setval == disk_in->ny)
				return(1);

		/* cleaning up the existing array */
		if (disk_in->allocated) {
			val = disk_in->val;
			for (i = 0 ; i < disk_in->nx ; i++)
				free(val[i]);
			free(val);
			disk_in->allocated = 0;
		}

		/* Assigning new array */
		if (strcmp(field,"nx") == 0)
			disk_in->nx = setval;
		if (strcmp(field,"ny") == 0)
			disk_in->ny = setval;
		if (!disk_in->allocated) {
			if (disk_in->nx <= 0 || disk_in->ny <= 0)
				return(1);
			val = disk_in->val =
				(float **) calloc(disk_in->nx,sizeof(float *));
			for (i = 0 ; i < disk_in->nx ; i++)
				val[i] = (float *) calloc(disk_in->ny,sizeof(float));
			disk_in->allocated = 1;
		}
		return(1);
		break;
    case RECALC:
		break;
    case CHECK:
		break;
	}
}
