#include "dev_ext.h"

/*
** an extracellular field potential recording electrode that uses
** current sources and their distance from the electrode site
** to calculate the field.
*/
/* M.Wilson Caltech 2/89 */
ExtracellularRecordingElectrode(amp,action)
register struct efield_type *amp;
Action		*action;
{
MsgIn	*msg;
double	distance;

    if(debug > 1){
	ActionHeader("ExtracellularRecordingElectrode",amp,action);
    }

    SELECT_ACTION(action){
    case PROCESS:
	amp->field = 0;
	MSGLOOP(amp,msg) {
	    case 0:				/* current source */
		/*
		** 0 = current
		** 1 = distance from electrode
		*/
		amp->field += MSGVALUE(msg,0)/MSGVALUE(msg,1);
		break;
	}
	amp->field *= amp->scale; 
	break;
    case RESET:
	amp->field = 0;
	/*
	** compute current source distance
	*/
    case RECALC:
	MSGLOOP(amp,msg) {
	    case 0:				/* current source */
		/*
		** 0 = current
		** 1 = distance from electrode
		*/
		if((distance = sqrt(
		pow(msg->src->x - amp->x,2.0) +
		pow(msg->src->y - amp->y,2.0) +
		pow(msg->src->z - amp->z,2.0)
		)) <= 0){
		    distance = 1e-30;
		};
		*((double *)(msg->slot[1].data)) = distance;
		break;
	}
	break;
    }
}
