#include "struct_defs.h"

/*
*******************************
**         EVENT             **
*******************************
*/
struct variable_type {
	float 	value;
};

/*
*******************************
**         BUFFER            **
*******************************
*/

struct random_type {
    BUFFER_TYPE
    float	state;
    float	rate;
    float	max_amp;
    float	min_amp;
    short	reset;
    float	reset_value;
};

struct playback_type {
    BUFFER_TYPE
    float	state;
};

struct periodic_type {
    BUFFER_TYPE
    float	state;
    float	stime;
    float	scale;
    short	mode;
};

struct spike_type {
    BUFFER_TYPE
    float	state;
    float 	thresh;
    float 	abs_refract;
    float 	output_amp;
};

struct state_type {
    BUFFER_TYPE
    float	state;
};

struct graded_type {
    BUFFER_TYPE
    float	state;
    float 	baseline;
    float 	scale;
    float 	rectify;
};

struct sigmoid_type {
    BUFFER_TYPE
    float	input;
    float	state;
    float 	gain;
    float 	amplitude;
    float 	thresh;
};

struct linear_type {
    BUFFER_TYPE
    float	state;
    float 	gain;
    float 	thresh;
};

struct inject_type {
    BUFFER_TYPE
    float 	inject;
};
