//genesis

function add_squid_graphs(path)
str path, gpath

    create xform {path}/graphs [50,10,1000,550] -title {path}


    // plot membrane potential

    gpath = {path} + "/graphs/Vm"
    create xgraph {gpath} [10, 50, 49%, 49%]  -widgets \
	[NULL, NULL, NULL.right, NULL.bottom] \
	-title "membrane potential" 
    create xbutton {gpath}"scale" [10, 50, 50, 15]  -widgets \
	[NULL, NULL, NULL, NULL] \
	-title "scale" -script "set_scale "{gpath}
    set {gpath} XUnits "t (msec)" YUnits "voltage (mV)"
    set {gpath} xmax 20 ymin -20 ymax 120

 
    // plot injection currents
  
    gpath = {path} + "/graphs/inj"
    create xgraph {gpath} [0, 10, 49%, 10]  -widgets \
	[Vm.left, Vm.bottom, NULL.right, NULL.bottom] \
	-title "injection current" 
    create xbutton {gpath}"scale" [0, 10, 50, 15]  -widgets \
	[Vm.left, Vm.bottom, NULL, NULL] \
	-title "scale" -script "set_scale "{gpath}
    set {gpath} XUnits "t (msec)" YUnits "current (uA)"
    set {gpath} xmax 20 ymin -0.5 ymax 0.5 

    
    // plot channel conductances

    gpath = {path} + "/graphs/Gk"
    create xgraph {gpath} [10, 50, 10, 49%] -widgets \
	[Vm.right, NULL, NULL.right, NULL.bottom] \
	-title "channel conductance" 
    create xbutton {gpath}"scale" [10, 50, 50, 15] -widgets \
	[Vm.right, NULL, NULL, NULL] \
	-title "scale" -script "set_scale "{gpath}
    set {gpath} XUnits "t (msec)" YUnits "conductance (mS)"
    set {gpath} xmax 20 ymin 0.0 ymax 0.5


    // plot channel currents
   
    gpath = {path} + "/graphs/Ik"
    create xgraph {gpath} [0, 10, 10, 10] -widgets \ 
	[Gk.left, Gk.bottom, NULL.right, NULL.bottom] \
	-title "channel current" 
    create xbutton {gpath}"scale" [0, 10, 50, 15] -widgets \ 
	[Gk.left, Gk.bottom, NULL, NULL] \
	-title "scale" -script "set_scale "{gpath}
    set {gpath} XUnits "t (msec)" YUnits "current (uA)"
    set {gpath} xmax 20 ymin -10 ymax 10


    setclock 1 0.1
    graphclock {path} 1
    showgraphics {path}
end

function set_scale(gpath)
    str gpath
    float xmin, xmax, ymin, ymax, overlay
    xmin = get({gpath},xmin)
    xmax = get({gpath},xmax)
    ymin = get({gpath},ymin)
    ymax = get({gpath},ymax)
    overlay = get({gpath},overlay)

    ce /forms/gscale
    set -env /forms/gscale gpath {gpath}
    set xmin value {xmin}
    set xmax value {xmax}
    set ymin value {ymin}
    set ymax value {ymax}
    set overlay value {overlay}
    xshow .
end
