// genesis

//
//==============================
// GLOBAL VARIABLE DEFINITIONS
//==============================
//

float	PI		=	3.14159

//
// Ion concentrations inside and outside squid axons 
// (from KNM, p 119)
//
float K_in_squid	=	400	// mM
float K_out_squid	=	 10	// mM
float Na_in_squid	=	 50	// mM
float Na_out_squid	=	460	// mM
float Cl_in_squid	=	100	// mM
float Cl_out_squid	=	540	// mM
float Ca_in_squid	=	0.0001	// mM
float Ca_out_squid	=	10	// mM

//
// Specific membrane capacitance and conductances, 
// (from HH, J. Physiol. 117, 500-544 (1952) - Table 3) 
//
float Cm_squid		=	  1	// uF/cm^2
float GNa_squid		=	120	// mmho/cm^2
float GK_squid		=	 36	// mmho/cm^2
float Gleak_squid	=	  0.3	// mmho/cm^2

// Specific axial resistance (KNM, p 171)
float Ra_squid		=	0.030	// kohm-cm

//
// Vvoltages (from HH, J. Physiol. 117, 500-544 (1952) - Table 3,
// but with opposite sign convention) 
//
float Vrest_squid	=	  0.0	// mV
float Vleak_squid	=	 10.613	// mV
float VNa_squid		=	115	// mV
float VK_squid		=	-12	// mV
