float	LGN_SEPX = 80e-6
float	LGN_SEPY = 80e-6
float	LGN_SEPZ = 1e-3
float	LGN_NX = 5
float	LGN_NY = 5

float	curr_time = 0.0000
float	dt = 0.001

create xform /Simulation_History [20,20,600,800]
ce /Simulation_History
create xdraw draw \
     -wx {2.5 * (LGN_SEPX * LGN_NX)} -wy {2.5 * (LGN_SEPY * LGN_NY)} \
     -vz 300 -transform ortho3d
	set ^ refresh_flag FALSE

ce draw

create xfileview horiz -path horiz_disk \
	-ox {-0.6 * LGN_SEPX * LGN_NX}  -oz {5 * LGN_SEPZ} \
	-autoscale FALSE -vmin -0.09 -vmax 0.05

create xfileview vert -path vert_disk \
	-ox {0.6 * LGN_SEPX * LGN_NX}  -oz {-5 * LGN_SEPZ} \
	-autoscale FALSE -vmin -0.09 -vmax 0.05

when . click1 do "decr_time"
when . click2 do "plotviewgraph <widget>"
when . click3 do "incr_time"

create xbutton zero_time -script "zero_time" \
	[2%,5,15%,30] -widgets [NULL,draw.bottom,NULL,NULL]
create xdialog timestep -script "set_timestep <widget>" -value {dt} \
	[10,5,30%,30] -widgets [zero_time.right,draw.bottom,NULL,NULL]
create xdialog current_time -script "set_time <widget>" \
	-value {curr_time} \
	[10,5,30%,30] -widgets [timestep.right,draw.bottom,NULL,NULL]
create xbutton movie -script "movie" \
	[10,5,15%,30] -widgets [current_time.right,draw.bottom,NULL,NULL]

function zero_time
	curr_time = 0
	set /Simulation_History/draw/current_time value {curr_time}
end

function set_timestep(widget)
str widget
	dt = {get({widget},value)}
end

function display_time 
	ce /Simulation_History/draw
	set vert time {curr_time}
	set horiz time {curr_time}
	xupdatepix . vert
	xupdatepix . horiz
	set current_time value {curr_time}
end 

function set_time(widget)
str widget
	curr_time = {get({widget},value)}
	display_time
end

function movie
	for (curr_time = 0.0 ; curr_time < 0.05 ; curr_time = curr_time + dt)
		display_time
	end
	set /Simulation_History/draw/current_time value {curr_time}
end

function incr_time 
	curr_time = curr_time + dt
	display_time
end

function decr_time 
	curr_time = curr_time - dt
	display_time
end

//===================================================================

ce ..

create xgraph graph -title "Membrane Potential Vm in mV."  \
    -range [0,-0.09,0.1,0.05]  


create xdialog index -script plotindex -value 12 \
    [2%,5,20%,30] -widgets [NULL,graph.bottom,NULL,NULL]
create xdialog filename -script plotindex -value vert_disk \
    [10,5,30%,30] -widgets [index.right,graph.bottom,NULL,NULL]

create xdialog /Simulation_History/xmin -script "setxrange" -value 0 \
    [10,5,20%,30] -widgets [filename.right,graph.bottom,NULL,NULL]
create xdialog /Simulation_History/xmax -script "setxrange" -value 0.1 \
    [10,5,20%,30] -widgets [xmin.right,graph.bottom,NULL,NULL]

create xbutton /Simulation_History/quit -script quit
xshow /Simulation_History
//===================================================================

function setxrange
	ce /Simulation_History
    set graph xmin {get(xmin,value)}
    set graph xmax {get(xmax,value)}
end


function plotindex
    str index,filename
    index = get(/Simulation_History/index,value)
    filename = get(/Simulation_History/filename,value)
    xsimplot /Simulation_History/graph -c {index} {filename}
end

function plotviewgraph(widget)
str widget
str elm
int index
    index = {get({widget},value)}
	elm = {get({widget},pixchoose)}
    set /Simulation_History/index value {index}
    if (strcmp({elm},vert) == 0)
        set /Simulation_History/filename value vert_disk
    else 
        set /Simulation_History/filename value horiz_disk
    end
    plotindex
end

