//genesis

	float bar_x,bar_y,bar_w,bar_h,bar_dx,bar_dy
	float baserate = 50
/* 
** Bar generates a bar-shaped pattern of activity in the 
** retina rec cells.
**
** rate is in spikes/sec
*/
function bar(x,y,w,h,rate)
float x,y,w,h,rate
float x1,y1,x2,y2
	x1 = x - w/2
	y1 = y - h/2
	x2 = x + w/2
	y2 = y + h/2
/* Here we are using advanced wildcarding features to create a list
** of elements to be used (by the set command)  based on their
** x and y positions. 
*/
	set /retina/recplane/rec[x>{x1}][y>{y1}][x<{x2}][y<{y2}]/input rate {rate}
end

// Sweeps a bar from left to right across the visual field 
function do_autosweep
	set /retina/recplane/rec[]/input rate {baserate}
	bar_x = bar_x + bar_dx;
	bar_y = bar_y + bar_dy;
	bar {bar_x} {bar_y} {bar_w} {bar_h} {get(/control/bar_firing_rate,value)}
end

// a dummy function
function do_nothing
end

/* autosweep calculates the parameters for the bar and sweep rate, then
** causes the simulator to step the appropriate number of times, then
** cleans up. */
function autosweep(widget)
str widget
	float vel 
	int	nsteps

	vel = {get({widget},value)}
	bar_x = {-0.5 * REC_NX * REC_SEPX}
	bar_y = 0
	bar_w = {2 * REC_SEPX}
	bar_h = {REC_NY * REC_SEPY}
	bar_dx = {REC_SEPX * vel}
	bar_dy = 0
	nsteps = {REC_NX / vel - 1}
	set /output/each_step command do_autosweep
	reset
	echo sweeping bar across {REC_NX} cells in {nsteps} timesteps
	step {nsteps}
	echo finished {nsteps} steps
	set /output/each_step command do_nothing
	call /output/each_step RECALC 
	/* setting the command does not change the actual command stored,
	** so we force the change using the RECALC. To be fixed !! */
end

/* The script_out elements execute the script defined in their 'command'
** field every timestep. */
create script_out /output/each_step 
set /output/each_step command do_nothing

/* If change the clock used by a script_out element to one with another
** period, we can get commands executed different rates. Here, 
** clock 1 starts up at 1/10 the simulation clock rate so the script
** is executed every 10 timesteps */
create script_out /output/refresh_out
set /output/refresh_out command do_refresh
useclock /output/refresh_out 1
