//genesis

function do_rel_position(src,x,y,z)
	str src
	float x,y,z
	int nmsgs,i

	float tx,ty,tz
	str child

	nmsgs = getmsg({src},IN,-count)

	tx = x + get({src},x)
	ty = y + get({src},y)
	tz = z + get({src},z)
	set {src} x {tx}
	set {src} y {ty}
	set {src} z {tz}

	for(i = 0 ; i < nmsgs ; i = i + 1)
		if (strcmp({getmsg({src},IN,{i},type)},RAXIAL) == 0)
			child = getmsg({src},IN,{i},src)
			do_rel_position {child} {x} {y} {z}
		end
	end
end

function do_rel_position(src,x,y,z)
	/* testing the C version of the routine. */
	rel_position({src},{x},{y},{z})
end

function do_z_rotate(name,x,y,sin,cos)
	str name
	float x,y,sin,cos

	int nmsgs,i
	str child
	float dx,dy

	nmsgs = getmsg({name},IN,-count)

	for(i = 0 ; i < nmsgs ; i = i + 1)
		if (strcmp({getmsg({name},IN,{i},type)},RAXIAL) == 0)
			child = getmsg({name},IN,{i},src)
			do_z_rotate {child} {x} {y} {sin} {cos}
		end
	end

	dx = get({name},x) - x
	dy = get({name},y) - y
	set {name} x {x + cos * dx - sin * dy}
	set {name} y {y + sin * dx + cos * dy}
end

function do_x_rotate(name,y,z,sin,cos)
	str name
	float y,z,sin,cos

	int nmsgs,i
	str child
	float dy,dz

	nmsgs = getmsg({name},IN,-count)

	for(i = 0 ; i < nmsgs ; i = i + 1)
		if (strcmp({getmsg({name},IN,{i},type)},RAXIAL) == 0)
			child = getmsg({name},IN,{i},src)
			do_x_rotate {child} {y} {z} {sin} {cos}
		end
	end

	dy = get({name},y) - y
	dz = get({name},z) - z
	set {name} y {y + cos * dy - sin * dz}
	set {name} z {z + sin * dy + cos * dz}
end


function do_y_rotate(name,x,z,sin,cos)
	str name
	float x,z,sin,cos

	int nmsgs,i
	str child
	float dx,dz

	nmsgs = getmsg({name},IN,-count)

	for(i = 0 ; i < nmsgs ; i = i + 1)
		if (strcmp({getmsg({name},IN,{i},type)},RAXIAL) == 0)
			child = getmsg({name},IN,{i},src)
			do_y_rotate {child} {x} {z} {sin} {cos}
		end
	end

	dx = get({name},x) - x
	dz = get({name},z) - z
	set {name} x {x + cos * dx - sin * dz}
	set {name} z {z + sin * dx + cos * dz}
end

function scale_el_props(elm,ratio,scope)
	str elm
	float ratio
	int scope

	float temp
	float nmsgs,i
	str name

	temp = get({elm},Ra)
	set {elm} Ra {temp * ratio}
	temp = get({elm},Rm)
	set {elm} Rm {temp / ratio}
	temp = get({elm},Cm)
	set {elm} Cm {temp * ratio}
	if (scope == 0)
		return
	end
	nmsgs = getmsg({elm},IN,-count)

	for(i = 0 ; i < nmsgs ; i = i + 1)
		if (strcmp({getmsg({elm},IN,{i},type)},RAXIAL) == 0)
			name = getmsg({elm},IN,{i},src)
			scale_el_props {name} {ratio} 1
		end
	end
end


function do_stretch
	str elm,parent
	float cos,sin
	float dotprd,crossprd
	float dx,dy,dz,ex,ey,ez,px,py,pz,elx,ely,elz
	float len
	float init_len,final_len,ratio
	int nmsgs,i

	if (strcmp({get(/compt_select/draw,transform)},ortho3d) == 0)
		echo Draw transform should be one of z2d,y2d,x2d.
		return
	end

	elm = comptpath
	nmsgs = getmsg({elm},IN,-count)
	for (i = 0 ; i < nmsgs ; i = i + 1)
		if (strcmp({getmsg({elm},IN,{i},type)},AXIAL) == 0)
			parent = getmsg({elm},IN,{i},src)
		end
	end

	elx = get({elm},x)
	ely = get({elm},y)
	elz = get({elm},z)
	px = get({parent},x)
	py = get({parent},y)
	pz = get({parent},z)

	init_len = (elx - px) * (elx - px) + (ely - py) * (ely - py) + \
		(elz - pz) * (elz - pz)

	if (strcmp({get(/compt_select/draw,transform)},z2d) == 0)
		dx = click1(x) - px
		dy = click1(y) - py
		ex = elx - px
		ey = ely - py
		dotprd = dx * ex + dy * ey
		crossprd = ex * dy - dx * ey
		len = ex * ex + ey * ey
		cos = dotprd / len
		sin = crossprd / len 
		dx = cos * ex - sin * ey - ex
		dy = sin * ex + cos * ey - ey
		if ({get(/compt_select/scope,state)} == 0)
			do_rel_position {elm} {dx} {dy} 0
		else
			do_z_rotate {elm} {px} {py} {sin} {cos}
		end
	end
	if (strcmp({get(/compt_select/draw,transform)},x2d) == 0)
		dz = click1(z) - pz
		dy = click1(y) - py
		ez = elz - pz
		ey = ely - py
		dotprd = dz * ez + dy * ey
		crossprd = dz * ey - ez * dy
		len = ez * ez + ey * ey
		cos = dotprd / len
		sin = crossprd / len 
		dy = cos * ey - sin * ez - ey
		dz = sin * ey + cos * ez - ez
		if ({get(/compt_select/scope,state)} == 0)
			do_rel_position {elm} 0 {dy} {dz}
		else
			do_x_rotate {elm} {py} {pz} {sin} {cos}
		end
	end
	if (strcmp({get(/compt_select/draw,transform)},y2d) == 0)
		dx = click1(x) - px
		dz = click1(z) - pz
		ex = elx - px
		ez = elz - pz
		dotprd = dx * ex + dz * ez
		crossprd = ex * dz - dx * ez
		len = ex * ex + ez * ez
		cos = dotprd / len
		sin = crossprd / len 
		dx = cos * ex - sin * ez - ex
		dz = sin * ex + cos * ez - ez
		if ({get(/compt_select/scope,state)} == 0)
			do_rel_position {elm} {dx} 0 {dz}
		else
			do_y_rotate {elm} {px} {pz} {sin} {cos}
		end
	end

	elx = get({elm},x)
	ely = get({elm},y)
	elz = get({elm},z)
	final_len = (elx - px) * (elx - px) + (ely - py) * (ely - py) + \
		(elz - pz) * (elz - pz)
	ratio = sqrt({final_len/init_len})
	scale_el_props({elm},{ratio},{get(/compt_select/scope,state)})

	set /compt_select/draw/cell path {cellpath}/##[TYPE=compartment]
end

function do_rotate

	str elm,parent
	float cos,sin
	float dotprd,crossprd
	float dx,dy,dz,ex,ey,ez,px,py,pz,elx,ely,elz
	float len
	int nmsgs,i

	elm = comptpath
	nmsgs = getmsg({elm},IN,-count)
	for (i = 0 ; i < nmsgs ; i = i + 1)
		if (strcmp({getmsg({elm},IN,{i},type)},AXIAL) == 0)
			parent = getmsg({elm},IN,{i},src)
		end
	end

	elx = get({elm},x)
	ely = get({elm},y)
	elz = get({elm},z)
	px = get({parent},x)
	py = get({parent},y)
	pz = get({parent},z)

	if (strcmp({get(/compt_select/draw,transform)},z2d) == 0)
		dx = click1(x) - px
		dy = click1(y) - py
		ex = elx - px
		ey = ely - py
		dotprd = dx * ex + dy * ey
		crossprd = ex * dy - dx * ey
		len = sqrt({dx * dx + dy * dy})
		len = len * sqrt({ex * ex + ey * ey})
		cos = dotprd / len
		sin = crossprd / len 
		dx = cos * ex - sin * ey - ex
		dy = sin * ex + cos * ey - ey
		if ({get(/compt_select/scope,state)} == 0)
			do_rel_position {elm} {dx} {dy} 0
		else
			do_z_rotate {elm} {px} {py} {sin} {cos}
		end
	end
	if (strcmp({get(/compt_select/draw,transform)},x2d) == 0)
		dz = click1(z) - pz
		dy = click1(y) - py
		ez = elz - pz
		ey = ely - py
		dotprd = dz * ez + dy * ey
		crossprd = dz * ey - ez * dy
		len = sqrt({dz * dz + dy * dy})
		len = len * sqrt({ez * ez + ey * ey})
		cos = dotprd / len
		sin = crossprd / len 
		dy = cos * ey - sin * ez - ey
		dz = sin * ey + cos * ez - ez
		if ({get(/compt_select/scope,state)} == 0)
			do_rel_position {elm} 0 {dy} {dz}
		else
			do_x_rotate {elm} {py} {pz} {sin} {cos}
		end
	end
	if (strcmp({get(/compt_select/draw,transform)},y2d) == 0)
		dx = click1(x) - px
		dz = click1(z) - pz
		ex = elx - px
		ez = elz - pz
		dotprd = dx * ex + dz * ez
		crossprd = ex * dz - dx * ez
		len = sqrt({dx * dx + dz * dz})
		len = len * sqrt({ex * ex + ez * ez})
		cos = dotprd / len
		sin = crossprd / len 
		dx = cos * ex - sin * ez - ex
		dz = sin * ex + cos * ez - ez
		if ({get(/compt_select/scope,state)} == 0)
			do_rel_position {elm} {dx} 0 {dz}
		else
			do_y_rotate {elm} {px} {pz} {sin} {cos}
		end
	end
	if (strcmp({get(/compt_select/draw,transform)},ortho3d) == 0)
		echo Draw transform should be one of z2d,y2d,x2d.
	else
		set /compt_select/draw/cell path {cellpath}/##[TYPE=compartment]
	end
end

