Making a new library
--------------------

To compile a new library you should follow this procedure.

Step 1:
-------
set up a directory to contain the new library and all of the 
code files to go into it. For example
	
	mkdir new

where 'new' will be the location of the new library.

Step 2:
-------
Copy the library makefile 'Libmake' found in the genesis system
directory (e.g. /usr/genesis) into the new library directory.

	cp /usr/genesis/Libmake new/Makefile

This file will have to be edited to suit your specific code files.
This will be discussed later.

Step 3:
-------
Place your source code files (.c and .h files) into this directory.
Your .c files should contain shell functions of the form

    do_myfunc(argc,argv)
    int argc;
    char **argv;
    {
    }

or object functions of the form

    MyObject(element,action)
    struct my_struct *element;
    Action *action;
    {
    }

The names of these functions is arbitrary as long as they do not
conflict with existing function names. If there is a conflict it
will be reported during the link phase of compilation
as a multiply defined function. In this case the function should be
renamed. As a suggested convention, all shell functions should be
prefixed with 'do_'.

The files which contain these functions should be of the form

    #include "my_ext.h"

    function1()
    {
    }

    function2()
    {
    }

    etc..

The file 'my_ext.h' is a header file which should contain variable
and structure declarations. The name of this file is arbitrary.

Step 4:
-------
Create the header file used in step 3 (e.g. "my_ext.h").
This file should have the form

    #include "sim_ext.h"
    #include "my_struct.h"

The file 'sim_ext.h' is a specific genesis header file which must
be included. "my_struct.h" is a user-defined file which must be created.

Step 5:
-------
Create the structure declaration file used in step 4 (e.g. "my_struct.h").

Step 5.1:
---------
If new object functions are being added this file be of the form

    #include "struct_defs.h"

    struct mystruct {
	TYPE
	fields ...
    };

    struct another_struct {
	TYPE
	other_fields ...
    };

    etc ...

The structure names (e.g. mystruct) are arbitrary but must not conflict with
any existing structure names. 
'TYPE' specifies a list of basic object fields.
It should be selected from one of:
	ELEMENT_TYPE
	BUFFER_TYPE
	SEGMENT_TYPE
	CONNECTION_TYPE
	PROJECTION_TYPE
depending on the class of the object.
The 'fields' of the structure are completely user defined.
For example, a new segment class object might have a structure
definition like:

    struct mystruct {
	SEGMENT_TYPE
	float	state;
	int	count;
    };

Step 5.2:
---------
If no new structure definitions are to be added then simply create
an empty structure file. This can be accomplished using the UNIX
shell command

	touch "my_struct.h"

Step 6:
-------
Create a function list file containing the names of any new
Object or shell functions. The name of this file is arbitrary.
For example, create the file 'newfuncs' and add the names of the
functions given in Step 3.

    do_myfunc
    MyObject

Step 7:
-------
Edit the Makefile for the library.
There will be a list of six variables which must be set. These variables
are:

GENESIS		= /usr/genesis-v0.8
LIBRARY_NAME 	= user
FUNCTIONS 	= userfuncs
STRUCTURES 	= user_struct.h
EXT_HEADER	= user_ext.h
OBJECTS 	= 

Step 7.1
--------
GENESIS should contain the name of the genesis system files. For example

    GENESIS		= /usr/genesis-v0.8

Step 7.2
--------
LIBRARY_NAME is the name that you will use to refer to this library. It
can be any name which does not conflict with existing libraries. For
example using the specification in step 1:

    LIBRARY_NAME	= new

Step 7.3
--------
FUNCTIONS is the name of the function list file created in Step 6. For
example:

    FUNCTIONS		= newfuncs

Step 7.4
--------
STRUCTURES is the name of the .h file containing the structure
definitions created in Step 5. Only one filename is allowed. For example:

    STRUCTURES 		= new_struct.h

Step 7.5
--------
EXT_HEADER is the name of the external header file created in Step 4.
Only one filename is allowed.  For example:

    EXT_HEADER		= user_ext.h

Step 7.5
--------
OBJECTS is the list of object files (.o files) to be included in the
new library. The names of these files should be the same as the
source code (.c) files with the .c extension changed to .o
For example with source code files newcode.c and othercode.c 

    OBJECTS 		= newcode.o othercode.o 

Step 8
------
To make the library, from the UNIX shell command line type:

	make

This should produce a file called LIBRARY_NAMElib.o, where LIBRARY_NAME
is the name specified in Step 7.2. For example using the specification
given in Step 7.2, make should produce a library file called

	newlib.o

