/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.1/kernel/sources/RCS/cc_rcc.h,v $
  SHORTNAME      : 
  SNNS VERSION   : 4.1

  PURPOSE        : Header file of correspondent '.c' file
  NOTES          :

  AUTHOR         : Michael Schmalzl
  DATE           : 5.2.92

  CHANGED BY     : Michael Schmalzl
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 2.6 $
  LAST CHANGE    : $Date: 1995/11/16 12:02:03 $

             Copyright (c) 1990-1995  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/
#ifndef _CC_RCC_DEFINED_
#define  _CC_RCC_DEFINED_

/* begin global definition section */

extern krui_err cc_freeStorage(int StartPattern, int EndPattern, int flag);
extern void rcc_manageResetArray(int startPattern, int endPattern, int flag);
extern void rcc_manageLinkArray(int newNoOfSpecialUnits, int flag);
extern krui_err cc_deleteAllSpecialAndAllHiddenUnits(void);
extern krui_err cc_allocateStorage(int StartPattern,int EndPattern, int NoOfSpecialUnits);
extern krui_err kr_topoSort(int type);
extern krui_err krui_setUnitActFunc(int unitNo, char *name);
extern void cc_initErrorArrays(void);
extern void cc_initActivationArrays(void);
extern void cc_printTopoPtrArray(void);
extern void cc_printUnitArray(void);
extern FlintType cc_generateRandomNo(float maxValue);
extern void cc_printUnit(struct Unit *unitPtr);
extern void cc_printAllLinks(struct Unit *unitPtr);  
extern void cc_compareActFunctions(int actFunc,int flag);
extern krui_err cc_changeActFuncOfSpecialUnits(int type,int LearnFunc);
extern krui_err cc_calculateNetParameters(int *maxYPosOfHiddenUnit,int *xPosOfLastInsertedHiddenUnit,
                                          int *yPosOfLastInsertedHiddenUnit,int *outputXMax);
extern void cc_initOutputUnits(void);
extern float cc_calculateCorrelation(int StartPattern,int EndPattern,int counter);
extern void cc_initInputUnitsWithPattern(int PatternNo);
extern krui_err cc_setHiddenUnit(struct Unit *hiddenUnitPtr,int maxYPosOfHiddenUnit,
                                 int *xPosOfLastInsertedHiddenUnit,int *yPosOfLastInsertedHiddenUnit);
extern krui_err cc_setPointers(void);
extern krui_err cc_initSpecialUnitLinks(void);
extern void cc_updatePosOfSpecialUnits(void);
extern krui_err cc_deleteAllSpecialUnits(void); 


extern struct CC_DATA cc_data; 
extern char *cc_onOffArray[];  
extern char *cc_actFuncArray[]; 
extern char *cc_learningFuncArray[];
extern char *cc_pruningFuncArray[];
extern char *rcc_actFuncArray[];
extern int cc_end;
extern int cc_storageFree;
extern int cc_allButtonIsPressed;
extern int cc_cascadeFlag;
extern int rcc_currentPattern;
/* pcc */
extern int   LastInsertedHiddenUnit;
extern int cc_backfittingOnOff;

extern struct Unit  **FirstInputUnitPtr,**FirstHiddenUnitPtr,
                    **FirstOutputUnitPtr,**FirstSpecialUnitPtr,
                    *bestSpecialUnitPtr;

extern float **OutputUnitError;
extern float **SpecialUnitAct;
extern float **CorBetweenSpecialActAndOutError;
extern float *OutputUnitSumError;
extern float *SpecialUnitSumAct;

extern void (*cc_trainSpecialUnits)(int maxNoOfCovarianceUpdateCycles, float minCovarianceChange, 
                                 int specialPatience,int StartPattern,int EndPattern,
                                 float param4, float param5, float param6, int MaxSpecialUnitNo);
extern void (*cc_trainOutputUnits)(int maxNoOfErrorUpdateCycles, int backfittPatience, float minErrorChange, 
                                int outPatience, int StartPattern,int EndPattern,
                                float param1,float param2, float param3,
                                float **ParameterOutArray,int *NoOfOutParams);

extern int cc_update;
extern float SumSqError;
extern int cc_printOnOff;
extern int *reset;
extern float **linkArray;
extern int cc_cascade;

/* end  global definition section */

/* begin privat definition section */
/* end privat definition section */

#endif /* _CC_RCC_DEFINED_ */
