/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.1/xgui/sources/RCS/cc_main.c,v $
  SHORTNAME      : cc_main.c
  SNNS VERSION   : 4.1

  PURPOSE        : Creates the CASCADE-window. 
  NOTES          :

  AUTHOR         : Michael Schmalzl, modified by Christian Wehrfritz (PCC)  
  DATE           : 23.2.93

  CHANGED BY     : Michael Schmalzl
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 2.8 $
  LAST CHANGE    : $Date: 1995/11/16 07:15:48 $

             Copyright (c) 1990-1995  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/cursorfont.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/Grip.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/SimpleMenu.h>

#include "ui.h"
#include "ui_xWidgets.h"
#include "kr_typ.h"
#include "kr_ui.h"
#include "glob_typ.h" 
#include "ui_netUpdate.h"
#include "ui_display.h"
#include "ui_main.h"
#include "ui_mainP.h"
#include "ui_confirmer.h"
#include "cc_type.h"
#include "cc_mac.h"
#include "cc_rcc.h"
#include "ui_control.h"
#include "done.xbm"
#include "delete_cand_units.xbm"
#include "ui_key.h"

#include "cc_main.ph"

/*****************************************************************************
  FUNCTION :

  PURPOSE  : 
  NOTES    :

  UPDATE   : 8.2.93
******************************************************************************/

static void cc_centerString(char *string, int length1, int length2)
{
 int i,difference,move;

 if((difference=(length2 - length1)) >=2) {
   move = difference / 2;
   for(i=length1-1;i>=0;i--) {
     string[i+move] = string[i];
   }
   for(i=0;i<move;i++){
     string[i] = ' ';
   }
 }
}
       

/*****************************************************************************
  FUNCTION :

  PURPOSE  : 
  NOTES    :

  UPDATE   : 8.2.93
******************************************************************************/

static void cc_selectActFuncCand(Widget w, int value, caddr_t call_data)
{
 switch(value) {
   case ASYM_SIGMOID: ui_xSetLabel(cc_w10b,"Act_Logistic");
                      break;
   case SYM_SIGMOID : ui_xSetLabel(cc_w10b,"Act_LogSym");
                      break;
   case TANH        : ui_xSetLabel(cc_w10b,"Act_TanH");
                      break;
   case RANDOM      : ui_xSetLabel(cc_w10b,"Act_Random");
                      break;
 }
 cc_data.CAND.actFunc = cc_candActFunc = value;
}

/*****************************************************************************
  FUNCTION :

  PURPOSE  : 
  NOTES    :

  UPDATE   : 8.2.93
******************************************************************************/

static void cc_selectOnOff(Widget w, int value, caddr_t call_data)
{
 switch(value) {
   case ON:   ui_xSetLabel(cc_w13b,"on");
              break;
   case OFF : ui_xSetLabel(cc_w13b,"off");
              break;
 }
 cc_data.GLOBAL.onOff = cc_onOff = value;
}
/*****************************************************************************
  FUNCTION :

  PURPOSE  : 
  NOTES    :

  UPDATE   : 8.2.93
******************************************************************************/
static void cc_selectPruneOnOff(Widget w, int value, caddr_t call_data)
{
 switch(value) {
   case ON:   ui_xSetLabel(cc_w15b,"on");
              break;
   case OFF : ui_xSetLabel(cc_w15b,"off");
              break;
 }
 cc_data.GLOBAL.pruneOnOff = cc_pruneOnOff = value;
}

/*****************************************************************************
  FUNCTION :

  PURPOSE  : 
  NOTES    :

  UPDATE   : 8.2.93
******************************************************************************/
static void cc_selectBackfittOnOff(Widget w, int value, caddr_t call_data)
{
 switch(value) {
   case ON:   ui_xSetLabel(cc_w17b,"on");
              break;
   case OFF : ui_xSetLabel(cc_w17b,"off");
              break;
 }
 cc_data.GLOBAL.backfittOnOff = cc_backfittOnOff = value;
}

/*****************************************************************************
  FUNCTION :

  PURPOSE  : 
  NOTES    :

  UPDATE   : 8.2.93
******************************************************************************/
static void cc_selectLearningFunc(Widget w, int value, caddr_t call_data)
{
 switch(value) {
   case QUICKPROP: ui_xSetLabel(cc_w11b,"Quickprop");
                   break;
   case BACKPROP : ui_xSetLabel(cc_w11b,"Backprop");
                   break;
   case RPROP    : ui_xSetLabel(cc_w11b,"Rprop");
                   break;
 }
 cc_data.GLOBAL.learningFunc = cc_learningFunc = value;
}
/*****************************************************************************
  FUNCTION :

  PURPOSE  : 
  NOTES    :

  UPDATE   : 8.2.93
******************************************************************************/
static void cc_selectPruneFunc(Widget w, int value, caddr_t call_data)
{
 switch(value) {
 case SBC:   ui_xSetLabel(cc_pfb,"SBC");
   break;
 case AIC:   ui_xSetLabel(cc_pfb,"AIC");
   break;
 case CMSEP: ui_xSetLabel(cc_pfb,"CMSEP");
   break;
 }
 cc_data.GLOBAL.pruneFunc = cc_pruneFunc = value;
}

/*****************************************************************************
  FUNCTION :

  PURPOSE  : 
  NOTES    :

  UPDATE   : 8.2.93
******************************************************************************/

static void cc_deleteCandUnits(Widget w, int value, caddr_t call_data)
{
 cc_deleteAllSpecialUnits();
 ui_net_completeRefresh(ui_currentDisplay,2);
}

/*****************************************************************************
  FUNCTION :

  PURPOSE  : 
  NOTES    :

  UPDATE   : 8.2.93
******************************************************************************/

void cc_readElements(void)
{

 if((cc_onOff == -1) || (cc_learningFunc == -1) || (cc_candActFunc == -1) ||
   (cc_pruneFunc == -1)) {
   cc_onOff        = cc_data.GLOBAL.onOff;
   cc_pruneOnOff   = cc_data.GLOBAL.pruneOnOff;
   cc_pruneFunc    = cc_data.GLOBAL.pruneFunc;
   cc_backfittOnOff= cc_data.GLOBAL.backfittOnOff;
   cc_learningFunc = cc_data.GLOBAL.learningFunc;
   cc_candActFunc  = cc_data.CAND.actFunc;
 }

 if(cc_open) {
   cc_data.GLOBAL.pixelError         = ui_xFloatFromAsciiWidget(cc_w9b);
   cc_data.GLOBAL.learningFunc       = cc_learningFunc;
   cc_data.GLOBAL.onOff              = cc_onOff;
   cc_data.GLOBAL.pruneOnOff         = cc_pruneOnOff;
   cc_data.GLOBAL.pruneFunc          = cc_pruneFunc;
   /* cc_data.GLOBAL.backfittOnOff      = cc_backfittOnOff;
    * cc_data.GLOBAL.backfittPatience   = ui_xIntFromAsciiWidget(cc_w19b);
    */
   cc_data.CAND.covarianceChange     = ui_xFloatFromAsciiWidget(cc_w1b);
   cc_data.CAND.candidatePatience    = ui_xIntFromAsciiWidget(cc_w2b); 
   cc_data.CAND.maxNoOfUpdateCycles  = ui_xIntFromAsciiWidget(cc_w3b);
   cc_data.CAND.maxNoOfCandUnits     = ui_xIntFromAsciiWidget(cc_w7b); 
   cc_data.CAND.actFunc              = cc_candActFunc;
   cc_data.OUT.errorChange           = ui_xFloatFromAsciiWidget(cc_w4b);
   cc_data.OUT.outputPatience        = ui_xIntFromAsciiWidget(cc_w5b);
   cc_data.OUT.maxNoOfUpdateCycles   = ui_xIntFromAsciiWidget(cc_w6b);
 }
 ui_learnParameters[6] = cc_data.GLOBAL.pixelError;       
 ui_learnParameters[7] = (float)cc_data.GLOBAL.learningFunc;   
 ui_learnParameters[8] = (float)cc_data.GLOBAL.onOff; 
          
 ui_learnParameters[9]  = cc_data.CAND.covarianceChange;  
 ui_learnParameters[10] = cc_data.CAND.candidatePatience; 
 ui_learnParameters[11] = cc_data.CAND.maxNoOfUpdateCycles; 
 ui_learnParameters[12] = cc_data.CAND.maxNoOfCandUnits;  
 ui_learnParameters[13] = (float)cc_data.CAND.actFunc;  
         
 ui_learnParameters[14] = cc_data.OUT.errorChange;        
 ui_learnParameters[15] = cc_data.OUT.outputPatience;    
 ui_learnParameters[16] = cc_data.OUT.maxNoOfUpdateCycles;

 ui_learnParameters[17] = (float)cc_data.GLOBAL.pruneOnOff; 
 ui_learnParameters[18] = (float)cc_data.GLOBAL.backfittOnOff; 
 ui_learnParameters[19] = cc_data.GLOBAL.backfittPatience;
 ui_learnParameters[20] = cc_data.GLOBAL.pruneFunc; 
}


/*****************************************************************************
  FUNCTION : cc_doneProc

  PURPOSE  : callback function of the done-buttom. You are leaving CC. The storage     
             is deallocated.
  NOTES    :

  UPDATE   : 3.4.1992
******************************************************************************/

static void cc_doneProc(void)
{
 cc_readElements();
 XtDestroyWidget(cc_mainWidget);
 cc_open = 0;
}

/*****************************************************************************
  FUNCTION : cc_xCreateButtonItem

  PURPOSE  : create a command widget
  NOTES    :

  UPDATE   : 5.10.92
******************************************************************************/

static Widget cc_xCreateButtonItem (char *name, Widget parent, Widget left, Widget top)
{
    int n;
    Widget   w;
    Arg      arg[15];
    
    n = 0;

    if (strcmp (name, "done") == 0)
      {  
        XtSetArg(arg[n], XtNbitmap, 
                  (Pixmap) XCreateBitmapFromData (ui_display,
                   XDefaultRootWindow (ui_display), 
                   done_bits, done_width, done_height)); n++;
      } 

    if (strcmp (name, "delete_cand_units") == 0)
      {  
        XtSetArg(arg[n], XtNbitmap, 
                  (Pixmap) XCreateBitmapFromData (ui_display,
                   XDefaultRootWindow (ui_display), 
                   delete_cand_units_bits, delete_cand_units_width, delete_cand_units_height)); n++;
      } 

    XtSetArg(arg[n], XtNborderWidth, 0); n++;
    XtSetArg(arg[n], XtNinternalHeight, 1); n++;
    XtSetArg(arg[n], XtNinternalWidth , 1); n++; 

    XtSetArg(arg[n], XtNfromVert , top);  n++;
    XtSetArg(arg[n], XtNfromHoriz, left);  n++;
    XtSetArg(arg[n], XtNleft  , XtChainLeft); n++;
    XtSetArg(arg[n], XtNright , XtChainLeft); n++;
    XtSetArg(arg[n], XtNtop   , XtChainTop); n++;
    XtSetArg(arg[n], XtNbottom, XtChainTop); n++;

    w = XtCreateManagedWidget(name, commandWidgetClass, parent, arg, (unsigned int) n);
    return(w);

}

/*****************************************************************************
  FUNCTION : cc_xCreateMenueButtonItem

  PURPOSE  : create a menue widget
  NOTES    :

  UPDATE   : 5.10.92
******************************************************************************/

static Widget cc_xCreateMenueButtonItem (char *name, Widget parent, Widget left, Widget top, int dist)
{
    int n;
    Widget   w;
    Arg      arg[15];
    
    n = 0;

    XtSetArg(arg[n], XtNborderWidth, 1); n++;
    XtSetArg(arg[n], XtNinternalHeight, 1); n++; 
    XtSetArg(arg[n], XtNinternalWidth , 2); n++; 

    XtSetArg(arg[n], XtNhorizDistance , dist);  n++;
    XtSetArg(arg[n], XtNfromVert , top);  n++;
    XtSetArg(arg[n], XtNfromHoriz, left);  n++; 
    XtSetArg(arg[n], XtNleft  , XtChainLeft); n++;
    XtSetArg(arg[n], XtNright , XtChainLeft); n++;
    XtSetArg(arg[n], XtNtop   , XtChainTop); n++;
    XtSetArg(arg[n], XtNbottom, XtChainTop); n++;
/*    XtSetArg(arg[n], XtNresizable,1); n++; */

    w = XtCreateManagedWidget(name, menuButtonWidgetClass, parent, arg, (unsigned int) n);
    return(w);

}

/*****************************************************************************
  FUNCTION : cc_createCandidatePannel

  PURPOSE  : creates the candidate pannel, which is part of the CC-window
  NOTES    :

  UPDATE   : 5.10.92
******************************************************************************/


static void cc_createCandidatePannel (Widget parent)
{
 Widget       form,menu,mItem,delete_cand_units;
 Arg          arg[25];
 Cardinal     n;
 char         buf[20];
 int          length1;
  
 n = 0;  
 form = XtCreateManagedWidget ("pannel", formWidgetClass, parent, arg, n);

 cc_w0  = ui_xCreateLabelItem("          Candidate parameters",form,35*cc_fontWidth,NULL,NULL);

 cc_w1a = ui_xCreateLabelItem("Min. covariance change: ",form,30*cc_fontWidth,NULL,cc_w0);
 sprintf(buf,"%.3f",cc_data.CAND.covarianceChange);
 cc_w1b = ui_xCreateDialogItem ("cc_w1b",form,buf,6*cc_fontWidth,cc_w1a,cc_w0); 

 cc_w2a = ui_xCreateLabelItem("Candidate patience: ",form,30*cc_fontWidth,NULL,cc_w1a);
 sprintf(buf,"%d",cc_data.CAND.candidatePatience);
 cc_w2b = ui_xCreateDialogItem ("cc_w2b",form,buf,6*cc_fontWidth,cc_w2a,cc_w1a); 

 cc_w3a = ui_xCreateLabelItem("Max. no. of covariance updates: ",form,30*cc_fontWidth,NULL,cc_w2a);
 sprintf(buf,"%d",cc_data.CAND.maxNoOfUpdateCycles);
 cc_w3b = ui_xCreateDialogItem ("cc_w3b",form,buf,6*cc_fontWidth,cc_w3a,cc_w2a); 

 cc_w7a = ui_xCreateLabelItem("Max. no. of candidate units: ",form,30*cc_fontWidth,NULL,cc_w3a);
 sprintf(buf,"%d",cc_data.CAND.maxNoOfCandUnits);
 cc_w7b = ui_xCreateDialogItem ("cc_w7b",form,buf,6*cc_fontWidth,cc_w7a,cc_w3a); 

 cc_w10a = ui_xCreateLabelItem("Activation function: ",form,24*cc_fontWidth,NULL,cc_w7a);
 length1 = strlen(cc_actFuncArray[cc_data.CAND.actFunc]);
 sprintf(buf,"%-13s",cc_actFuncArray[cc_data.CAND.actFunc]);
 cc_centerString(buf,length1,13);
 cc_w10b = cc_xCreateMenueButtonItem (buf,form,cc_w10a,cc_w7a,5);

 menu     = XtCreatePopupShell("menu",simpleMenuWidgetClass,cc_w10b,NULL,ZERO);

 mItem    = XtCreateManagedWidget("Act_Logistic", smeBSBObjectClass,menu,NULL,ZERO);
   XtAddCallback(mItem,XtNcallback,(XtCallbackProc)cc_selectActFuncCand,ASYM_SIGMOID);
 mItem    = XtCreateManagedWidget("Act_LogSym", smeBSBObjectClass,menu,NULL,ZERO);
   XtAddCallback(mItem,XtNcallback,(XtCallbackProc)cc_selectActFuncCand,(caddr_t)SYM_SIGMOID);
 mItem    = XtCreateManagedWidget("Act_TanH", smeBSBObjectClass,menu,NULL,ZERO);
   XtAddCallback(mItem,XtNcallback,(XtCallbackProc)cc_selectActFuncCand,(caddr_t)TANH);
 mItem    = XtCreateManagedWidget("Act_Random", smeBSBObjectClass,menu,NULL,ZERO);
   XtAddCallback(mItem,XtNcallback,(XtCallbackProc)cc_selectActFuncCand,(caddr_t)RANDOM);

 delete_cand_units = cc_xCreateButtonItem ("delete_cand_units",form,NULL,cc_w10a);
   XtAddCallback(delete_cand_units,XtNcallback,(XtCallbackProc)cc_deleteCandUnits,(caddr_t)NULL);


}

/*****************************************************************************
  FUNCTION : cc_creatOutputPannel

  PURPOSE  : creates the output pannel, which is part of the CC-window
  NOTES    :

  UPDATE   : 5.10.92
******************************************************************************/


static void cc_createOutputPannel (Widget parent)
{
 Widget       form;
 Arg          arg[25];
 Cardinal     n;
 char         buf[10];
  
 n = 0;  
 form = XtCreateManagedWidget ("pannel", formWidgetClass, parent, arg, n);

 cc_w0  = ui_xCreateLabelItem("            Output parameters",form,35*cc_fontWidth,NULL,NULL);

 cc_w4a = ui_xCreateLabelItem("Error change: ",form,30*cc_fontWidth,NULL,cc_w0);
 sprintf(buf,"%.3f",cc_data.OUT.errorChange);
 cc_w4b = ui_xCreateDialogItem ("cc_w4b",form,buf,6*cc_fontWidth,cc_w4a,cc_w0); 

 cc_w5a = ui_xCreateLabelItem("Output patience: ",form,30*cc_fontWidth,NULL,cc_w4a);
 sprintf(buf,"%d",cc_data.OUT.outputPatience);
 cc_w5b = ui_xCreateDialogItem ("cc_w5b",form,buf,6*cc_fontWidth,cc_w5a,cc_w4a); 

 cc_w6a = ui_xCreateLabelItem("Max. no. of epochs: ",form,30*cc_fontWidth,NULL,cc_w5a);
 sprintf(buf,"%d",cc_data.OUT.maxNoOfUpdateCycles);
 cc_w6b = ui_xCreateDialogItem ("cc_w6b",form,buf,6*cc_fontWidth,cc_w6a,cc_w5a); 

}

/*****************************************************************************
  FUNCTION : cc_createGlobalPannel

  PURPOSE  : creates the global pannel, which is part of the CC-window
  NOTES    :

  UPDATE   : 5.10.92
******************************************************************************/


static void cc_createGlobalPannel (Widget parent)
{
 Widget       form,menu,mItem;
 Arg          arg[25];
 Cardinal     n;
 char         buf[15];
 int          length1;
  
 n = 0;  
 form = XtCreateManagedWidget("pannel", formWidgetClass, parent, arg, n);

 cc_w0  = ui_xCreateLabelItem("           Global parameters",form,35*cc_fontWidth,NULL,NULL);

 cc_w9a = ui_xCreateLabelItem("Max. output unit error:  ",form,30*cc_fontWidth,NULL,cc_w0);
 sprintf(buf,"%.3f",cc_data.GLOBAL.pixelError);
 cc_w9b = ui_xCreateDialogItem ("cc_w9b",form,buf,6*cc_fontWidth,cc_w9a,cc_w0);  

 cc_w11a = ui_xCreateLabelItem("Learning function: ",form,28*cc_fontWidth,NULL,cc_w9a);
 length1 = strlen(cc_learningFuncArray[cc_data.GLOBAL.learningFunc]);
 sprintf(buf,"%-9s",cc_learningFuncArray[cc_data.GLOBAL.learningFunc]);
 cc_centerString(buf,length1,9); 
 cc_w11b  = cc_xCreateMenueButtonItem (buf,form,cc_w11a,cc_w9a,1);

 menu     = XtCreatePopupShell("menu",simpleMenuWidgetClass,cc_w11b,NULL,ZERO);

 mItem    = XtCreateManagedWidget("Backprop", smeBSBObjectClass,menu,NULL,ZERO);
   XtAddCallback(mItem,XtNcallback,(XtCallbackProc)cc_selectLearningFunc,(caddr_t)BACKPROP);
 mItem    = XtCreateManagedWidget("Quickprop", smeBSBObjectClass,menu,NULL,ZERO);
   XtAddCallback(mItem,XtNcallback,(XtCallbackProc)cc_selectLearningFunc,(caddr_t)QUICKPROP);
 mItem    = XtCreateManagedWidget("Rprop", smeBSBObjectClass,menu,NULL,ZERO);
 XtAddCallback(mItem,XtNcallback,(XtCallbackProc)cc_selectLearningFunc,(caddr_t)RPROP);

 cc_w13a = ui_xCreateLabelItem("Print covariance and error:",form,28*cc_fontWidth,NULL,cc_w11a);
 length1 = strlen(cc_onOffArray[cc_data.GLOBAL.onOff]);
 sprintf(buf,"%-9s",cc_onOffArray[cc_data.GLOBAL.onOff]);
 cc_centerString(buf,length1,9); 
 cc_w13b  = cc_xCreateMenueButtonItem (buf,form,cc_w13a,cc_w11a,1);

 menu     = XtCreatePopupShell("menu",simpleMenuWidgetClass,cc_w13b,NULL,ZERO);

 mItem    = XtCreateManagedWidget("on", smeBSBObjectClass,menu,NULL,ZERO);
   XtAddCallback(mItem,XtNcallback,(XtCallbackProc)cc_selectOnOff,(caddr_t)ON);
 mItem    = XtCreateManagedWidget("off", smeBSBObjectClass,menu,NULL,ZERO);
   XtAddCallback(mItem,XtNcallback,(XtCallbackProc)cc_selectOnOff,(caddr_t)OFF);
 /* pruning */
 cc_w15a = ui_xCreateLabelItem("Prune new hidden unit:",form,28*cc_fontWidth,NULL,cc_w13a);
 length1 = strlen(cc_onOffArray[cc_data.GLOBAL.pruneOnOff]);
 sprintf(buf,"%-9s",cc_onOffArray[cc_data.GLOBAL.pruneOnOff]);
 cc_centerString(buf,length1,9); 
 cc_w15b  = cc_xCreateMenueButtonItem (buf,form,cc_w15a,cc_w13a,1);
 
 menu     = XtCreatePopupShell("menu",simpleMenuWidgetClass,cc_w15b,NULL,ZERO);
 
 mItem    = XtCreateManagedWidget("on", smeBSBObjectClass,menu,NULL,ZERO);
 XtAddCallback(mItem,XtNcallback,(XtCallbackProc)cc_selectPruneOnOff,(caddr_t)ON);
 mItem    = XtCreateManagedWidget("off", smeBSBObjectClass,menu,NULL,ZERO);
 XtAddCallback(mItem,XtNcallback,(XtCallbackProc)cc_selectPruneOnOff,(caddr_t)OFF);

 cc_pfl = ui_xCreateLabelItem("Minimize: ",form,28*cc_fontWidth,NULL,cc_w15a);
 length1 = strlen(cc_pruningFuncArray[cc_data.GLOBAL.pruneFunc]);
 sprintf(buf,"%-6s",cc_pruningFuncArray[cc_data.GLOBAL.pruneFunc]);
 cc_centerString(buf,length1,9); 
 cc_pfb  = cc_xCreateMenueButtonItem (buf,form,cc_pfl,cc_w15a,1);

 menu     = XtCreatePopupShell("menu",simpleMenuWidgetClass,cc_pfb,NULL,ZERO);

 mItem    = XtCreateManagedWidget("SBC", smeBSBObjectClass,menu,NULL,ZERO);
   XtAddCallback(mItem,XtNcallback,(XtCallbackProc)cc_selectPruneFunc,(caddr_t)SBC);
 mItem    = XtCreateManagedWidget("AIC", smeBSBObjectClass,menu,NULL,ZERO);
   XtAddCallback(mItem,XtNcallback,(XtCallbackProc)cc_selectPruneFunc,(caddr_t)AIC);
 mItem    = XtCreateManagedWidget("CMSEP", smeBSBObjectClass,menu,NULL,ZERO);
 XtAddCallback(mItem,XtNcallback,(XtCallbackProc)cc_selectPruneFunc,(caddr_t)CMSEP);
 
 /* backfitting, untested */ /*
    cc_w17a = ui_xCreateLabelItem("Enable backfitting:",form,28*cc_fontWidth,NULL,cc_w15a);
    length1 = strlen(cc_onOffArray[cc_data.GLOBAL.backfittOnOff]);
    sprintf(buf,"%-9s",cc_onOffArray[cc_data.GLOBAL.backfittOnOff]);
    cc_centerString(buf,length1,9); 
    cc_w17b  = cc_xCreateMenueButtonItem (buf,form,cc_w17a,cc_w15a,1);
    
    menu     = XtCreatePopupShell("menu",simpleMenuWidgetClass,cc_w17b,NULL,ZERO);
    
    mItem    = XtCreateManagedWidget("on", smeBSBObjectClass,menu,NULL,ZERO);
    XtAddCallback(mItem,XtNcallback,(XtCallbackProc)cc_selectBackfittOnOff,(caddr_t)ON);
    mItem    = XtCreateManagedWidget("off", smeBSBObjectClass,menu,NULL,ZERO);
    XtAddCallback(mItem,XtNcallback,(XtCallbackProc)cc_selectBackfittOnOff,(caddr_t)OFF);
    

    cc_w19a = ui_xCreateLabelItem("Start backfitting after: "\
    ,form,30*cc_fontWidth,NULL,cc_w17a);
    sprintf(buf,"%d",cc_data.GLOBAL.backfittPatience);
    cc_w19b = ui_xCreateDialogItem ("cc_w19b"\
    ,form,buf,6*cc_fontWidth,cc_w19a,cc_w17a); 
    */
}


/*****************************************************************************
  FUNCTION : cc_createWindow

  PURPOSE  : creates the CC-window
  NOTES    :

  UPDATE   : 5.10.92
******************************************************************************/


void cc_createWindow (void)
{
    Widget       done,box;
    Arg          arg[25];
    Cardinal     n;
    char         buf[40];

    if(!cc_open) {
      cc_open = 1;
      sprintf (buf, "Cascade");
      n = 0;  
      cc_mainWidget = XtCreatePopupShell(buf,topLevelShellWidgetClass,
					 ui_toplevel,arg,n); 

      n = 0;  
      box = XtCreateManagedWidget("box",boxWidgetClass,cc_mainWidget,arg,n);

      cc_createGlobalPannel(box);
      cc_createCandidatePannel (box); 
      cc_createOutputPannel(box);

      done = cc_xCreateButtonItem ("done",box,NULL,NULL);
         XtAddCallback(done,XtNcallback,(XtCallbackProc)cc_doneProc,NULL); 

      XtAddEventHandler(box,KeyPressMask,FALSE,
			(XtEventHandler)ui_key_control,(Cardinal *) 0);
      ui_checkWindowPosition(cc_mainWidget);
      XtPopup (cc_mainWidget, XtGrabNone);
      ui_xDontResizeWidget(cc_mainWidget); 
   } else {
      XRaiseWindow (XtDisplay (cc_mainWidget), XtWindow (cc_mainWidget));
   }
}  



/* XtVaGetValues(cc_w1b,XtNwidth,&widgetWidth,XtNx,&widgetXPos,NULL); */

