/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.0/rpc/sources/RCS/ui_transfer.c,v $
  SHORTNAME      : ui_tansfer
  SNNS VERSION   : 4.0

  PURPOSE        : 
  NOTES          :

  AUTHOR         : Sven Doering
  DATE           : 

  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.6 $
  LAST CHANGE    : $Date: 1995/05/08 10:29:08 $

             (c) 1994 by Sven Doering and the SNNS-Group

******************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>

#include <string.h>		/* strcmp */
#include <rpc/rpc.h>

#include "ui.h"

#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/AsciiSrc.h>

#include "kr_ui.h"
#include "kr_ui_rpc.h"
#include "kr_ui_rpc_main.h"
#include "ui_rpcsnns.h"

#include "ui_xWidgets.h"
#include "ui_confirmer.h"
#include "ui_mainP.h"
#include "ui_fileP.h"
#include "ui_control.h"

#include "ui_rpc.h"
#include "ui_rpcP.h"

#include "ui_transfer.ph"


/*****************************************************************************
  FUNCTION : ui_RPCdownloadFile

  PURPOSE  :
  RETURNS  : int
  NOTES    :

  UPDATE   :
*****************************************************************************/

static int
ui_RPCdownloadFile(char *filename,int command,int hostnum)
{
    FILE *tempfile;
    char buf[128];
    par_filetransfer par;
    rpc_krui_err *res;
    static int epoche=0;
    int laufnr=0;
    
    epoche++;
    par.epoche= epoche;
    tempfile = fopen(filename,"r");
    if (tempfile == NULL){
	sprintf(buf,"Can't read file: %s",filename); 
	ui_tw_errorMessage(buf); 
	return(RPC_CANNOT_OPEN_FILE);
    }
    par.Command = command;
    do{
	par.bytes_used = fread(&par.fileblock[0],sizeof(char)
			       ,FILEBLOCKSIZE-1,tempfile);
	if (feof(tempfile)!=0)
	    par.lastblock=TRUE;
	else
	    par.lastblock=FALSE;
	par.laufnr = laufnr++;
	clnt_control(host[hostnum].cl,CLGET_TIMEOUT,&oldtimeout);
	clnt_control(host[hostnum].cl,CLSET_TIMEOUT
		     ,&host[hostnum].kernel_config->timeoutlong);
	res = download_file_40(&par,host[hostnum].cl);
	clnt_control(host[hostnum].cl,CLSET_TIMEOUT,&oldtimeout);
	if( res == NULL || *res != RPC_NO_ERROR){
	    if(res != NULL && *res == RPC_WRONG_PAKET){
		ui_tw_errorMessage("Wrong Paketnumber during file-transfer"); 
	    }else{
		ui_tw_errorMessage("Error during file-transfer"); 
	    }
	    return(RPC_TRANSFER_ERROR);
	}
    }while(feof(tempfile)==0);
    fclose(tempfile);

    return(RPC_NO_ERROR);
}

/*****************************************************************************
  FUNCTION : ui_RPCuploadFile

  PURPOSE  :
  RETURNS  : int
  NOTES    :

  UPDATE   :
*****************************************************************************/

static int
ui_RPCuploadFile(char *filename,par_upload *par,int hostnum)
{
    FILE *tempfile;
    char buf[128];
    char *buf2;
    res_filetransfer *res;
    static int epoche=0;
    int laufnr=0;

    epoche++;
    par->epoche= epoche;
    tempfile = fopen(filename,"w");
    if (tempfile == NULL){
	sprintf(buf,"Can't write to file: %s",filename); 
	ui_tw_errorMessage(buf); 
	return(RPC_CANNOT_OPEN_FILE);
    }
    do{
	clnt_control(host[hostnum].cl,CLGET_TIMEOUT,&oldtimeout);
	clnt_control(host[hostnum].cl,CLSET_TIMEOUT
		     ,&host[hostnum].kernel_config->timeoutlong);
	res = upload_file_40(par,host[hostnum].cl);
	clnt_control(host[hostnum].cl,CLSET_TIMEOUT,&oldtimeout);
	if( res == NULL || res->error != RPC_NO_ERROR){
	    buf2 = clnt_sperror(host[hostnum].cl,buf2);
	    sprintf(buf,"Error during file-transfer :%s",buf2);
	    ui_tw_errorMessage(buf); 
	    return(RPC_TRANSFER_ERROR);
	}
	if(laufnr != res->laufnr || epoche != res->epoche){
	    ui_tw_errorMessage("Error during file-transfer\nwrong Paket or wrong Epoch"); 
	    return(RPC_TRANSFER_ERROR);
	}
	laufnr++;
	fwrite(&res->fileblock[0],sizeof(char),res->bytes_used,tempfile);
    }while(res->lastblock==FALSE);
    fclose(tempfile);

    return(RPC_NO_ERROR);
}


/*****************************************************************************
  FUNCTION : ui_RPCTansferFileCallback

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

static void
ui_RPCTransferFileCallback(Widget w, caddr_t Com, caddr_t selektion)
{
    char buf[128],buf2[135];
    char hostname[MAXHOSTDLEN],*hp,*hp2;
    int  Command,typ,i,h,pos,setno;
    par_upload par;
    char *netname;
    

    /* Destroy TransferPopup */
    if(ui_RPCTransferIsCreated){
	ui_RPCTransferIsCreated = FALSE;
	XtDestroyWidget(ui_popRPCTransfer);
    }

    if(Com == NULL){
	return;
    }

    Command = (int)Com &~RPC_PUT &~RPC_GET;
    typ = (int) Com & ~Command;
    


    if(typ == RPC_PUT){
	for(h = 0 ; h < anzlist2 ;h++){
	    pos = hostnr2[h];
	    switch(Command){
	      case TRANSFERNETWORK:
		gethostname(hostname,16);
		sprintf(buf,"/tmp/%s.%d.net",hostname,getpid());
		/* save Netzwerk */
		if(krui_saveNet(buf,NULL)!=KRERR_NO_ERROR){
		    ui_tw_errorMessage("Can't save Net"); 
		    return;
		}
		ui_RPCdownloadFile(buf,Command,pos);
		/* delete file */
		sprintf(buf2,"/bin/rm -f %s",buf);
		system(buf2);
		break;
	      case TRANSFERPATTERN:
		if(!host[pos].hasKernelConfig)
		    ui_getKernelConfig(pos);
		/* First delete all Patternsets */
		for(i = NO_OF_PAT_SETS-1  ; i >= 0 ;i--){
		    krui_deletepatset_40(&i, host[pos].cl);
		}
		hp = &host[pos].kernel_config->PATTERN_SET_FILE[0];
		gethostname(hostname,16);
		sprintf(buf,"/tmp/%s.%d.pat",hostname,getpid());
		for (i = 0 ; i < NO_OF_PATTERN_SETS; i++){
		    /* save Patterns */
		    if(krui_saveNewPatterns(buf,0)!=KRERR_NO_ERROR){
			ui_tw_errorMessage("Can't save Patterns"); 
			return;
		    }
		    if(ui_RPCdownloadFile(buf,Command,pos) 
		       == RPC_NO_ERROR){
			host[pos].kernel_config->ui_noOfCurrentPattern = 
			    i+1;
			host[pos].kernel_config->NO_OF_PATTERN_SETS = 
			    i+1;
			host[pos].kernel_config->CURR_PATTERN_SET = i+1;
			strncpy(hp,PATTERN_SET_FILE[i],19);
			hp+= ((strlen(PATTERN_SET_FILE[i])+1)>20) ? 20 : (strlen(PATTERN_SET_FILE[i])+1);
		    }
		    /* delete file */
		    sprintf(buf2,"/bin/rm -f %s",buf);
		    system(buf2);
		}
		host[pos].kernel_config->CURR_PATTERN_SET = 
		    CURR_PATTERN_SET;
		/* Save new kernel config*/
		ui_setKernelConfig(pos);
		break;
	    }
	}
    }else{
	par.command = Command;
	switch(Command){
	  case TRANSFERNETWORK:
	    par.command = Command;
	    gethostname(hostname,16);
	    sprintf(buf,"/tmp/%s.%d.net",hostname,getpid());
	    if(ui_RPCuploadFile(buf,&par,aktlistpos) 
	       == RPC_NO_ERROR) {
		/* load Netzwerk */
		if(krui_loadNet(buf,&netname)!=KRERR_NO_ERROR){
		    ui_tw_errorMessage("Can't load Net"); 
		    return;
		}
	    }
	    /* delete file */
	    sprintf(buf2,"/bin/rm -f %s",buf);
	    system(buf2);
	    break;
	  case TRANSFERPATTERN:
	    /* First delete all Patternsets for 'direct local'*/
	    for(i = NO_OF_PAT_SETS-1  ; i >= 0 ;i--){
		krui_deletePatSet(i);
	    }
	    gethostname(hostname,16);
	    sprintf(buf,"/tmp/%s.%d.pat",hostname,getpid());
	    if(!host[aktlistpos].hasKernelConfig)
		ui_getKernelConfig(aktlistpos);
	    hp = &host[aktlistpos].kernel_config->PATTERN_SET_FILE[0];
	    hp2 = &host[0].kernel_config->PATTERN_SET_FILE[0];
	    for (i = 0 ; 
		 i < host[aktlistpos].kernel_config->NO_OF_PATTERN_SETS; i++){
		par.setno = i;
		if(ui_RPCuploadFile(buf,&par,aktlistpos) 
		   == RPC_NO_ERROR){
		    /* load Pattern */
		    if(krui_loadNewPatterns(buf,&setno)!=KRERR_NO_ERROR){
			ui_tw_errorMessage("Can't load Patterns"); 
		    }
		    ui_noOfCurrentPattern =
			host[0].kernel_config->ui_noOfCurrentPattern = i+1;
		    NO_OF_PATTERN_SETS =
		       host[0].kernel_config->NO_OF_PATTERN_SETS = 
			   host[aktlistpos].kernel_config->NO_OF_PATTERN_SETS;
		    CURR_PATTERN_SET =
			host[0].kernel_config->CURR_PATTERN_SET = i+1;
		    strncpy(hp2,hp,19);
		    PATTERN_SET_FILE[i] = (char *)strdup(hp);
		    hp += (strlen(hp2)+1);
		    hp2 += (strlen(hp2)+1);
		}
		/* delete file */
		sprintf(buf2,"/bin/rm -f %s",buf);
		system(buf2);
	    }
	    CURR_PATTERN_SET =
		host[0].kernel_config->CURR_PATTERN_SET = 
		    host[aktlistpos].kernel_config->CURR_PATTERN_SET;
	    /* Save new kernel config*/
	    ui_setKernelConfig(0);
	    
	    ui_RPCchangeControlPanel();
	}
	ui_sel_unselectAll(ui_set_displayPtr, UI_GLOBAL);
	ui_sel_resetList();
	ui_net_completeRefresh(ui_set_displayPtr, UI_GLOBAL);
	ui_file_updateShellLabels();
    }
}
/*****************************************************************************
  FUNCTION : ui_RPCmoveRightCallback

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

static void
ui_RPCmoveRightCallback(Widget w, caddr_t client_data, caddr_t data)
{
    if (akttranshost >=0 && akttranshost < anzlist1){
	/* Append at List2 */
	hostl2[anzlist2] = &hostn[hostnr1[akttranshost]-1][0];
	hostnr2[anzlist2] = hostnr1[akttranshost];
	anzlist2++;
	/* Delete from list1 */
	memcpy(&hostl1[akttranshost],&hostl1[akttranshost+1],
	       (anzlist1-akttranshost)*sizeof(char *));
	hostl1[anzlist1]=NULL;
	hostl2[anzlist2]=NULL;
	memcpy(&hostnr1[akttranshost],&hostnr1[akttranshost+1],
	       (anzlist1-akttranshost)*sizeof(int));
	anzlist1--;
	XawListChange(RPCtransferL1, hostl1, 0, 0, True);
	XawListChange(RPCtransferL2, hostl2, 0, 0, True);
    }
    if(anzlist1 > 0 && akttranshost > 0 && akttranshost < anzlist1)
      XawListHighlight(RPCtransferL1,akttranshost);
    if(anzlist2 > 0 && aktnottranshost > 0 && aktnottranshost < anzlist2)
      XawListHighlight(RPCtransferL2,aktnottranshost);
}

/*****************************************************************************
  FUNCTION : ui_RPCmoveLeftCallback

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

static void
ui_RPCmoveLeftCallback(Widget w, caddr_t client_data, caddr_t data)
{
    if (aktnottranshost >=0 && aktnottranshost < anzlist2){
	/* Append at List1 */
	hostl1[anzlist1] = &hostn[hostnr2[aktnottranshost]-1][0];
	hostnr1[anzlist1] = hostnr2[aktnottranshost];
	anzlist1++;
	/* Delete from list2 */
	memcpy(&hostl2[aktnottranshost],&hostl2[aktnottranshost+1],
	       (anzlist2-aktnottranshost)*sizeof(char *));
	hostl2[anzlist2]=NULL;
	hostl1[anzlist1]=NULL;
	memcpy(&hostnr2[aktnottranshost],&hostnr2[aktnottranshost+1],
	       (anzlist2-aktnottranshost)*sizeof(int));
	anzlist2--;
	XawListChange(RPCtransferL1, hostl1, 0, 0, True);
	XawListChange(RPCtransferL2, hostl2, 0, 0, True);
    }
    if(anzlist1 > 0 && akttranshost > 0 && akttranshost < anzlist1)
      XawListHighlight(RPCtransferL1,akttranshost);
    if(anzlist2 > 0 && aktnottranshost > 0 && aktnottranshost < anzlist2)
      XawListHighlight(RPCtransferL2,aktnottranshost);
}

/*****************************************************************************
  FUNCTION : ui_RPCtransferHostCallback

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

static void
ui_RPCtransferHostCallback(Widget w, caddr_t client_data, XawListReturnStruct * selektion)
{
    if((int)client_data==1)
	akttranshost = selektion->list_index;
    else
	aktnottranshost = selektion->list_index;
}

/*****************************************************************************
  FUNCTION : ui_displayRPCFileTransfer

  PURPOSE  : popup the RPC Setup panel
  RETURNS  : void
  NOTES    :

  UPDATE   : 16.02.94
******************************************************************************/
void
ui_displayRPCFileTransfer(Widget w, caddr_t Transfertyp, caddr_t call_data)
{
    Arg             args[20];
    Cardinal        n;
    Widget          form,tbutton,label,viewport1,viewport2;
    int             i;
    static char *np[2] = {NULL,NULL};

    if(akthost != 0){
        ui_tw_errorMessage("The current host must be 'direct local' to use PUT and GET" );
        return;
    }
    if((((int)Transfertyp) == RPC_GET) && (aktlistpos == 0)){
	ui_tw_errorMessage("Can't GET from \n'direct local' to 'direct local'"); 
	return;
    }

    if (ui_RPCTransferIsCreated)
	return;
    ui_RPCTransferIsCreated = TRUE;


    /* init datas */
    akttranshost=-1;
    aktnottranshost=-1;
    anzlist1 = anzHostEntries-1;
    anzlist2 = 0;
    transferlistcreated = FALSE;
    /* Make List */
    for (i = 0; i < anzlist1; i++) {
	sprintf(&hostn[i][0],"%-16s %-9ld",host[i+1].hostname,
		host[i+1].kernelno);
	hostnr1[i] = i+1;
	hostl1[i] = &hostn[i][0];
    }
    hostl2[0]=NULL;

    n = 0;
    XtSetArg(args[n], XtNx, 500 /* x */); n++;
    XtSetArg(args[n], XtNy, 350 /* y */); n++;

    /* Now create Popup */

    ui_popRPCTransfer = 
	XtCreatePopupShell("RPC FILE TRANSFER", transientShellWidgetClass, 
			   ui_toplevel, args, n);

    n = 0;
    XtSetArg(args[n], XtNresizable, TRUE);n++;
    form = XtCreateManagedWidget("RPCtransferform",formWidgetClass,
				 ui_popRPCTransfer,args, n);


    if ((int)Transfertyp == RPC_PUT){
	label = ui_xCreateLabelItem("Transfer from 'direct local'",form,210,NULL,NULL);

	label = ui_xCreateLabelItem("HOSTS                                  SELECTED HOSTS", form, 400 , NULL, label);
	n = 0;
	XtSetArg(args[n], XtNwidth, 210);n++;
	XtSetArg(args[n], XtNheight, 16 * 9);n++;
	XtSetArg(args[n], XtNresizable, FALSE);n++;
	XtSetArg(args[n], XtNleft, XtChainLeft);n++;
	XtSetArg(args[n], XtNallowHoriz, FALSE);n++;
	XtSetArg(args[n], XtNallowVert, TRUE);n++;
	XtSetArg(args[n], XtNuseBottom, TRUE);n++;
	XtSetArg(args[n], XtNforceBars, TRUE);n++;
	XtSetArg(args[n], XtNfromVert, label);n++;
	XtSetArg(args[n], XtNright, XtChainRight);n++;
	XtSetArg(args[n], XtNtop, XtChainTop);n++;
	XtSetArg(args[n], XtNbottom, XtChainBottom);n++;
	
	viewport1 = XtCreateManagedWidget("Viewport", viewportWidgetClass,
					 form, args, n);
	n = 0;
	XtSetArg(args[n], XtNresizable, TRUE);n++;
	XtSetArg(args[n], XtNforceColumns, TRUE);n++;
	XtSetArg(args[n], XtNdefaultColumns, 1);n++;
	XtSetArg(args[n], XtNverticalList, FALSE);n++;
	
	RPCtransferL1 = XtCreateManagedWidget("ListWin1",listWidgetClass,
					      viewport1,args,n);
	XtAddCallback(RPCtransferL1, XtNcallback, 
		      (XtCallbackProc) ui_RPCtransferHostCallback,(caddr_t) 1);
	XawListChange(RPCtransferL1, hostl1, 0, 0, True);
	
	tbutton = ui_xCreateButtonItem("right2",form, viewport1,NULL);
	XtAddCallback(tbutton, XtNcallback, 
		      (XtCallbackProc) ui_RPCmoveRightCallback, (caddr_t)NULL);
	n = 0;
	XtSetArg(args[n], XtNvertDistance, 90);n++;
	XtSetValues(tbutton,args,n);

	tbutton = ui_xCreateButtonItem("left2",form, viewport1,tbutton);
	XtAddCallback(tbutton, XtNcallback, 
		      (XtCallbackProc) ui_RPCmoveLeftCallback, (caddr_t) NULL);
	n = 0;
	XtSetArg(args[n], XtNwidth, 210);n++;
	XtSetArg(args[n], XtNheight, 16 * 9);n++;
	XtSetArg(args[n], XtNresizable, FALSE);n++;
	XtSetArg(args[n], XtNfromVert, label);n++;
	XtSetArg(args[n], XtNleft, XtChainLeft);n++;
	XtSetArg(args[n], XtNallowHoriz, FALSE);n++;
	XtSetArg(args[n], XtNallowVert, TRUE);n++;
	XtSetArg(args[n], XtNuseBottom, TRUE);n++;
	XtSetArg(args[n], XtNforceBars, TRUE);n++;
	XtSetArg(args[n], XtNfromHoriz, tbutton);n++;
	XtSetArg(args[n], XtNright, XtChainRight);n++;
	XtSetArg(args[n], XtNtop, XtChainTop);n++;
	XtSetArg(args[n], XtNbottom, XtChainBottom);n++;
	
	viewport2 = XtCreateManagedWidget("Viewport2", viewportWidgetClass,
					 form, args, n);
	
	n = 0;
	XtSetArg(args[n], XtNresizable, TRUE);n++;
	XtSetArg(args[n], XtNforceColumns, TRUE);n++;
	XtSetArg(args[n], XtNdefaultColumns, 1);n++;
	XtSetArg(args[n], XtNverticalList, FALSE);n++;

	RPCtransferL2 = XtCreateManagedWidget("ListWin2",listWidgetClass,
					      viewport2,args,n);
	XtAddCallback(RPCtransferL2, XtNcallback, 
		      (XtCallbackProc) ui_RPCtransferHostCallback,(caddr_t) 2);
	XawListChange(RPCtransferL2, np, 0, 0, True);

	tbutton = ui_xCreateButtonItem("cancelt",form, NULL, viewport1);
	XtAddCallback(tbutton, XtNcallback, 
		      (XtCallbackProc) ui_RPCTransferFileCallback, (caddr_t) NULL);
	tbutton = ui_xCreateButtonItem("networkt", form, tbutton, viewport1);
	XtAddCallback(tbutton, XtNcallback, 
		      (XtCallbackProc) ui_RPCTransferFileCallback, 
		      (caddr_t) ((int)TRANSFERNETWORK | (int)Transfertyp));
	
	tbutton = ui_xCreateButtonItem("patternst",form, tbutton, viewport1);
	XtAddCallback(tbutton, XtNcallback, 
		      (XtCallbackProc) ui_RPCTransferFileCallback, 
		      (caddr_t)  ((int)TRANSFERPATTERN | (int)Transfertyp));
	
	tbutton = ui_xCreateButtonItem("net+pattt",form, tbutton, viewport1);
	XtAddCallback(tbutton, XtNcallback, 
		      (XtCallbackProc) ui_RPCTransferFileCallback, 
		      (caddr_t)  ((int)TRANSFERNETWORK | (int)Transfertyp));
	XtAddCallback(tbutton, XtNcallback, 
		      (XtCallbackProc) ui_RPCTransferFileCallback, 
		      (caddr_t) ((int)TRANSFERPATTERN | (int)Transfertyp));
	

	
    }else{
	label = ui_xCreateLabelItem("Transfer to 'direct local'"
				    , form,185,NULL,NULL);

	tbutton = ui_xCreateButtonItem("networkt", form, NULL, label);
	XtAddCallback(tbutton, XtNcallback, 
		      (XtCallbackProc) ui_RPCTransferFileCallback, 
		      (caddr_t) ((int)TRANSFERNETWORK | (int)Transfertyp));
	
	tbutton = ui_xCreateButtonItem("patternst",form, NULL, tbutton);
	XtAddCallback(tbutton, XtNcallback, 
		      (XtCallbackProc) ui_RPCTransferFileCallback, 
		      (caddr_t)  ((int)TRANSFERPATTERN | (int)Transfertyp));
	
	tbutton = ui_xCreateButtonItem("net+pattt",form, NULL,tbutton);
	XtAddCallback(tbutton, XtNcallback, 
		      (XtCallbackProc) ui_RPCTransferFileCallback, 
		      (caddr_t)  ((int)TRANSFERNETWORK | (int)Transfertyp));
	XtAddCallback(tbutton, XtNcallback, 
		      (XtCallbackProc) ui_RPCTransferFileCallback, 
		      (caddr_t) ((int)TRANSFERPATTERN | (int)Transfertyp));
	
	tbutton = ui_xCreateButtonItem("cancelt",form, NULL, tbutton);
	XtAddCallback(tbutton, XtNcallback, 
		      (XtCallbackProc) ui_RPCTransferFileCallback, (caddr_t) NULL);
    }
    ui_checkWindowPosition(ui_popRPCTransfer);
    XtPopup(ui_popRPCTransfer, XtGrabExclusive);
    ui_xDontResizeWidget(ui_popRPCTransfer); 
    
}
