/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.0/rpc/sources/RCS/kr_ui_rpc_proc.c,v $
  SHORTNAME      :
  SNNS VERSION   : 4.0

  PURPOSE        :
  NOTES          :

  AUTHOR         : Sven Doering
  DATE           :

  CHANGED BY     :
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.6 $
  LAST CHANGE    : $Date: 1995/04/21 14:01:28 $

             (c) 1994 by Sven Doering and the SNNS-Group

******************************************************************************/

#include <stdio.h>
#include <stdlib.h>/* getenv, exit */
#ifdef sgi
#include <sym.h>
#include <exception.h>
#endif
#include <sys/types.h> /* open */
#include <sys/socket.h>
#include <netinet/in.h>
#include <rpc/rpc.h>
/*#include <sys/dirent.h>*/
#include <dirent.h>
#include <sys/param.h>
#include <netdb.h>
#include <unistd.h>

#ifndef rand
#include "random.h"	 /*  Randomize Library Function Prototypes  */
#endif

#include "kr_typ.h"	 /*  Kernel Types and Constants  */
#include "glob_typ.h"
#include "kr_const.h"	 /*  Constant Declarators for SNNS-Kernel  */
#include "kr_def.h"	 /*  Default Values  */

#include "kr_io.h"	 /*  Kernel I/O-Routines */
#include "kr_funcs.h"    /*  Function Prototypes */
#include "kernel.h"	 /*  Function Prototypes */
#include "kr_mem.h"      /*  Function Prototypes */
#include "version.h"	 /*  Version and Patchlevel  */
#include "kr_mac.h"	 /*  Kernel Macros  */
#include "kr_newpattern.h"   /* new style pattern handling */
#include "kr_inversion.h" /* inversion algorithm routines */
#include "cc_rcc.h"


#ifdef __linux__
#ifdef d_namlen
#undef  d_namlen
#endif
#endif
#include "kr_ui.h"

#include "kr_ui_rpc.h"
#include "ui_rpcsnns.h"
#include "ui_rpcP.h"
#include "kr_ui_rpc_main.h"

#include "kr_ui_rpc_proc.ph"

int *
get_snns_kernel_40(par_get_kernel *par, struct svc_req * cl)
{
    static int info;
    struct client Client;
    if (strcmp(par->xguihost, null_ptr)==0) {
	Client.xguihost = NULL;
    }else{
	Client.xguihost = par->xguihost;
    }
    Client.xguiprogramm = par->xguipnumber;
    Client.xguiversion = par->xguiversion;
    Client.xguiid = par->xguiid;
    Client.uid = par->uid;
    Client.pid = par->pid;
    info = make_xgui_callback(&Client, NOERROR);

    return (&info);
}

char**
get_kernel_infotext_40(void *dummy, struct svc_req * cl)
{
    static char *res = NULL;
    char *hp;
    int    no_of_sites, no_of_links, no_of_STable_entries, no_of_FTable_entries;
    int    unit_bytes, site_bytes, link_bytes, 
           NTable_bytes, STable_bytes, FTable_bytes;

    if(res == NULL){
	res = calloc(1,7168); /* Max Message size + XDR_INFO < 8K */
    }
    hp = res;
    sprintf(hp,"RPC - Interface 4.0\n");hp +=strlen(hp);
    sprintf(hp,"\n%s :\n\n", krui_getVersion());hp +=strlen(hp);

    krui_getNetInfo(&no_of_sites, &no_of_links,
		    &no_of_STable_entries, &no_of_FTable_entries);

    sprintf(hp,"#input  units: %6d\n#output units: %6d\n#patterns    : %6d\n",
	    krui_getNoOfInputUnits(), krui_getNoOfOutputUnits(), 
	    krui_getNoOfPatterns());hp +=strlen(hp);
 
    sprintf(hp,"#sites       : %6d\n#links       : %6d\n",
	    no_of_sites, no_of_links);
    hp +=strlen(hp);
    sprintf(hp,"#STable entr.: %6d\n#FTable-Entr.: %6d\n\n",
	    no_of_STable_entries, no_of_FTable_entries);
    hp +=strlen(hp);

    krui_getMemoryManagerInfo(&unit_bytes, &site_bytes, &link_bytes,
			      &NTable_bytes, &STable_bytes, &FTable_bytes);
    sprintf(hp,"sizes in bytes:\nunits        : %7d\nsites        : %7d\nlinks        : %7d\n",
	    unit_bytes, site_bytes, link_bytes);
    hp +=strlen(hp);
    sprintf(hp,"NTable       : %7d\nSTable       : %7d\nFTable       : %7d\n\n"
	    ,NTable_bytes, STable_bytes, FTable_bytes);
    hp +=strlen(hp);
    sprintf(hp,"learning function  : %s\n", krui_getLearnFunc());
    hp +=strlen(hp);
    sprintf(hp,"update function    : %s\n", krui_getUpdateFunc());
    hp +=strlen(hp);
    sprintf(hp,"initialize function: %s\n\n\n", krui_getInitialisationFunc());
    hp +=strlen(hp);

    return (&res);
}

kernel_info    *
get_kernel_info_40(void *dummy, struct svc_req * cl)
{
    static kernel_info info;

    info.pid = getpid();
    info.uid = getuid();
    info.port = 0;
    return (&info);
}

int *
set_rpc_kernel_config_40(par_config *par, struct svc_req * cl)
{
    static int res = RPC_NO_ERROR;

    memcpy(&kernel_config,par,sizeof(par_config));
    timervalue = kernel_config.exittimeout;
    kernelMode = kernel_config.kernelMode;
    config_received = TRUE;
    return (&res);
}

par_config *
get_rpc_kernel_config_40(int *par, struct svc_req * cl)
{
    int i;
    if(config_received)
	return (&kernel_config);
    else{
	if(kernel_config.kernelMode!=COOP_M_KERNEL 
	   && kernel_config.kernelMode!=COOP_S_KERNEL){
	    kernel_config.kernelMode = NORMALKERNEL;
	    kernelMode  = NORMALKERNEL; 
	}
	kernel_config.isUDP = FALSE;
	kernel_config.timeout.tv_sec = 25;
	kernel_config.timeout.tv_usec = 0;
	kernel_config.timeoutlong.tv_sec = MAXWAITTIME;
	kernel_config.timeoutlong.tv_usec = 0;
	kernel_config.exittimeout= TIMEOUTVAL;
	kernel_config.switchtolocalall = 5;
	kernel_config.switchtolocalsingle = 10;
	kernel_config.status = S_IDLE;

	if(!patternloaded)
	    kernel_config.PATTERN_SET_FILE[0] = '\0';
	
	/* Set default values */
	kernel_config.ui_patternLoadMode = OUTPUT_ACT;
	kernel_config.ui_shuffleFlg = FALSE;
	for(i=0 ; i <= 5 ; i++){
	    kernel_config.subIPatSize[i] = 1;
	    kernel_config.subIPatPos[i]  = 1;
	    kernel_config.subIPatStep[i] = 1;
	    kernel_config.subOPatStep[i] = 1;
	    kernel_config.subOPatSize[i] = 1;
	    kernel_config.subOPatPos[i]  = 1;
	}
	kernel_config.ui_learnParameters[0] = 0.2;
	kernel_config.ui_updateParameters[0] = 0.0;
	kernel_config.ui_initParameters[0] = 1.0;
	kernel_config.ui_initParameters[1] = -1.0;
	
	kernel_config.ui_numberOfCycles = 1;
	kernel_config.ui_numberOfSteps = 1;

	kernel_config.noOfPatterns = (krui_getNoOfPatterns()>0) ? krui_getNoOfPatterns() : 0;
	kernel_config.noOfUnits = krui_getNoOfUnits();
	kernel_config.noOfInput = krui_getNoOfInputUnits();
	kernel_config.noOfOutput = krui_getNoOfOutputUnits();
	kernel_config.noOfHidden = krui_getNoOfTTypeUnits(HIDDEN);
    }
    return(&kernel_config);
}

res_send_kernel_msg *
send_kernel_msg_40(int *par, struct svc_req * cl)
{
    static res_send_kernel_msg res;
    switch(*par){
      case PING:
	res.return_value = RPC_NO_ERROR;
	break;
      case SHUTDOWN:
	res.return_value = RPC_NO_ERROR;
	QuitKernel(NOSAVE);
	break;
      default:
	res.return_value = RPC_UNKNOWN_OPTION;
	break;
    }
    
    return (&res);
}

rpc_DIRP *
rpc_opendir_40(char **dirname, struct svc_req * cl)
{
    static long resp;
    char *d1;
    if (strcmp(*dirname, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = *dirname;
    }
    resp = (long)opendir(d1);
    return(&resp);
}

rpc_dirent *
rpc_readdir_40(rpc_DIRP **dirp, struct svc_req * cl)
{
    static rpc_dirent res;
    struct dirent *resp;
    resp = readdir((DIR *)*dirp);
    if (resp == NULL) {
	res.last_entry = TRUE;
	res.d_name = null_ptr;
    }else{
	res.last_entry = FALSE;
#if ! defined __PARAGON__ && ! defined ultrix
	res.d_off = resp->d_off;
#endif
	res.d_reclen = resp->d_reclen;       
#if ! defined __linux__ && ! defined sgi
	res.d_fileno = resp->d_fileno;       
	res.d_namlen = resp->d_namlen;       
#endif
	if( resp->d_name == NULL){
	    res.d_name = null_ptr;
	}else{
	    res.d_name = &resp->d_name[0];
	}
    }
    return(&res);
}

int *
rpc_closedir_40(rpc_DIRP **dirp, struct svc_req * cl)
{
    static int res;
    res = closedir((DIR*)*dirp);
    return(&res);
}

char **
rpc_getcwd_40(par_getcwd *par, struct svc_req * cl)
{
    static char *res;
    char *d1;
    if (strcmp(par->buf, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = par->buf;
    }
    res = getcwd(d1,par->size);
    if(res == NULL) res = null_ptr;
    return(&res);
}

int *
rpc_access_40(par_access *par, struct svc_req * cl)
{
    static int res;
    char *d1;
    if (strcmp(par->path, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = par->path;
    }
    res = access(d1,par->mode);
    return(&res);
}

rpc_krui_err   *
download_file_40(par_filetransfer *par, struct svc_req * cl)
{
    static bool opentmpfile=TRUE;
    static FILE *tempfile;
    static rpc_krui_err res;
    static char *netname,buf[128];
    char buf2[135];
    char hostname[MAXHOSTDLEN];
    int  hostlen=16,setno;
    static int epoche=0,laufnr=0;

    if (epoche != par->epoche){
	/*reset Transfer */
	if(!opentmpfile)
	    fclose(tempfile);
	opentmpfile = TRUE;
	laufnr = 0;
	epoche = par->epoche;
    }
    if (par->laufnr != laufnr++){
	res = RPC_WRONG_PAKET;
	return(&res);
    }

    res = RPC_NO_ERROR;
    switch(par->Command){
      case TRANSFERNETWORK:
	if(opentmpfile){
	    gethostname(hostname,hostlen);
	    sprintf(buf,"/tmp/%s.%d.net",hostname,getpid());
	    tempfile = fopen(buf,"w");
	    if (tempfile == NULL) {
		res = RPC_CANNOT_OPEN_FILE;
		return(&res);
	    }
	    opentmpfile = FALSE;
	}
	fwrite(&par->fileblock[0],sizeof(char),par->bytes_used,tempfile);
	if(par->lastblock){
	    fclose(tempfile);
	    krui_deleteNet();
	    res = krui_loadNet(buf,&netname);
	    /* delete file */
	    sprintf(buf2,"/bin/rm -f %s",buf);
	    system(buf2);
	    opentmpfile = TRUE;
	}
	break;
      case TRANSFERPATTERN:
	if(opentmpfile){
	    gethostname(hostname,hostlen);
	    sprintf(buf,"/tmp/%s.%d.pat",hostname,getpid());
	    tempfile = fopen(buf,"w");
	    if (tempfile == NULL) {
		res = RPC_CANNOT_OPEN_FILE;
		return(&res);
	    }
	    opentmpfile = FALSE;
	}
	fwrite(&par->fileblock[0],sizeof(char),par->bytes_used,tempfile);
	if(par->lastblock){
	    fclose(tempfile);
	    res = krui_loadNewPatterns(buf,&setno);
	    /* delete file */
	    sprintf(buf2,"/bin/rm -f %s",buf);
	    system(buf2);
	    opentmpfile = TRUE;
	}
	break;
      default:
	res = RPC_CANNOT_OPEN_FILE;
    }
    return(&res);
}

res_filetransfer   *
upload_file_40(par_upload *par, struct svc_req * cl)
{
    static res_filetransfer res;
    static bool opentmpfile=TRUE;
    static FILE *tempfile;
    char buf[135];
    char buf2[135];
    char hostname[MAXHOSTDLEN];
    int  hostlen=16;
    static int epoche=0,laufnr=0;

    res.error = RPC_NO_ERROR;
    if (epoche != par->epoche){
	/*reset Transfer */
	if(!opentmpfile)
	    fclose(tempfile);
	opentmpfile = TRUE;
	laufnr = 0;
	epoche = par->epoche;
    }
    res.epoche = epoche;
    res.laufnr = laufnr++;
    switch(par->command){
      case TRANSFERNETWORK:
	if(opentmpfile){
	    gethostname(hostname,hostlen);
	    sprintf(buf,"/tmp/%s.%d.net",hostname,getpid());
	    /* Netzwerk sichern */
	    if(krui_saveNet(buf,NULL)!=KRERR_NO_ERROR){
		res.error = RPC_CANNOT_SAVE_FILE;
		return(&res);
	    }
	    tempfile = fopen(buf,"r");
	    if (tempfile == NULL) {
		res.error = RPC_CANNOT_OPEN_FILE;
		return(&res);
	    }
	    opentmpfile = FALSE;
	}
	res.bytes_used = fread(&res.fileblock[0],sizeof(char),FILEBLOCKSIZE-1,tempfile);
	if (feof(tempfile) != 0){
	    res.lastblock=TRUE;
	    fclose(tempfile);
	    /* delete file */
	    sprintf(buf2,"/bin/rm -f %s",buf);
	    system(buf2);
	    opentmpfile = TRUE;
	}else{
	    res.lastblock=FALSE;
	}
	return(&res);
	break;
    case TRANSFERPATTERN:
	if(opentmpfile){
	    gethostname(hostname,hostlen);
	    sprintf(buf,"/tmp/%s.%d.pat",hostname,getpid());
	    /* Netzwerk sichern */
	    if(krui_saveNewPatterns(buf,par->setno)!=KRERR_NO_ERROR){
		res.error = RPC_CANNOT_SAVE_FILE;
		return(&res);
	    }
	    tempfile = fopen(buf,"r");
	    if (tempfile == NULL) {
		res.error = RPC_CANNOT_OPEN_FILE;
		return(&res);
	    }
	    opentmpfile = FALSE;
	}
	res.bytes_used = fread(&res.fileblock[0],sizeof(char),FILEBLOCKSIZE-1,tempfile);
	if (feof(tempfile) != 0){
	    res.lastblock=TRUE;
	    fclose(tempfile);
	    /* delete file */
	    sprintf(buf2,"/bin/rm -f %s",buf);
	    system(buf2);
	    opentmpfile = TRUE;
	}else{
	    res.lastblock=FALSE;
	}
	return(&res);
	break;
    }
    return(&res);
}


int *
set_coopconfig_40(parallel_kernels *conf, struct svc_req * cl)
{
    static int res;
    int i;
    char buf[65];
    bool found=FALSE;

   memcpy(&m_coopKernels[0],conf->kernels.kernels_val
	   ,conf->kernels.kernels_len*sizeof(parallel_kernel));

    m_anzCoopKernels = conf->kernels.kernels_len;
    for (i = 0 ; i < m_anzCoopKernels ; i++){
	m_coopKernels[i].kernelid = conf->kernels.kernels_val[i].kernelid;
	m_coopKernels[i].kernelno = conf->kernels.kernels_val[i].kernelno;
	m_coopKernels[i].host = strdup(conf->kernels.kernels_val[i].host);
	m_coopKernels[i].domain = strdup(conf->kernels.kernels_val[i].domain);
	m_coopKernels[i].hostaddr = 
	    strdup(conf->kernels.kernels_val[i].hostaddr);
	m_coopKernels[i].status = S_IDLE;
	m_coopKernels[i].coop_id = i; 
	if(m_coopKernelsCl[i]!= NULL){
	    auth_destroy(m_coopKernelsCl[i]->cl_auth);
	    clnt_destroy(m_coopKernelsCl[i]);
	}
	m_coopKernelsCl[i] = NULL;
	m_coopKernelsStartT[i].tv_sec = 0L;
	m_coopKernelsStartT[i].tv_usec = 0L;
	m_coopKernelsLastT[i].tv_sec = 0L;
	m_coopKernelsLastT[i].tv_usec = 0L;
    }
     /* init the rest of the coopstructure */
    for (i = m_anzCoopKernels ;i < MAXPARAKERNELS ; i++){
	m_coopKernels[i].status = S_IDLE;
	if(m_coopKernelsCl[i]!= NULL){
	    auth_destroy(m_coopKernelsCl[i]->cl_auth);
	    clnt_destroy(m_coopKernelsCl[i]);
	}
	m_coopKernelsCl[i] = NULL;
	m_coopKernelsStartT[i].tv_sec = 0L;
	m_coopKernelsStartT[i].tv_usec = 0L;
	m_coopKernelsLastT[i].tv_sec = 0L;
	m_coopKernelsLastT[i].tv_usec = 0L;
    }
    /* Is this the master ?? */
    gethostname(buf,64);
    if((strcmp(m_coopKernels[0].host,buf)==0)
       && m_coopKernels[0].kernelno == rpcversion){
	kernelMode = COOP_M_KERNEL;
	kernel_config.kernelMode = COOP_M_KERNEL;
#ifdef DEBUG
	printf("KernelMode is MASTER\n");
#endif
    }else{
	/* Slave ?? */
	for(i = 1 ; i < m_anzCoopKernels ; i++){
	    if((strcmp(m_coopKernels[i].host,buf)==0)
	       && m_coopKernels[i].kernelno == rpcversion){   
		found = TRUE;
		kernelMode = COOP_S_KERNEL;
		kernel_config.kernelMode = COOP_S_KERNEL;
#ifdef DEBUG
		printf("KernelMode is SLAVE\n");
#endif
	    }		
	}
	if(!found){
	    kernelMode = NORMALKERNEL;
	    kernel_config.kernelMode = NORMALKERNEL;
#ifdef DEBUG
	    printf("KernelMode is NORMAL\n");
#endif
	}		
    }
	
#ifdef DEBUG
    kr_showCoopConfig();
#endif
    
    
    res = RPC_NO_ERROR;
    return(&res);
}

int *
send_par_matrix_40(par_matrix *par, struct svc_req * cl)
{
    static int res;

    res = RPC_NO_ERROR;
    switch(par->val_type){
      case VAL_WEIGHT:

	break;
      default:
	res = RPC_UNKNOWN_OPTION;
	break;
    }

    return(&res);
}

int *
send_res_matrix_40(res_matrix *par, struct svc_req * cl)
{
    static int res;
    res = RPC_NO_ERROR;
    switch(par->val_type){
      case VAL_WEIGHT:

	break;
      default:
	res = RPC_UNKNOWN_OPTION;
	break;
    }


    return(&res);
}

int *
start_learning_40(par_learning *par, struct svc_req * cl)
{
    static int res;

#ifdef DEBUG
    printf("Start Learning from Pattern %ld to %ld \n with CoopID:%d\n"
	   ,par->startpat,par->endpat,par->coop_id);
#endif
    res = RPC_NO_ERROR;
    
    /* send replay to the coop_master */
    if (!svc_sendreply(global_transp, xdr_int, &res)) {
	svcerr_systemerr(global_transp);
    }

    /* Start Learning */

    return(&res);
}


res_stat *
rpc_stat_40(char  **path, struct svc_req * cl)
{
    static res_stat res;
    char *d1;
    if (strcmp(*path, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = *path;
    }
    res.return_value = stat(d1,&res);
    return(&res);
}


int            *
krui_getnoofunits_40(void *dummy, struct svc_req * cl)
{
    static int      res;
    res = krui_getNoOfUnits();
    return (&res);
}

int            *
krui_getfirstunit_40(void *dummy, struct svc_req * cl)
{
    static int      res;
    res = krui_getFirstUnit();
    return (&res);
}

int            *
krui_getnextunit_40(void *dummy, struct svc_req * cl)
{
    static int      res;
    res = krui_getNextUnit();
    return (&res);
}

int            *
krui_getcurrentunit_40(void *dummy, struct svc_req * cl)
{
    static int      res;
    res = krui_getCurrentUnit();
    return (&res);
}

rpc_krui_err   *
krui_setcurrentunit_40(int *unit_no, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_setCurrentUnit(*unit_no);
    return (&res);
}

char          **
krui_getunitname_40(int *unit_no, struct svc_req * cl)
{
    static char    *res;
    res = krui_getUnitName(*unit_no);
    if(res == NULL) res = null_ptr;
    return (&res);
}

rpc_krui_err   *
krui_setunitname_40(par_setUnitName *par, struct svc_req * cl)
{
    static rpc_krui_err res;
    char *d1;
    if (strcmp(par->unit_name, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = par->unit_name;
    }
    res = krui_setUnitName(par->unit_no,d1);
    return (&res);
}

int            *
krui_searchunitname_40(char **unit_name, struct svc_req * cl)
{
    static int      res;
    char *d1;
    if (strcmp(*unit_name, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = *unit_name;
    }
    res = krui_searchUnitName(d1);
    return (&res);
}


int            *
krui_searchnextunitname_40(void *dummy, struct svc_req * cl)
{
    static int      res;
    res = krui_searchNextUnitName();
    return (&res);
}

char           **
krui_getunitoutfuncname_40(int *unitno, struct svc_req * cl)
{
    static char *res;
    res = krui_getUnitOutFuncName(*unitno);
    if(res == NULL) res = null_ptr;
    return (&res);
}
rpc_krui_err   *
krui_setunitoutfunc_40(par_setUnitOutFunc *par, struct svc_req * cl)
{
    static rpc_krui_err res;
    char *d1;
    if (strcmp(par->unitOutFuncName, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = par->unitOutFuncName;
    }
    res = krui_setUnitOutFunc(par->unit_no,d1);
    return (&res);
}
char           **
krui_getunitactfuncname_40(int *unitno, struct svc_req * cl)
{
    static char *res;
    res = krui_getUnitActFuncName(*unitno);
    if(res == NULL) res = null_ptr;
    return (&res);
}
rpc_krui_err   *
krui_setunitactfunc_40(par_setUnitActFunc *par, struct svc_req * cl)
{
    static rpc_krui_err res;
    char *d1;
    if (strcmp(par->unitActFuncName, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = par->unitActFuncName;
    }
    res = krui_setUnitActFunc(par->unit_no,d1);
    return (&res);
}
char           **
krui_getunitftypename_40(int *unitno, struct svc_req * cl)
{
    static char *res;
    res = krui_getUnitFTypeName(*unitno);
    if(res == NULL) res = null_ptr;
    return (&res);
}
rpc_FlintType  *
krui_getunitactivation_40(int *unitno, struct svc_req * cl)
{
    static rpc_FlintType res;
    res = krui_getUnitActivation(*unitno);
    return (&res);
}
rpc_krui_err   *
krui_setunitactivation_40(par_setUnitActivation *par, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_setUnitActivation(par->UnitNo,par->unit_activation);
    return (&res);
}

rpc_FlintType  *
krui_getunitinitialactivation_40(int *unitno, struct svc_req * cl)
{
    static rpc_FlintType res;
    res = krui_getUnitInitialActivation(*unitno);
    return (&res);
}
void * 
krui_setunitinitialactivation_40( par_setUnitInitialActivation *par, struct svc_req * cl)
{
    static int res;
    krui_setUnitInitialActivation(par->UnitNo,par->unit_i_activation);
    return (&res);
}
rpc_FlintType *
krui_getunitoutput_40(int *unitno, struct svc_req * cl)
{
    static rpc_FlintType res;
    res = krui_getUnitOutput(*unitno);
    return (&res);
}
rpc_krui_err 	* 
krui_setunitoutput_40(par_setUnitOutput *par, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_setUnitOutput(par->unit_no,par->unit_output); 
    return (&res);
}
rpc_FlintType *
krui_getunitbias_40(int *unitno, struct svc_req * cl)
{
    static rpc_FlintType res;
    res = krui_getUnitBias(*unitno);
    return (&res);
}
void *
krui_setunitbias_40(par_setUnitBias *par, struct svc_req * cl)
{
    static int res;
    krui_setUnitBias(par->UnitNo,par->unit_bias); 
    return(&res);
}

rpc_FlintType  *
krui_getunitvaluea_40(int *unitno, struct svc_req * cl)
{
    static rpc_FlintType res;
    res = krui_getUnitValueA(*unitno);
    return (&res);
}
void * 
krui_setunitvaluea_40( par_setUnitValueA *par, struct svc_req * cl)
{
    static int res;
    krui_setUnitValueA(par->UnitNo,par->unit_valueA);
    return (&res);
}
int *
krui_getunitsubnetno_40(int *unitno, struct svc_req * cl)
{
    static int res;
    res = krui_getUnitSubnetNo(*unitno);
    return (&res);
}
void *
krui_setunitsubnetno_40(par_setUnitSubnetNo *par, struct svc_req * cl)
{
    static int res;
    krui_setUnitSubnetNo(par->UnitNo,par->subnet_no); 
    return (&res);
}
unsigned short *
krui_getunitlayerno_40(int *unitno, struct svc_req * cl)
{
    static unsigned short res;
    res = krui_getUnitLayerNo(*unitno);
    return (&res);
}
void *
krui_setunitlayerno_40(par_setUnitLayerNo *par, struct svc_req * cl)
{
    static int res;
    krui_setUnitLayerNo(par->UnitNo,par->layer_no); 
    return (&res);
}
res_getUnitPosition *
krui_getunitposition_40(par_getUnitPosition *par, struct svc_req * cl)
{
    static res_getUnitPosition res;
    krui_getUnitPosition(par->UnitNo,((struct PosType *)par->position));
    res.position.x = par->position->x;
    res.position.y = par->position->y;
    res.position.z = par->position->z;

    return (&res);
}
void *
krui_setunitposition_40(par_setUnitPosition *par, struct svc_req * cl)
{
    static int res;
    krui_setUnitPosition(par->UnitNo,((struct PosType *)par->position));
    return (&res);
}
int *
krui_getunitnoatposition_40(par_getUnitNoAtPosition *par, struct svc_req * cl)
{
    static int res;
    res = krui_getUnitNoAtPosition((struct PosType *)par->position,
				   par->subnet_no);
    return (&res);
}
int *
krui_getunitnonearposition_40(par_getUnitNoNearPosition *par, struct svc_req * cl)
{
    static int res;
    res = krui_getUnitNoNearPosition((struct PosType *)par->position,
				     par->subnet_no,
				     par->range,par->gridWidth);
    return (&res);
}
int *
krui_getunitttype_40(int *unit_no, struct svc_req * cl)
{
    static int res;
    res = krui_getUnitTType(*unit_no);
    return (&res);
}
rpc_krui_err 	* 
krui_setunitttype_40(par_setUnitTType *par, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_setUnitTType(par->unit_no,par->UnitTType);
    return (&res);
}
rpc_krui_err 	* 
krui_freezeunit_40(int *unit_no, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_freezeUnit(*unit_no);
    return (&res);
}
rpc_krui_err 	* 
krui_unfreezeunit_40(int *unit_no, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_unfreezeUnit(*unit_no);
    return (&res);
}
bool *
krui_isunitfrozen_40(int *unit_no, struct svc_req * cl)
{
    static bool res;
    res = krui_isUnitFrozen(*unit_no);
    return (&res);
}
int *
krui_getunitinputtype_40(int *unit_no, struct svc_req * cl)
{
    static int res;
    res = krui_getUnitInputType(*unit_no);
    return (&res);
}
int *
krui_createdefaultunit_40(void *dummy, struct svc_req * cl)
{
    static int res;
    res = krui_createDefaultUnit();
    return (&res);
}
int *
krui_createunit_40(par_createUnit *par, struct svc_req * cl)
{
    static int res;
    char *d1,*d2,*d3;
    if (strcmp(par->unit_name, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = par->unit_name;
    }
    if (strcmp(par->out_func_name, null_ptr)==0) {
	d2 = NULL;
    }else{
	d2 = par->out_func_name;
    }
    if (strcmp(par->act_func_name, null_ptr)==0) {
	d3 = NULL;
    }else{
	d3 = par->act_func_name;
    }
    res = krui_createUnit(d1,d2,d3,par->i_act,par->bias);
    return (&res);
}
rpc_krui_err 	* 
krui_deleteunit_40(int *unit_no, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_deleteUnit(*unit_no);
    return (&res);
}
rpc_krui_err 	* 
krui_deleteunitlist_40(par_deleteUnitList *par, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_deleteUnitList(par->no_of_units,par->unit_list.unit_list_val);
    return (&res);
}
int *
krui_createftypeunit_40(char **ftype_symbol, struct svc_req * cl)
{
    static int res;
    char *d1;
    if (strcmp(*ftype_symbol, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = *ftype_symbol;
    }
    res = krui_createFTypeUnit(d1);
    return (&res);
}
rpc_krui_err 	* 
krui_setunitftype_40(par_setUnitFType *par, struct svc_req * cl)
{
    static rpc_krui_err res;
    char *d1;
    if (strcmp(par->Ftype_symbol, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = par->Ftype_symbol;
    }
    res = krui_setUnitFType(par->unit_no,d1);
    return (&res);
}
int *
krui_copyunit_40(par_copyUnit *par, struct svc_req * cl)
{
    static int res;
    res = krui_copyUnit(par->unit_no,par->copy_mode);
    return (&res);
}
bool *
krui_setfirstftypeentry_40(void *dummy, struct svc_req * cl)
{
    static bool res;
    res = krui_setFirstFTypeEntry();
    return (&res);
}
bool *
krui_setnextftypeentry_40(void *dummy, struct svc_req * cl)
{
    static bool res;
    res = krui_setNextFTypeEntry();
    return (&res);
}
bool *
krui_setftypeentry_40(char **ftype_symbol, struct svc_req * cl)
{
    static bool res;
    char *d1;
    if (strcmp(*ftype_symbol, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = *ftype_symbol;
    }
    res = krui_setFTypeEntry(d1);
    return (&res);
}
char          **
krui_getftypename_40(void *dummy, struct svc_req * cl)
{
    static char *res;
    res = krui_getFTypeName();
    if(res == NULL) res = null_ptr;
    return (&res);
}
rpc_krui_err 	* 
krui_setftypename_40(char **ftype_symbol, struct svc_req * cl)
{
    static rpc_krui_err res;
    char *d1;
    if (strcmp(*ftype_symbol, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = *ftype_symbol;
    }
    res = krui_setFTypeName(d1);
    return (&res);
}
char           **
krui_getftypeactfuncname_40(void *dummy, struct svc_req * cl)
{
    static char *res;
    res = krui_getFTypeActFuncName();
    if(res == NULL) res = null_ptr;
    return (&res);
}
char           **
krui_getftypeoutfuncname_40(void *dummy, struct svc_req * cl)
{
    static char *res;
    res = krui_getFTypeOutFuncName();
    return (&res);
}
rpc_krui_err 	* 
krui_setftypeactfunc_40(char **act_func_name, struct svc_req * cl)
{
    static rpc_krui_err res;
    char *d1;
    if (strcmp(*act_func_name, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = *act_func_name;
    }
    res = krui_setFTypeActFunc(d1);
    return (&res);
}
rpc_krui_err 	* 
krui_setftypeoutfunc_40(char **out_func_name, struct svc_req * cl)
{
    static rpc_krui_err res;
    if (strcmp(*out_func_name, null_ptr)==0) {
	res = krui_setFTypeOutFunc(NULL);
    }else{
	res = krui_setFTypeOutFunc(*out_func_name);
    }
    return (&res);
}
bool *
krui_setfirstftypesite_40(void *dummy, struct svc_req * cl)
{
    static bool res;
    res = krui_setFirstFTypeSite();
    return (&res);
}
bool *
krui_setnextftypesite_40(void *dummy, struct svc_req * cl)
{
    static bool res;
    res = krui_setNextFTypeSite();
    return (&res);
}
char           **
krui_getftypesitename_40(void *dummy, struct svc_req * cl)
{
    static char *res;
    res = krui_getFTypeSiteName();
    if(res == NULL) res = null_ptr;
    return (&res);
}
rpc_krui_err 	* 
krui_setftypesitename_40(char **ftype_site_name, struct svc_req * cl)
{
    static rpc_krui_err res;
    char *d1;
    if (strcmp(*ftype_site_name, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = *ftype_site_name;
    }
    res = krui_setFTypeSiteName(d1);
    return (&res);
}
rpc_krui_err 	* 
krui_createftypeentry_40(par_createFTypeEntry *par, struct svc_req * cl)
{
    static rpc_krui_err res;
    char *d1,*d2,*d3;
    if (strcmp(par->Ftype_symbol, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = par->Ftype_symbol;
    }
    if (strcmp(par->act_func_name, null_ptr)==0) {
	d2 = NULL;
    }else{
	d2 = par->act_func_name;
    }
    if (strcmp(par->out_func_name, null_ptr)==0) {
	d3 = NULL;
    }else{
	d3 = par->out_func_name;
    }
    res=krui_createFTypeEntry(d1,d2,d3,par->no_of_sites,
			      par->array_of_site_names.array_of_site_names_val);
    
    return (&res);
}
rpc_krui_err 	* 
krui_deleteftypeentry_40(char **ftype_symbol, struct svc_req * cl)
{
    static rpc_krui_err res;
    char *d1;
    if (strcmp(*ftype_symbol, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = *ftype_symbol;
    }
    res = krui_deleteFTypeEntry(d1);
    return (&res);
}
int *
krui_getnooffunctions_40(void *dummy, struct svc_req * cl)
{
    static int res;
    res = krui_getNoOfFunctions();
    return (&res);
}
res_getFuncInfo *
krui_getfuncinfo_40(int *func_no, struct svc_req * cl)
{
    static res_getFuncInfo res;
    krui_getFuncInfo(*func_no,&res.func_name,&res.func_type);
    if(res.func_name == NULL) res.func_name = null_ptr;
    return (&res);
}
bool *
krui_isfunction_40(par_isFunction *par, struct svc_req * cl)
{
    static bool res;
    char *d1;
    if (strcmp(par->func_name, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = par->func_name;
    }
    res = krui_isFunction(d1,par->func_type);
    return (&res);
}
res_getFuncParamInfo *
krui_getfuncparaminfo_40(par_getFuncParamInfo *par, struct svc_req * cl)
{
    static res_getFuncParamInfo res;
    char *d1;
    if (strcmp(par->func_name, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = par->func_name;
    }
    res.return_value = krui_getFuncParamInfo(d1,par->func_type,
					     &res.no_of_input_params,
					     &res.no_of_output_params);
    return (&res);
}
res_getSiteTableEntry *
krui_getfirstsitetableentry_40(par_getSiteTableEntry *par, struct svc_req * cl)
{
    static res_getSiteTableEntry  res;
    res.return_value = krui_getFirstSiteTableEntry(&res.site_name,&res.site_func);
    if(res.site_name == NULL) res.site_name = null_ptr;
    if(res.site_func == NULL) res.site_func = null_ptr;
    return (&res);
}
res_getSiteTableEntry *
krui_getnextsitetableentry_40(par_getSiteTableEntry *par, struct svc_req * cl)
{
    static res_getSiteTableEntry  res;
    res.return_value = krui_getNextSiteTableEntry(&res.site_name,&res.site_func);
    if(res.site_name == NULL) res.site_name = null_ptr;
    if(res.site_func == NULL) res.site_func = null_ptr;
    return (&res);
}
char           **
krui_getsitetablefuncname_40(char **site_name, struct svc_req * cl)
{
    static char *res;
    if (strcmp(*site_name, null_ptr)==0) {
	res = krui_getSiteTableFuncName(NULL);
    }else{
	res = krui_getSiteTableFuncName(*site_name);
    }
    if(res == NULL) res = null_ptr;
    return (&res);
}
rpc_krui_err 	* 
krui_createsitetableentry_40(par_createSiteTableEntry *par, struct svc_req * cl)
{
    static rpc_krui_err res;
    char *d1,*d2;
    if (strcmp(par->site_name, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = par->site_name;
    }
    if (strcmp(par->site_func, null_ptr)==0) {
	d2 = NULL;
    }else{
	d2 = par->site_func;
    }
    res = krui_createSiteTableEntry(d1,d2);
    return (&res);
}
rpc_krui_err 	* 
krui_changesitetableentry_40(par_changeSiteTableEntry *par, struct svc_req * cl)
{
    static rpc_krui_err res;
    char *d1,*d2,*d3;
    if (strcmp(par->old_site_name, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = par->old_site_name;
    }
    if (strcmp(par->new_site_name, null_ptr)==0) {
	d2 = NULL;
    }else{
	d2 = par->new_site_name;
    }
    if (strcmp(par->new_site_func, null_ptr)==0) {
	d3 = NULL;
    }else{
	d3 = par->new_site_func;
    }
    res = krui_changeSiteTableEntry(d1,d2,d3);
    return (&res);
}
rpc_krui_err 	* 
krui_deletesitetableentry_40(char **site_name, struct svc_req * cl)
{
    static rpc_krui_err res;
    char *d1;
    if (strcmp(*site_name, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = *site_name;
    }
    res = krui_deleteSiteTableEntry(d1);
    return (&res);
}
bool *
krui_setfirstsite_40(void *dummy, struct svc_req * cl)
{
    static bool res;
    res = krui_setFirstSite();
    return (&res);
}
bool *
krui_setnextsite_40(void *dummy, struct svc_req * cl)
{
    static bool res;
    res = krui_setNextSite();
    return (&res);
}
rpc_krui_err 	* 
krui_setsite_40(char **site_name, struct svc_req * cl)
{
    static rpc_krui_err res;
    char *d1;
    if (strcmp(*site_name, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = *site_name;
    }
    res = krui_setSite(d1);
    return (&res);
}
rpc_FlintType * 
krui_getsitevalue_40(void *dummy, struct svc_req * cl)
{
    static rpc_FlintType res;
    res = krui_getSiteValue();
    return (&res);
}
char          **
krui_getsitename_40(void *dummy, struct svc_req * cl)
{
    static char *res;
    res = krui_getSiteName();
    if(res == NULL) res = null_ptr;
    return (&res);
}
rpc_krui_err 	* 
krui_setsitename_40(char **site_name, struct svc_req * cl)
{
    static rpc_krui_err res;
    if (strcmp(*site_name, null_ptr)==0) {
	res = krui_setSiteName(NULL);
    }else{
	res = krui_setSiteName(*site_name);
    }
    return (&res);
}
char           **
krui_getsitefuncname_40(void *dummy, struct svc_req * cl)
{
    static char *res;
    res = krui_getSiteFuncName();
    if(res == NULL) res = null_ptr;
    return (&res);
}
rpc_krui_err 	* 
krui_addsite_40(char **site_name, struct svc_req * cl)
{
    static rpc_krui_err res;
    if (strcmp(*site_name, null_ptr)==0) {
	res = krui_setSiteName(NULL);
    }else{
	res = krui_setSiteName(*site_name);
    }
    return (&res);
}
bool *
krui_deletesite_40(void *dummy, struct svc_req * cl)
{
    static bool res;
    res = krui_deleteSite();
    return (&res);
}
res_Links *
krui_getfirstpredunit_40(rpc_FlintType * strength, struct svc_req * cl)
{
    static res_Links res;
    res.return_value = krui_getFirstPredUnit(&res.strength);
    return (&res);
}
/*
res_Links *
krui_getfirstlogpredunit_40(rpc_FlintType * strength, struct svc_req * cl)
{
    static res_Links res;
    res.return_value = krui_getFirstLogPredUnit(&res.strength);
    return (&res);
}
*/
res_Links *
krui_getnextpredunit_40(rpc_FlintType * strength, struct svc_req * cl)
{
    static res_Links res;
    res.return_value = krui_getNextPredUnit(&res.strength);
    return (&res);
}
/*
res_Links *
krui_getnextlogpredunit_40(rpc_FlintType * strength, struct svc_req * cl)
{
    static res_Links res;
    res.return_value = krui_getNextLogPredUnit(&res.strength);
    return (&res);
}
*/
res_Links *
krui_getcurrentpredunit_40(rpc_FlintType * strength, struct svc_req * cl)
{
    static res_Links res;
    res.return_value = krui_getCurrentPredUnit(&res.strength);
    return (&res);
}
res_Links *
krui_getfirstsuccunit_40(par_getFirstSuccUnit *par, struct svc_req * cl)
{
    static res_Links res;
    res.return_value = krui_getFirstSuccUnit(par->source_unit_no,&res.strength);
    return (&res);
}
/*
res_Links *
krui_getfirstlogsuccunit_40(par_getFirstLogSuccUnit *par, struct svc_req * cl)
{
    static res_Links res;
    res.return_value = krui_getFirstLogSuccUnit(par->source_unit_no,&res.strength);
    return (&res);
}
*/
res_Links *
krui_getnextsuccunit_40(rpc_FlintType * weight, struct svc_req * cl)
{
    static res_Links res;
    res.return_value = krui_getNextSuccUnit(&res.strength);
    return (&res);
}
/*
res_Links *
krui_getnextlogsuccunit_40(rpc_FlintType * weight, struct svc_req * cl)
{
    static res_Links res;
    res.return_value = krui_getNextLogSuccUnit(&res.strength);
    return (&res);
}
*/
bool *
krui_areconnected_40(par_areConnected *par, struct svc_req * cl)
{
    static bool res;
    res = krui_areConnected(par->source_unit_no,par->target_unit_no);
    return (&res);
}
res_Links_Bool *
krui_areconnectedweight_40(par_areConnected *par, struct svc_req * cl)
{
    static res_Links_Bool res;
    res.return_value = krui_areConnectedWeight(par->source_unit_no,
					       par->target_unit_no,
					       &res.strength);
    return (&res);
}
bool *
krui_isconnected_40(int *source_unit_no, struct svc_req * cl)
{
    static bool res;
    res = krui_isConnected(*source_unit_no);
    return (&res);
}
rpc_FlintType *
krui_getlinkweight_40(void *dummy, struct svc_req * cl)
{
    static rpc_FlintType res;
    res = krui_getLinkWeight();
    return (&res);
}
void *           
krui_setlinkweight_40(rpc_FlintTypeParam *weight, struct svc_req * cl)
{
    static int res;
    krui_setLinkWeight(*weight);
    return (&res);
}

rpc_krui_err 	* 
krui_createlink_40(par_createLink *par, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_createLink(par->source_unit_no,par->weight);
    return (&res);
}
rpc_krui_err 	* 
krui_deletelink_40(void *dummy, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_deleteLink();
    return (&res);
}
rpc_krui_err 	* 
krui_deleteallinputlinks_40(void *dummy, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_deleteAllInputLinks();
    return (&res);
}
rpc_krui_err 	* 
krui_deletealloutputlinks_40(void *dummy, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_deleteAllOutputLinks();
    return (&res);
};

void  *         
krui_jogweights_40(par_jogWeights *par, struct svc_req * cl)
{
    static int res;
    krui_jogWeights(par->minus,par->plus);
    return (&res);
}                        
float 	* 
krui_getvariance_40(void *dummy, struct svc_req * cl)
{
    static float res;
    res = krui_getVariance();
    return (&res);
}               
int 	* 
krui_countlinks_40(void *dummy, struct svc_req * cl)
{
    static int res;
    res = krui_countLinks();
    return (&res);
}
int 	* 
krui_checkpruning_40(void *dummy, struct svc_req * cl)
{
    static int res;
    res = krui_checkPruning();
    return (&res);
}                               
rpc_krui_err 	* 
krui_updatesingleunit_40(int *unit_no, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_updateSingleUnit(*unit_no); 
    return (&res);
}
char           **
krui_getupdatefunc_40(void *dummy, struct svc_req * cl)
{
    static char *res;
    res = krui_getUpdateFunc();
    if(res == NULL) res = null_ptr;
    return (&res);
}
rpc_krui_err 	* 
krui_setupdatefunc_40(char **update_func, struct svc_req * cl)
{
    static rpc_krui_err res;
    if (strcmp(*update_func, null_ptr)==0) {
	res = krui_setUpdateFunc(NULL);
    }else{
	res = krui_setUpdateFunc(*update_func);
    }
    return (&res);
}
rpc_krui_err 	* 
krui_updatenet_40(par_updateNet *par, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_updateNet(par->parameterInArray.parameterInArray_val,
			 par->NoOfInParams);
    return (&res);
}
char           **
krui_getinitialisationfunc_40(void *dummy, struct svc_req * cl)
{
    static char *res;
    res = krui_getInitialisationFunc();
    if(res == NULL) res = null_ptr;
    return (&res);
}
rpc_krui_err 	* 
krui_setinitialisationfunc_40(char **initialisation_func, struct svc_req * cl)
{
    static rpc_krui_err res;
    if (strcmp(*initialisation_func, null_ptr)==0) {
	res = krui_setInitialisationFunc(NULL);
    }else{
	res = krui_setInitialisationFunc(*initialisation_func);
    }
    return (&res);
}
rpc_krui_err 	* 
krui_initializenet_40(par_initializeNet *par, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_initializeNet(par->parameterInArray.parameterInArray_val,
			     par->parameterInArray.parameterInArray_len);
    return (&res);
}
char           **
krui_getlearnfunc_40(void *dummy, struct svc_req * cl)
{
    static char *res;
    res = krui_getLearnFunc();
    if(res == NULL) res = null_ptr;
    return (&res);
}
rpc_krui_err 	* 
krui_setlearnfunc_40(char **learning_func, struct svc_req * cl)
{
    static rpc_krui_err res;
    if (strcmp(*learning_func, null_ptr)==0) {
	res = krui_setLearnFunc(NULL);
    }else{
	res = krui_setLearnFunc(*learning_func);
    }
    return (&res);
}
rpc_krui_err 	* 
krui_setprunfunc_40(char **learning_func, struct svc_req * cl)
{
    static rpc_krui_err res;
    if (strcmp(*learning_func, null_ptr)==0) {
	res = krui_setPrunFunc(NULL);
    }else{
	res = krui_setPrunFunc(*learning_func);
    }
    return (&res);
}
char           **
krui_getprunfunc_40(void *dummy, struct svc_req * cl)
{
    static char *res;
    res = krui_getPrunFunc();
    if(res == NULL) res = null_ptr;
    return (&res);
}
rpc_krui_err 	* 
krui_setfflearnfunc_40(char **learning_func, struct svc_req * cl)
{
    static rpc_krui_err res;
    if (strcmp(*learning_func, null_ptr)==0) {
	res = krui_setFFLearnFunc(NULL);
    }else{
	res = krui_setFFLearnFunc(*learning_func);
    }
    return (&res);
}
char           **
krui_getfflearnfunc_40(void *dummy, struct svc_req * cl)
{
    static char *res;
    res = krui_getFFLearnFunc();
    if(res == NULL) res = null_ptr;
    return (&res);
}
res_NetLearnParameters *
krui_trainnetwork_40(par_NetLearnParameters *par, struct svc_req * cl)
{
    static res_NetLearnParameters res;
    NetLearnParameters para;
    int i;

    kernel_config.status = S_LEARNING;

    for (i = 0 ; i < par->noOfParameters ; i++)
	para.parameter[i] = par->parameter.parameter_val[i];
    para.noOfParameters = par->parameter.parameter_len;
    para.noOfParameters = par->noOfParameters;
    para.firstPattern = par->firstPattern;
    para.lastPattern = par->lastPattern;
    para.noOfEpochs = par->noOfEpochs;
	
    res.return_value =
	krui_trainNetwork(&para);

    res.result.result_val = &para.result[0];
    res.result.result_len = para.noOfResults;
    res.noOfResults = para.noOfResults;
    res.learnErrors.learnErrors_val = &para.learnErrors[0];
    res.learnErrors.learnErrors_len = para.noOfErrors;
    res.noOfErrors = para.noOfErrors;
    /* parameterDescription not supproted yet */

    kernel_config.status = S_IDLE;

    return(&res);
}

res_getNetworkErrorArray *
krui_getnetworkerrorarray_40(void *dummy, struct svc_req * cl)
{
    static res_getNetworkErrorArray res;

    res.return_value = 
	krui_getNetworkErrorArray(&res.learnErrors.learnErrors_val
				  ,&res.atEpoch.atEpoch_val,&res.noOfErrors);
    res.learnErrors.learnErrors_len = res.noOfErrors;
    res.atEpoch.atEpoch_len = res.noOfErrors;

    return (&res);
}

rpc_krui_err *
krui_stoptraining_40(void *dummy, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_stopTraining();
    kernel_config.status = S_IDLE;
    return(&res);
}


res_learnPatterns 	* 
krui_learnallpatterns_40(par_learnPatterns *par, struct svc_req * cl)
{
    static res_learnPatterns res;

    kernel_config.status = S_LEARNING;

    res.return_value = 
	krui_learnAllPatterns(par->parameterInArray.parameterInArray_val,
			      par->parameterInArray.parameterInArray_len,
			      &res.parameterOutArray.parameterOutArray_val,
			      &res.parameterOutArray.parameterOutArray_len);
    res.NoOfOutParams = res.parameterOutArray.parameterOutArray_len;

    kernel_config.status = S_IDLE;

    return (&res);
}
res_learnPatterns 	* 
krui_testallpatterns_40(par_learnPatterns *par, struct svc_req * cl)
{
    static res_learnPatterns res;

    res.return_value = 
	krui_testAllPatterns(par->parameterInArray.parameterInArray_val,
			      par->parameterInArray.parameterInArray_len,
			      &res.parameterOutArray.parameterOutArray_val,
			      &res.parameterOutArray.parameterOutArray_len);
    res.NoOfOutParams = res.parameterOutArray.parameterOutArray_len;
    return (&res);
}
res_learnPatterns 	* 
krui_learnsinglepattern_40(par_learnPatterns *par, struct svc_req * cl)
{
    static res_learnPatterns res;

    kernel_config.status = S_LEARNING;

    res.return_value = 
	krui_learnSinglePattern(par->pattern_no,
				par->parameterInArray.parameterInArray_val,
				par->parameterInArray.parameterInArray_len,
				&res.parameterOutArray.parameterOutArray_val,
				&res.parameterOutArray.parameterOutArray_len);
    res.NoOfOutParams = res.parameterOutArray.parameterOutArray_len;

    kernel_config.status = S_IDLE;

    return (&res);
}
res_learnPatterns 	* 
krui_testsinglepattern_40(par_learnPatterns *par, struct svc_req * cl)
{
    static res_learnPatterns res;

    res.return_value = 
	krui_testSinglePattern(par->pattern_no,
				par->parameterInArray.parameterInArray_val,
				par->parameterInArray.parameterInArray_len,
				&res.parameterOutArray.parameterOutArray_val,
				&res.parameterOutArray.parameterOutArray_len);
    res.NoOfOutParams = res.parameterOutArray.parameterOutArray_len;
    return (&res);
}
res_learnPatterns 	* 
krui_learnsinglepatternff_40(par_learnPatterns *par, struct svc_req * cl)
{
    static res_learnPatterns res;

    kernel_config.status = S_LEARNING;

    res.return_value = 
	krui_learnSinglePatternFF(par->pattern_no,
				par->parameterInArray.parameterInArray_val,
				par->parameterInArray.parameterInArray_len,
				&res.parameterOutArray.parameterOutArray_val,
				&res.parameterOutArray.parameterOutArray_len);
    res.NoOfOutParams = res.parameterOutArray.parameterOutArray_len;

    kernel_config.status = S_IDLE;

    return (&res);
}
res_learnPatterns 	* 
krui_learnallpatternsff_40(par_learnPatterns *par, struct svc_req * cl)
{
    static res_learnPatterns res;

    kernel_config.status = S_LEARNING;

    res.return_value = 
	krui_learnAllPatternsFF(par->parameterInArray.parameterInArray_val,
			      par->parameterInArray.parameterInArray_len,
			      &res.parameterOutArray.parameterOutArray_val,
			      &res.parameterOutArray.parameterOutArray_len);
    res.NoOfOutParams = res.parameterOutArray.parameterOutArray_len;

    kernel_config.status = S_IDLE;

    return (&res);
}
rpc_krui_err 	* 
krui_showpattern_40(int *mode, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_showPattern(*mode);
    return (&res);
}
res_allocNewPatternSet 	* 
krui_allocnewpatternset_40(int *set_no, struct svc_req * cl)
{
    static res_allocNewPatternSet res;
    res.return_value = krui_allocNewPatternSet(&res.set_no);
    return (&res);
}
rpc_krui_err 	* 
krui_newpattern_40(void *dummy, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_newPattern();
    return (&res);
}
rpc_krui_err 	* 
krui_setpatternno_40(int *pattern_no, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_setPatternNo(*pattern_no);
    return (&res);
}
rpc_krui_err 	* 
krui_deletepattern_40(void *dummy, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_deletePattern();
    return (&res);
}
rpc_krui_err 	* 
krui_modifypattern_40(void *dummy, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_modifyPattern();
    return (&res);
}

void *           
krui_deleteallpatterns_40(void *dummy, struct svc_req * cl)
{
    static int res;
    krui_deleteAllPatterns();
    return (&res);
}
rpc_krui_err 	* 
krui_shufflepatterns_40(bool *on_or_off, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_shufflePatterns(*on_or_off);
    return (&res);
}
rpc_krui_err 	* 
krui_shufflesubpatterns_40(bool *on_or_off, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_shuffleSubPatterns(*on_or_off);
    return (&res);
}
int *
krui_getnoofpatterns_40(void *dummy, struct svc_req * cl)
{
    static int res;
    res = krui_getNoOfPatterns();
    return (&res);
}
res_loadNewPatterns * 
krui_loadnewpatterns_40(char **filename,struct svc_req * cl)
{
    static res_loadNewPatterns res;

    kernel_config.status = S_LOAD;

    if (strcmp(*filename, null_ptr)==0) {
	res.return_value = krui_loadNewPatterns(NULL,&res.number);
    }else{
	res.return_value = krui_loadNewPatterns(*filename,&res.number);
    }

    kernel_config.status = S_IDLE;

    return (&res);
}
rpc_krui_err 	* 
krui_setcurrpatset_40(int *number, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_setCurrPatSet(*number);
    return (&res);
}
rpc_krui_err 	* 
krui_savenewpatterns_40(par_saveNewPatterns *par, struct svc_req * cl)
{
    static rpc_krui_err res;

    kernel_config.status = S_SAVE;

     if (strcmp(par->filename, null_ptr)==0) {
	res = krui_saveNewPatterns(NULL,par->number);
    }else{
	res = krui_saveNewPatterns(par->filename,par->number);
    }

    kernel_config.status = S_IDLE;

    return (&res);
}
rpc_krui_err 	* 
krui_deletepatset_40(int *number, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_deletePatSet(*number);
    return (&res);
}
res_getPatInfo 	* 
krui_getpatinfo_40(void *dummy, struct svc_req * cl)
{
    static res_getPatInfo res;
    static pattern_set_info set_info;
    static pattern_descriptor pat_des;
    res.return_value = krui_GetPatInfo(&set_info,&pat_des);

    res.set_info.number_of_pattern = set_info.number_of_pattern;
    res.set_info.output_present = set_info.output_present;
    res.set_info.fixed_fixsizes = set_info.fixed_fixsizes;
    res.set_info.in_fixsize = set_info.in_fixsize;
    res.set_info.out_fixsize = set_info.out_fixsize;
    res.set_info.in_number_of_dims = set_info.in_number_of_dims;
    res.set_info.out_number_of_dims = set_info.out_number_of_dims;
    res.set_info.in_max_dim_sizes.in_max_dim_sizes_len = MAX_NO_OF_VAR_I_DIM;
    res.set_info.in_max_dim_sizes.in_max_dim_sizes_val = set_info.in_max_dim_sizes;
    res.set_info.out_max_dim_sizes.out_max_dim_sizes_len = MAX_NO_OF_VAR_O_DIM;
    res.set_info.out_max_dim_sizes.out_max_dim_sizes_val = set_info.out_max_dim_sizes;
    res.set_info.in_min_dim_sizes.in_min_dim_sizes_len = MAX_NO_OF_VAR_I_DIM;
    res.set_info.in_min_dim_sizes.in_min_dim_sizes_val = set_info.in_min_dim_sizes;
    res.set_info.out_min_dim_sizes.out_min_dim_sizes_len = MAX_NO_OF_VAR_O_DIM;
    res.set_info.out_min_dim_sizes.out_min_dim_sizes_val = set_info.out_min_dim_sizes;

    res.pat_des.input_dim = pat_des.input_dim;
    res.pat_des.input_dim_sizes.input_dim_sizes_len = MAX_NO_OF_VAR_I_DIM;
    res.pat_des.input_dim_sizes.input_dim_sizes_val = pat_des.input_dim_sizes;
    res.pat_des.input_fixsize = pat_des.input_fixsize;
/* Must be changed */
    res.pat_des.input_pattern.input_pattern_len = 0;
    res.pat_des.input_pattern.input_pattern_val = pat_des.input_pattern;
    if(pat_des.input_info == NULL){
	res.pat_des.input_info = null_ptr;
    }else{
	res.pat_des.input_info = pat_des.input_info;
    }
    res.pat_des.output_dim = pat_des.output_dim;
    res.pat_des.output_dim_sizes.output_dim_sizes_len = MAX_NO_OF_VAR_O_DIM;
    res.pat_des.output_dim_sizes.output_dim_sizes_val = pat_des.output_dim_sizes;
    res.pat_des.output_fixsize = pat_des.output_fixsize;
/* Must be changed */
    res.pat_des.output_pattern.output_pattern_len = 0;
    res.pat_des.output_pattern.output_pattern_val = pat_des.output_pattern;
    if(pat_des.output_info == NULL){
	res.pat_des.output_info = null_ptr;
    }else{
	res.pat_des.output_info = pat_des.output_info;
    }

    return (&res);
}
par_defShowSubPat 	* 
krui_defshowsubpat_40( par_defShowSubPat *par, struct svc_req * cl)
{
    static par_defShowSubPat res;
    res = *par; 
    res.return_value=krui_DefShowSubPat(&res.insize,&res.outsize,
					&res.inpos,&res.outpos);
    return (&res);
}
par_defTrainSubPat	* 
krui_deftrainsubpat_40(par_defTrainSubPat *par, struct svc_req * cl)
{
    static par_defTrainSubPat res;
    res = *par; 
    res.return_value=krui_DefTrainSubPat(&res.insize,&res.outsize,
					 &res.instep,&res.outstep,
					 &res.max_n_pos);
    return (&res);
}
par_alignSubPat	* 
krui_alignsubpat_40(par_alignSubPat *par, struct svc_req * cl)
{ 
    static par_alignSubPat res;
    res = *par; 
    res.return_value=krui_AlignSubPat(&res.inpos,&res.outpos,&res.no);
    return (&res);
}
par_getShapeOfSubPattern 	* 
krui_getshapeofsubpattern_40(par_getShapeOfSubPattern *par, struct svc_req * cl)
{
    static par_getShapeOfSubPattern res;
    res = *par; 
    res.return_value=krui_GetShapeOfSubPattern(&res.insize,&res.outsize,
					       &res.inpos,&res.outpos,
					       par->n_pos);
    return (&res);
}
rpc_krui_err 	* 
krui_savenet_40(par_saveNet *par, struct svc_req * cl)
{
    static rpc_krui_err res;
    char *d1,*d2;

    kernel_config.status = S_SAVE;

    if (strcmp(par->filename, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = par->filename;
    }
    if (strcmp(par->netname, null_ptr)==0) {
	d2 = NULL;
    }else{
	d2 = par->netname;
    }
    res = krui_saveNet(d1,d2);

    kernel_config.status = S_IDLE;

    return (&res);
}
res_loadNet 	* 
krui_loadnet_40(par_loadNet *par, struct svc_req * cl)
{
    static res_loadNet res;
    char *d1;

    kernel_config.status = S_LOAD;

    if (strcmp(par->filename, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = par->filename;
    }
    res.return_value = krui_loadNet(d1,&res.netname);
    if(res.netname == NULL) {
	res.netname = null_ptr;
    }

    kernel_config.status = S_IDLE;

    return (&res);
}
rpc_krui_err 	* 
krui_saveresultparam_40(par_saveResult *par, struct svc_req * cl)
{
    static rpc_krui_err res;
    char *d1;

    kernel_config.status = S_SAVE;


    if (strcmp(par->filename, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = par->filename;
    }
    res = krui_saveResultParam(d1,par->create,par->startpattern
			       ,par->endpattern
			       ,par->includeinput,par->includeoutput
			       ,par->Update_param_array.Update_param_array_val
                               ,par->Update_param_array.Update_param_array_len);

    kernel_config.status = S_IDLE;

    return (&res);
}
rpc_krui_err 	* 
krui_allocateunits_40(int *no_of_units, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_allocateUnits(*no_of_units);
    return (&res);
}
void *
krui_deletenet_40(void *dummy, struct svc_req * cl)
{
    static int res;
    krui_deleteNet();
    return (&res);
}
res_getSymbolEntry *
krui_getfirstsymboltableentry_40(void *dummy, struct svc_req * cl)
{
    static res_getSymbolEntry res;
    res.return_value = krui_getFirstSymbolTableEntry(&res.symbol_name,
						     &res.symbol_type);
    if(res.symbol_name == NULL) res.symbol_name = null_ptr;
    return (&res);
}
res_getSymbolEntry *
krui_getnextsymboltableentry_40(void *dummy, struct svc_req * cl)
{
    static res_getSymbolEntry res;
    res.return_value = krui_getNextSymbolTableEntry(&res.symbol_name,
						    &res.symbol_type);
    if(res.symbol_name == NULL) res.symbol_name = null_ptr;
    return (&res);
}
bool *
krui_symbolsearch_40(par_symbolSearch *par, struct svc_req * cl)
{
    static bool res;
    char *d1;
    if (strcmp(par->symbol, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = par->symbol;
    }
    res = krui_symbolSearch(d1,par->symbol_type);
    return (&res);
}
char           **
krui_getversion_40(void *dummy, struct svc_req * cl)
{
    static char *res;
    res = krui_getVersion();
    if(res == NULL) res = null_ptr;
    return (&res);
}
res_getNetInfo * 
krui_getnetinfo_40(void *dummy, struct svc_req * cl)
{
    static res_getNetInfo res;
    krui_getNetInfo(&res.no_of_sites,
		    &res.no_of_links, 
		    &res.no_of_STable_entries, 
		    &res.no_of_FTable_entries);
    return(&res);
}
res_getMemoryManagerInfo *
krui_getmemorymanagerinfo_40(void *dummy, struct svc_req * cl)
{
    static res_getMemoryManagerInfo res;
    krui_getMemoryManagerInfo(&res.unit_bytes,
			      &res.site_bytes,
			      &res.link_bytes,
			      &res.NTable_bytes,
			      &res.STable_bytes,
			      &res.FTable_bytes);
    return(&res);    
}
res_getUnitDefaults *
krui_getunitdefaults_40(void *dummy, struct svc_req * cl)
{
    static res_getUnitDefaults res;
    krui_getUnitDefaults(&res.act,
			 &res.bias,
			 &res.st,
			 &res.subnet_no,
			 &res.layer_no,
			 &res.act_func, 
			 &res.out_func);
    if(res.act_func == NULL) res.act_func = null_ptr;
    if(res.out_func == NULL) res.out_func = null_ptr;
    return(&res);
}
rpc_krui_err 	* 
krui_setunitdefaults_40(par_setUnitDefaults *par, struct svc_req * cl)
{
    static rpc_krui_err res;
    char *d1,*d2;
    if (strcmp(par->act_func, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = par->act_func;
    }
    if (strcmp(par->out_func, null_ptr)==0) {
	d2 = NULL;
    }else{
	d2 = par->out_func;
    }
    res = krui_setUnitDefaults(par->act,
			       par->bias,
			       par->st,
			       par->subnet_no,
			       par->layer_no,
			       d1, 
			       d2);
   
    return (&res);
}
void *
krui_resetnet_40(void *dummy, struct svc_req * cl)
{
    static int res;
    krui_resetNet();
    return (&res);
}
void *
krui_setseedno_40(long int *seed, struct svc_req * cl)
{
    static int res;
    krui_setSeedNo(*seed);
    return (&res);
}
int *
krui_getnoofinputunits_40(void *dummy, struct svc_req * cl)
{
    static int res;
    res = krui_getNoOfInputUnits();
    return (&res);
}
int *
krui_getnoofoutputunits_40(void *dummy, struct svc_req * cl)
{
    static int res;
    res = krui_getNoOfOutputUnits();
    return (&res);
}
int *
krui_getnoofspecialinputunits_40(void *dummy, struct svc_req * cl)
{
    static int res;
    res = krui_getNoOfSpecialInputUnits();
    return (&res);
}
int *
krui_getnoofspecialoutputunits_40(void *dummy, struct svc_req * cl)
{
    static int res;
    res = krui_getNoOfSpecialOutputUnits();
    return (&res);
}
int *
krui_getnoofttypeunits_40(int *unitttype, struct svc_req * cl)
{
    static int res;
    res = krui_getNoOfTTypeUnits(*unitttype);
    return (&res);
}
res_xyTransTable * 
krui_xytranstable_40(par_xyTransTable *par, struct svc_req * cl)
{
    static res_xyTransTable res;
    res.x = par->x; 
    res.y = par->y; 
    res.return_value = krui_xyTransTable(par->op,&res.x,&res.y,par->z);
    return (&res);
}
res_getUnitCenters	* 
krui_getunitcenters_40(par_getUnitCenters *par, struct svc_req * cl)
{
    static res_getUnitCenters res;
    struct PositionVector *hp;
    hp = ((struct PositonVector *)&res.unit_center);
    res.return_value = krui_getUnitCenters(par->unit_no,par->center_no,&hp);
    return (&res);
}
rpc_krui_err 	* 
krui_setunitcenters_40(par_setUnitCenters *par, struct svc_req * cl)
{
    static rpc_krui_err res;
    struct PositionVector *hp;
    hp = ((struct PositonVector *)&par->unit_center);
    res = krui_setUnitCenters(par->unit_no,par->center_no,hp);
    return (&res);
}
char           **
krui_error_40(int *error_code, struct svc_req * cl)
{
    static char *res;
    res = krui_error(*error_code);
    if(res == NULL) res = null_ptr;
    return (&res);
}

float 	* 
krui_na_error_40(par_na_error *par, struct svc_req * cl)
{
    static float res;
    res = krui_NA_Error(par->currentPattern,par->error_unit,par->error,par->ave);
    return (&res);
}
/*
rpc_krui_err 	* 
krui_maspar_40(int *mode, struct svc_req * cl)
{
    static rpc_krui_err res;

    return (&res);
}
rpc_krui_err 	* 
krui_getmasparstatus_40(void *dummy, struct svc_req * cl)
{
    static rpc_krui_err res;

    return (&res);
}
rpc_krui_err 	* 
krui_masparbenchmark_40(func_type, cycles, result, struct svc_req * cl)
{
    static rpc_krui_err res;

    return (&res);
}
*/
rpc_krui_err 	* 
krui_setspecialnetworktype_40(int *net_type, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_setSpecialNetworkType(*net_type);
    return (&res);
}

int *
krui_getspecialnetworktype_40(void *dummy, struct svc_req * cl)
{
    static int res;
    res = krui_getSpecialNetworkType();
    return (&res);
}

int *
krui_initinversion_40(void *dummy, struct svc_req * cl)
{
    static int res;
    res = krui_initInversion();
    return (&res);
}

void *
krui_inv_forwardpass_40(void *dummy, struct svc_req * cl)
{
    static int res;
    krui_inv_forwardPass(NULL/*Muss noch geaendert werden */);
    return (&res);
}

double *
krui_inv_backwardpass_40(void *dummy, struct svc_req * cl)
{
    static double res;
/*    res = krui_inv_backwardPass();*/
    return (&res);
}

void *
krui_kohonen_setextraparameter_40(int *x, struct svc_req * cl)
{
    static int res;
    krui_kohonen_SetExtraParameter(*x);
    return (&res);
}

void *
krui_spanning_tree_40(void *dummy, struct svc_req * cl)
{
    static int res;
    krui_spanning_tree();
    return (&res);
}

void *
krui_cc_updateposofspecialunits_40(void *dummy, struct svc_req * cl)
{
    static int res;
    krui_cc_updatePosOfSpecialUnits();
    return (&res);
}

rpc_krui_err *
krui_cc_deleteallspecialunits_40(void *dummy, struct svc_req * cl)
{
    static rpc_krui_err res;
    res = krui_cc_deleteAllSpecialUnits();
    return (&res);
}

int *
krui_geterrorcode_40(void *dummy, struct svc_req * cl)
{
    static int res;
    res = krui_getErrorCode();
    return (&res);
}













