/*
 * Miscellaneous system dependencies.
 *
 * I kept the name pmachine.h because it was already in all of the files...this
 * barely resembles the pmachine.h that comes with the real Prospero, tho.
 */

#ifdef FUNCS
#define index		strchr
#define rindex		strrchr
#ifndef AUX
#define bcopy(a,b,n)	memcpy(b,a,n)
#define bzero(a,n)	memset(a,0,n)
#endif
#endif

#if defined(RS6000) || defined(BULL)
# define NEED_SELECT_H
#endif

#if defined(_AIX) || defined(UTS) || defined(AUX) || defined(USG)
# define NEED_TIME_H
#endif

#ifdef VMS
/* Get the system status stuff.  */
# include <ssdef.h>
#endif /* VMS */

/*
 * FD_SET: lib/pfs/dirsend.c, user/vget/ftp.c
 */
#if !defined(FD_SET) && !defined(VMS)
#define	NFDBITS		32
#define	FD_SETSIZE	32
#define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p)	bzero((char *)(p), sizeof(*(p)))
#endif
