function retval = rank (A, tol)

# Return the rank of A.

  if (nargin == 1)
    sigma = svd (A);
    tolerance = max (size (A)) * sigma (1) * eps;
  elseif (nargin == 2)
    tolerance = tol;
  else
    error ('usage: rank (A)');
  endif
  retval = sum (sigma > tolerance);

endfunction
