/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	ctlr_1d.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_ctlr_1d class header
 *
 *	RCSid = "$Id: ctlr_1d.H,v 4.8.1.2 1993/06/05 20:10:08 garya Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_ctlr_1d_H
#define OI_ctlr_1d_H

#ifndef OI_dpy_1d_H
#include <OI/dpy_1d.H>
#endif /* OI_dpy_1d_H */

	// class forward reference declarations
	class OI_ctlr_1d;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Definitions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		
 /* ctl_bits private bits */
#define		OI_CTLR_1D_MOTION_CALLBACK	0x1	/* 1 => controlled object callbacks for motion events */
#define		OI_CTLR_1D_SPAN_UPDATE		0x2	/* 1 => update span/viewport/handle appearance when span/view changes */
#define		OI_CTLR_1D_BUSY			0x4	/* 1 => we are busy */

#define		OI_ctlr_1d_ends			OI_display_1d_ends
#define		OI_ctlr_1d_ends_none		OI_display_1d_ends_none
#define		OI_ctlr_1d_ends_numeric		OI_display_1d_ends_numeric
#define		OI_ctlr_1d_ends_strings		OI_display_1d_ends_strings
#define		OI_CTLR_1D_ENDS_NONE		OI_ctlr_1d_ends_none
#define		OI_CTLR_1D_ENDS_NUMERIC		OI_ctlr_1d_ends_numeric
#define		OI_CTLR_1D_ENDS_STRINGS		OI_ctlr_1d_ends_strings

#define		OI_ctlr_1d_current		OI_display_1d_current
#define		OI_ctlr_1d_current_none		OI_display_1d_current_none
#define		OI_ctlr_1d_current_ro		OI_display_1d_current_ro
#define		OI_ctlr_1d_current_rw		OI_display_1d_current_rw
#define		OI_CTLR_1D_CURRENT_NONE		OI_ctlr_1d_current_none
#define		OI_CTLR_1D_CURRENT_RO		OI_ctlr_1d_current_ro
#define		OI_CTLR_1D_CURRENT_RW		OI_ctlr_1d_current_rw

#define		OI_ctlr_1d_ticks		OI_display_1d_ticks
#define		OI_ctlr_1d_ticks_none		OI_display_1d_ticks_none
#define		OI_ctlr_1d_ticks_ends		OI_display_1d_ticks_ends
#define		OI_ctlr_1d_ticks_all		OI_display_1d_ticks_all
#define		OI_ctlr_1d_ticks_ends_custom	OI_display_1d_ticks_ends_custom
#define		OI_ctlr_1d_ticks_all_custom	OI_display_1d_ticks_all_custom
#define		OI_CTLR_1D_TICKS_NONE		OI_ctlr_1d_ticks_none
#define		OI_CTLR_1D_TICKS_ENDS		OI_ctlr_1d_ticks_ends
#define		OI_CTLR_1D_TICKS_ALL		OI_ctlr_1d_ticks_all
#define		OI_CTLR_1D_TICKS_ENDS_CUSTOM	OI_ctlr_1d_ticks_ends_custom
#define		OI_CTLR_1D_TICKS_ALL_CUSTOM	OI_ctlr_1d_ticks_all_custom

#define		OI_CTLR_1D_INTERVAL		200	/* controller interval (ms) when button held down */

 /* key definitions */
#define	OI_CTLR_1D_KEY_UNIT		0					/* unit scroll (nomodifiers) */
#define	OI_CTLR_1D_KEY_VIEW		OI_K_SHIFT				/* viewport scroll */
#define	OI_CTLR_1D_KEY_EXTREME		OI_K_CTRL				/* scroll to extreme */
#define	OI_CTLR_1D_KEY_POSITION		OI_K_META				/* scroll to specified position */
#define OI_CTLR_1D_KEY_UNIT_LEFT	OI_K_LEFT				/* Scroll by single unit left */
#define OI_CTLR_1D_KEY_UNIT_RIGHT	OI_K_RIGHT				/* Scroll by single unit Right */
#define OI_CTLR_1D_KEY_UNIT_UP		OI_K_UP					/* Scroll by single unit Up */
#define OI_CTLR_1D_KEY_UNIT_DOWN	OI_K_DOWN				/* Scroll by single unit Down */
//#define OI_CTLR_1D_KEY_VIEW_LEFT	(OI_CTLR_1D_KEY_VIEW|OI_K_LEFT)		/* Scroll by Viewport size left */
//#define OI_CTLR_1D_KEY_VIEW_RIGHT	(OI_CTLR_1D_KEY_VIEW|OI_K_RIGHT)	/* Scroll by Viewport size Right */
//#define OI_CTLR_1D_KEY_VIEW_UP	(OI_CTLR_1D_KEY_VIEW|OI_K_UP)		/* Scroll by Viewport size Up */
//#define OI_CTLR_1D_KEY_VIEW_DOWN	(OI_CTLR_1D_KEY_VIEW|OI_K_DOWN)		/* Scroll by Viewport size Down */
#define OI_CTLR_1D_KEY_MAX_LEFT		(OI_CTLR_1D_KEY_EXTREME|OI_K_LEFT)	/* Scroll as far as possible left */
#define OI_CTLR_1D_KEY_MAX_RIGHT	(OI_CTLR_1D_KEY_EXTREME|OI_K_RIGHT)	/* Scroll as far as possible Right */
#define OI_CTLR_1D_KEY_MAX_UP		(OI_CTLR_1D_KEY_EXTREME|OI_K_UP)	/* Scroll as far as possible Up */
#define OI_CTLR_1D_KEY_MAX_DOWN		(OI_CTLR_1D_KEY_EXTREME|OI_K_DOWN)	/* Scroll as far as possible Down */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		
#ifdef TYPEDEF_MEMFN
	typedef	void	(OI_ctlr_1d_fn)(OI_ctlr_1d*,void*,OI_scroll_event,long) ;			/* ctlr_1d callback function */
	typedef	void	(OI_callback::OI_ctlr_1d_memfn)(OI_ctlr_1d*,void*,OI_scroll_event,long) ;	/* ctlr_1d callback mem function */
#endif /* TYPEDEF_MEMFN */
	typedef	void	(*OI_ctlr_1d_fnp)(OI_ctlr_1d*,void*,OI_scroll_event,long) ;			/* ctlr_1d callback function */
	typedef	void	(OI_callback::*OI_ctlr_1d_memfnp)(OI_ctlr_1d*,void*,OI_scroll_event,long) ;	/* ctlr_1d callback mem function */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	END OF DOCUMENTED SECTION
		//
		//-------------------------------------------------------------------------------------------------		

	class OI_ctlr_1d : public OI_display_1d {
			unsigned long	ctl_bits ;		/* object specific control bits */
	 protected:
			long		vw_spn ;		/* size of viewport to object, same units as obj_span */
			long		prv_hdl_psn ;		/* previous location of handle */
			OI_number	init_intrvl ;		/* initial_scroll interval, ms, for repeats */
			OI_number	intrvl ;		/* scroll interval, ms, for repeats */
			OI_number	trg ;			/* button used to trigger user interactions */
			OI_number	trg_mods ;		/* modifiers for trigger */
	 public:
		static	OI_class	*clsp ;			/* ptr to class record */
		static	XrmQuark	q_cbCtlr1d ;		/* quark for scroll callback */
	 private:
			void		construct(OI_ctlr_1d_fnp, OI_callback*, OI_ctlr_1d_memfnp, void*) ;
	 protected:
					OI_ctlr_1d(OI_class *clsp, const char *usr_namp, long mx=0, long mn=1, OI_ctlr_1d_fnp fp=NULL,
						OI_callback *op=NULL, OI_ctlr_1d_memfnp mfp=NULL, void *ap=OI_DEF_ARG,
						const char *l=NULL, OI_ctlr_1d_ends et=OI_CTLR_1D_ENDS_NONE, const char *bl=NULL,
						const char *el=NULL,OI_ctlr_1d_current cv=OI_CTLR_1D_CURRENT_NONE, OI_number nt=0,
						OI_ctlr_1d_ticks tt=OI_CTLR_1D_TICKS_NONE, const char* const *tl=NULL) ;
		virtual	void		clone_adjust(OI_d_tech*) ;
		virtual	OI_bool		mov_hdl(long) = 0 ;
			void		new_interval(OI_number t)	{intrvl=t;}	/* set scroll repeat interval, ms */
		virtual	void		paint_current() ;			/* paint current value, if displayed somewhere */
		virtual	void		paint_value(long) ;			/* Paints the value. */
		virtual	void		re_layout() ;				/* readjust geometry due to resource changes */
		virtual	void		span_changed(long) ;
	 public:
	  /* public functions reserved for toolkit */
					~OI_ctlr_1d();
		// Allow busy is before activate so that it gets inlined.  You cannot inline a forward reference.... imp
			void		allow_busy()				{ctl_bits |= OI_CTLR_1D_BUSY;}
 			void		activate(OI_d_tech *, const XEvent *, const char* const *, unsigned int *)		{ allow_busy(); }
			void		disallow_busy()				{ctl_bits &= ~OI_CTLR_1D_BUSY;}
 			void		deactivate(OI_d_tech *, const XEvent *, const char* const *, unsigned int *)		{ disallow_busy(); }
		static	OI_bool		init(OI_connection*) ;
			OI_bool		is_busy()				{return ((ctl_bits&OI_CTLR_1D_BUSY)?OI_YES:OI_NO); }
			void		set_trigger(OI_number b, OI_number m)	{trg=b; trg_mods=m;}
			void		update_prev_handle_loc()	{prv_hdl_psn=hdl_psn;}
			OI_number	trigger()			{return(trg);}
			OI_number	trigger_mods()			{return(trg_mods);}
			void		mov_hdl_obj(OI_scroll_event, long, OI_bool=OI_NO) ;		/* relocate hdl & scroll object */
			OI_number	initial_interval()		{return(init_intrvl);}		/* scroll repeat interval, ms */
			void		res_interval(void *);						/* set scroll repeat interval, ms */
			void		res_motion_callback(void *);
			void		set_initial_interval(OI_number n)	{init_intrvl=n;}	/* set scroll repeat initial interval, ms */
			void		set_view_span(long s) ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	OI_stat		set_span(long,long) ;				/* set span of object being scrolled (user units) */
		virtual	OI_stat		set_span(long) ;
		virtual	OI_stat		set_value(long) ;				/* set value */
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmers manual, and are
		//		available to the toolkit users.  Functions not contained in user documentation
		//		are subject to change without notice and should never be used.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//		
		//-------------------------------------------------------------------------------------------------		
			void		allow_motion_callback()		{ctl_bits |= OI_CTLR_1D_MOTION_CALLBACK;}
			void		allow_span_update() ;
			void		change_action(OI_ctlr_1d_fnp fp, void *argp=NULL) ;
			void		change_action(OI_callback *objp, OI_ctlr_1d_memfnp mfp, void *argp=NULL) ;
			void		change_arg(void *argp) ;
			void		disallow_motion_callback()	{ctl_bits &= ~OI_CTLR_1D_MOTION_CALLBACK;}
			void		disallow_span_update()		{ctl_bits &= ~OI_CTLR_1D_SPAN_UPDATE;}
			void		*get_arg() ;
			long		handle_loc() ;
			OI_number	interval()			{return(intrvl);}		/* scroll repeat interval, ms */
			OI_bool		is_motion_callback()		{return(OI_bool)((ctl_bits&OI_CTLR_1D_MOTION_CALLBACK) != 0);}
			OI_bool		is_span_update()		{return(OI_bool)((ctl_bits&OI_CTLR_1D_SPAN_UPDATE) != 0);}
			long		prev_handle_loc() ;
			OI_stat		set_handle_loc(long,OI_bool=OI_YES) ;		/* set position of handle within obj_span */
			void		set_interval(OI_number);			/* set scroll repeat interval, ms */
			long		view_span()			{ return(vw_spn); }
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

#endif /* OI_ctlr_1d_H */
