/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	class.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_class class header
 *
 *	RCSid = "$Id: class.H,v 4.15.1.2 1993/06/04 04:35:41 garya Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_class_H
#define OI_class_H

#ifndef OI_defs_H
#include <OI/defs.H>
#endif /* OI_defs_H */

	// class forward reference declarations
	class	OI_class;
	class	OI_class_per_connection;
	class	OI_connection;
	class	OI_cb_class;
	struct	OI_resource;
	struct	OI_cb_def;

		struct OI_alpha_callback {			/* structure for callback specifications in alpha form */
		const	char		*typ_namp ;		/* callback type */
		const	char		*obj_namp ;		/* object name, for member function */
		const	char		*fn_namp ;		/* function/member function name */
		const	char		*arg_namp ;		/* argument name */
			unsigned short	mask ;			/* bits indicating what is set */
		} ;

		enum OI_alpha_callback_mask {
			OI_cb_argp	= 0x1,
			OI_cb_fnp	= 0x2,
			OI_cb_memfnp	= 0x4,
			OI_cb_objp	= 0x8
		} ;

#ifdef TYPEDEF_MEMFN
	typedef	OI_bool		(OI_class_init_memfn)(OI_connection*) ;		/* class init fn */
//	typedef	OI_callback*	(OI_callback::OI_make_minimal_memfn)(char*,OI_minimal_type) ;	/* create minimal object fn */
//	typedef	OI_callback*	(OI_callback::OI_make_minimal_memfn)(void*,OI_minimal_type) ;	/* create minimal object fn */
	typedef	CommonBase*	(OI_make_minimal_memfn)(void*,OI_minimal_type) ;	/* create minimal object fn */
#endif /* TYPEDEF_MEMFN */
	typedef	OI_bool		(*OI_class_init_memfnp)(OI_connection*) ;		/* class init fn */
//	typedef	OI_callback*	(OI_callback::*OI_make_minimal_memfnp)(char*,OI_minimal_type) ;	/* create minimal object fn */
//	typedef	OI_callback*	(OI_callback::*OI_make_minimal_memfnp)(void*,OI_minimal_type) ;	/* create minimal object fn */
	typedef	CommonBase*	(*OI_make_minimal_memfnp)(void*,OI_minimal_type) ;	/* create minimal object fn */

/* bit definitions for ctl_bits */
#define OI_CLASS_INITIALIZED		0x01					/* the class has been initialized (NOT per connection) */
#define OI_CLASS_CONVERSION		0x02					/* are we permitted to convert this class? */
#define OI_CLASS_IN_INIT		0x04					/* class initialization in process */
#define	OI_CLASS_DTECH_MIN_MEMFN	0x08					/* class initialization in process */

	class OI_class {
	 private:
			XrmQuark		classq ;			/* quark corresponding to class name */
			XrmQuark		nameq ;				/* quark corresponding to instance name */
			unsigned long		ctl_bits;			/* control bits */
			OI_class_init_memfnp	init_memfnp ;			/* ptr to initialization function for class */
			OI_make_minimal_memfnp	make_minimal_memfnp ;		/* ptr to function to create minimal object */
			OI_class		*sib ;				/* next sibling class in chain this class is on */
			OI_class		*ancstr ;			/* ptr to immediate ancestor class */
			OI_class		*drv ;				/* ptr to list of derived classes */
			OI_class_per_connection	*per_conp ;			/* additional connection info */
			OI_number		mx_conn ;			/* max # connections */
			OI_number		n_conn ;			/* # connections in use */
			OI_number		n_cb ;				/* # callback types registered for this class */
			OI_cb_class		**cb_classp ;			/* ptrs to class objects for callback types */
			OI_cb_refresh_memfnp	refresh_memfnp ;		/* memfnp to install class callbacks */
		struct	OI_resource		*rsrs ;
			OI_number		n_rsrs ;
		const	char			**con_args ;
			OI_number		n_con_args ;
			void			*datp ;				/* user data */
	 private:
			void			clear_in_init()			{ ctl_bits &= ~OI_CLASS_IN_INIT; }
			OI_bool			in_init()			{ return((ctl_bits & OI_CLASS_IN_INIT) ? OI_yes : OI_no); }
			OI_class_per_connection	*per_connection(OI_connection*) ;
			OI_resource		*search_xrm_list(XrmQuark, OI_resource *, unsigned int);
			void			set_in_init()			{ ctl_bits |= OI_CLASS_IN_INIT; }
	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						OI_class(XrmQuark, OI_class_init_memfnp, OI_make_minimal_memfnp) ;
						~OI_class() ;
			void			allow_conversion()		{ ctl_bits |= OI_CLASS_CONVERSION; }
 			void			allow_dt_min_memfn()		{ ctl_bits |= OI_CLASS_DTECH_MIN_MEMFN; }
			OI_cb_class		*callback_definition(const char*) ;
			OI_cb_class		*callback_definition(XrmQuark) ;
			OI_cb_class		**callbacks()			{ return(cb_classp); }
			void			close_connection(OI_connection*) ;
		const	char* const		*constructor_args()		{ return( con_args ) ; }
			void			*data()				{ return(datp); }
			OI_class		*descendant(XrmQuark) ;
			void			disallow_conversion()		{ ctl_bits &= ~OI_CLASS_CONVERSION; }
 			void			disallow_dt_min_memfn()		{ ctl_bits &= ~OI_CLASS_DTECH_MIN_MEMFN; }
			OI_bool			initialized(OI_connection *cp) ;
			void			initialize(OI_connection*) ;
			void			initialize_hierarchy(OI_connection*) ;
			XrmQuark		instance_quark()		{ return(nameq); }
			OI_bool			is_callback(XrmQuark) ;
			OI_bool			is_conversion()			{ return((ctl_bits&OI_CLASS_CONVERSION)?OI_yes:OI_no); }
 			OI_bool			is_dt_min_memfn()		{ return((ctl_bits&OI_CLASS_DTECH_MIN_MEMFN)?OI_yes:OI_no); }
			OI_bool			is_my_callback(XrmQuark) ;
			OI_bool			is_superclass_of(OI_class*) ;
			CommonBase		*make_minimal(void *, OI_minimal_type=OI_MINIMAL) ;
			OI_make_minimal_memfnp	minimal_memfnp()		{ return(make_minimal_memfnp); }
			OI_number		num_callbacks()			{ return(n_cb) ; }
			OI_number		num_constructor_args()		{ return( n_con_args ) ; }
			XrmQuark		quark()				{ return(classq); }
			OI_cb_refresh_memfnp	refresh_callback_memfnp()	{ return(refresh_memfnp); }
			void			set_ancestor(OI_class *p)	{ ancstr=p; }
			void			set_callbacks(OI_cb_def*, OI_number, OI_cb_refresh_memfnp=NULL);
			void			set_data(void *p)		{ datp=p; }
			void			set_derived(OI_class *p)	{ drv=p; }
			void			set_make_minimal(OI_make_minimal_memfnp mfp )	{ make_minimal_memfnp = mfp; }
			void			set_sibling(OI_class *p)	{ sib=p; }

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			OI_class		*ancestor()			{ return(ancstr); }
			void			*class_dependent(OI_connection*) ;
			OI_bool			class_initialized() ;
			OI_class		*derived()			{ return(drv); }
			OI_bool			is_createable()			{ return((make_minimal_memfnp != NULL) ? OI_yes : OI_no); }
			OI_bool			is_derived_from(OI_class*) ;
			void			mark_initialized(OI_connection *, void * =NULL) ;
		const	char			*name() ;
			OI_class		*next(OI_class*) ;
			OI_number		num_resources()			{ return( n_rsrs ) ; }
			OI_resource		*resources()			{ return( rsrs ); }
			OI_resource		*resource_definition(const char*) ;
			OI_resource		*resource_definition(XrmQuark) ;
			void			set_constructor_args( const char* const *, OI_number );
			void			set_resources(struct OI_resource *, OI_number) ;
			OI_class		*sibling()			{ return(sib); }
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

	OI_class *OI_register_class(const char*, const char*, OI_class_init_memfnp, OI_make_minimal_memfnp) ;
	OI_class *OI_class_object(XrmQuark) ;
	OI_class *OI_class_object(const char*) ;

#endif /* OI_class_H */
