#!/bin/bash
# @(#)backup_weekly.sh - backup directories weekly v1.0, (c)mpan 10/2003

# Weekly backup directory
weekly="/mnt/backup/weekly"

# Daily backup directory
daily="/mnt/backup/daily"

# Move to the backup directory
cd $weekly

# Only root has access to the backup files. Also umask 027 may be used
umask 077

# Create backup file that holds daily incremental backups.
# Backup file is
# <week number: 01, 02, etc.>.<month name: Jan, Feb, etc.>.backup.tar.
# File errors.txt holds errors that occurred during backup
tar -cf `date +%U.%b`.backup.tar $daily 2>./errors.txt
error=$?

# If no errors during backup procedure, remove daily incremental backups
if [ $error = 0 ]
then
    rm -f $daily/*.backup.tar.gz
    rm -f $daily/*.backup.tar.gz.txt
else

# Send error message to the root
    mail -s "Error in backup_weekly.sh" root@localhost <./errors.txt
fi
