#!/bin/bash
# @(#)backup_monthly.sh - backup directories monthly v1.0, (c)mpan 10/2003

# Monthly backup directory
monthly="/mnt/backup/monthly"

# Weekly backup directory
weekly="/mnt/backup/weekly"

# Directories to be backed up
dirs="/home /root"

# Move to the backup directory
cd $monthly

# Only root has access to the backup files. Also umask 027 may be used
umask 077

# Full backup. Backup file is 
# <month name: Jan, Feb, etc.>.backup.tar.gz and end of list of files is .txt.
# File errors.txt holds errors that occurred during backup
tar -czvf `date +%b`.backup.tar.gz $dirs 1>./`date +%b`.backup.tar.gz.txt 2>./errors.txt
error=$?

# If no errors during backup procedure, remove old backups
if [ $error = 0 ]
then

# Remove all others except this months 
# weekly incremental backups from directory $weekly. 
# This script should be run every month at 28.th day. This means that 
# there is 4 to about 9 weeks schedule for the file recovery
    files=`ls $weekly/*`
    for i in $files
    do
	case "`basename $i`" in
	    *.`date +%b`.backup.tar)
	    ;;
	    *.backup.tar)
	    rm -f $i
	    ;;
	esac
    done

# Remove all others except this months full backup from directory $monthly
    files=`ls $monthly/*`
    for i in $files
    do
	case "`basename $i`" in
	    `date +%b`.backup.tar.gz)
	    ;;
	    `date +%b`.backup.tar.gz.txt)
	    ;;
	    *.backup.tar.gz)
	    rm -f $i
	    ;;
	    *.backup.tar.gz.txt)
	    rm -f $i
	    ;;
	esac
    done

else

# Send error message to the root
    mail -s "Error in backup_monthly.sh" root@localhost <./errors.txt
fi
