/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.ReportSet;

public class ReportPlugin
implements Serializable {
    private String groupId = "org.apache.maven.plugins";
    private String artifactId;
    private String version;
    private String inherited;
    private Object configuration;
    private List reportSets;
    private Map reportSetMap = null;
    private boolean inheritanceApplied = true;
    private String modelEncoding = "UTF-8";

    public void addReportSet(ReportSet reportSet) {
        this.getReportSets().add(reportSet);
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public Object getConfiguration() {
        return this.configuration;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getInherited() {
        return this.inherited;
    }

    public List getReportSets() {
        if (this.reportSets == null) {
            this.reportSets = new ArrayList();
        }
        return this.reportSets;
    }

    public String getVersion() {
        return this.version;
    }

    public void removeReportSet(ReportSet reportSet) {
        this.getReportSets().remove(reportSet);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setConfiguration(Object configuration) {
        this.configuration = configuration;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setInherited(String inherited) {
        this.inherited = inherited;
    }

    public void setReportSets(List reportSets) {
        this.reportSets = reportSets;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void flushReportSetMap() {
        this.reportSetMap = null;
    }

    public Map getReportSetsAsMap() {
        if (this.reportSetMap == null) {
            this.reportSetMap = new HashMap();
            if (this.getReportSets() != null) {
                Iterator i = this.getReportSets().iterator();
                while (i.hasNext()) {
                    ReportSet reportSet = (ReportSet)i.next();
                    this.reportSetMap.put(reportSet.getId(), reportSet);
                }
            }
        }
        return this.reportSetMap;
    }

    public String getKey() {
        return ReportPlugin.constructKey(this.groupId, this.artifactId);
    }

    public static String constructKey(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    public void unsetInheritanceApplied() {
        this.inheritanceApplied = false;
    }

    public boolean isInheritanceApplied() {
        return this.inheritanceApplied;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }
}

