# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._application_package_operations import (
    build_activate_request,
    build_create_request,
    build_delete_request,
    build_get_request,
    build_list_request,
)

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ApplicationPackageOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.batch.aio.BatchManagementClient`'s
        :attr:`application_package` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def activate(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        version_name: str,
        parameters: _models.ActivateApplicationPackageParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ApplicationPackage:
        """Activates the specified application package. This should be done after the
        ``ApplicationPackage`` was created and uploaded. This needs to be done before an
        ``ApplicationPackage`` can be used on Pools or Tasks.

        :param resource_group_name: The name of the resource group that contains the Batch account.
         Required.
        :type resource_group_name: str
        :param account_name: The name of the Batch account. Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param version_name: The version of the application. Required.
        :type version_name: str
        :param parameters: The parameters for the request. Required.
        :type parameters: ~azure.mgmt.batch.models.ActivateApplicationPackageParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ApplicationPackage or the result of cls(response)
        :rtype: ~azure.mgmt.batch.models.ApplicationPackage
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def activate(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        version_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ApplicationPackage:
        """Activates the specified application package. This should be done after the
        ``ApplicationPackage`` was created and uploaded. This needs to be done before an
        ``ApplicationPackage`` can be used on Pools or Tasks.

        :param resource_group_name: The name of the resource group that contains the Batch account.
         Required.
        :type resource_group_name: str
        :param account_name: The name of the Batch account. Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param version_name: The version of the application. Required.
        :type version_name: str
        :param parameters: The parameters for the request. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ApplicationPackage or the result of cls(response)
        :rtype: ~azure.mgmt.batch.models.ApplicationPackage
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def activate(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        version_name: str,
        parameters: Union[_models.ActivateApplicationPackageParameters, IO],
        **kwargs: Any
    ) -> _models.ApplicationPackage:
        """Activates the specified application package. This should be done after the
        ``ApplicationPackage`` was created and uploaded. This needs to be done before an
        ``ApplicationPackage`` can be used on Pools or Tasks.

        :param resource_group_name: The name of the resource group that contains the Batch account.
         Required.
        :type resource_group_name: str
        :param account_name: The name of the Batch account. Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param version_name: The version of the application. Required.
        :type version_name: str
        :param parameters: The parameters for the request. Is either a model type or a IO type.
         Required.
        :type parameters: ~azure.mgmt.batch.models.ActivateApplicationPackageParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ApplicationPackage or the result of cls(response)
        :rtype: ~azure.mgmt.batch.models.ApplicationPackage
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2022-10-01"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ApplicationPackage]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "ActivateApplicationPackageParameters")

        request = build_activate_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            application_name=application_name,
            version_name=version_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.activate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ApplicationPackage", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    activate.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}/versions/{versionName}/activate"}  # type: ignore

    @overload
    async def create(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        version_name: str,
        parameters: Optional[_models.ApplicationPackage] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ApplicationPackage:
        """Creates an application package record. The record contains a storageUrl where the package
        should be uploaded to.  Once it is uploaded the ``ApplicationPackage`` needs to be activated
        using ``ApplicationPackageActive`` before it can be used. If the auto storage account was
        configured to use storage keys, the URL returned will contain a SAS.

        :param resource_group_name: The name of the resource group that contains the Batch account.
         Required.
        :type resource_group_name: str
        :param account_name: The name of the Batch account. Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param version_name: The version of the application. Required.
        :type version_name: str
        :param parameters: The parameters for the request. Default value is None.
        :type parameters: ~azure.mgmt.batch.models.ApplicationPackage
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ApplicationPackage or the result of cls(response)
        :rtype: ~azure.mgmt.batch.models.ApplicationPackage
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        version_name: str,
        parameters: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ApplicationPackage:
        """Creates an application package record. The record contains a storageUrl where the package
        should be uploaded to.  Once it is uploaded the ``ApplicationPackage`` needs to be activated
        using ``ApplicationPackageActive`` before it can be used. If the auto storage account was
        configured to use storage keys, the URL returned will contain a SAS.

        :param resource_group_name: The name of the resource group that contains the Batch account.
         Required.
        :type resource_group_name: str
        :param account_name: The name of the Batch account. Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param version_name: The version of the application. Required.
        :type version_name: str
        :param parameters: The parameters for the request. Default value is None.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ApplicationPackage or the result of cls(response)
        :rtype: ~azure.mgmt.batch.models.ApplicationPackage
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        version_name: str,
        parameters: Optional[Union[_models.ApplicationPackage, IO]] = None,
        **kwargs: Any
    ) -> _models.ApplicationPackage:
        """Creates an application package record. The record contains a storageUrl where the package
        should be uploaded to.  Once it is uploaded the ``ApplicationPackage`` needs to be activated
        using ``ApplicationPackageActive`` before it can be used. If the auto storage account was
        configured to use storage keys, the URL returned will contain a SAS.

        :param resource_group_name: The name of the resource group that contains the Batch account.
         Required.
        :type resource_group_name: str
        :param account_name: The name of the Batch account. Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param version_name: The version of the application. Required.
        :type version_name: str
        :param parameters: The parameters for the request. Is either a model type or a IO type. Default
         value is None.
        :type parameters: ~azure.mgmt.batch.models.ApplicationPackage or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ApplicationPackage or the result of cls(response)
        :rtype: ~azure.mgmt.batch.models.ApplicationPackage
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2022-10-01"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ApplicationPackage]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            if parameters is not None:
                _json = self._serialize.body(parameters, "ApplicationPackage")
            else:
                _json = None

        request = build_create_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            application_name=application_name,
            version_name=version_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ApplicationPackage", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}/versions/{versionName}"}  # type: ignore

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, account_name: str, application_name: str, version_name: str, **kwargs: Any
    ) -> None:
        """Deletes an application package record and its associated binary file.

        :param resource_group_name: The name of the resource group that contains the Batch account.
         Required.
        :type resource_group_name: str
        :param account_name: The name of the Batch account. Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param version_name: The version of the application. Required.
        :type version_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2022-10-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            application_name=application_name,
            version_name=version_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}/versions/{versionName}"}  # type: ignore

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, account_name: str, application_name: str, version_name: str, **kwargs: Any
    ) -> _models.ApplicationPackage:
        """Gets information about the specified application package.

        :param resource_group_name: The name of the resource group that contains the Batch account.
         Required.
        :type resource_group_name: str
        :param account_name: The name of the Batch account. Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param version_name: The version of the application. Required.
        :type version_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ApplicationPackage or the result of cls(response)
        :rtype: ~azure.mgmt.batch.models.ApplicationPackage
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2022-10-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ApplicationPackage]

        request = build_get_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            application_name=application_name,
            version_name=version_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ApplicationPackage", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}/versions/{versionName}"}  # type: ignore

    @distributed_trace
    def list(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        maxresults: Optional[int] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.ApplicationPackage"]:
        """Lists all of the application packages in the specified application.

        :param resource_group_name: The name of the resource group that contains the Batch account.
         Required.
        :type resource_group_name: str
        :param account_name: The name of the Batch account. Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param maxresults: The maximum number of items to return in the response. Default value is
         None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ApplicationPackage or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.batch.models.ApplicationPackage]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2022-10-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ListApplicationPackagesResult]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_request(
                    resource_group_name=resource_group_name,
                    account_name=account_name,
                    application_name=application_name,
                    subscription_id=self._config.subscription_id,
                    maxresults=maxresults,
                    api_version=api_version,
                    template_url=self.list.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ListApplicationPackagesResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}/versions"}  # type: ignore
