# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class CreateMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The mode to create a new MySQL server.
    """

    DEFAULT = "Default"
    POINT_IN_TIME_RESTORE = "PointInTimeRestore"
    REPLICA = "Replica"

class HaEnabledEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Whether or not HA is enabled for this server. Value is optional but if passed in, must be
    'Enabled' or 'Disabled'
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class InfrastructureEncryptionEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Add a second layer of encryption for your data using new encryption algorithm which gives
    additional data protection. Value is optional but if passed in, must be 'Disabled' or
    'Enabled'.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class IsConfigPendingRestart(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """If is the configuration pending restart or not.
    """

    TRUE = "True"
    FALSE = "False"

class IsDynamicConfig(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """If is the configuration dynamic.
    """

    TRUE = "True"
    FALSE = "False"

class IsReadOnly(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """If is the configuration read only.
    """

    TRUE = "True"
    FALSE = "False"

class OperationOrigin(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The intended executor of the operation.
    """

    NOT_SPECIFIED = "NotSpecified"
    USER = "user"
    SYSTEM = "system"

class PublicNetworkAccessEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Whether or not public network access is allowed for this server. Value is optional but if
    passed in, must be 'Enabled' or 'Disabled'
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class ServerHAState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of a HA server.
    """

    NOT_ENABLED = "NotEnabled"
    CREATING_STANDBY = "CreatingStandby"
    REPLICATING_DATA = "ReplicatingData"
    FAILING_OVER = "FailingOver"
    HEALTHY = "Healthy"
    REMOVING_STANDBY = "RemovingStandby"

class ServerKeyType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The key type like 'AzureKeyVault'.
    """

    AZURE_KEY_VAULT = "AzureKeyVault"

class ServerState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of a server.
    """

    READY = "Ready"
    DROPPING = "Dropping"
    DISABLED = "Disabled"
    STARTING = "Starting"
    STOPPING = "Stopping"
    STOPPED = "Stopped"
    UPDATING = "Updating"

class ServerVersion(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The version of a server.
    """

    FIVE7 = "5.7"

class SkuTier(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The tier of the particular SKU, e.g. GeneralPurpose.
    """

    BURSTABLE = "Burstable"
    GENERAL_PURPOSE = "GeneralPurpose"
    MEMORY_OPTIMIZED = "MemoryOptimized"

class SslEnforcementEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Enable ssl enforcement or not when connect to server.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class StorageAutogrow(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Enable Storage Auto Grow.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"
