# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

from typing import Any, List, Mapping, Optional, overload

from .._utils.model_base import Model as _Model, rest_field


class AddToGroupsRequest(_Model):
    """Request object to add connections to groups.

    :ivar groups: Target groups.
    :vartype groups: list[str]
    :ivar filter: Following OData filter syntax to filter out the subscribers receiving the
     messages.
    :vartype filter: str
    """

    groups: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Target groups."""
    filter: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Following OData filter syntax to filter out the subscribers receiving the messages."""

    @overload
    def __init__(
        self,
        *,
        groups: Optional[List[str]] = None,
        filter: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ClientTokenResponse(_Model):
    """The response object containing the client access token.

    :ivar token: Access token for the client to connect Azure Web PubSub service.
    :vartype token: str
    """

    token: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Access token for the client to connect Azure Web PubSub service."""

    @overload
    def __init__(
        self,
        *,
        token: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GroupMember(_Model):
    """Group member.

    :ivar connection_id: Connection Id. Required.
    :vartype connection_id: str
    :ivar user_id: User Id.
    :vartype user_id: str
    """

    connection_id: str = rest_field(name="connectionId", visibility=["read", "create", "update", "delete", "query"])
    """Connection Id. Required."""
    user_id: Optional[str] = rest_field(name="userId", visibility=["read", "create", "update", "delete", "query"])
    """User Id."""

    @overload
    def __init__(
        self,
        *,
        connection_id: str,
        user_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RemoveFromGroupsRequest(_Model):
    """Request object to remove connections from groups.

    :ivar groups: Target groups.
    :vartype groups: list[str]
    :ivar filter: Following OData filter syntax to filter out the subscribers receiving the
     messages.
    :vartype filter: str
    """

    groups: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Target groups."""
    filter: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Following OData filter syntax to filter out the subscribers receiving the messages."""

    @overload
    def __init__(
        self,
        *,
        groups: Optional[List[str]] = None,
        filter: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
