/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.IntegratedFunctionLibrary;
import net.sf.saxon.functions.IsIdRef;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.BasePatternWithPredicate;
import net.sf.saxon.pattern.MultipleNodeKindTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.trans.KeyIndex;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.z.IntHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyManager {
    private PackageData packageData;
    private static final KeyIndex underConstruction = new KeyIndex(false);
    private HashMap<StructuredQName, KeyDefinitionSet> keyDefinitions;
    private transient WeakHashMap<TreeInfo, WeakReference<IntHashMap<KeyIndex>>> docIndexes;

    public KeyManager(Configuration config, PackageData pack) {
        this.packageData = pack;
        this.keyDefinitions = new HashMap(10);
        this.docIndexes = new WeakHashMap(10);
        this.registerIdrefKey(config);
    }

    private void registerIdrefKey(Configuration config) {
        BasePatternWithPredicate pp = new BasePatternWithPredicate(new NodeTestPattern(new MultipleNodeKindTest(UType.ELEMENT_OR_ATTRIBUTE)), IntegratedFunctionLibrary.makeFunctionCall(new IsIdRef(), new Expression[0]));
        try {
            IndependentContext sc = new IndependentContext(config);
            sc.setPackageData(this.packageData);
            sc.setXPathLanguageLevel(31);
            RetainedStaticContext rsc = new RetainedStaticContext(sc);
            Expression sf = SystemFunction.makeCall("string", rsc, new ContextItemExpression());
            Expression use = SystemFunction.makeCall("tokenize", rsc, sf);
            StructuredQName qName = StandardNames.getStructuredQName(562);
            SymbolicName symbolicName = new SymbolicName(165, qName);
            KeyDefinition key = new KeyDefinition(symbolicName, pp, use, null, null);
            key.setPackageData(this.packageData);
            key.setIndexedItemType(BuiltInAtomicType.STRING);
            this.addKeyDefinition(qName, key, true, config);
        }
        catch (XPathException err) {
            throw new AssertionError((Object)err);
        }
    }

    public void preRegisterKeyDefinition(StructuredQName keyName) {
        KeyDefinitionSet keySet = this.keyDefinitions.get(keyName);
        if (keySet == null) {
            keySet = new KeyDefinitionSet(keyName, this.keyDefinitions.size());
            this.keyDefinitions.put(keyName, keySet);
        }
    }

    public void addKeyDefinition(StructuredQName keyName, KeyDefinition keydef, boolean reusable, Configuration config) throws XPathException {
        boolean backwardsCompatible;
        KeyDefinitionSet keySet = this.keyDefinitions.get(keyName);
        if (keySet == null) {
            keySet = new KeyDefinitionSet(keyName, this.keyDefinitions.size());
            this.keyDefinitions.put(keyName, keySet);
        }
        keySet.addKeyDefinition(keydef);
        if (!reusable) {
            keySet.setReusable(false);
        }
        if (backwardsCompatible = keySet.isBackwardsCompatible()) {
            List<KeyDefinition> v = keySet.getKeyDefinitions();
            for (KeyDefinition kd : v) {
                kd.setBackwardsCompatible(true);
                if (kd.getBody().getItemType().equals(BuiltInAtomicType.STRING)) continue;
                AtomicSequenceConverter exp = new AtomicSequenceConverter(kd.getBody(), BuiltInAtomicType.STRING);
                exp.allocateConverter(config, false);
                kd.setBody(exp);
            }
        }
    }

    public KeyDefinitionSet getKeyDefinitionSet(StructuredQName qName) {
        return this.keyDefinitions.get(qName);
    }

    public KeyDefinitionSet findKeyDefinition(Pattern finder, Expression use, String collationName) {
        for (KeyDefinitionSet keySet : this.keyDefinitions.values()) {
            if (keySet.getKeyDefinitions().size() != 1) continue;
            for (KeyDefinition keyDef : keySet.getKeyDefinitions()) {
                if (!keyDef.getMatch().equals(finder) || !keyDef.getUse().equals(use) || !keyDef.getCollationName().equals(collationName)) continue;
                return keySet;
            }
        }
        return null;
    }

    private synchronized KeyIndex buildIndex(KeyDefinitionSet keySet, TreeInfo doc, XPathContext context) throws XPathException {
        KeyIndex index = new KeyIndex(keySet.isRangeKey());
        index.buildIndex(keySet, doc, context);
        return index;
    }

    public SequenceIterator selectByKey(KeyDefinitionSet keySet, TreeInfo doc, AtomicValue soughtValue, XPathContext context) throws XPathException {
        if (soughtValue == null) {
            return EmptyIterator.OfNodes.THE_INSTANCE;
        }
        if (keySet.isBackwardsCompatible()) {
            ConversionRules rules = context.getConfiguration().getConversionRules();
            soughtValue = Converter.convert(soughtValue, BuiltInAtomicType.STRING, rules).asAtomic();
        } else {
            BuiltInAtomicType itemType = soughtValue.getPrimitiveType();
            if (itemType.equals(BuiltInAtomicType.INTEGER) || itemType.equals(BuiltInAtomicType.DECIMAL) || itemType.equals(BuiltInAtomicType.FLOAT)) {
                soughtValue = new DoubleValue(((NumericValue)soughtValue).getDoubleValue());
            }
        }
        KeyIndex index = this.obtainIndex(keySet, doc, context);
        List<NodeInfo> nodes = index.get(soughtValue);
        if (nodes == null) {
            return EmptyIterator.emptyIterator();
        }
        return new ListIterator(nodes);
    }

    public SequenceIterator selectByCompositeKey(KeyDefinitionSet keySet, TreeInfo doc, SequenceIterator soughtValue, XPathContext context) throws XPathException {
        KeyIndex index = this.obtainIndex(keySet, doc, context);
        List<NodeInfo> nodes = index.getComposite(soughtValue);
        if (nodes == null) {
            return EmptyIterator.emptyIterator();
        }
        return new ListIterator(nodes);
    }

    public KeyIndex obtainIndex(KeyDefinitionSet keySet, TreeInfo doc, XPathContext context) throws XPathException {
        if (keySet.isReusable()) {
            return this.obtainSharedIndex(keySet, doc, context);
        }
        return this.obtainLocalIndex(keySet, doc, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyIndex obtainSharedIndex(KeyDefinitionSet keySet, TreeInfo doc, XPathContext context) throws XPathException {
        KeyIndex index;
        int keySetNumber = keySet.getKeySetNumber();
        TreeInfo treeInfo = doc;
        synchronized (treeInfo) {
            index = this.getSharedIndex(doc, keySetNumber);
            if (index == underConstruction) {
                XPathException de = new XPathException("Key definition is circular");
                de.setXPathContext(context);
                de.setErrorCode("XTDE0640");
                throw de;
            }
            if (index == null) {
                this.putSharedIndex(doc, keySetNumber, underConstruction, context);
                index = this.buildIndex(keySet, doc, context);
                this.putSharedIndex(doc, keySetNumber, index, context);
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyIndex obtainLocalIndex(KeyDefinitionSet keySet, TreeInfo doc, XPathContext context) throws XPathException {
        KeyIndex index;
        int keySetNumber = keySet.getKeySetNumber();
        TreeInfo treeInfo = doc;
        synchronized (treeInfo) {
            index = this.getLocalIndex(doc, keySetNumber, context);
            if (index == underConstruction) {
                XPathException de = new XPathException("Key definition is circular");
                de.setXPathContext(context);
                de.setErrorCode("XTDE0640");
                throw de;
            }
            if (index == null) {
                this.putLocalIndex(doc, keySetNumber, underConstruction, context);
                index = this.buildIndex(keySet, doc, context);
                this.putLocalIndex(doc, keySetNumber, index, context);
            }
        }
        return index;
    }

    private synchronized void putSharedIndex(TreeInfo doc, int keyFingerprint, KeyIndex index, XPathContext context) {
        IntHashMap indexList;
        WeakReference<IntHashMap<KeyIndex>> indexRef;
        if (this.docIndexes == null) {
            this.docIndexes = new WeakHashMap(10);
        }
        if ((indexRef = this.docIndexes.get(doc)) == null || indexRef.get() == null) {
            indexList = new IntHashMap(10);
            Controller controller = context.getController();
            if (controller.getDocumentPool().contains(doc)) {
                context.getController().setUserData(doc, "saxon:key-index-list", indexList);
            } else {
                doc.setUserData("saxon:key-index-list", indexList);
            }
            this.docIndexes.put(doc, new WeakReference<IntHashMap>(indexList));
        } else {
            indexList = (IntHashMap)indexRef.get();
        }
        indexList.put(keyFingerprint, index);
    }

    private synchronized void putLocalIndex(TreeInfo doc, int keyFingerprint, KeyIndex index, XPathContext context) {
        Controller controller = context.getController();
        IntHashMap<KeyIndex> docIndexes = (IntHashMap<KeyIndex>)controller.getUserData(doc, "saxon:unshared-key-index-list");
        if (docIndexes == null) {
            docIndexes = new IntHashMap<KeyIndex>();
            controller.setUserData(doc, "saxon:unshared-key-index-list", docIndexes);
        }
        docIndexes.put(keyFingerprint, index);
    }

    private synchronized KeyIndex getSharedIndex(TreeInfo doc, int keyFingerprint) {
        WeakReference<IntHashMap<KeyIndex>> ref;
        if (this.docIndexes == null) {
            this.docIndexes = new WeakHashMap(10);
        }
        if ((ref = this.docIndexes.get(doc)) == null) {
            return null;
        }
        IntHashMap indexList = (IntHashMap)ref.get();
        if (indexList == null) {
            return null;
        }
        return (KeyIndex)indexList.get(keyFingerprint);
    }

    private synchronized KeyIndex getLocalIndex(TreeInfo doc, int keyFingerprint, XPathContext context) {
        Controller controller = context.getController();
        IntHashMap docIndexes = (IntHashMap)controller.getUserData(doc, "saxon:unshared-key-index-list");
        if (docIndexes == null) {
            return null;
        }
        return (KeyIndex)docIndexes.get(keyFingerprint);
    }

    public synchronized void clearDocumentIndexes(TreeInfo doc) {
        this.docIndexes.remove(doc);
    }

    public Collection<KeyDefinitionSet> getAllKeyDefinitionSets() {
        return this.keyDefinitions.values();
    }

    public int getNumberOfKeyDefinitions() {
        return this.keyDefinitions.size();
    }

    public void exportKeys(ExpressionPresenter out, Map<Component, Integer> componentIdMap) throws XPathException {
        for (Map.Entry<StructuredQName, KeyDefinitionSet> e : this.keyDefinitions.entrySet()) {
            boolean reusable = e.getValue().isReusable();
            List<KeyDefinition> list = e.getValue().getKeyDefinitions();
            for (KeyDefinition kd : list) {
                if (kd.getObjectName().equals(StandardNames.getStructuredQName(562))) continue;
                kd.export(out, reusable, componentIdMap);
            }
        }
    }
}

