
      SUBROUTINE INISU3
C     ------------------

      INCLUDE 'qcd2.inc'

      INTEGER     NDIR
      PARAMETER ( NDIR = 4 )

      INTEGER     TDIR,  XDIR,  YDIR,  ZDIR,  EVEN,  ODD,
     *            PSENSE,  NSENSE,  PLUS,  MINUS,  RE,  IM
      PARAMETER ( TDIR = 1,    XDIR = 2,    YDIR = 3,    ZDIR = 4,
     *            EVEN = 0,     ODD = 1, PSENSE= 0, NSENSE= 1,
     *            PLUS = 0,   MINUS = 1,      RE = 1,      IM = 2 )

      INTEGER  PARITY, DIR, SITE, I, J, K
      DOUBLE PRECISION    U (NCOLOR, NCMPLX), 
     *                    V (NCOLOR, NCMPLX),
     *                    W (NCOLOR, NCMPLX),
     *            GAUGE( NSITES/2, NCOLOR, NCOLOR, NCMPLX, NDIR, 0:1)

      COMMON / LINKS / GAUGE
C     --------------------------------------------------------------------
C     |  The gauge fields (on the links) are initialised to randomly     |
C     |  distributed SU(3) matrices.  All the elements of the SU(3)      |
C     |  matrix are stored.  The matrices are parameterised as follows:  |
C     |                                                                  |
C     |       SU(3) matrix = [ u  v  w ]                                 |
C     |                                                                  |
C     |  where u, v, w are complex 3-component column vectors subject    |
C     |  to the following conditions:                                    |
C     |                                                                  |
C     |       (u,u) = 1;   (v,v) = 1;   (u,v) = 0;                       |
C     |                                                                  |
C     |       w = complex.conj (u /\ v)                                  |
C     --------------------------------------------------------------------


      DO 102  PARITY = 0, 1
        DO 101  DIR = 1, NDIR
          DO 100  SITE = 1, NSITES / 2

C     -------------------------------------------------------------------------
C     |  First column of SU(3) matrix = u   (a complex 3-vector, st (u,u) = 1)|
C     -------------------------------------------------------------------------
            CALL RANDS5 ( U )
            DO 10  I = 1, 3
              GAUGE (SITE, I, 1, RE, DIR, PARITY) = U (I, RE)
              GAUGE (SITE, I, 1, IM, DIR, PARITY) = U (I, IM)
 10         CONTINUE

C     --------------------------------------------------------
C     |  Second column of SU(3) matrix = v                   |
C     | ( a complex 3-vector, st (v,v) = 1 and (u,v) = 0 ).  |
C     --------------------------------------------------------
            CALL ORTHS5 ( U, V )
            DO 20  I = 1, 3
              GAUGE (SITE, I, 2, RE, DIR, PARITY) = V (I, RE)
              GAUGE (SITE, I, 2, IM, DIR, PARITY) = V (I, IM)
 20         CONTINUE

C     -----------------------------------------------------------------
C     |  Third column of SU3 matrix  =  w  =  complex conj. (u /\ v)  |
C     -----------------------------------------------------------------
            DO 30  I = 1, 3
              J = MOD (I, 3) + 1
              K = MOD ((I+1), 3) + 1
              W (I, RE) = 
     *                 ( U (J,RE) * V (K,RE) - U (K,RE) * V (J,RE) )
     *               - ( U (J,IM) * V (K,IM) - U (K,IM) * V (J,IM) )
 
              W (I, IM) = 
     *               - ( U (J,RE) * V (K,IM) - U (K,RE) * V (J,IM) )
     *               - ( U (J,IM) * V (K,RE) - U (K,IM) * V (J,RE) )
 30         CONTINUE

C------ w should have length 1, but renormalise it anyway to correct
C------ for rounding errors:

            CALL RENORM (W)

            DO 40  I = 1, 3
              GAUGE (SITE, I, 3, RE, DIR, PARITY) = W (I, RE)
              GAUGE (SITE, I, 3, IM, DIR, PARITY) = W (I, IM)
 40         CONTINUE

 100      CONTINUE
 101    CONTINUE
 102  CONTINUE
      END
