/* XTRON.H - Tron player routines for X

  Rhett D. Jacobs   <rhett@jaemol.cbr.fidonet.org>

  Version 1.0

  Last Modified: 1/1/95
*/

#ifndef XTRON_H
#define XTRON_H

/* Changed code to work with other sized windows too... -- ET */
#define MAXHORZ	48			/* game area 'slots' */
#define MINHORZ 0
#define MAXVERT 37			/* for 640x400 screen */
#define MINVERT 0
#define GAME_X	MAXHORZ * 8		/* game area in pixels (8x8 blocks) */
#define GAME_Y	MAXVERT * 8

#define WIN_WIDTH	GAME_X
#define WIN_HEIGHT	GAME_Y + 64	/* + sum of icon heights */

enum directions {left, right, up, down};
enum play_types {human, computer};

struct Player {
  short int co_ords[2];
  short int plr_num;  
  int score;
  int alive;
  enum directions plr_dir;
  enum play_types plr_type; 
} p[2];

struct Board {
  short int contents[MAXHORZ + 1][MAXVERT + 1];
} b;

 
void plr_setup(void);
int plr_checkmove(int p_num, int new_val, int axis_type, enum directions dir);
void plr_turn(int p_num, enum directions dir);
void brd_setup(void);
int brd_newcontents(int x, int y, int what);

#endif
