#include <libraries/dosextens.h>
#include <exec/memory.h>
#include <functions.h>
#include <string.h>

char *pathoflock(struct FileLock *l);

main()
{
    struct CommandLineInterface *cli;
    struct Process *p;
    struct FileLock *lock;
    long l, *lp;

    p = (struct Process *)FindTask(0);
    if (!(cli = (struct CommandLineInterface *)((long)p->pr_CLI << 2)))
	exit(1);

    puts("Current dir");
    l = (long)cli->cli_CommandDir;
    while (l) {
	l <<= 2;
	lp = (long *)l;
	lock = (struct FileLock *)*(lp + 1);
	puts(pathoflock(lock));
	l = *lp;
    }
    puts("C:");
    exit(0);
}

char *pathoflock(struct FileLock *origl)
{
    static char tmp[256],path[256];
    struct FileInfoBlock *fib;
    struct FileLock *l, *p = origl;

    path[0] = '\0';
    fib = (struct FileInfoBlock *)malloc(sizeof(*fib));
    while (l = p) {
	Examine((BPTR)l, (BPTR)fib);
	if (!*(fib->fib_FileName))
	    strcpy(tmp, "RAM");		/* If null name, assume RAM disk */
	else
	    strcpy(tmp, (char *)(fib->fib_FileName));

	if (!(p = ParentDir(l)))
	    strcat(tmp, ":");
	else if (path[0])
	    strcat(tmp, "/");
	if (l != origl)
	    UnLock((BPTR)l);
	strcat (tmp, path);
	strcpy (path, tmp);
    }
    free(fib);
    return(path);
}
