/* The Manx library uses "proprietary" environment variables (stored in some
   form of "ENV:" handler) so we duplicate (empirically) the AmigaDOS version
   of environment variables.  (Which I am told the next minor release of the
   Manx compiler (beyond 5.0) will support.)
*/
#include <stdio.h>
   
char *getenv(char *name)
{
    char fullname[128];
    static char buff[128];
    FILE *f;
    int len;

    sprintf(fullname, "ENV:%s", name);
    if (!(f = fopen(fullname, "r"))) return (NULL);
    len = fread(buff, 1, sizeof(buff) - 1, f);
    fclose(f);
    if (len > 0 && buff[len - 1] == '\n') len--;
    buff[len] = '\0';
    return (len ? buff : NULL);
}
