#
# Makefile	15 May 1990 David G. Grubbs (-dgg-)
#
# A heavily modified version of the PERL Makefile.
#
# "cd" to the "amiga" directory below the main PERL directory, and type
# "make".  This will build a library and copy some amiga-specific to the
# "perl" working directory.
#
# Then "cd" to the main PERL directory and type "make".
#

CC = cc
YACC = bison -y
bin = bin:
privlib = s:perl
DEBUG= -DDEBUGGING
CFLAGS = $(DEBUG) -Iamiga -O
LDFLAGS = -O

ulib = amiga/unix.lib
libs = $(ulib) -lm

MAKE = make

h1 = EXTERN.h INTERN.h arg.h array.h cmd.h config.h form.h handy.h
h2 = hash.h perl.h regcomp.h regexp.h spat.h stab.h str.h util.h
ulibh = dir.h stat.h

h = $(h1) $(h2) $(ulibh)

c1 = array.c cmd.c cons.c consarg.c doarg.c doio.c
c2 = dolist.c dump.c eval.c form.c hash.c perly.c
c3 = regcomp.c regexec.c stab.c str.c toke.c util.c spawn.c

c = $(c1) $(c2) $(c3)

obj1 = array.o cmd.o cons.o consarg.o doarg.o doio.o
obj2 = dolist.o dump.o eval.o form.o hash.o perly.o
obj3 = regcomp.o regexec.o stab.o str.o toke.o util.o spawn.o

obj = $(obj1) $(obj2) $(obj3)

.c.o:
	$(CC) -c $(CFLAGS) $*.c

all: perl

perl: perl.o $(obj) $(ulib)
	$(CC) $(LDFLAGS) $(obj) perl.o $(libs) -o perl

perl.c: perl.y
	@echo "Expect 25 shift/reduce conflicts..."
	$(YACC) -d perl.y
	move y.tab.c perl.c
	join y.tab.h amiga/perly.adder as perly.h
	delete y.tab.h

perl.o: perl.c perly.h $(h)
	$(CC) -c $(CFLAGS) perl.c

eval.o: evalargs.xc

$(obj1): $(h)
$(obj2): $(h)
$(obj3): $(h)

install: all
	-delete $(bin)perl.old
	-move $(bin)perl $(bin)perl.old
	-copy perl $(bin)
	-makedir $(privlib)
	-copy lib $(privlib) all

clean:
	-delete AztecC.err
	-delete $(obj)
	-delete perl perl.c perly.h
