#include "authdefs.h"
#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/notify.h>
#include <mach/mach_types.h>
#include <mach/mig_errors.h>
#include <mach/msg_type.h>
#ifndef	KERNEL
#include <strings.h>
#endif	KERNEL
/* LINTLIBRARY */

extern mach_port_t mig_get_reply_port();
extern void mig_dealloc_reply_port();

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

#define msgh_request_port	msgh_remote_port
#define msgh_reply_port		msgh_local_port


/* Routine auth_getids */
mig_external kern_return_t auth_getids
#if	(defined(__STDC__) || defined(c_plusplus))
(
	auth_t handle,
	idarray_t *uids,
	mach_msg_type_number_t *uidsCnt,
	idarray_t *gids,
	mach_msg_type_number_t *gidsCnt
)
#else
	(handle, uids, uidsCnt, gids, gidsCnt)
	auth_t handle;
	idarray_t *uids;
	mach_msg_type_number_t *uidsCnt;
	idarray_t *gids;
	mach_msg_type_number_t *gidsCnt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t uidsType;
		uid_t uids[512];
		mach_msg_type_long_t gidsType;
		uid_t gids[512];
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
#if	TypeCheck
	unsigned int msgh_size;
#endif	TypeCheck
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = handle;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 25000;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 25100) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);

	if (((msgh_size < 56)) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
	if ((OutP->uidsType.msgtl_header.msgt_longform != TRUE) ||
	    (OutP->uidsType.msgtl_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->uidsType.msgtl_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	msgh_size_delta = (OutP->uidsType.msgtl_header.msgt_inline) ? 4 * OutP->uidsType.msgtl_number : sizeof(uid_t *);
#if	TypeCheck
	if (msgh_size < 56 + msgh_size_delta)
		return MIG_TYPE_ERROR;
	msgh_size -= msgh_size_delta;
#endif	TypeCheck

	if (!OutP->uidsType.msgtl_header.msgt_inline)
	    *uids = *((uid_t **)OutP->uids);
	else if (OutP->uidsType.msgtl_number > *uidsCnt) {
	    mig_allocate((vm_offset_t *)uids,
		4 * OutP->uidsType.msgtl_number);
	    bcopy(*(char **)OutP->uids, (char *)*uids, 4 * OutP->uidsType.msgtl_number);
	}
	else {
	    bcopy((char *) OutP->uids, (char *) *uids, 4 * OutP->uidsType.msgtl_number);
	}

	*uidsCnt = OutP->uidsType.msgtl_number;

	OutP = (Reply *) ((char *) OutP + msgh_size_delta - 2048);

#if	TypeCheck
	if ((OutP->gidsType.msgtl_header.msgt_longform != TRUE) ||
	    (OutP->gidsType.msgtl_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->gidsType.msgtl_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
	if (msgh_size != 56 + ((OutP->gidsType.msgtl_header.msgt_inline) ? 4 * OutP->gidsType.msgtl_number : sizeof(uid_t *)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (!OutP->gidsType.msgtl_header.msgt_inline)
	    *gids = *((uid_t **)OutP->gids);
	else if (OutP->gidsType.msgtl_number > *gidsCnt) {
	    mig_allocate((vm_offset_t *)gids,
		4 * OutP->gidsType.msgtl_number);
	    bcopy(*(char **)OutP->gids, (char *)*gids, 4 * OutP->gidsType.msgtl_number);
	}
	else {
	    bcopy((char *) OutP->gids, (char *) *gids, 4 * OutP->gidsType.msgtl_number);
	}

	*gidsCnt = OutP->gidsType.msgtl_number;

	return KERN_SUCCESS;
}

/* Routine auth_makeauth */
mig_external kern_return_t auth_makeauth
#if	(defined(__STDC__) || defined(c_plusplus))
(
	auth_t handle,
	idarray_t uids,
	mach_msg_type_number_t uidsCnt,
	idarray_t gids,
	mach_msg_type_number_t gidsCnt,
	mach_port_t *newhandle
)
#else
	(handle, uids, uidsCnt, gids, gidsCnt, newhandle)
	auth_t handle;
	idarray_t uids;
	mach_msg_type_number_t uidsCnt;
	idarray_t gids;
	mach_msg_type_number_t gidsCnt;
	mach_port_t *newhandle;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_long_t uidsType;
		uid_t uids[512];
		mach_msg_type_long_t gidsType;
		uid_t gids[512];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t newhandleType;
		mach_port_t newhandle;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
	boolean_t msgh_simple = TRUE;
	unsigned int msgh_size;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_long_t uidsType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	MACH_MSG_TYPE_INTEGER_32,
		/* msgtl_size = */	32,
		/* msgtl_number = */	512,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t gidsType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	MACH_MSG_TYPE_INTEGER_32,
		/* msgtl_size = */	32,
		/* msgtl_number = */	512,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t newhandleCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->uidsType = uidsType;
#else	UseStaticMsgType
	InP->uidsType.msgtl_name = MACH_MSG_TYPE_INTEGER_32;
	InP->uidsType.msgtl_size = 32;
	InP->uidsType.msgtl_header.msgt_name = 0;
	InP->uidsType.msgtl_header.msgt_size = 0;
	InP->uidsType.msgtl_header.msgt_number = 0;
	InP->uidsType.msgtl_header.msgt_inline = TRUE;
	InP->uidsType.msgtl_header.msgt_longform = TRUE;
	InP->uidsType.msgtl_header.msgt_deallocate = FALSE;
	InP->uidsType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	if (uidsCnt > 512) {
		InP->uidsType.msgtl_header.msgt_inline = FALSE;
		*((uid_t **)InP->uids) = uids;
		msgh_simple = FALSE;
	}
	else {
		bcopy((char *) uids, (char *) InP->uids, 4 * uidsCnt);
	}

	InP->uidsType.msgtl_number = uidsCnt;

	msgh_size_delta = (InP->uidsType.msgtl_header.msgt_inline) ? 4 * uidsCnt : sizeof(uid_t *);
	msgh_size = 48 + msgh_size_delta;
	InP = (Request *) ((char *) InP + msgh_size_delta - 2048);
#if	UseStaticMsgType
	InP->gidsType = gidsType;
#else	UseStaticMsgType
	InP->gidsType.msgtl_name = MACH_MSG_TYPE_INTEGER_32;
	InP->gidsType.msgtl_size = 32;
	InP->gidsType.msgtl_header.msgt_name = 0;
	InP->gidsType.msgtl_header.msgt_size = 0;
	InP->gidsType.msgtl_header.msgt_number = 0;
	InP->gidsType.msgtl_header.msgt_inline = TRUE;
	InP->gidsType.msgtl_header.msgt_longform = TRUE;
	InP->gidsType.msgtl_header.msgt_deallocate = FALSE;
	InP->gidsType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	if (gidsCnt > 512) {
		InP->gidsType.msgtl_header.msgt_inline = FALSE;
		*((uid_t **)InP->gids) = gids;
		msgh_simple = FALSE;
	}
	else {
		bcopy((char *) gids, (char *) InP->gids, 4 * gidsCnt);
	}

	InP->gidsType.msgtl_number = gidsCnt;

	msgh_size += (InP->gidsType.msgtl_header.msgt_inline) ? 4 * gidsCnt : sizeof(uid_t *);
	InP = &Mess.In;
	InP->Head.msgh_bits = msgh_simple ?
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE) :
		(MACH_MSGH_BITS_COMPLEX|
		 MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE));
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = handle;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 25001;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 25101) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);

	if (((msgh_size != 40) || msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->newhandleType != * (int *) &newhandleCheck)
#else	UseStaticMsgType
	if ((OutP->newhandleType.msgt_inline != TRUE) ||
	    (OutP->newhandleType.msgt_longform != FALSE) ||
	    (OutP->newhandleType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (OutP->newhandleType.msgt_number != 1) ||
	    (OutP->newhandleType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*newhandle = OutP->newhandle;

	return KERN_SUCCESS;
}

/* Routine auth_combine */
mig_external kern_return_t auth_combine
#if	(defined(__STDC__) || defined(c_plusplus))
(
	auth_t handle1,
	auth_t handle2,
	mach_port_t *newhandle
)
#else
	(handle1, handle2, newhandle)
	auth_t handle1;
	auth_t handle2;
	mach_port_t *newhandle;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t handle2Type;
		auth_t handle2;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t newhandleType;
		mach_port_t newhandle;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
#if	TypeCheck
	unsigned int msgh_size;
#endif	TypeCheck

#if	UseStaticMsgType
	static mach_msg_type_t handle2Type = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t newhandleCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->handle2Type = handle2Type;
#else	UseStaticMsgType
	InP->handle2Type.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	InP->handle2Type.msgt_size = 32;
	InP->handle2Type.msgt_number = 1;
	InP->handle2Type.msgt_inline = TRUE;
	InP->handle2Type.msgt_longform = FALSE;
	InP->handle2Type.msgt_deallocate = FALSE;
	InP->handle2Type.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->handle2 = handle2;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = handle1;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 25002;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 25102) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);

	if (((msgh_size != 40) || msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->newhandleType != * (int *) &newhandleCheck)
#else	UseStaticMsgType
	if ((OutP->newhandleType.msgt_inline != TRUE) ||
	    (OutP->newhandleType.msgt_longform != FALSE) ||
	    (OutP->newhandleType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (OutP->newhandleType.msgt_number != 1) ||
	    (OutP->newhandleType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*newhandle = OutP->newhandle;

	return KERN_SUCCESS;
}

/* Routine auth_user_authenticate */
mig_external kern_return_t auth_user_authenticate
#if	(defined(__STDC__) || defined(c_plusplus))
(
	auth_t handle,
	mach_port_t rendezvous,
	mach_port_t *newport
)
#else
	(handle, rendezvous, newport)
	auth_t handle;
	mach_port_t rendezvous;
	mach_port_t *newport;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t rendezvousType;
		mach_port_t rendezvous;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t newportType;
		mach_port_t newport;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
#if	TypeCheck
	unsigned int msgh_size;
#endif	TypeCheck

#if	UseStaticMsgType
	static mach_msg_type_t rendezvousType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t newportCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->rendezvousType = rendezvousType;
#else	UseStaticMsgType
	InP->rendezvousType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	InP->rendezvousType.msgt_size = 32;
	InP->rendezvousType.msgt_number = 1;
	InP->rendezvousType.msgt_inline = TRUE;
	InP->rendezvousType.msgt_longform = FALSE;
	InP->rendezvousType.msgt_deallocate = FALSE;
	InP->rendezvousType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->rendezvous = rendezvous;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = handle;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 25003;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 25103) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);

	if (((msgh_size != 40) || msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->newportType != * (int *) &newportCheck)
#else	UseStaticMsgType
	if ((OutP->newportType.msgt_inline != TRUE) ||
	    (OutP->newportType.msgt_longform != FALSE) ||
	    (OutP->newportType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (OutP->newportType.msgt_number != 1) ||
	    (OutP->newportType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*newport = OutP->newport;

	return KERN_SUCCESS;
}

/* Routine auth_server_authenticate */
mig_external kern_return_t auth_server_authenticate
#if	(defined(__STDC__) || defined(c_plusplus))
(
	auth_t handle,
	mach_port_t rendezvous,
	mach_port_t newport,
	idarray_t *uids,
	mach_msg_type_number_t *uidsCnt,
	idarray_t *gids,
	mach_msg_type_number_t *gidsCnt
)
#else
	(handle, rendezvous, newport, uids, uidsCnt, gids, gidsCnt)
	auth_t handle;
	mach_port_t rendezvous;
	mach_port_t newport;
	idarray_t *uids;
	mach_msg_type_number_t *uidsCnt;
	idarray_t *gids;
	mach_msg_type_number_t *gidsCnt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t rendezvousType;
		mach_port_t rendezvous;
		mach_msg_type_t newportType;
		mach_port_t newport;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t uidsType;
		uid_t uids[512];
		mach_msg_type_long_t gidsType;
		uid_t gids[512];
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
#if	TypeCheck
	unsigned int msgh_size;
#endif	TypeCheck
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t rendezvousType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t newportType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->rendezvousType = rendezvousType;
#else	UseStaticMsgType
	InP->rendezvousType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	InP->rendezvousType.msgt_size = 32;
	InP->rendezvousType.msgt_number = 1;
	InP->rendezvousType.msgt_inline = TRUE;
	InP->rendezvousType.msgt_longform = FALSE;
	InP->rendezvousType.msgt_deallocate = FALSE;
	InP->rendezvousType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->rendezvous = rendezvous;

#if	UseStaticMsgType
	InP->newportType = newportType;
#else	UseStaticMsgType
	InP->newportType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	InP->newportType.msgt_size = 32;
	InP->newportType.msgt_number = 1;
	InP->newportType.msgt_inline = TRUE;
	InP->newportType.msgt_longform = FALSE;
	InP->newportType.msgt_deallocate = FALSE;
	InP->newportType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->newport = newport;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = handle;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 25004;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 25104) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);

	if (((msgh_size < 56)) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
	if ((OutP->uidsType.msgtl_header.msgt_longform != TRUE) ||
	    (OutP->uidsType.msgtl_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->uidsType.msgtl_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	msgh_size_delta = (OutP->uidsType.msgtl_header.msgt_inline) ? 4 * OutP->uidsType.msgtl_number : sizeof(uid_t *);
#if	TypeCheck
	if (msgh_size < 56 + msgh_size_delta)
		return MIG_TYPE_ERROR;
	msgh_size -= msgh_size_delta;
#endif	TypeCheck

	if (!OutP->uidsType.msgtl_header.msgt_inline)
	    *uids = *((uid_t **)OutP->uids);
	else if (OutP->uidsType.msgtl_number > *uidsCnt) {
	    mig_allocate((vm_offset_t *)uids,
		4 * OutP->uidsType.msgtl_number);
	    bcopy(*(char **)OutP->uids, (char *)*uids, 4 * OutP->uidsType.msgtl_number);
	}
	else {
	    bcopy((char *) OutP->uids, (char *) *uids, 4 * OutP->uidsType.msgtl_number);
	}

	*uidsCnt = OutP->uidsType.msgtl_number;

	OutP = (Reply *) ((char *) OutP + msgh_size_delta - 2048);

#if	TypeCheck
	if ((OutP->gidsType.msgtl_header.msgt_longform != TRUE) ||
	    (OutP->gidsType.msgtl_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->gidsType.msgtl_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
	if (msgh_size != 56 + ((OutP->gidsType.msgtl_header.msgt_inline) ? 4 * OutP->gidsType.msgtl_number : sizeof(uid_t *)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (!OutP->gidsType.msgtl_header.msgt_inline)
	    *gids = *((uid_t **)OutP->gids);
	else if (OutP->gidsType.msgtl_number > *gidsCnt) {
	    mig_allocate((vm_offset_t *)gids,
		4 * OutP->gidsType.msgtl_number);
	    bcopy(*(char **)OutP->gids, (char *)*gids, 4 * OutP->gidsType.msgtl_number);
	}
	else {
	    bcopy((char *) OutP->gids, (char *) *gids, 4 * OutP->gidsType.msgtl_number);
	}

	*gidsCnt = OutP->gidsType.msgtl_number;

	return KERN_SUCCESS;
}
