 /*
  * Khoros: $Id: main_util.c,v 1.3 1992/03/20 22:41:22 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: main_util.c,v 1.3 1992/03/20 22:41:22 dkhoros Exp $";
#endif

 /*
  * $Log: main_util.c,v $
 * Revision 1.3  1992/03/20  22:41:22  dkhoros
 * VirtualPatch5
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xprism3.h"	


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: main_util.c
   >>>>              
   >>>>   description: This file contains utilities for the 
   >>>>			commandline integration.
   >>>>              
   >>>>      routines:
   >>>>			usage
   >>>>			init_xprism3
   >>>>			set_global_outdir
   >>>>			set_global_indir
   >>>>			find_machtype_index
   >>>>              
   >>>> modifications:
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



/**************************************************************
*
* MODULE NAME: usage
*
*     PURPOSE: This module is used for printing out the usage for the
*	       program.
*
*       INPUT: none
*
*      OUTPUT: prints out the usage for the program
*
* CALLED FROM: VGetArgs
*
* MODIFIED: Sept 10, 1990 by John M. Salas
*		- modified to reflect new command line.
*
**************************************************************/

void
usage()
{
  (void) fprintf(stderr, "%s:\n", program);
  (void) fprintf(stderr, "\n");
  (void) fprintf(stderr, "\t3D plotting package\n");

  (void) fprintf(stderr, "\n\t[-fn] Specifies the font for %s\n", program);
  (void) fprintf(stderr, "\n\t[-jr filename.jp] Creates a journal recording of %s", program);
  (void) fprintf(stderr, "\n\t[-jp filename.jp] Executes a journal playback of %s", program);
  (void) fprintf(stderr, "\n\t[-V] Gives the version number for %s\n", program);
  (void) fprintf(stderr, "\t[-U] Gives the usage for %s\n", program);
  (void) fprintf(stderr, "\t[-P] prompts for command line options\n");
  (void) fprintf(stderr, "\t[-a [file1]] use %s.ans or file1 as the option answer file\n", program);
  (void) fprintf(stderr, "\t[-A [file2]] creates the answer file called %s.ans or file\n", program);

  (void) fprintf(stderr,"\n\n\tXprism3 has too many other command line ");
  (void) fprintf(stderr,"arguments to list\n\tthem all here.  When the [-P] ");
  (void) fprintf(stderr,"is used a subset of the all\n\tthe possible command");
  (void) fprintf(stderr,"line inputs are actually requested\n\tfrom the user.\n\n");
  (void) fprintf(stderr,"\tThis subset will prompt for multiple plots, ");
  (void) fprintf(stderr,"either files\n\tor functions, and the plotting ");
  (void) fprintf(stderr,"characteristics for the plots,\n\te.g. line type, ");
  (void) fprintf(stderr,"marker type, begin plotting point, etc.\n\n\tAfter all ");
  (void) fprintf(stderr,"the plots and their characteristics are entered\n\t");
  (void) fprintf(stderr,"the plot window is created and the plots drawn.\n\n");
  (void) fprintf(stderr,"\tFor more information on how to use xprism3 and all ");
  (void) fprintf(stderr,"the possible\n\tcommand line options either look in the");
  (void) fprintf(stderr," file\n\t KHOROS_HOME/doc/xprism/xprism3/help/Start_Up, or ");
  (void) fprintf(stderr,"do a vman xprism3\n");

}

/**************************************************************
*
* MODULE NAME: init_xprism3
*
*     PURPOSE: This module is used to get the command line arguments
*	       needed to run this program.
*
*       INPUT: none
*
*	NOTE: uses the global pointer to the arguments structure.
*
*      OUTPUT: none (Just gets the command line options)
*
* CALLED FROM: main() and run_answer_file()
*
* MODIFIED: Aug 9, 1990 by John M. Salas
*		- Renamed routine from VGetArgs() to init_xprism3()
*               - Restructured code so that all parameters needed to
*		  reconstruct a plot are available to the user on the
*		  command line or in a answer file.  The defaults not
*		  specified by the user are set and are passed in the
*		  structure xprism3_args.
*		- Selected a limited set of parameters that the user
*		  is prompted for when prompting requested.
*		- Modified the routine so that it could be called
*		  from the forms.
*               - Modified the -np option so that an answer file
*                 and extra input files can be specified.
*
**************************************************************/

#include "xprism.h"

init_xprism3(called_by_main, fd, xprism3_args)
xprism3_struct *xprism3_args;
int called_by_main, fd;

{

  xp3_area_info_struct *area_info;
  xp3_plot_info_struct *plot_info;

  char	answer_file[LENGTH],
	default_machine_name[LENGTH],
	*form_filestring,
	key[20],
	prompt[512],
	temp[512],
	temp1[512],
	string[10];

  int	default_value_int,
	default_maximum_int,
  	xdefault_value_int,
	xdefault_maximum_int,
  	ydefault_value_int,
	ydefault_maximum_int,
	error,
	fd_ansr = -1,
	find_machtype_index(),
	have_plot_in_area,
	i,
	file_type,
	need_plot,
	no_plot_specified,
	query,
	plot_area,
	plot_number,
	plotting_file,
	plotting_function,
	prompting = FALSE,
	specified,
	rsrl_specified,
	specified_line_type,
	specified_marker_type,
	specified_color_type,
	value;

  float	dummy, beg, end;

  if ( called_by_main )
  {
    vgparml(fd_ansr, "-V", "noprompt", &query, 0, 0, &error);
    if (error == 0)
    {	/* findout information about this routine */
      fprintf(stderr, "\n%s: Version: %d.%d\n\n", RELEASE_NAME, 
				              RELEASE_MAJOR, RELEASE_MINOR);
      khoros_close();
    }
    vgparml(fd_ansr, "-U", "noprompt", &query, 0, 0, &error);
    if (error == 0)
    {	/* findout information about this routine */
      usage();
      exit(1);
    }

    vgparml(fd_ansr, "-P","noprompt", &query, 0, 0, &error);
    if (error == 0)
    {
      prompting = TRUE;
    }

    vgparms(fd_ansr, "-a","noprompt", answer_file, 0, 0, &error);
    if (error == 0)
    {
      if (VStrlen(answer_file) == 0)
      (void) sprintf(answer_file, "%s.ans", program);
      while (fd_ansr < 0)
      {
        if ((fd_ansr = open(answer_file, O_RDONLY, 0666)) == -1)
        {	/* an error trying to open answer file */
	  (void) fprintf(stderr, 
		         "%s: Can not open answer file \"%s\"\nRe-enter: ",
		         program, answer_file);
	  (void) gets(answer_file);
	  if (VStrlen(answer_file) == 0)
	  {
	    (void) sprintf(answer_file, "%s.ans", program);
	  }
        }
      }
    }
  }
  else /* called by forms */
  {
    fd_ansr = fd;
  }

/*
  Get an alternate user interface description file ...
*/
  specified = vget_infile(fd_ansr, prompting, "-form",
			  "noprompt", &form_filestring);

/*
   ... if form specified expand ...
*/
  if (specified)
  {
    xprism3_args->form_file = vfullpath(form_filestring, NULL, NULL);
    free(form_filestring);
    form_filestring = NULL;
  }
/*
   ... if no form specified use the default form.
*/
  else
  {
    xprism3_args->form_file = VStrcpy(XPRISM3_FORM);
  }

/*
   Set up global defaults.  Starting with the input and output paths ...
*/
  specified = vget_string(fd_ansr, prompting, "-indir", "noprompt",
			  &xprism3_args->indir, INDIR);

  specified = vget_string(fd_ansr, prompting, "-outdir", "noprompt",
			  &xprism3_args->outdir, OUTDIR);

/*
   ... get annotation files ...
*/
  specified = vget_string(fd_ansr, prompting, "-anin", "noprompt", 
			  &xprism3_args->annotation_in_file, NULL);
   
  specified = vget_string(fd_ansr, prompting, "-anout", "noprompt",
			  &xprism3_args->annotation_out_file, NULL);

/*
   ... get output files ...
*/
  specified = vget_string(fd_ansr,prompting, "-expifile", "noprompt",
			  &xprism3_args->explicit_imagefile, NULL);

  specified = vget_string(fd_ansr,prompting, "-impifile", "noprompt",
			  &xprism3_args->implicit_imagefile, NULL);

  specified = vget_string(fd_ansr,prompting, "-cmifile", "noprompt",
			  &xprism3_args->colormap_imagefile, NULL);

  specified = vget_string(fd_ansr,prompting, "-sdumpfile", "noprompt",
			  &xprism3_args->screendump_file, NULL);

  specified = vget_string(fd_ansr,prompting, "-outans", "noprompt",
			  &xprism3_args->output_answer_file, NULL);

/*
   ... postscript output ...
*/
  specified = vget_string(fd_ansr,prompting, "-pslp", "noprompt", 
			  &xprism3_args->postscr_printer, NULL);

  specified = vget_string(fd_ansr,prompting, "-psfile", "noprompt", 
			  &xprism3_args->postscr_file, NULL);

  specified = vget_logic(fd_ansr, prompting, "-psflush", "noprompt",
			 &xprism3_args->postscr_flush, FLUSH_PRINTEROUTPUT);

  specified = vget_logic(fd_ansr, prompting, "-psinvert", "noprompt",
			 &xprism3_args->postscr_invert, INVERT_PRINTEROUTPUT);

  specified = vget_logic(fd_ansr, prompting, "-pslandscape", "noprompt",
                    	 &xprism3_args->postscr_landscape,
			 LANDSCAPE_PRINTEROUTPUT);

  specified = vget_logic(fd_ansr, prompting, "-psmono", "noprompt",
                    	 &xprism3_args->postscr_mono,
			 MONO_PRINTEROUTPUT);

  specified = vget_float(fd_ansr, prompting, "-psw", "noprompt",
			 &xprism3_args->postscr_width, PRINTEROUT_WIDTH,
			 PRINTEROUT_WIDTH_MIN, PRINTEROUT_WIDTH_MAX);

  specified = vget_float(fd_ansr, prompting, "-psh", "noprompt",
			 &xprism3_args->postscr_height, PRINTEROUT_HEIGHT,
			 PRINTEROUT_HEIGHT_MIN, PRINTEROUT_HEIGHT_MAX);

  specified = vget_float(fd_ansr, prompting, "-psx", "noprompt",
			 &xprism3_args->postscr_xoffset, PRINTEROUT_XOFFSET,
			 PRINTEROUT_OFFSET_MIN, PRINTEROUT_OFFSET_MAX);

  specified = vget_float(fd_ansr, prompting, "-psy", "noprompt",
			 &xprism3_args->postscr_yoffset, PRINTEROUT_YOFFSET,
			 PRINTEROUT_OFFSET_MIN, PRINTEROUT_OFFSET_MAX);

  specified = vget_int(fd_ansr, prompting, "-psotype", "noprompt", 
		       &xprism3_args->postscr_output_type, VECTOR_OUTPUT,
		       VECTOR_OUTPUT, RASTER_OUTPUT);

/*
   ... imagen output ...
*/
  specified = vget_string(fd_ansr,prompting, "-imlp", "noprompt", 
			  &xprism3_args->imagen_printer, NULL);

  specified = vget_string(fd_ansr,prompting, "-imfile", "noprompt", 
			  &xprism3_args->imagen_file, NULL);

  specified = vget_logic(fd_ansr, prompting, "-imflush", "noprompt",
			 &xprism3_args->imagen_flush, FLUSH_PRINTEROUTPUT);

  specified = vget_logic(fd_ansr, prompting, "-iminvert", "noprompt",
			 &xprism3_args->imagen_invert, INVERT_PRINTEROUTPUT);

  specified = vget_float(fd_ansr, prompting, "-imw", "noprompt",
			 &xprism3_args->imagen_width, PRINTEROUT_WIDTH,
			 PRINTEROUT_WIDTH_MIN, PRINTEROUT_WIDTH_MAX);

  specified = vget_float(fd_ansr, prompting, "-imh", "noprompt",
			 &(xprism3_args->imagen_height), PRINTEROUT_HEIGHT,
			 PRINTEROUT_HEIGHT_MIN, PRINTEROUT_HEIGHT_MAX);

  specified = vget_float(fd_ansr, prompting, "-imx", "noprompt",
			 &(xprism3_args->imagen_xoffset), PRINTEROUT_XOFFSET,
			 PRINTEROUT_OFFSET_MIN, PRINTEROUT_OFFSET_MAX);

  specified = vget_float(fd_ansr, prompting, "-imy", "noprompt",
			 &(xprism3_args->imagen_yoffset), PRINTEROUT_YOFFSET,
			 PRINTEROUT_OFFSET_MIN, PRINTEROUT_OFFSET_MAX);

  specified = vget_int(fd_ansr, prompting, "-imotype", "noprompt", 
		       &(xprism3_args->imagen_output_type), VECTOR_OUTPUT,
		       VECTOR_OUTPUT, RASTER_OUTPUT);

/*
   ... HPGL output ...
*/
  specified = vget_string(fd_ansr,prompting, "-hpgllp", "noprompt", 
			  &xprism3_args->hpgl_printer, NULL);

  specified = vget_string(fd_ansr,prompting, "-hpglfile", "noprompt", 
			  &xprism3_args->hpgl_file, NULL);

  specified = vget_logic(fd_ansr, prompting, "-hpglflush", "noprompt",
			 &xprism3_args->hpgl_flush, FLUSH_PRINTEROUTPUT);

  specified = vget_logic(fd_ansr, prompting, "-hpgllandscape", "noprompt",
			 &xprism3_args->hpgl_landscape, LANDSCAPE_PRINTEROUTPUT);

  specified = vget_float(fd_ansr, prompting, "-hpglw", "noprompt",
			 &xprism3_args->hpgl_width, PRINTEROUT_WIDTH,
			 PRINTEROUT_WIDTH_MIN, PRINTEROUT_WIDTH_MAX);

  specified = vget_float(fd_ansr, prompting, "-hpglh", "noprompt",
			 &(xprism3_args->hpgl_height), PRINTEROUT_HEIGHT,
			 PRINTEROUT_HEIGHT_MIN, PRINTEROUT_HEIGHT_MAX);

  specified = vget_float(fd_ansr, prompting, "-hpglx", "noprompt",
			 &(xprism3_args->hpgl_xoffset), PRINTEROUT_XOFFSET,
			 PRINTEROUT_OFFSET_MIN, PRINTEROUT_OFFSET_MAX);

  specified = vget_float(fd_ansr, prompting, "-hpgly", "noprompt",
			 &(xprism3_args->hpgl_yoffset), PRINTEROUT_YOFFSET,
			 PRINTEROUT_OFFSET_MIN, PRINTEROUT_OFFSET_MAX);

/*
   ... LN03 output ...
*/
  specified = vget_string(fd_ansr,prompting, "-ln03lp", "noprompt", 
			  &xprism3_args->ln03_printer, NULL);

  specified = vget_string(fd_ansr,prompting, "-ln03file", "noprompt", 
			  &xprism3_args->ln03_file, NULL);

  specified = vget_logic(fd_ansr, prompting, "-ln03invert", "noprompt",
			 &xprism3_args->ln03_invert, INVERT_PRINTEROUTPUT);

/*
   ... set the labeled maximum, minimum, and major interval values ...
*/
  xprism3_args->numerical_relabel_specified_xmin =
	vget_float(fd_ansr, prompting, "-xlmin", "noprompt",
		   &xprism3_args->xlabel_min, -1.0, 0.0, 0.0);

  xprism3_args->numerical_relabel_specified_xmax =
	vget_float(fd_ansr, prompting, "-xlmax", "noprompt",
		   &xprism3_args->xlabel_max,
		   xprism3_args->xlabel_min + 2.0,
		   xprism3_args->xlabel_min, XV_MAXFLOAT);

  xprism3_args->numerical_relabel_specified_xint =
	vget_float(fd_ansr, prompting, "-xlint", "noprompt",
		   &xprism3_args->major_xlabel_int, 0.5, 0.0, 0.0);

  xprism3_args->numerical_relabel_specified_ymin =
	vget_float(fd_ansr, prompting, "-ylmin", "noprompt",
		   &xprism3_args->ylabel_min, -1.0, 0.0, 0.0);

  xprism3_args->numerical_relabel_specified_ymax =
	vget_float(fd_ansr, prompting, "-ylmax", "noprompt",
		   &xprism3_args->ylabel_max, xprism3_args->ylabel_min + 2.0,
		   xprism3_args->ylabel_min, XV_MAXFLOAT);

  xprism3_args->numerical_relabel_specified_yint =
	vget_float(fd_ansr, prompting, "-ylint", "noprompt",
		   &xprism3_args->major_ylabel_int, 0.5, 0.0, 0.0);


  xprism3_args->numerical_relabel_specified_zmin =
	vget_float(fd_ansr, prompting, "-zlmin", "noprompt",
		   &xprism3_args->zlabel_min, -1.0, 0.0, 0.0);

  xprism3_args->numerical_relabel_specified_zmax =
	vget_float(fd_ansr, prompting, "-zlmax", "noprompt",
		   &xprism3_args->zlabel_max, xprism3_args->zlabel_min + 2.0,
		   xprism3_args->zlabel_min, XV_MAXFLOAT);

  xprism3_args->numerical_relabel_specified_zint =
	vget_float(fd_ansr, prompting, "-zlint", "noprompt",
		   &xprism3_args->major_zlabel_int, 0.5, 0.0, 0.0);
/* 
   ... set the actual maximum, minimum, and major interval values ...
*/
  xprism3_args->numerical_scale_specified_xmin =
	vget_float(fd_ansr, prompting, "-xsmin", "noprompt",
		   &xprism3_args->xmin, -1.0, 0.0, 0.0);

  xprism3_args->numerical_scale_specified_xmax =
	vget_float(fd_ansr, prompting, "-xsmax", "noprompt",
		   &xprism3_args->xmax, xprism3_args->xmin + 2.0,
		   xprism3_args->xmin, XV_MAXFLOAT);

  xprism3_args->numerical_scale_specified_xint =
	vget_float(fd_ansr, prompting, "-xsint", "noprompt",
		   &xprism3_args->major_xint, 0.5, 0.0, 0.0);

  xprism3_args->numerical_scale_specified_ymin =
	vget_float(fd_ansr, prompting, "-ysmin", "noprompt",
		   &xprism3_args->ymin, -1.0, 0.0, 0.0);

  xprism3_args->numerical_scale_specified_ymax =
	vget_float(fd_ansr, prompting, "-ysmax", "noprompt",
		   &xprism3_args->ymax, xprism3_args->ymin + 2.0,
		   xprism3_args->ymin, XV_MAXFLOAT);

  xprism3_args->numerical_scale_specified_yint =
	vget_float(fd_ansr, prompting, "-ysint", "noprompt",
		   &xprism3_args->major_yint, 0.5, 0.0, 0.0);

  xprism3_args->numerical_scale_specified_zmin =
	vget_float(fd_ansr, prompting, "-zsmin", "noprompt",
		   &xprism3_args->zmin, -1.0, 0.0, 0.0);

  xprism3_args->numerical_scale_specified_zmax =
	vget_float(fd_ansr, prompting, "-zsmax", "noprompt",
		   &xprism3_args->zmax, xprism3_args->zmin + 2.0,
		   xprism3_args->zmin, XV_MAXFLOAT);

  xprism3_args->numerical_scale_specified_zint =
	vget_float(fd_ansr, prompting, "-zsint", "noprompt",
		   &xprism3_args->major_zint, 0.5, 0.0, 0.0);

/*
   ... set the begin, end, and step size for the data to be plotted ...
*/
  specified = vget_int(fd_ansr, prompting, "-xb", "noprompt",
		       &xprism3_args->xbegin_point, 0, 1, 1);

  specified = vget_int(fd_ansr, prompting, "-xe", "noprompt",
		       &xprism3_args->xend_point, 0,
		       xprism3_args->xbegin_point, XV_MAXLINT);

  if ( xprism3_args->xend_point == 0 )
  {
    default_maximum_int = XV_MAXLINT - xprism3_args->xbegin_point;
  }
  else
  {
    default_maximum_int = xprism3_args->xend_point - xprism3_args->xbegin_point;
  }

  if ( default_maximum_int == 0 )
  {
    default_maximum_int = 1;
  }

  specified = vget_int(fd_ansr, prompting, "-xs", "noprompt",
		       &xprism3_args->xstep_size, 1, 1,
		       default_maximum_int);


  specified = vget_int(fd_ansr, prompting, "-yb", "noprompt",
		       &xprism3_args->ybegin_point, 0, 1, 1);

  specified = vget_int(fd_ansr, prompting, "-ye", "noprompt",
		       &xprism3_args->yend_point, 0,
		       xprism3_args->ybegin_point, XV_MAXLINT);

  if ( xprism3_args->yend_point == 0 )
  {
    default_maximum_int = XV_MAXLINT - xprism3_args->ybegin_point;
  }
  else
  {
    default_maximum_int = xprism3_args->yend_point - xprism3_args->ybegin_point;
  }

  if ( default_maximum_int == 0 )
  {
    default_maximum_int = 1;
  }

  specified = vget_int(fd_ansr, prompting, "-ys", "noprompt",
		       &xprism3_args->ystep_size, 1, 1,
		       default_maximum_int);

/*
   ... set function minimum, maximum, and number of points ...
*/
  specified = vget_string(fd_ansr, prompting, "-fxmin", "noprompt",
			 &xprism3_args->func_xmin, "-1.0");

  specified = vget_string(fd_ansr, prompting, "-fxmax", "noprompt",
			 &xprism3_args->func_xmax, "1.0");

  specified = vget_string(fd_ansr, prompting, "-fxpts", "noprompt",
		       &xprism3_args->func_xptnum, "40");


  specified = vget_string(fd_ansr, prompting, "-fymin", "noprompt",
			 &xprism3_args->func_ymin, "-1.0");

  specified = vget_string(fd_ansr, prompting, "-fymax", "noprompt",
			 &xprism3_args->func_ymax, "1.0");

  specified = vget_string(fd_ansr, prompting, "-fypts", "noprompt",
		       &xprism3_args->func_yptnum, "40");

/*
   ... set information about the data and machine ...
*/
  specified = vget_int(fd_ansr, prompting, "-df", "noprompt",
		       &xprism3_args->data_format, XYZ_TRIPLES-1, MIN_DATA_FORMAT,
		       MAX_DATA_FORMAT);

  specified = vget_int(fd_ansr, prompting, "-dt", "noprompt",
		       &xprism3_args->data_type, MAX_DATA_TYPE, MIN_DATA_TYPE,
		       MAX_DATA_TYPE);

  (void) machtype(default_machine_name);
  default_value_int = find_machtype_index(default_machine_name);
  specified = vget_int(fd_ansr, prompting, "-mach", "noprompt",
		       &xprism3_args->machine_type, default_value_int,
		       0, NUMBER_MACHINES - 1);

  specified = vget_logic(fd_ansr, prompting, "-active", "noprompt",
			 &xprism3_args->active, TRUE);

/*
   ... plot type ...
*/
  specified = vget_int(fd_ansr, prompting, "-pt", "noprompt",
		       &xprism3_args->plot_type, MIN_PLOT_TYPE, MIN_PLOT_TYPE,
		       MAX_PLOT_TYPE);

/*
   ... which data band to plot ...
*/
  specified = vget_int(fd_ansr, prompting, "-band", "noprompt",
		       &xprism3_args->whichband, -1, 0, 0);

/*
   ... if input file is an image and complex 
	then which complex type to use
*/
  specified = vget_int(fd_ansr, prompting, "-cmplx", "noprompt",
		       &xprism3_args->cmplx, 0, 0, 4);


/*
   ... need to know the number of rows for the plot
*/
  specified = vget_int(fd_ansr, prompting, "-rows", "noprompt",
		       &xprism3_args->rows, 1, 2, 2);

/*

   ... marker type ...
*/
  specified_marker_type = vget_int(fd_ansr, prompting, "-mt",
				   "noprompt", &xprism3_args->marker_type,
				   MIN_MARKER_TYPE, MIN_MARKER_TYPE,
				   MAX_MARKER_TYPE);

/*
   ... line type ...
*/
  specified_line_type = vget_int(fd_ansr, prompting, "-lt", "noprompt",
				 &xprism3_args->line_type, MIN_LINE_TYPE,
				 MIN_LINE_TYPE, MAX_LINE_TYPE);

/*
   ... color for plot ...
*/
  specified_color_type = vget_int(fd_ansr, prompting, "-pc", "noprompt",
				  &xprism3_args->plot_color, MIN_COLOR_TYPE,
				  MIN_COLOR_TYPE, MAX_COLOR_TYPE);

/*
   ... default color for axes, grid, labels, etc. ...
*/
  specified = vget_int(fd_ansr, prompting, "-color", "noprompt",
		       &xprism3_args->color, MIN_COLOR_TYPE,
		       MIN_COLOR_TYPE, MAX_COLOR_TYPE);

/*
   ... color for title ...
*/
  specified = vget_int(fd_ansr, prompting, "-tc", "noprompt",
		       &xprism3_args->title_color, xprism3_args->color,
		       MIN_COLOR_TYPE, MAX_COLOR_TYPE);

/*
   ... color for axes label ...
*/
  specified = vget_int(fd_ansr, prompting, "-xalc", "noprompt",
		       &xprism3_args->xaxis_label_color, xprism3_args->color,
		       MIN_COLOR_TYPE, MAX_COLOR_TYPE);

  specified = vget_int(fd_ansr, prompting, "-yalc", "noprompt",
		       &xprism3_args->yaxis_label_color, xprism3_args->color,
		       MIN_COLOR_TYPE, MAX_COLOR_TYPE);

  specified = vget_int(fd_ansr, prompting, "-zalc", "noprompt",
		       &xprism3_args->zaxis_label_color, xprism3_args->color,
		       MIN_COLOR_TYPE, MAX_COLOR_TYPE);

/*
   ... color for axes ...
*/
  specified = vget_int(fd_ansr, prompting, "-xac", "noprompt",
		       &xprism3_args->xaxis_color, xprism3_args->color,
		       MIN_COLOR_TYPE, MAX_COLOR_TYPE);

  specified = vget_int(fd_ansr, prompting, "-yac", "noprompt",
		       &xprism3_args->yaxis_color, xprism3_args->color,
		       MIN_COLOR_TYPE, MAX_COLOR_TYPE);

  specified = vget_int(fd_ansr, prompting, "-zac", "noprompt",
		       &xprism3_args->zaxis_color, xprism3_args->color,
		       MIN_COLOR_TYPE, MAX_COLOR_TYPE);

/*
   ... color for numerical labels for axes ...
*/
  specified = vget_int(fd_ansr, prompting, "-nxac", "noprompt",
		       &xprism3_args->num_xaxis_color,
		       xprism3_args->color,
		       MIN_COLOR_TYPE, MAX_COLOR_TYPE);

  specified = vget_int(fd_ansr, prompting, "-nyac", "noprompt",
		       &xprism3_args->num_yaxis_color,
		       xprism3_args->color,
		       MIN_COLOR_TYPE, MAX_COLOR_TYPE);

  specified = vget_int(fd_ansr, prompting, "-nzac", "noprompt",
		       &xprism3_args->num_zaxis_color,
		       xprism3_args->color,
		       MIN_COLOR_TYPE, MAX_COLOR_TYPE);

/*
   ... color for grid ...
*/
  specified = vget_int(fd_ansr, prompting, "-gc", "noprompt",
		       &xprism3_args->grid_color, xprism3_args->color,
		       MIN_COLOR_TYPE, MAX_COLOR_TYPE);

/*
   ... color for legend ...
*/
  specified = vget_int(fd_ansr, prompting, "-lc", "noprompt",
		       &xprism3_args->legend_color, xprism3_args->color,
		       MIN_COLOR_TYPE, MAX_COLOR_TYPE);

/*
   ... title of plot ...
*/
  specified = vget_string(fd_ansr, prompting, "-title", "noprompt",
			  &xprism3_args->title, "Xprism Plot");

/*
   ... x axis label ...
*/
  specified = vget_string(fd_ansr,prompting, "-xaxis", "noprompt",
			  &xprism3_args->xaxis, "X Axis");

/*
   ... y axis label ...
*/
  specified = vget_string(fd_ansr,prompting, "-yaxis", "noprompt",
			  &xprism3_args->yaxis, "Y Axis");

/*
   ... z axis label ...
*/
  specified = vget_string(fd_ansr,prompting, "-zaxis", "noprompt",
			  &xprism3_args->zaxis, "Z Axis");


/*
   ... fonts ...
*/
  specified = vget_int(fd_ansr, prompting, "-font", "noprompt",
		       &xprism3_args->font, MIN_FONT_TYPE, MIN_FONT_TYPE,
		       MAX_FONT_TYPE);

  specified = vget_int(fd_ansr, prompting, "-xaf", "noprompt", 
		       &xprism3_args->xaxis_font, xprism3_args->font,
		       MIN_FONT_TYPE, MAX_FONT_TYPE);

  specified = vget_int(fd_ansr, prompting, "-yaf", "noprompt", 
		       &xprism3_args->yaxis_font, xprism3_args->font,
		       MIN_FONT_TYPE, MAX_FONT_TYPE);

  specified = vget_int(fd_ansr, prompting, "-zaf", "noprompt", 
		       &xprism3_args->zaxis_font, xprism3_args->font,
		       MIN_FONT_TYPE, MAX_FONT_TYPE);

  specified = vget_int(fd_ansr, prompting, "-numf", "noprompt", 
		       &xprism3_args->numbers_font, xprism3_args->font,
		       MIN_FONT_TYPE, MAX_FONT_TYPE);

  specified = vget_int(fd_ansr, prompting, "-lf", "noprompt", 
		       &xprism3_args->legend_font, xprism3_args->font,
		       MIN_FONT_TYPE, MAX_FONT_TYPE);

  specified = vget_int(fd_ansr, prompting, "-tf", "noprompt", 
		       &xprism3_args->title_font, xprism3_args->font,
		       MIN_FONT_TYPE, MAX_FONT_TYPE);

/*
   ... plot area viewing parameters ...
*/
  specified = vget_logic(fd_ansr, prompting, "-legend", "noprompt", 
			 &xprism3_args->legend, TRUE);

  specified = vget_logic(fd_ansr, prompting, "-box", "noprompt", 
			 &xprism3_args->box, FALSE);

  specified = vget_logic(fd_ansr, prompting, "-numlabels", "noprompt", 
			 &xprism3_args->numerical_labels, TRUE);

  specified = vget_logic(fd_ansr, prompting, "-axes", "noprompt", 
			 &xprism3_args->axes, TRUE);

  specified = vget_logic(fd_ansr, prompting, "-grid", "noprompt", 
			 &xprism3_args->grid, FALSE);

  specified = vget_logic(fd_ansr, prompting, "-autoscale", "noprompt", 
			 &xprism3_args->auto_scale, FALSE);

  specified = vget_logic(fd_ansr, prompting, "-clrls", "noprompt", 
			 &xprism3_args->clear_labels, FALSE);

  rsrl_specified = vget_int(fd_ansr, prompting, "-rsrl", "noprompt", 
		       &xprism3_args->rescale_relabel, RESCALE, RESCALE,
		       RELABEL);

/* set the perspective */

   specified = vget_float(fd_ansr, prompting, "-alpha", "noprompt",
		   &xprism3_args->alpha, 63.7, 0.0, 360.0);

   specified = vget_float(fd_ansr, prompting, "-theta", "noprompt",
		   &xprism3_args->theta, 31.8, 0.0, 360.0);

   specified = vget_float(fd_ansr, prompting, "-eyedist", "noprompt",
		   &xprism3_args->eyedist, 8.0, 0.0, 100.0);

   specified = vget_float(fd_ansr, prompting, "-viewdist", "noprompt",
		   &xprism3_args->viewdist, 16.0, 0.0, 100.0);


/* all axes scale code is commented out until it can be reworked

  specified = vget_int(fd_ansr, prompting, "-xscale", "noprompt", 
		       &xprism3_args->scale.x, LINEAR, LINEAR, LN);

  specified = vget_int(fd_ansr, prompting, "-yscale", "noprompt", 
		       &xprism3_args->scale.y, LINEAR, LINEAR, LN);
 
  specified = vget_int(fd_ansr, prompting, "-zscale", "noprompt", 
		       &xprism3_args->scale.z, LINEAR, LINEAR, LN);
*/

  specified = vget_int(fd_ansr, prompting, "-xtics", "noprompt", 
		       &xprism3_args->x_tics, MIN_TICS, MIN_TICS, MAX_TICS);

  specified = vget_int(fd_ansr, prompting, "-ytics", "noprompt", 
		       &xprism3_args->y_tics, MIN_TICS, MIN_TICS, MAX_TICS);

  specified = vget_int(fd_ansr, prompting, "-ztics", "noprompt", 
		       &xprism3_args->z_tics, MIN_TICS, MIN_TICS, MAX_TICS);

/*
   Code to support multiple plot areas.  When ever the time is right or
   the sun rises in the western sky in a bright purple haze with orange
   fringe and a ;^) on its face.

  number_areas_flg = vget_int(fd_ansr, prompting, "-na",
			      "Number of plot areas - ",
			      &xprism3_args->number_areas, 0, 1, MAX_AREAS);

*/

  xprism3_args->number_areas = 1;
  xprism3_args->plots_specified = FALSE;

  for ( plot_area = 1 ; plot_area <= xprism3_args->number_areas ; plot_area++ )
  {

    area_info =
    xprism3_args->area_info[plot_area - 1] = (xp3_area_info_struct *)
	         calloc((unsigned)1, (unsigned)sizeof(xp3_area_info_struct));

/*
   set the labeled maximum, minimum, and major interval values
*/
    sprintf(key,"-xlmin%d", plot_area);
    area_info->numerical_relabel_specified_xmin =
	vget_float(fd_ansr, prompting, key, "noprompt", &area_info->xlabel_min,
		   xprism3_args->xlabel_min, 0.0, 0.0);

    sprintf(key,"-xlmax%d", plot_area);
    area_info->numerical_relabel_specified_xmax =
	vget_float(fd_ansr, prompting, key, "noprompt", &area_info->xlabel_max,
		   xprism3_args->xlabel_max, area_info->xlabel_min,
		   XV_MAXFLOAT);

    sprintf(key,"-xlint%d", plot_area);
    area_info->numerical_relabel_specified_xint =
	vget_float(fd_ansr, prompting, key, "noprompt",
		   &area_info->major_xlabel_int, xprism3_args->major_xlabel_int,
		   0.0, 0.0);

    sprintf(key,"-ylmin%d", plot_area);
    area_info->numerical_relabel_specified_ymin =
	vget_float(fd_ansr, prompting, key, "noprompt", &area_info->ylabel_min,
		   xprism3_args->ylabel_min, 0.0, 0.0);

    sprintf(key,"-ylmax%d", plot_area);
    area_info->numerical_relabel_specified_ymax =
	vget_float(fd_ansr, prompting, key, "noprompt", &area_info->ylabel_max,
		   xprism3_args->ylabel_max, area_info->ylabel_min,
		   XV_MAXFLOAT);

    sprintf(key,"-ylint%d", plot_area);
    area_info->numerical_relabel_specified_yint =
	vget_float(fd_ansr, prompting, key, "noprompt",
                   &area_info->major_ylabel_int, xprism3_args->major_ylabel_int,
		   0.0, 0.0);

    sprintf(key,"-zlmin%d", plot_area);
    area_info->numerical_relabel_specified_zmin =
	vget_float(fd_ansr, prompting, key, "noprompt", &area_info->zlabel_min,
		   xprism3_args->zlabel_min, 0.0, 0.0);

    sprintf(key,"-zlmax%d", plot_area);
    area_info->numerical_relabel_specified_zmax =
	vget_float(fd_ansr, prompting, key, "noprompt", &area_info->zlabel_max,
		   xprism3_args->zlabel_max, area_info->zlabel_min,
		   XV_MAXFLOAT);

    sprintf(key,"-zlint%d", plot_area);
    area_info->numerical_relabel_specified_zint =
	vget_float(fd_ansr, prompting, key, "noprompt",
                   &area_info->major_zlabel_int, xprism3_args->major_zlabel_int,
		   0.0, 0.0);



    if ( xprism3_args->numerical_relabel_specified_xmin && 
	 ! area_info->numerical_relabel_specified_xmin )
    {
      area_info->numerical_relabel_specified_xmin = TRUE;
    }

    if ( xprism3_args->numerical_relabel_specified_xmax && 
	 ! area_info->numerical_relabel_specified_xmax )
    {
      area_info->numerical_relabel_specified_xmax = TRUE;
    }

    if ( xprism3_args->numerical_relabel_specified_xint && 
	 ! area_info->numerical_relabel_specified_xint )
    {
      area_info->numerical_relabel_specified_xint = TRUE;
    }

    if ( xprism3_args->numerical_relabel_specified_ymin && 
	 ! area_info->numerical_relabel_specified_ymin )
    {
      area_info->numerical_relabel_specified_ymin = TRUE;
    }

    if ( xprism3_args->numerical_relabel_specified_ymax && 
	 ! area_info->numerical_relabel_specified_ymax )
    {
      area_info->numerical_relabel_specified_ymax = TRUE;
    }

    if ( xprism3_args->numerical_relabel_specified_yint && 
	 ! area_info->numerical_relabel_specified_yint )
    {
      area_info->numerical_relabel_specified_yint = TRUE;
    }

    if ( xprism3_args->numerical_relabel_specified_zmin && 
	 ! area_info->numerical_relabel_specified_zmin )
    {
      area_info->numerical_relabel_specified_zmin = TRUE;
    }

    if ( xprism3_args->numerical_relabel_specified_zmax && 
	 ! area_info->numerical_relabel_specified_zmax )
    {
      area_info->numerical_relabel_specified_zmax = TRUE;
    }

    if ( xprism3_args->numerical_relabel_specified_zint && 
	 ! area_info->numerical_relabel_specified_zint )
    {
      area_info->numerical_relabel_specified_zint = TRUE;
    }

/* check to see min, max, and int are specified. Check to see
   if one is specified without all being specified.
*/

    if ( ( area_info->numerical_relabel_specified_xmin |
           area_info->numerical_relabel_specified_xmax |
           area_info->numerical_relabel_specified_xint ) &&
	 ! ( area_info->numerical_relabel_specified_xmin &
	     area_info->numerical_relabel_specified_xmax &
	     area_info->numerical_relabel_specified_xint ) )
    {
     fprintf(stderr,"WARNING: Need to specify minimum, maximum and interval\n");
     fprintf(stderr,"         for changing the labels on the x-axis.\n");
    }

    if ( ( area_info->numerical_relabel_specified_ymin |
           area_info->numerical_relabel_specified_ymax |
           area_info->numerical_relabel_specified_yint ) &&
         ! ( area_info->numerical_relabel_specified_ymin &
             area_info->numerical_relabel_specified_ymax &
             area_info->numerical_relabel_specified_yint ) )
    {
     fprintf(stderr,"WARNING: Need to specify minimum, maximum and interval\n");
     fprintf(stderr,"         for changing the labels on the y-axis.\n");
    }

    if ( ( area_info->numerical_relabel_specified_zmin |
           area_info->numerical_relabel_specified_zmax |
           area_info->numerical_relabel_specified_zint ) &&
         ! ( area_info->numerical_relabel_specified_zmin &
             area_info->numerical_relabel_specified_zmax &
             area_info->numerical_relabel_specified_zint ) )
    {
     fprintf(stderr,"WARNING: Need to specify minimum, maximum and interval\n");
     fprintf(stderr,"         for changing the labels on the z-axis.\n");
    }


/* 
   set the actual maximum, minimum, and major interval values
*/
    sprintf(key,"-xsmin%d", plot_area);
    area_info->numerical_scale_specified_xmin =
	vget_float(fd_ansr, prompting, key, "noprompt", &area_info->xmin,
		   xprism3_args->xmin, 0.0, 0.0);

    sprintf(key,"-xsmax%d", plot_area);
    area_info->numerical_scale_specified_xmax =
	vget_float(fd_ansr, prompting, key, "noprompt", &area_info->xmax,
		   xprism3_args->xmax, area_info->xmin, XV_MAXFLOAT);

    sprintf(key,"-xsint%d", plot_area);
    area_info->numerical_scale_specified_xint =
	vget_float(fd_ansr, prompting, key, "noprompt", &area_info->major_xint,
		   xprism3_args->major_xint, 0.0, 0.0);

    sprintf(key,"-ysmin%d", plot_area);
    area_info->numerical_scale_specified_ymin =
	vget_float(fd_ansr, prompting, key, "noprompt", &area_info->ymin,
		   xprism3_args->ymin, 0.0, 0.0);

    sprintf(key,"-ysmax%d", plot_area);
    area_info->numerical_scale_specified_ymax =
	vget_float(fd_ansr, prompting, key, "noprompt", &area_info->ymax,
		   xprism3_args->ymax, area_info->ymin, XV_MAXFLOAT);

    sprintf(key,"-ysint%d", plot_area);
    area_info->numerical_scale_specified_yint =
	vget_float(fd_ansr, prompting, key, "noprompt", &area_info->major_yint,
		   xprism3_args->major_yint, 0.0, 0.0);

    sprintf(key,"-zsmin%d", plot_area);
    area_info->numerical_scale_specified_zmin =
	vget_float(fd_ansr, prompting, key, "noprompt", &area_info->zmin,
		   xprism3_args->zmin, 0.0, 0.0);

    sprintf(key,"-zsmax%d", plot_area);
    area_info->numerical_scale_specified_zmax =
	vget_float(fd_ansr, prompting, key, "noprompt", &area_info->zmax,
		   xprism3_args->zmax, area_info->zmin, XV_MAXFLOAT);

    sprintf(key,"-zsint%d", plot_area);
    area_info->numerical_scale_specified_zint =
	vget_float(fd_ansr, prompting, key, "noprompt", &area_info->major_zint,
		   xprism3_args->major_zint, 0.0, 0.0);

    if ( xprism3_args->numerical_scale_specified_xmin && 
	 ! area_info->numerical_scale_specified_xmin )
    {
      area_info->numerical_scale_specified_xmin = TRUE;
    }

    if ( xprism3_args->numerical_scale_specified_xmax && 
	 ! area_info->numerical_scale_specified_xmax )
    {
      area_info->numerical_scale_specified_xmax = TRUE;
    }

    if ( xprism3_args->numerical_scale_specified_xint && 
	 ! area_info->numerical_scale_specified_xint )
    {
      area_info->numerical_scale_specified_xint = TRUE;
    }

    if ( xprism3_args->numerical_scale_specified_ymin && 
	 ! area_info->numerical_scale_specified_ymin )
    {
      area_info->numerical_scale_specified_ymin = TRUE;
    }

    if ( xprism3_args->numerical_scale_specified_ymax && 
	 ! area_info->numerical_scale_specified_ymax )
    {
      area_info->numerical_scale_specified_ymax = TRUE;
    }

    if ( xprism3_args->numerical_scale_specified_yint && 
	 ! area_info->numerical_scale_specified_yint )
    {
      area_info->numerical_scale_specified_yint = TRUE;
    }

    if ( xprism3_args->numerical_scale_specified_zmin && 
	 ! area_info->numerical_scale_specified_zmin )
    {
      area_info->numerical_scale_specified_zmin = TRUE;
    }

    if ( xprism3_args->numerical_scale_specified_zmax && 
	 ! area_info->numerical_scale_specified_zmax )
    {
      area_info->numerical_scale_specified_zmax = TRUE;
    }

    if ( xprism3_args->numerical_scale_specified_zint && 
	 ! area_info->numerical_scale_specified_zint )
    {
      area_info->numerical_scale_specified_zint = TRUE;
    }

    if ( ( area_info->numerical_scale_specified_xmin |
           area_info->numerical_scale_specified_xmax |
           area_info->numerical_scale_specified_xint ) && 
	 ! ( area_info->numerical_scale_specified_xmin &
	     area_info->numerical_scale_specified_xmax &
	     area_info->numerical_scale_specified_xint ) )
    {
     fprintf(stderr,"WARNING: Need to specify minimum, maximum and interval\n");
     fprintf(stderr,"         for changing the scale of the x-axis.\n");
    }

    if ( ( area_info->numerical_scale_specified_ymin |
           area_info->numerical_scale_specified_ymax |
           area_info->numerical_scale_specified_yint ) &&
	 ! ( area_info->numerical_scale_specified_ymin &
	     area_info->numerical_scale_specified_ymax &
	     area_info->numerical_scale_specified_yint ) )
    {
     fprintf(stderr,"WARNING: Need to specify minimum, maximum and interval\n");
     fprintf(stderr,"         for changing the scale of the y-axis.\n");
    }

    if ( ( area_info->numerical_scale_specified_zmin |
           area_info->numerical_scale_specified_zmax |
           area_info->numerical_scale_specified_zint ) &&
	 ! ( area_info->numerical_scale_specified_zmin &
	     area_info->numerical_scale_specified_zmax &
	     area_info->numerical_scale_specified_zint ) )
    {
     fprintf(stderr,"WARNING: Need to specify minimum, maximum and interval\n");
     fprintf(stderr,"         for changing the scale of the z-axis.\n");
    }

    sprintf(key,"-fxmin%d", plot_area);
    specified = vget_string(fd_ansr, prompting, key, "noprompt",
			   &area_info->func_xmin, xprism3_args->func_xmin);

    sprintf(key,"-fxmax%d", plot_area);
    specified = vget_string(fd_ansr, prompting, key, "noprompt",
			   &area_info->func_xmax, xprism3_args->func_xmax);

    sprintf(key,"-fxpts%d", plot_area);
    specified = vget_string(fd_ansr, prompting, key, "noprompt",
			 &area_info->func_xptnum, xprism3_args->func_xptnum);

    sprintf(key,"-fymin%d", plot_area);
    specified = vget_string(fd_ansr, prompting, key, "noprompt",
			   &area_info->func_ymin, xprism3_args->func_ymin);

    sprintf(key,"-fymax%d", plot_area);
    specified = vget_string(fd_ansr, prompting, key, "noprompt",
			   &area_info->func_ymax, xprism3_args->func_ymax);

    sprintf(key,"-fypts%d", plot_area);
    specified = vget_string(fd_ansr, prompting, key, "noprompt",
			 &area_info->func_yptnum, xprism3_args->func_yptnum);

    sprintf(key,"-df%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
			 &area_info->data_format,
			 xprism3_args->data_format, MIN_DATA_FORMAT,
			 MAX_DATA_FORMAT);

    sprintf(key,"-dt%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
			 &area_info->data_type,
			 xprism3_args->data_type, MIN_DATA_TYPE,
			 MAX_DATA_TYPE);

    sprintf(key,"-mach%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
			 &area_info->machine_type,
			 xprism3_args->machine_type, 0,
			 NUMBER_MACHINES - 1);

    sprintf(key,"-active%d", plot_area);
    specified = vget_logic(fd_ansr, prompting, key, "noprompt",
			   &area_info->active, xprism3_args->active);

    sprintf(key,"-xb%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
			 &area_info->xbegin_point, xprism3_args->xbegin_point,
			 1, 1);

    if ( xprism3_args->xend_point < area_info->xbegin_point )
    {
      default_value_int = 0;
    }
    else
    {
      default_value_int = xprism3_args->xend_point;
    }
    sprintf(key,"-xe%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
			 &area_info->xend_point, default_value_int,
			 area_info->xbegin_point, XV_MAXLINT);

    if ( area_info->xend_point == 0 )
    {
      default_maximum_int = XV_MAXLINT - area_info->xbegin_point;
    }
    else
    {
      default_maximum_int = xprism3_args->xend_point - area_info->xbegin_point;
    }

    if ( default_maximum_int == 0 )
    {
      default_maximum_int = 1;
    }

    if ( default_maximum_int < xprism3_args->xstep_size )
    {
      default_value_int = 0;
    }
    else
    {
      default_value_int = xprism3_args->xstep_size;
    }

    sprintf(key,"-xs%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
			 &area_info->xstep_size, default_value_int, 1,
			 default_maximum_int);


    sprintf(key,"-yb%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
			 &area_info->ybegin_point, xprism3_args->ybegin_point,
			 1, 1);

    if ( xprism3_args->yend_point < area_info->ybegin_point )
    {
      default_value_int = 0;
    }
    else
    {
      default_value_int = xprism3_args->yend_point;
    }
    sprintf(key,"-ye%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
			 &area_info->yend_point, default_value_int,
			 area_info->ybegin_point, XV_MAXLINT);

    if ( area_info->yend_point == 0 )
    {
      default_maximum_int = XV_MAXLINT - area_info->ybegin_point;
    }
    else
    {
      default_maximum_int = xprism3_args->yend_point - area_info->ybegin_point;
    }

    if ( default_maximum_int == 0 )
    {
      default_maximum_int = 1;
    }

    if ( default_maximum_int < xprism3_args->ystep_size )
    {
      default_value_int = 0;
    }
    else
    {
      default_value_int = xprism3_args->ystep_size;
    }

    sprintf(key,"-ys%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
			 &area_info->ystep_size, default_value_int, 1,
			 default_maximum_int);

/*
  plot type
*/
    sprintf(key,"-pt%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
			 &area_info->plot_type, xprism3_args->plot_type,
			 MIN_PLOT_TYPE, MAX_PLOT_TYPE);

/*
   ... which data band to plot ...
*/
  sprintf(key,"-band%d", plot_area);
  specified = vget_int(fd_ansr, prompting, key, "noprompt",
		       &area_info->whichband, xprism3_args->whichband, 0, 0);

/*
   ... if input file is an image and complex 
	then which complex type to use
*/
  sprintf(key,"-cmplx%d", plot_area);
  specified = vget_int(fd_ansr, prompting, key, "noprompt",
		       &area_info->cmplx, xprism3_args->cmplx, 0, 4);

/*
   ... set the number of rows
*/
  sprintf(key,"-rows%d", plot_area);
  specified = vget_int(fd_ansr, prompting, key, "noprompt",
		       &area_info->rows, xprism3_args->rows, 0, 4);

/*
  marker type
*/
    sprintf(key,"-mt%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
			 &area_info->marker_type, xprism3_args->marker_type,
			 MIN_MARKER_TYPE, MAX_MARKER_TYPE);
    specified_marker_type |= specified;

/*
  line type
*/
    sprintf(key,"-lt%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
			 &area_info->line_type, xprism3_args->line_type,
			 MIN_LINE_TYPE, MAX_LINE_TYPE);
    specified_line_type |= specified;

/*
   color for plot
*/
    sprintf(key,"-pc%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
			 &area_info->plot_color, xprism3_args->plot_color,
			 MIN_COLOR_TYPE, MAX_COLOR_TYPE);
    specified_color_type |= specified;

/*
  color for labels
*/
    sprintf(key,"-color%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
			 &area_info->color, xprism3_args->color,
			 MIN_COLOR_TYPE, MAX_COLOR_TYPE);

/*
   ... color for title ...
*/
    sprintf(key,"-tc%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
			 &area_info->title_color, area_info->color,
			 MIN_COLOR_TYPE, MAX_COLOR_TYPE);

/*
   color for axes label
*/
    sprintf(key,"-xalc%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
			 &area_info->xaxis_label_color,
			 area_info->xaxis_label_color,
			 MIN_COLOR_TYPE, MAX_COLOR_TYPE);

    sprintf(key,"-yalc%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
			 &area_info->yaxis_label_color,
			 area_info->yaxis_label_color,
			 MIN_COLOR_TYPE, MAX_COLOR_TYPE);

    sprintf(key,"-zalc%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
			 &area_info->zaxis_label_color,
			 area_info->zaxis_label_color,
			 MIN_COLOR_TYPE, MAX_COLOR_TYPE);

/*
   color for axes
*/
    sprintf(key,"-xac%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
			 &area_info->xaxis_color, area_info->xaxis_color,
			 MIN_COLOR_TYPE, MAX_COLOR_TYPE);

    sprintf(key,"-yac%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
			 &area_info->yaxis_color, area_info->yaxis_color,
			 MIN_COLOR_TYPE, MAX_COLOR_TYPE);

    sprintf(key,"-zac%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
			 &area_info->zaxis_color, area_info->zaxis_color,
			 MIN_COLOR_TYPE, MAX_COLOR_TYPE);

/*
   ... color for numerical labels for axes ...
*/
    sprintf(key,"-nxac%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
		         &area_info->num_xaxis_color,
		         area_info->color,
		         MIN_COLOR_TYPE, MAX_COLOR_TYPE);

    sprintf(key,"-nyac%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
		         &area_info->num_yaxis_color,
		         area_info->color,
		         MIN_COLOR_TYPE, MAX_COLOR_TYPE);

    sprintf(key,"-nzac%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
		         &area_info->num_zaxis_color,
		         area_info->color,
		         MIN_COLOR_TYPE, MAX_COLOR_TYPE);

/*
   color for grid
*/
    sprintf(key,"-gc%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
			 &area_info->grid_color, area_info->grid_color,
			 MIN_COLOR_TYPE, MAX_COLOR_TYPE);

/*
   ... color for legend ...
*/
    sprintf(key,"-lc%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt",
			 &area_info->legend_color, area_info->color,
			 MIN_COLOR_TYPE, MAX_COLOR_TYPE);

/*
   fonts
*/
    sprintf(key,"-xaf%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt", 
			 &area_info->xaxis_font, xprism3_args->xaxis_font,
			 MIN_FONT_TYPE, MAX_FONT_TYPE);

    sprintf(key,"-yaf%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt", 
			 &area_info->yaxis_font, xprism3_args->yaxis_font,
			 MIN_FONT_TYPE, MAX_FONT_TYPE);

    sprintf(key,"-zaf%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt", 
			 &area_info->zaxis_font, xprism3_args->zaxis_font,
			 MIN_FONT_TYPE, MAX_FONT_TYPE);

    sprintf(key,"-numf%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt", 
			 &area_info->numbers_font, xprism3_args->numbers_font,
			 MIN_FONT_TYPE, MAX_FONT_TYPE);

    sprintf(key,"-lf%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt", 
			 &area_info->legend_font, xprism3_args->legend_font,
			 MIN_FONT_TYPE, MAX_FONT_TYPE);

    sprintf(key,"-tf%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt", 
		         &area_info->title_font, xprism3_args->title_font,
		         MIN_FONT_TYPE, MAX_FONT_TYPE);

/*
   plot area viewing parameters
*/
    sprintf(key,"-legend%d", plot_area);
    specified = vget_logic(fd_ansr, prompting, key, "noprompt", 
			   &area_info->legend, xprism3_args->legend);

    sprintf(key,"-box%d", plot_area);
    specified = vget_logic(fd_ansr, prompting, key, "noprompt", 
			   &area_info->box, xprism3_args->box);

    sprintf(key,"-numlabels%d", plot_area);
    specified = vget_logic(fd_ansr, prompting, key, "noprompt", 
			   &area_info->numerical_labels,
			   xprism3_args->numerical_labels);

    sprintf(key,"-axes%d", plot_area);
    specified = vget_logic(fd_ansr, prompting, key, "noprompt", 
			   &area_info->axes, xprism3_args->axes);

    sprintf(key,"-grid%d", plot_area);
    specified = vget_logic(fd_ansr, prompting, key, "noprompt", 
			   &area_info->grid, xprism3_args->grid);

    sprintf(key,"-autoscale%d", plot_area);
    specified = vget_logic(fd_ansr, prompting, key, "noprompt", 
			   &area_info->auto_scale,
			   xprism3_args->auto_scale);

    sprintf(key,"-clrls%d", plot_area);
    specified = vget_logic(fd_ansr, prompting, key, "noprompt", 
			   &area_info->clear_labels,
			   xprism3_args->clear_labels);

    sprintf(key,"-rsrl%d", plot_area);
    rsrl_specified = vget_int(fd_ansr, prompting, key, "noprompt", 
			 &area_info->rescale_relabel,
			 xprism3_args->rescale_relabel, RESCALE, RELABEL);

/* set the perspective */

   sprintf(key,"-alpha%d", plot_area);
   specified = vget_float(fd_ansr, prompting, key, "noprompt",
		   &area_info->alpha, xprism3_args->alpha, 0.0, 360.0);

   sprintf(key,"-theta%d", plot_area);
   specified = vget_float(fd_ansr, prompting, key, "noprompt",
		   &area_info->theta, xprism3_args->theta, 0.0, 360.0);

   sprintf(key,"-eyedist%d", plot_area);
   specified = vget_float(fd_ansr, prompting, key, "noprompt",
		   &area_info->eyedist, xprism3_args->eyedist, 0.0, 100.0);

   sprintf(key,"-viewdist%d", plot_area);
   specified = vget_float(fd_ansr, prompting, key, "noprompt",
		   &area_info->viewdist, xprism3_args->viewdist, 0.0, 100.0);

/* all axes scale code is commented out until it can be reworked
    sprintf(key,"-xscale%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt", 
			 &area_info->scale.x, xprism3_args->scale.x,
			 LINEAR, LN);

    sprintf(key,"-yscale%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt", 
			 &area_info->scale.y, xprism3_args->scale.y,
			 LINEAR, LN);

    sprintf(key,"-zscale%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt", 
			 &area_info->scale.z, xprism3_args->scale.z,
			 LINEAR, LN);
*/

    sprintf(key,"-xtics%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt", 
			 &area_info->x_tics, xprism3_args->x_tics,
			 MIN_TICS, MAX_TICS);

    sprintf(key,"-ytics%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt", 
			 &area_info->y_tics, xprism3_args->y_tics,
			 MIN_TICS, MAX_TICS);

    sprintf(key,"-ztics%d", plot_area);
    specified = vget_int(fd_ansr, prompting, key, "noprompt", 
			 &area_info->z_tics, xprism3_args->z_tics,
			 MIN_TICS, MAX_TICS);

/*
   title of plot
*/
    sprintf(key,"-title%d", plot_area);
    specified = vget_string(fd_ansr, prompting, key, "noprompt",
			    &area_info->title, xprism3_args->title);

/*
   x axis label
*/
    sprintf(key,"-xaxis%d", plot_area);
    specified = vget_string(fd_ansr,prompting, key, "noprompt",
			    &area_info->xaxis, xprism3_args->xaxis);

/*
   y axis label
*/
    sprintf(key,"-yaxis%d", plot_area);
    specified = vget_string(fd_ansr,prompting, key, "noprompt",
			    &area_info->yaxis, xprism3_args->yaxis);

/*
   z axis label
*/
    sprintf(key,"-zaxis%d", plot_area);
    specified = vget_string(fd_ansr,prompting, key, "noprompt",
			    &area_info->zaxis, xprism3_args->zaxis);


    if (prompting)
    {
      fprintf(stderr, "\n\t----------------------------------------------\n");
      fprintf(stderr, "\tSpecify number of plots in area %d.\n", plot_area);
    }

    sprintf(key, "-np%d", plot_area);
    sprintf(prompt, "Enter: (%s) (int) (0) - ", key);
    specified = vget_int(fd_ansr, prompting, key, prompt,
			 &area_info->number_plots, 0, 0, MAX_PLOTS);

/*
   Since xprism can be called from cantata we need to check for any
   input files and functions on the command line.  This will also allow
   answer files that have files and functions that are not declared in
   sequence, i.e. -i11, -i15, -i16 instead of -i11, -i12, -i13. 
   Also, this allows an answer file and other input files within
   Cantata and on the command line
*/
    if ( area_info->number_plots == 0 && ! prompting)
    {
      area_info->number_plots = MAX_PLOTS;
    }

    have_plot_in_area = FALSE;

    for ( plot_number = 1 ; plot_number <= area_info->number_plots ;
	  plot_number++ )
    {

      plot_info = area_info->plot_info[plot_number - 1] =
		  (xp3_plot_info_struct *)
	          calloc((unsigned)1, (unsigned)sizeof(xp3_plot_info_struct));

      need_plot = FALSE;
      no_plot_specified = FALSE;

/*
   If prompting continue asking for a file or function till one is
   specified.  If not prompting look for the information once.
*/
      do
      {
/*
  Get the input data file ...
*/
	if (prompting)
	{
	  fprintf(stderr, "\n\t------------------------------------------\n");
	  fprintf(stderr, "\tEnter file to be plotted --\n");
	}

	sprintf(key, "-i%d%d", plot_area, plot_number);
	sprintf(prompt, "Enter: (%s) (infile) input file %d - ",
		key, plot_number);
	plotting_file = vget_infile(fd_ansr, prompting, key, prompt,
				    &plot_info->i_file);

/*
  ... if no input file specified get a function ...
*/
	if ( ! plotting_file )
	{
	  if (prompting)
	  {
	  fprintf(stderr, "\n\t-------------------------------------------\n");
	    fprintf(stderr, "\tEnter function to be plotted --\n");
	  }
	  sprintf(key,"-func%d%d", plot_area, plot_number);
	  sprintf(prompt, "Enter: (%s) (string) 3D function %d - ",
		  key, plot_number);
	  specified = vget_string(fd_ansr,prompting, key, prompt,
				  &plot_info->func_str, NULL);

	  if (plot_info->func_str != NULL)
	  {
	    plotting_function = TRUE;
	    file_type = KEYB_FUN;

	    if (prompting)
	    {
	fprintf(stderr, "\n\t----------------------------------------------\n");
	      fprintf(stderr, "\tEnter X & Y minimum, maximum, & number of points\n");
	      fprintf(stderr, "\tfor function --\n");
	    }

	    sprintf(key,"-fxmin%d%d", plot_area, plot_number);
	   sprintf(prompt,"Enter: (%s) (string) (%s) X minimum of function %d - ",
		    key, area_info->func_xmin, plot_number);
	    specified = vget_string(fd_ansr, prompting, key, prompt,
				   &plot_info->func_xmin, area_info->func_xmin);

	    sprintf(key,"-fxmax%d%d", plot_area, plot_number);
	   sprintf(prompt,"Enter: (%s) (string) (%s) X maximum of function %d - ",
		    key, area_info->func_xmax, plot_number);
	    specified = vget_string(fd_ansr, prompting, key, prompt,
				   &plot_info->func_xmax, area_info->func_xmax);

	    sprintf(key,"-fxpts%d%d", plot_area, plot_number);
	  sprintf(prompt,"Enter: (%s) (string) (%s) X # points in function %d - ",
		    key, area_info->func_xptnum, plot_number);
	    specified = vget_string(fd_ansr, prompting, key, prompt,
				 &plot_info->func_xptnum, area_info->func_xptnum);

	    sprintf(key,"-fymin%d%d", plot_area, plot_number);
	   sprintf(prompt,"Enter: (%s) (string) (%s) Y minimum of function %d - ",
		    key, area_info->func_ymin, plot_number);
	    specified = vget_string(fd_ansr, prompting, key, prompt,
				   &plot_info->func_ymin, area_info->func_ymin);

	    sprintf(key,"-fymax%d%d", plot_area, plot_number);
	   sprintf(prompt,"Enter: (%s) (string) (%s) Y maximum of function %d - ",
		    key, area_info->func_ymax, plot_number);
	    specified = vget_string(fd_ansr, prompting, key, prompt,
				   &plot_info->func_ymax, area_info->func_ymax);

	    sprintf(key,"-fypts%d%d", plot_area, plot_number);
	  sprintf(prompt,"Enter: (%s) (string) (%s) Y # points in function %d - ",
		    key, area_info->func_yptnum, plot_number);
	    specified = vget_string(fd_ansr, prompting, key, prompt,
				 &plot_info->func_yptnum, area_info->func_yptnum);
	  }
	  else
	  {
	    if (prompting)
	    {
	  fprintf(stderr,"\n\nNo file or function specified.  Please enter\n");
	      fprintf(stderr,"either a file or function to plot.\n");
	      need_plot = TRUE;
	      plotting_function = FALSE;
	    }
	    else if ( ! prompting )
	    {
free(xprism3_args->area_info[plot_area - 1]->plot_info[plot_number - 1]);
	      xprism3_args->area_info[plot_area - 1]->plot_info[plot_number - 1]
		= NULL;
	      no_plot_specified = TRUE;
	    }
	  }
	}
	else
	{
	  file_type = get_file_type(plot_info->i_file);

	  if ( file_type != XVIFF && file_type != ASCII_FUN )
	  {
	    if (prompting)
	    {
        fprintf(stderr, "\n\t----------------------------------------------\n");
fprintf(stderr, "\tSpecify the number of rows for the data in file %s --\n\n",
		      plot_info->i_file);
	    }

	    sprintf(key,"-rows%d%d", plot_area, plot_number);
	    sprintf(prompt,"Enter: (%s) (int) (%d) - ",
		    key, area_info->rows);
	    specified = vget_int(fd_ansr, prompting, key, prompt,
				 &plot_info->rows, area_info->rows, 2, 2);


	    if (prompting)
	    {
        fprintf(stderr, "\n\t----------------------------------------------\n");
fprintf(stderr, "\tSpecify data and machine information for file %s --\n\n",
		      plot_info->i_file);
	      fprintf(stderr, "\tSpecify DATA FORMATS --\n");
	      fprintf(stderr, "\t1: XYZ Triplets       2: Z only\n");
	    }

	    sprintf(key,"-df%d%d", plot_area, plot_number);
	    sprintf(prompt,"Enter: (%s) (int) (%d: %s) - ",
		    key, area_info->data_format,
		    data_format_names[area_info->data_format - 1]);
	    specified = vget_int(fd_ansr, prompting, key, prompt,
				 &plot_info->data_format,
				 area_info->data_format, MIN_DATA_FORMAT,
				 MAX_DATA_FORMAT);

	    if( file_type != ASCII_DATA )
	    {
	      if (prompting)
	      {
		fprintf(stderr, "\tSpecify DATA TYPE --\n");
		fprintf(stderr, "\t1: Byte           2: Short\n");
		fprintf(stderr, "\t3: Integer        4: Float\n");
	      }
	      sprintf(key,"-dt%d%d", plot_area, plot_number);
	    sprintf(prompt,"Enter: (%s) (int) (%d: %s) - ",
		    key, area_info->data_type,
		    data_type_names[area_info->data_type - 1]);
	      specified = vget_int(fd_ansr, prompting, key, prompt,
				   &plot_info->data_type,
				   area_info->data_type, MIN_DATA_TYPE,
				   MAX_DATA_TYPE);

	      if (prompting)
	      {
		fprintf(stderr, "\tSpecify MACHINE TYPE --\n");
		for ( i = 0 ; i < MAX_MACHINE_TYPE ; i++ )
		{
		  fprintf(stderr, "\t%d: %s\n", i, machine_defs[i].hosttype);
		}
	      }
	      sprintf(key,"-mach%d%d", plot_area, plot_number);
	      sprintf(prompt,"Enter: (%s) (int) (%d: %s) - ",
		      key, area_info->machine_type,
		      machine_defs[i].hosttype);
	      specified = vget_int(fd_ansr, prompting, key, prompt,
				   &plot_info->machine_type,
				   area_info->machine_type, MIN_MACHINE_TYPE,
				   MAX_MACHINE_TYPE);
	    }
	    else
	    {
	      plot_info->data_type = area_info->data_type;
	      plot_info->machine_type = area_info->machine_type;
	    }
	  }
	  else if (file_type == XVIFF)
	  {
	    if (prompting)
	    {
        fprintf(stderr, "\n\t----------------------------------------------\n");
               fprintf(stderr, "\tSpecify the data band to plot if the image is multiband for plot %d\n",
		       plot_number);
            }
    
	    sprintf(key,"-band%d%d", plot_area, plot_number);
	    sprintf(prompt,"Enter: (%s) (int) (%d) - ", key,
		    area_info->whichband);
	    if (area_info->whichband != -1)
		value = area_info->whichband;
	    else
		value = 0;
            specified = vget_int(fd_ansr, prompting, key, prompt,
			         &plot_info->whichband, value,
			         1, 1);

	    if (prompting)
	    {
        fprintf(stderr, "\n\t----------------------------------------------\n");
           fprintf(stderr, "\tSpecify the complex data type to plot if the image is of type Complex for plot %d\n\n",
		   plot_number);
               fprintf(stderr, "\t1: Real         2: Imaginary \n");
               fprintf(stderr, "\t3: Magnitude    4: Phase\n\n");
            }

	    sprintf(key,"-cmplx%d%d", plot_area, plot_number);
	    sprintf(prompt,"Enter: (%s) (float) (%d) - ", key,
		    area_info->cmplx);
	    if (area_info->cmplx != 0)
		value = area_info->cmplx;
	    else
		value = 1;
            specified = vget_int(fd_ansr, prompting, key, prompt,
			        &plot_info->cmplx, value,
			        1, 4);
	  }
	  else
	  {
	    plot_info->data_format = area_info->data_format;
	    plot_info->data_type = area_info->data_type;
	    plot_info->machine_type = area_info->machine_type;
	  }
	}
      } while (need_plot);

/*
   If the answer file specifies that file X in plot area Y should exists, but
   no file or function is given, ignore the plot specifications.
*/
      if ( ! no_plot_specified )
      {
	have_plot_in_area = TRUE;
	if (prompting)
	{
        fprintf(stderr, "\n\t----------------------------------------------\n");
           fprintf(stderr, "\tSpecify X and Y points to plot for plot %d --\n\n",
		   plot_number);
	}

	if ( plotting_file )
	{
	   (void) get_file_points(PLOT_3D, plot_info->i_file,
				  plot_info->data_format, plot_info->data_type, 
				  &xdefault_maximum_int, &ydefault_maximum_int);

	  if ( default_maximum_int == -1 )
	  {
	    xdefault_maximum_int = area_info->xend_point;
	    ydefault_maximum_int = area_info->yend_point;
	  }
	}
	else
	{
	  (void) sprintf(temp,"x = (%s,%s,%s)", plot_info->func_xmin,
                    plot_info->func_xmax, plot_info->func_xptnum);

	  if (! get_range(temp, &beg, &end, &xdefault_maximum_int, temp1))
	  {
	    xdefault_maximum_int = area_info->xend_point;
	  }

	  (void) sprintf(temp,"y = (%s,%s,%s)", plot_info->func_ymin,
                    plot_info->func_ymax, plot_info->func_yptnum);

	  if (! get_range(temp, &beg, &end, &ydefault_maximum_int, temp1))
	  {
	    ydefault_maximum_int = area_info->yend_point;
	  }
	}

	if ( area_info->xbegin_point <= xdefault_maximum_int )
	{
	  xdefault_value_int = area_info->xbegin_point;
	}
	else
	{
	  xdefault_value_int = 0;
	}

	sprintf(key,"-xb%d%d", plot_area, plot_number);
        sprintf(prompt,"Enter: (%s) (int) (%d) X begin data point for plot %d - ",
		    key, default_value_int, plot_number);
	specified = vget_int(fd_ansr, prompting, key, prompt,
			     &plot_info->xbegin_point, xdefault_value_int,
			     0, xdefault_maximum_int);

	if ( area_info->xend_point <= xdefault_maximum_int )
	{
	  xdefault_value_int = area_info->xend_point;
	}
	else
	{
	  xdefault_value_int = 0;
	}

	sprintf(key,"-xe%d%d", plot_area, plot_number);
	sprintf(prompt,"Enter: (%s) (int) (%d) X end data point for plot %d - ",
		    key, default_value_int, plot_number);
	specified = vget_int(fd_ansr, prompting, key, prompt,
			     &plot_info->xend_point, xdefault_value_int,
			     plot_info->xbegin_point, xdefault_maximum_int);

	if ( plot_info->xend_point == 0 && /* plot to last point in file */
	     plotting_file )
	{
	  xdefault_maximum_int = xdefault_maximum_int - plot_info->xbegin_point;
	}
	else if ( plot_info->xend_point == 0 && /* plot to last point in file */
		  plotting_function )
	{
	  default_maximum_int = xdefault_maximum_int -
				  plot_info->xbegin_point;
	}
	else if ( plot_info->xend_point != 0 )
	{
	  xdefault_maximum_int = plot_info->xend_point - plot_info->xbegin_point;
	}

	if ( default_maximum_int < area_info->xstep_size )
	{
	  xdefault_value_int = 1;
	}
	else
	{
	  xdefault_value_int = area_info->xstep_size;
	}

	sprintf(key,"-xs%d%d", plot_area, plot_number);
	sprintf(prompt,"Enter: (%s) (int) (%d) X step size for plot %d - ",
		    key, xdefault_value_int, plot_number);
	specified = vget_int(fd_ansr, prompting, key, prompt,
			     &plot_info->xstep_size, xdefault_value_int,
			     1, xdefault_maximum_int);

/* Take care of Y begin_point, endpoint and step */

	if ( area_info->ybegin_point <= ydefault_maximum_int )
	{
	  ydefault_value_int = area_info->ybegin_point;
	}
	else
	{
	  ydefault_value_int = 0;
	}

	sprintf(key,"-yb%d%d", plot_area, plot_number);
        sprintf(prompt,"Enter: (%s) (int) (%d) Y begin data point for plot %d - ",
		    key, default_value_int, plot_number);
	specified = vget_int(fd_ansr, prompting, key, prompt,
			     &plot_info->ybegin_point, ydefault_value_int,
			     0, ydefault_maximum_int);

	if ( area_info->yend_point <= ydefault_maximum_int )
	{
	  ydefault_value_int = area_info->yend_point;
	}
	else
	{
	  ydefault_value_int = 0;
	}

	sprintf(key,"-ye%d%d", plot_area, plot_number);
	sprintf(prompt,"Enter: (%s) (int) (%d) Y end data point for plot %d - ",
		    key, default_value_int, plot_number);
	specified = vget_int(fd_ansr, prompting, key, prompt,
			     &plot_info->yend_point, ydefault_value_int,
			     plot_info->ybegin_point, ydefault_maximum_int);

	if ( plot_info->yend_point == 0 && /* plot to last point in file */
	     plotting_file )
	{
	  ydefault_maximum_int = ydefault_maximum_int - plot_info->ybegin_point;
	}
	else if ( plot_info->yend_point == 0 && /* plot to last point in file */
		  plotting_function )
	{
	  default_maximum_int = ydefault_maximum_int -
				  plot_info->ybegin_point;
	}
	else if ( plot_info->yend_point != 0 )
	{
	  ydefault_maximum_int = plot_info->yend_point - plot_info->ybegin_point;
	}

	if ( default_maximum_int < area_info->ystep_size )
	{
	  ydefault_value_int = 1;
	}
	else
	{
	  ydefault_value_int = area_info->ystep_size;
	}

	sprintf(key,"-ys%d%d", plot_area, plot_number);
	sprintf(prompt,"Enter: (%s) (int) (%d) Y step size for plot %d - ",
		    key, ydefault_value_int, plot_number);
	specified = vget_int(fd_ansr, prompting, key, prompt,
			     &plot_info->ystep_size, ydefault_value_int,
			     1, ydefault_maximum_int);

	if (prompting)
	{
        fprintf(stderr, "\n\t----------------------------------------------\n");
           fprintf(stderr, "\tSpecify PLOT TYPE for plot %d --\n\n",
		   plot_number);
        fprintf(stderr, "\t0: 3D          1: Mesh          2: Scatter\n");
        fprintf(stderr, "\t3: 3D Contour  4: 2D Contour    5: Impulse\n");
        fprintf(stderr, "\t6: Surface	  7: Horizon       8: Color Mesh\n\n");
        }

	sprintf(key,"-pt%d%d", plot_area, plot_number);
	sprintf(prompt,"Enter: (%s) (float) (%d: %s) - ", key,
		area_info->plot_type, plotnames[area_info->plot_type]);
        specified = vget_int(fd_ansr, prompting, key, prompt,
			     &plot_info->plot_type, area_info->plot_type,
			     MIN_PLOT_TYPE, MAX_PLOT_TYPE);

	if ( plot_info->plot_type == (PLOT_SCATTER + 1))
	{
	  if (prompting)
	  {
	fprintf(stderr, "\n\t----------------------------------------------\n");
	    fprintf(stderr, "\tSpecify INDIVIDUAL MARKER TYPES --\n");
	fprintf(stderr, "\t1:  Square        2: Triangle       3: Cross\n");
	fprintf(stderr, "\t4:  BowTie        5: Arc            6: Diamond\n");
	fprintf(stderr, "\t7:  Circle        8: V              9: Hexagon\n");
	fprintf(stderr, "\t10: X            11: Droplet       12: Caret\n");
	fprintf(stderr, "\t13: Point        14: Dagger        15: Box\n");
	  }

	  sprintf(key,"-mt%d%d", plot_area, plot_number);
	  if (specified_marker_type)
	  {
	    default_value_int = area_info->marker_type;
	  }
	  else
	  {
	    default_value_int = (plot_number - 1) % MAX_MARKER_TYPE + 1;
	  }
	  sprintf(prompt,"Enter: (%s) (float) (%d: %s) - ", key,
		  default_value_int, markernames[default_value_int - 1]);
          specified = vget_int(fd_ansr, prompting, key, prompt,
			       &plot_info->marker_type, default_value_int,
			       MIN_MARKER_TYPE, MAX_MARKER_TYPE);
/*
   Set up default line type even though it is not used initially.
*/
	  if (specified_line_type)
	  {
	    plot_info->line_type = area_info->line_type;
	  }
	  else
	  {
	    plot_info->line_type = (plot_number - 1) % MAX_LINE_TYPE + 1;
	  }
	}
	else
	{
	  if (prompting)
	  {
	fprintf(stderr, "\n\t----------------------------------------------\n");
	    fprintf(stderr, "\tTo specify the DEFAULT LINE TYPE --\n\n");
	fprintf(stderr, "\t1: Solid          2: Dotted\n");
	fprintf(stderr, "\t3: Dot Dashed:    4: Short Dashed\n");
	fprintf(stderr, "\t5: Long Dashed:   6: Odd Dashed\n");
	  }

	  sprintf(key,"-lt%d%d", plot_area, plot_number);
	  if (specified_line_type)
	  {
	    default_value_int = area_info->line_type;
	  }
	  else
	  {
	    default_value_int = (plot_number - 1) % MAX_LINE_TYPE + 1;
	  }
	  sprintf(prompt,"Enter: (%s) (float) (%d: %s) - ", key,
		  default_value_int, linenames[default_value_int - 1]);
	  specified = vget_int(fd_ansr, prompting, key, prompt,
			       &plot_info->line_type, default_value_int,
			       MIN_LINE_TYPE, MAX_LINE_TYPE);
/*
   Set up default marker type even though it is not used initially.
*/
	  if (specified_marker_type)
	  {
	    plot_info->marker_type = area_info->marker_type;
	  }
	  else
	  {
	    plot_info->marker_type = (plot_number - 1) % MAX_MARKER_TYPE + 1;
	  }
	}

	if (prompting)
	{
	fprintf(stderr, "\n\t----------------------------------------------\n");
	fprintf(stderr, "\tTo specify COLORS FOR INDIVIDUAL PLOTS --\n\n");
	fprintf(stderr, "\t 0: White   1: Green      2: Yellow  3: Cyan\n");
	fprintf(stderr, "\t 4: Orchid  5: Magenta    6: Orange  7: Wheat\n");
       fprintf(stderr, "\t 8: Lime    9: Turquoise 10: Pink   11: LightGrey\n");
	fprintf(stderr, "\t12: Plum   13: Forest    14: Salmon 15: Thistle\n");
	fprintf(stderr, "\t16: Violet 17: OrangeRed 18: Red    19: SeaGreen\n");
	fprintf(stderr, "\t20: Blue   21: Goldenrod 22: Coral  23: Sienna\n\n");
	}

	sprintf(key,"-pc%d%d", plot_area, plot_number);
	if (specified_color_type)
	{
	  default_value_int = area_info->plot_color;
	}
	else
	{
	  default_value_int = (plot_number) % MAX_COLOR_TYPE;
	}
	sprintf(prompt,"Enter: (%s) (float) (%d: %s) - ", key,
		 default_value_int, colornames[default_value_int]);
	specified = vget_int(fd_ansr, prompting, key, prompt,
			     &plot_info->plot_color, default_value_int,
			     MIN_COLOR_TYPE, MAX_COLOR_TYPE);

	sprintf(key,"-active%d%d", plot_area, plot_number);
	specified = vget_logic(fd_ansr, prompting, key, "noprompt", 
			       &plot_info->active, area_info->active);

	sprintf(key,"-legendstr%d%d", plot_area, plot_number);
	sprintf(string," Plot %d ", plot_number);
	specified = vget_string(fd_ansr, prompting, key, "noprompt",
			        &plot_info->legend_str, string);
      }
    } /* Finished aquiring plot info */

    if ( have_plot_in_area )
    {
      xprism3_args->plots_specified = TRUE;
    }
  } /* Finished aquiring plot area info */

  if ( fd_ansr != -1 && called_by_main )
  {
     close_afile(fd_ansr);
  }
}

/***********************************************************************
*
*  Routine Name: find_machtype_index
*
*          Date: Aug 9, 1990
*        
*       Purpose: This routine returns the index into the machine_names[]
*		   array that matches the default_machine_name passed in.
*
*         Input: char *default_machine_name;
*
*        Output: 
*
*    Written By:  John Salas
*
* Modifications:
*
***********************************************************************/

int
find_machtype_index(default_machine_name)
char *default_machine_name;

{
  int i;

  for ( i = 0 ; i < NUMBER_MACHINES ; i++ )
  {
    if ( ! strcmp(default_machine_name, machine_defs[i].hosttype) )
    {
      return (i);
    }
  }
  return(NUMBER_MACHINES - 1);
}

/***********************************************************************
*
*  Routine Name: set_global_indir
*
*          Date: Aug 9, 1990
*        
*       Purpose: This routine sets the global output path or
*               directory.
*
*         Input: char *indir
*
*        Output: 
*
*    Written By:  John Salas
*
* Modifications:
*
***********************************************************************/
int
set_global_indir(indir)
char *indir;

{
    if (indir == NULL)
    {
	return(1);
    }

    global_indir = xvf_strcpy(indir);

    XVF_FILE_DIR = xvf_strcpy(global_indir);

    return(0);
}

/***********************************************************************
*
*  Routine Name: set_global_outdir
*
*          Date: Aug 9, 1990
*        
*       Purpose: This routine sets the global output path or
*               directory.
*
*         Input: 
*
*        Output: 
*
*    Written By:  John Salas
*
* Modifications:
*
***********************************************************************/

int
set_global_outdir(outdir)
char *outdir;

{
    if (outdir == NULL)
    {
	return(1);
    }

    global_outdir = xvf_strcpy(outdir);

    return(0);
}
