 /*
  * Khoros: $Id: writer.h,v 1.2 1991/10/02 00:12:41 khoros Exp $
  */

 /*
  * $Log: writer.h,v $
 * Revision 1.2  1991/10/02  00:12:41  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: writer.h
 >>>>            Author: 
 >>>> Date Last Updated: Wed Sep 11 11:08:34 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _writer_h_
#define _writer_h_

#include "xvinclude.h"


/* -include_includes */
#include        "ghost.h"
#include        "xvforms.h"
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    writer Argument Structure
*
****************************************************************/

typedef struct _writer  {

/*
 *  name of program to be generated (Required string)
 */
char	*name;       	/* name of program to be generated STRING */
int	 name_flag;   	/* name of program to be generated FLAG */

/*
 *  use configuration file? (Optional logical)
 */
int	 config;      	/* use configuration file? LOGIC */
int	 config_flag;  	/* use configuration file? FLAG */

/*
 *  generate lib file? (Optional logical)
 */
int	 lib;      	/* generate lib file? LOGIC */
int	 lib_flag;  	/* generate lib file? FLAG */

/*
 *  generate man3 file? (Optional logical)
 */
int	 man3;      	/* generate man3 file? LOGIC */
int	 man3_flag;  	/* generate man3 file? FLAG */

/*
 *  install output? (Optional logical)
 */
int	 install;      	/* install output? LOGIC */
int	 install_flag;  	/* install output? FLAG */

/*
 *  formatting (0 = none, 1 = nroff) (Optional integer)
 */
int	 format;    	/* formatting (0 = none, 1 = nroff) INT */
int	 format_flag;	/* formatting (0 = none, 1 = nroff) FLAG */

/*
 *  generate debug statements in main? (Optional logical)
 */
int	 debug;      	/* generate debug statements in main? LOGIC */
int	 debug_flag;  	/* generate debug statements in main? FLAG */

/*
 *  append tags on variable names? (Optional logical)
 */
int	 tag;      	/* append tags on variable names? LOGIC */
int	 tag_flag;  	/* append tags on variable names? FLAG */

/*
 *  force output? (Optional logical)
 */
int	 force;      	/* force output? LOGIC */
int	 force_flag;  	/* force output? FLAG */

/*
 *  alternate copyright file (*.prog style) (Optional string)
 */
char	*cp;       	/* alternate copyright file (*.prog style) STRING */
int	 cp_flag;   	/* alternate copyright file (*.prog style) FLAG */

/*
 *  toolbox name (Optional string)
 */
char	*toolbox;       	/* toolbox name STRING */
int	 toolbox_flag;   	/* toolbox name FLAG */

/*
 * type of program (Optional string toggle - )
 */
char	*type;  		/* type of program STRING TOGGLE */
int	 type_flag;		/* type of program FLAG */

}  writer_struct;

writer_struct *writer;

/* -include_additions */

int gw_req_args[MaxCmdArgs], /* array of indices of required argument lines */
    gw_opt_args[MaxCmdArgs]; /* array of indices of optional argument lines */

int gw_num_req,     /*  # required arguments (size of gw_req_args[])    */
    gw_num_opt,     /*  # optional arguments (size of gw_opt_args[])    */
    gw_num_me_req,  /*  # of required mutually exclusive groups         */
    gw_num_me_opt,  /*  # of optional mutually exclusive groups         */
    gw_num_tog_req, /*  # of required toggle groups                     */
    gw_num_tog_opt; /*  # of optional toggle groups                     */

int arg_total;      /* total # arguments */

/* array of linked lists of mutually exclusive groups: note mut_excl_link
   is defined in xvforms.h */
mut_excl_link *gw_mut_excl[MaxMEGroups];
int            gw_mut_excl_num;  /* number of mutually exclusive groups */


/* array of toggle structures */
typedef struct _toggle_struct {
        int    type;    /* type of toggle : Int, Float, String, Logical */
        int    req;     /* boolean true if toggle val required, false if not */
        int    def;        /* index into correct type array of default */
        int    elem_num;   /* number of selections in Toggle */
        char  *desc;       /* description of toggle */
        char  *variable;   /* string name of toggle variable */
        int   *intvals;    /* array of int vals if type = IntegerOpt*/        
        float *floatvals;  /* array of float vals if type = FloatOpt*/
        char **stringvals; /* array of string vals if type = StringOpt*/
        char **elemdesc;   /* array of descriptions for toggle items */
        int   *logicvals;  /* array of string vals for type = StringOpt*/
        } gw_toggle_struct;

gw_toggle_struct *gw_toggle[MaxToggles];
int                gw_toggle_num;

/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
