 /*
  * Khoros: $Id: lwriter.c,v 1.4 1992/03/20 22:45:08 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lwriter.c,v 1.4 1992/03/20 22:45:08 dkhoros Exp $";
#endif

 /*
  * $Log: lwriter.c,v $
 * Revision 1.4  1992/03/20  22:45:08  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lwriter.c
 >>>>
 >>>>      Program Name: writer
 >>>>
 >>>> Date Last Updated: Wed Sep 11 11:08:39 1991 
 >>>>
 >>>>          Routines: lwriter - the library call for writer
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "xvinclude.h"


/* -library_includes */
#include "writer.h"
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lwriter - library call for writer
*
* Purpose:
*
* Input:
* Output:
* Written By:
*
****************************************************************/


/* -library_def */
int lwriter()
/* -library_def_end */

/* -library_code */
{
    Line_Info line_info;
    int  i, line_num, db_size;
    char **database, **prog_spec, **keynames[2]; 
    char *fullpath, temp[MaxLength], *path;
    FILE *db_file, *ps_file, *config_file;
    char *config_keys[ConfigKeyNum], *config_paths[ConfigKeyNum];
    char *edit_blanks();
    char *name, *global_src_dir; 

    name = edit_blanks(writer->name);

    if (xvf_strlen(name) > MaxProgName)
    {
       fprintf(stderr, "ghostwriter:\n");
       fprintf(stderr, "program name provided must be a maximum\n");
       fprintf(stderr, "of 9 characters long, so that files generated\n");
       fprintf(stderr, "will meet the 14 character length maximum.\n");
       return(false);
    }

    /* 
     *  initialize key names for ghostwriter 
     */
    gw_init_keynames(keynames);

    /*
     *  initialize key names for config file
     */

    /*
     *   Read configuration file info into path strings for later use.
     */
    sprintf(temp, "%s.conf", name);
    gw_init_config_keys(config_keys);

    if (writer->config)
    {
        if (!(gr_read_configfile(temp, config_keys,
                              ConfigKeyNum, config_paths)))
                  return(false);
        if (!(gw_check_config_paths(1, config_paths, 
                                    writer->lib, writer->man3)))
           return(false);

    }
    else
    {
        for (i = 0; i < ConfigKeyNum; i++)
           config_paths[i] = xvf_strcpy("./");
    }

    if (config_paths[TOPSRC] == NULL) 
       global_src_dir = NULL;
    else if (strcmp(config_paths[TOPSRC] , "./") == 0)
       global_src_dir = NULL;
    else
       global_src_dir = xvf_strcpy(config_paths[TOPSRC]);


    /*
     *   Look to see if the conf file is present.  If not, create a template.
     */
    sprintf(temp, "%s.conf", name);
    fullpath = vfullpath(temp, NULL, NULL);
    if (!(fopen(fullpath, "r")))
    {
        if (config_file = fopen(fullpath, "w"))
        {
            for(i = 0; i < ConfigKeyNum; i++) 
                fprintf(config_file, "%s: %s\n", 
                        config_keys[i], config_paths[i]);
            fprintf(stderr, "\nGenerating a TEMPLATE '%s.conf'\n", 
                        name);
        }
        else 
        {
            fprintf(stderr, "ghostwriter:\n");
            fprintf(stderr, "Unable to open '%s' to write *.conf file", 
                        fullpath);
            return(false);
        }
    }
    
   /*
    *   Get information for code generation from .pane file.
    *   Read user interface description into internal database
    *   structure for use.
    */

    sprintf(temp, "%s.pane", name);
    fullpath = vfullpath(temp, config_paths[PANEPATH], NULL);
    if (!(db_file = fopen(fullpath, "r")))
    {
           fprintf(stderr, "ghostwriter:\n");
           fprintf(stderr, "Unable to open '%s' to read .pane file", fullpath);
           return(false);
    }

    database = xvf_read_database(db_file, &line_num, &db_size);
    if (database == NULL)
    {
       fclose(db_file);
       return(false);
    }

    xvf_clear_line_info(&line_info);
    if (!(xvf_parse_startform_line(database[0], &line_info)))
       return(false);

    if (!(gw_get_pane_info(database)))
           return(false);

    /*
     *   Look to see if the prog file is present.  If not, create a template.
     *   If so, read program specification description into internal prog_spec
     *   structure for use.
     */
     if (strcmp(config_paths[PROGPATH], "./") != 0)
         sprintf(temp, "%s/%s.prog", config_paths[PROGPATH], name);
     else
         sprintf(temp, "%s.prog", name);
     fullpath = vfullpath(temp, global_src_dir, NULL);
     if (fullpath == NULL)
     {
        fprintf(stderr, "ghostwriter:\n");
        fprintf(stderr, "Couldn't expand path %s/%s", 
                        config_paths[TOPSRC],config_paths[PROGPATH]);
     }

     if (!(ps_file = fopen(fullpath, "r")))
     {
         prog_spec = (caddr_t *) calloc(1,sizeof(char *)*MaxProgSpecSize);
         for (i = 0; i < MaxProgSpecSize; i++)
            prog_spec[i] = NULL;

         writer->force = false;
         writer->install=false;

         sprintf(temp, "./%s.prog", name);
         if (gr_write_progfile(temp, prog_spec, keynames, writer->force))
         fprintf(stderr, "Generating a TEMPLATE '%s.prog'\n", name);
         fprintf(stderr,"ALL of the Following Files Will Be TEMPLATES Also.\n\n");
     }
     else
     {
        prog_spec = gw_read_progfile(ps_file, keynames);
        if (prog_spec == NULL)
        {
           fclose(ps_file);
           return(false);
        }
     }

    /*
     *  generate man1 file
     */
     if (writer->install) 
        path = xvf_strcpy(config_paths[MAN1PATH]);
     else 
        path = xvf_strcpy("./");
     gw_generate_man1file(database, prog_spec, name, path, writer->type);

    /*
     *  generate *.h file
     */
     if (writer->install) 
     {
        if (strcmp(config_paths[HPATH], "./") != 0)
           sprintf(temp, "%s/%s.h", config_paths[HPATH], name);
        else
           sprintf(temp, "%s.h", name);
        path = vfullpath(temp, global_src_dir, NULL);
     }
     else 
     {
        sprintf(temp, "./%s.h", name);
        path = xvf_strcpy(temp);
     }
     gw_generate_hfile(database, prog_spec, name, path, writer->type);

    /*
     *  generate *.c file
     */
     if (writer->install) 
     {
        if (strcmp(config_paths[CPATH], "./") != 0)
           /* sprintf(temp, "%s/%s.c", config_paths[HPATH], name); John
	      was here on March 13, 1992*/
           sprintf(temp, "%s/%s.c", config_paths[CPATH], name);
        else 
           sprintf(temp, "%s.c", name);
        path = vfullpath(temp, global_src_dir, NULL);
     }
     else
     {
        sprintf(temp, "./%s.c", name);
        path = xvf_strcpy(temp);
     }
     gw_generate_cfile(database, prog_spec, name, path, writer->type);

    /*
     *  generate l*.c file
     */
     if (writer->lib) 
     {
        if (writer->install) 
        {
            if (strcmp(config_paths[LPATH], "./") != 0)
               sprintf(temp, "%s/l%s.c", config_paths[LPATH], name);
            else 
               sprintf(temp, "l%s.c", name);
            path = vfullpath(temp, global_src_dir, NULL);
        }
        else
        {
           sprintf(temp, "./l%s.c", name);
           path = xvf_strcpy(temp);
        }
        gw_generate_lfile(database, prog_spec, name, path, writer->type);
     }

    /*
     *  generate man3 file
     */
     if (writer->man3)
     {
        if (writer->install) 
           path = xvf_strcpy(config_paths[MAN3PATH]);
        else 
           path = xvf_strcpy("./");
        gw_generate_man3file(database, prog_spec, name, path, writer->type);
     }

    /*
     *  generate Imakefile and Makefile in same directory as *.c file
     */
     if (writer->install) 
        path = xvf_strcpy(config_paths[CPATH]);
     else 
        path = xvf_strcpy("./");
     gw_generate_makefile(name, path, writer->type, writer->toolbox);

     return(true);
}


/****************************************************************
*
* Routine Name: gw_generate_makefile
*
*      Purpose:  generates Imakefile and Makefile
*
*        Input:  name
*    
*       Output:  none
*    
*   Written By: Danielle Argiro
*
****************************************************************/

gw_generate_makefile(name, path, type, project)
char *name;
char *path;
char *type;
char *project;
{
    char buff[MaxLength], savedir[MaxLength];
    char *fullpath, *newdir, *cptr, *toolbox, *status, *vtoolbox_path();
    FILE *tmpfile;
    
    
    /*
     *  see if Imakefile file already exists; if so, don't need
     *  the flags on the imkmf command that we will system off
     */
     fullpath = vfullpath("Imakefile", path, NULL);
     if (tmpfile = fopen(fullpath, "r"))
     {
         fclose(tmpfile);
     }
     else
     {
         if (project != NULL)
         {
           cptr = project;
           while (*cptr)
           {
             *cptr = toupper(*cptr);
             cptr++;
           }
           toolbox = VStrcpy(project);
           status = vtoolbox_path(toolbox);
           if (status == NULL)
           {
               fprintf(stderr, "ghostwriter:\n");
               fprintf(stderr, "Toolbox name '%s' is not a valid toolbox.\n", 
                       project);
               fprintf(stderr, "Please check the name of the toolbox and \n");
               fprintf(stderr, "run imkmf on your own\n");
               free(toolbox);
               return;
           }
           sprintf(buff, "imkmf -type %s -name %s -toolbox %s", 
                   type, name, project);
           free(toolbox);

         }
         else
            sprintf(buff, "imkmf -type %s -name %s", type, name);

         /*
          *  save current directory; go to specified directory 
          *  before system'ing imkmf commands, then return.
          */
         (void) getwd(savedir);

         newdir = vfullpath(path, NULL, NULL);
         chdir(newdir);

         system(buff);

         sprintf(buff, "makemake");
         system(buff);
        
         chdir(savedir);
     }
}

char *edit_blanks(string)
char *string;
{
     int  i, j, string_length;     
     char buffer[MaxLength];

     string_length = xvf_strlen(string);

     j = 0;

     for (i = 0; i < string_length; i++)
     {
        if (string[i] != ' ' && string[i] != '\t' && string[i] != '\n') 
        {
            buffer[j] = string[i]; j++;
        }
     }
     buffer[i] = '\0';
     return(xvf_strcpy(buffer));
}
/* -library_code_end */
