 /*
  * Khoros: $Id: init.c,v 1.2 1991/10/02 00:20:15 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: init.c,v 1.2 1991/10/02 00:20:15 khoros Exp $";
#endif

 /*
  * $Log: init.c,v $
 * Revision 1.2  1991/10/02  00:20:15  khoros
 * HellPatch2
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 *            Copyright 1990 University of New Mexico
 *
 *  Permission to use, copy, modify, distribute, and sell this
 *  software and its documentation for any purpose is hereby
 *  granted without fee, provided that the above copyright
 *  notice appear in all copies and that both that copyright
 *  notice and this permission notice appear in supporting docu-
 *  mentation, and that the name of UNM not be used in advertis-
 *  ing or publicity pertaining to distribution of the software
 *  without specific, written prior permission.  UNM makes no
 *  representations about the suitability of this software for
 *  any purpose.  It is provided "as is" without express or
 *  implied warranty.
 *
 *  UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 *  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 *  NESS, IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 *  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 *  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 *  ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 *  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 *  OF THIS SOFTWARE.
 *
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"
#include "warpimage.h"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>			Initialization Routines               <<<<
   >>>>                                                       <<<<
   >>>>			xvw_init()		      	      <<<<
   >>>>			xvw_create_gcs()		      <<<<
   >>>>			xvw_set_colors()		      <<<<
   >>>>                                                       <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */


/************************************************************
*
*  MODULE NAME: xvw_init()	
*
*      PURPOSE: initializes the src_image and dest_image DisplayStructures,
*	        the src_zoom and dest_zoom ZoomStructures, creates the
*		displays for the image, the zoom box, and the position
*		widgets. sets colors, creates gc's, initializes the 
*		rootwindow, the workspace, and the xvdisplay library.
*
*        INPUT: src  - the viff image input as the source [-src]
*		dest - the viff image input as the destination [-dest]
*       OUTPUT: none
*
*   WRITTEN BY: Danielle Argiro & Tom Sauer
*
************************************************************/

xvw_init(src, dest, tp_mode)
struct xvimage *src, *dest;
int  tp_mode;
{
	Widget horiz_offset;

	xvd_initialize(display);
        xvw_set_colors();
        xvw_create_gcs();
        rootwindow = XDefaultRootWindow(display);
	rubberbanding = False;
	point_and_clicking = False;
	tiepoint_mode = tp_mode;
	tiepoint_started = False;

	/*
	 *  initialize the src_image xvdisplay structure and zoom display
	 */

        map_display = xvd_init_image(display, NULL, NULL, NULL, NULL,
                                   True, True, False, NULL);


	/* create raster widget for source image to be displayed */
	src_image = xvd_init_image(display, src, NULL, NULL, NULL,
                                   False, True, False, map_display->colormap);
	xvw_create_display(display, workspace, src_image, NULL, NULL);

	/* create zoom box for zooming in source image */
	src_zoom = (ZoomStructure *) XtMalloc(sizeof(ZoomStructure));
	src_zoom->id = SrcZoom;
	xvw_create_zoom_display(workspace, src_image, src_zoom, 
				NULL, src_image->raster);

	/* create position box */
	xvw_create_position_widget(display, workspace, src_image, src_zoom,
			           NULL, src_zoom->raster);

	/* set colormaps */
	xvd_set_colormap(src_image->raster, map_display->colormap);
	xvd_set_colormap(src_zoom->raster, map_display->colormap);

	/*
	 *  initialize the dest_image xvdisplay structure and zoom display
	 */

	if (tp_mode == SourceAndDest)
	{

	    /* create raster widget for destination image to be displayed */
	    dest_image = xvd_init_image(display, dest, NULL, NULL, NULL,
                                      False, True, False, map_display->colormap);

	    if (src_image->image != NULL)
	    {
	       if (src_image->image->row_size > ZoomDisplayWidth)
	    	    horiz_offset = src_image->raster;
	       else
	    	    horiz_offset = src_zoom->raster;
	    }
	    else horiz_offset = src_image->raster;

	    xvw_create_display(display, workspace, 
	    		      dest_image, horiz_offset, NULL);

	    /* create zoom box for zooming in destination image */
	    dest_zoom = (ZoomStructure *) XtMalloc(sizeof(ZoomStructure));
	    dest_zoom->id = DestZoom;
	    xvw_create_zoom_display(workspace, dest_image, dest_zoom, 
				    horiz_offset, dest_image->raster);

	    xvw_create_position_widget(display,workspace, dest_image, dest_zoom,
				    horiz_offset, dest_zoom->raster); 

	    /* set colormaps */
	    xvd_set_colormap(dest_image->raster, map_display->colormap);
	    xvd_set_colormap(dest_zoom->raster, map_display->colormap);
	}

	tiepoints = NULL;
	view_toplevel = NULL;
	viewback = NULL;
	tiept_label_offset = NULL;

	if (src != NULL)
	  copyheader(src, &source_image_header);

        /*
         *  Initialize the action table for modifying tiepoints 
	 *  using the ViewTiepoints widget.
         */
        XtAppAddActions(xvf_app_context, livetiepts_actionTable,
                XtNumber(livetiepts_actionTable));
	live_tiepts_trans  = XtParseTranslationTable(live_tiepts_trans_table);

}


/************************************************************
*
*  MODULE NAME: xvw_create_gcs()	
*
*      PURPOSE: creates various Graphics Context structures for
*		later use with warpimge
*
*        INPUT: none
*       OUTPUT: none
*
*   WRITTEN BY: Danielle Argiro & Tom Sauer
*
************************************************************/

xvw_create_gcs()
{
	unsigned long mask;
	XGCValues values;
	Window     rootwindow = XDefaultRootWindow(display);
	
	mask = GCLineWidth | GCFunction | GCForeground;
        values.line_width = 0;
        values.function = GXcopy;
        values.foreground = grey;
        gc = XCreateGC(display, rootwindow, mask, &values);

	mask = GCLineWidth | GCFunction | GCForeground | GCBackground;
        values.line_width = 0;
        values.function = GXcopy;
        values.foreground = white;
        values.background = black;
        gc_zoom = XCreateGC(display, rootwindow, mask, &values);

	mask = GCLineWidth | GCFunction | GCForeground;
        values.line_width = 0;
        values.function = GXcopy;
        values.foreground = white;
        gc_set = XCreateGC(display, rootwindow, mask, &values);

	mask = GCLineWidth | GCFunction | GCPlaneMask | GCForeground;
        values.line_width = 0;
        values.function = GXxor;
        values.foreground = ~0;
        values.plane_mask = black ^ white;
        gc_xor = XCreateGC(display, rootwindow, mask, &values);

	mask = GCLineWidth | GCFunction | GCSubwindowMode;
        values.line_width = 0;
        values.function = GXinvert;
        values.subwindow_mode = IncludeInferiors;
        gc_invert = XCreateGC(display, rootwindow, mask, &values);

}

/************************************************************
*
*  MODULE NAME: xvw_set_colors()	
*
*      PURPOSE: allocates various colors for
*		later use with warpimge
*
*        INPUT: none
*       OUTPUT: none
*
*   WRITTEN BY: Danielle Argiro & Tom Sauer
*
************************************************************/

xvw_set_colors()
{
	XColor     color, exact;
	int        screen  = XDefaultScreen(display);
	Colormap   colormap = XDefaultColormap(display, screen);

	/*
         *  Get the black, white, & grey colors
         */
        if (XAllocNamedColor(display, colormap, "black", &color, &exact))
           black = color.pixel;
        else black = background = XBlackPixel(display, screen);

        if (XAllocNamedColor(display, colormap, "white", &color, &exact))
           white = color.pixel;
        else white = XWhitePixel(display, screen);

        if (XAllocNamedColor(display, colormap, "grey", &color, &exact))
           grey = color.pixel;
        else grey = white;

        if (XAllocNamedColor(display, colormap, "green", &color, &exact))
           green = color.pixel;
        else green = white;

        if (XAllocNamedColor(display, colormap, "red", &color, &exact))
           red = color.pixel;
        else red = white;
}


