 /*
  * Khoros: $Id: create_util.c,v 1.1 1991/05/10 15:59:17 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: create_util.c,v 1.1 1991/05/10 15:59:17 khoros Exp $";
#endif

 /*
  * $Log: create_util.c,v $
 * Revision 1.1  1991/05/10  15:59:17  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 *            Copyright 1990 University of New Mexico
 *
 *  Permission to use, copy, modify, distribute, and sell this
 *  software and its documentation for any purpose is hereby
 *  granted without fee, provided that the above copyright
 *  notice appear in all copies and that both that copyright
 *  notice and this permission notice appear in supporting docu-
 *  mentation, and that the name of UNM not be used in advertis-
 *  ing or publicity pertaining to distribution of the software
 *  without specific, written prior permission.  UNM makes no
 *  representations about the suitability of this software for
 *  any purpose.  It is provided "as is" without express or
 *  implied warranty.
 *
 *  UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 *  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 *  NESS, IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 *  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 *  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 *  ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 *  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 *  OF THIS SOFTWARE.
 *
 *----------------------------------------------------------------------
 */

#include "warpimage.h"
#include "cursors/cross"
#include "cursors/cross_mask"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>			Creation of Display Widgets           <<<<
   >>>>                                                       <<<<
   >>>>			xvw_create_display()		      <<<<
   >>>>			xvw_create_position_widget()	      <<<<
   >>>>			xvw_create_zoom_display()	      <<<<
   >>>>                                                       <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */
   


/************************************************************
*
*  MODULE NAME: xvw_create_display
*
*      PURPOSE: creates & initializes a raster widget for the
*		warpimage program.  The Display Structure
*		must already be initialized and all X resources
*		created.
*
*	 INPUT: display    - pointer to X11 Display structure
*		parent     - the parent widget in which the
*			     raster widget will be placed.
*		xvdisplay  - an xvdisplay structure with the
*			     structure already initialized.
*		horiz_offset - widget to left of this widget
*		vert_offset  - widget above this widget
*
*       OUTPUT: none
*
*    CALLED BY: the application program
*
*   WRITTEN BY: Mark Young & Danielle Argiro & Tom Sauer
*
*     COMMENTS: This code is a hacked-on version of xvd_create_raster()
*		in the xvdisplay library.  We needed our own version
*		so that we could modify it as desired for the warpimage
*		program.
*
*
*************************************************************/

Cursor	  display_cursor, xvd_create_cursor();

xvw_create_display(display, parent, xvdisplay, 
	           horiz_offset, vert_offset)

Display *display;
Widget  parent;
DisplayStructure *xvdisplay;
Widget  horiz_offset, vert_offset;
{
	int       i;
	Arg       args[MaxArgs];
	Dimension width = 256, height = 256;
	unsigned  foreground, background;
	static    int count = 0;
	char      name[MaxLength];

        /*
         *  Create the raster widget
         */
        i = 0;
        XtSetArg(args[i], XtNresizable, True);				i++;
	XtSetArg(args[i], XtNcolormap, xvdisplay->colormap);		i++;
        XtSetArg(args[i], XtNimage, xvdisplay->ximage);			i++;
        XtSetArg(args[i], XtNpanImage, False);				i++;
        XtSetArg(args[i], XtNpanBox, True);				i++;
        XtSetArg(args[i], XtNpixmap, xvdisplay->pixmap);		i++;
        XtSetArg(args[i], XtNvisual, xvdisplay->visual);		i++;
        XtSetArg(args[i], XtNdepth,  xvdisplay->depth);			i++;
        XtSetArg(args[i], XtNfromVert, vert_offset);			i++;
        XtSetArg(args[i], XtNfromHoriz, horiz_offset);			i++;
        XtSetArg(args[i], XtNmaxWidth, 400);				i++;
        XtSetArg(args[i], XtNmaxHeight, 400);				i++;

	foreground = white;
	background = black;
	if (xvdisplay->image != NULL)
	{
	   if (xvdisplay->image->data_storage_type  == VFF_TYP_BIT)
	   {
	      background = xvdisplay->xcolors[0].pixel;
	      foreground = xvdisplay->xcolors[1].pixel;
	   }
           width = xvdisplay->image->row_size;
           height = xvdisplay->image->col_size;
	}
	XtSetArg(args[i], XtNbackground, background);		i++;
	XtSetArg(args[i], XtNforeground, foreground);		i++;
        XtSetArg(args[i], XtNwidth,  width);			i++;
        XtSetArg(args[i], XtNheight, height);			i++;

	display_cursor = xvd_create_cursor(display, XDefaultRootWindow(display),
                	 cross_bits, cross_mask_bits, cross_width, 
		 	 cross_height, cross_mask_width, 
		 	 cross_mask_height, cross_x_hot, 
		         cross_y_hot, xvd_black, xvd_white);

        XtSetArg(args[i], XtNcursor, display_cursor);		i++;
        sprintf(name, "raster%d", count++);
        xvdisplay->raster = XtCreateManagedWidget(name, xImageWidgetClass, 
						   parent, args, i);
}

/************************************************************
*
*  MODULE NAME: xvw_create_position_widget
*
*      PURPOSE: creates & initializes a position widget 
*		which will give the value of the pixel at the
*		cursor position in the display widget or the zoom widget
*
*	 INPUT: display      - pointer to X11 Display structure
*		parent       - the parent widget in which the
*			       raster widget will be placed.
*		xvdisplay    - xvdisplay structure for the display widget 
*			       with which this position cursor is associated
*		zoom         - zoom structure for the zoom widget 
*			       with which this position cursor is associated
*		horiz_offset - widget from which to do the horizontal offset
*		vert_offset  - widget from which to do the vertical offset
*
*       OUTPUT: none
*
*    CALLED BY: lwarpimage
*
*   WRITTEN BY: Mark Young & Danielle Argiro & Tom Sauer
*
*************************************************************/

xvw_create_position_widget(display, parent, xvdisplay, zoom, 
			   horiz_offset, vert_offset)
Display *display;
Widget   parent, vert_offset, horiz_offset;
DisplayStructure *xvdisplay; 
ZoomStructure *zoom; 
{
	static int position_count = 0;
	char   temp[MaxLength];
	unsigned long mask;
	int    i;
	Arg   args[MaxArgs];
	void  xvw_update_zoom_position();

	/*
	 *  create widget at the bottom which
	 *  will give the value of the pixel at the cursor position
	 */
	 i = 0;
         XtSetArg(args[i], XtNlabel, VStrcpy("     x               "));  i++;
         XtSetArg(args[i], XtNfromVert, vert_offset);                    i++;
         XtSetArg(args[i], XtNfromHoriz, horiz_offset);                  i++;
	 XtSetArg(args[i], XtNleft,	XtChainLeft);			 i++;
	 XtSetArg(args[i], XtNright,	XtChainLeft);			 i++;
	 XtSetArg(args[i], XtNtop,	XtChainTop);			 i++;
	 XtSetArg(args[i], XtNbottom,	XtChainTop);			 i++;
         XtSetArg(args[i], XtNcursor, display_cursor);			 i++;
	 sprintf(temp, "position_%d", position_count);
         xvdisplay->position = XtCreateManagedWidget(temp, labelWidgetClass, 
					  parent, args, i);

	 mask = PointerMotionHintMask | PointerMotionMask;

         XtInsertEventHandler(xvdisplay->raster, mask, False, 
		     xvd_update_position, (caddr_t) xvdisplay, XtListTail);

	 XtInsertEventHandler(zoom->raster, mask, False, 
			      xvw_update_zoom_position, NULL, XtListTail);
	 position_count++;

}

/************************************************************
*
*  MODULE NAME: xvw_create_zoom_display
*
*      PURPOSE: creates & initializes a zoom box
*
*        INPUT: parent - the parent widget in which to create the zoom box
*		xvdisplay    - xvdisplay structure for the display widget 
*			       with which this position cursor is associated
*		zoom         - zoom structure for the zoom widget 
*			       with which this position cursor is associated
*		horiz_offset - widget from which to do the horizontal offset
*		vert_offset  - widget from which to do the vertical offset
* Output:  none
*
* Written By:  Mark Young & Danielle Argiro & Tom Sauer
*
****************************************************************/

xvw_create_zoom_display(parent, xvdisplay, zoom, horiz_offset, vert_offset)
Widget parent;
DisplayStructure *xvdisplay;
ZoomStructure *zoom;
Widget horiz_offset;
Widget vert_offset;
{
        int 	   i; 
        unsigned   long mask;
        Widget     toplevel;
	Arg	   args[MaxArgs];
	char	   temp[MaxLength];

	static int zoomcount = 0;

	if (xvdisplay->ximage != NULL)
	{
	    if (zoom->ximage = xvd_shrink_ximage(display, xvdisplay->ximage, 
					         ZoomDisplayWidth, 
						 ZoomDisplayHeight, 
						 NULL))
            {
               if (zoom->ximage->depth == 1)
                   zoom->ximage->format = XYBitmap;
            }
	}
	zoom->assoc_image  = xvdisplay->image;
	zoom->assoc_ximage = xvdisplay->ximage;
	zoom->assoc_raster = xvdisplay->raster;
	zoom->zoomfactor = 2.0;
	zoom->mode = PointClick;
	zoom->xpos = zoom->ypos = zoom->xoffset = zoom->yoffset = 0;

	if (zoom->assoc_ximage != NULL)
        {
	   zoom->min_x = zoom->assoc_ximage->width/2;
	   zoom->min_y = zoom->assoc_ximage->height/2;
        }

	/*
	 *  create widget at the bottom which
	 *  will give the value of the pixel at the cursor position
	 */
	 i = 0;
         XtSetArg(args[i], XtNfromHoriz, horiz_offset);           i++;
         XtSetArg(args[i], XtNfromVert, vert_offset);             i++;
         XtSetArg(args[i], XtNwidth, ZoomDisplayWidth);           i++;
         XtSetArg(args[i], XtNheight, ZoomDisplayHeight);         i++;
         XtSetArg(args[i], XtNcursor, display_cursor);		  i++;
         XtSetArg(args[i], XtNbackground, black);		  i++;
	 sprintf(temp, "zoom_%d", zoomcount);
         zoom->raster = XtCreateManagedWidget(temp, simpleWidgetClass, 
					  parent, args, i);

         mask = StructureNotifyMask | ExposureMask;
         XtInsertEventHandler(zoom->raster, mask, FALSE, 
			      redisplay_zoom, zoom, XtListHead);

         toplevel = parent;
         while (XtParent(toplevel) != NULL)
            toplevel = XtParent(toplevel);

         mask = StructureNotifyMask;
         XtAddEventHandler(toplevel, mask, FALSE, redisplay_zoom, zoom);

         XtInsertEventHandler(xvdisplay->raster, ExposureMask, TRUE, 
			      redraw_rubberband, zoom, XtListTail);

	 refresh_zoom(zoom);
	 zoomcount++;

} /* end xvw_create_zoom_display */
