 /*
  * Khoros: $Id: putimage.c,v 1.3 1992/03/20 22:40:16 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: putimage.c,v 1.3 1992/03/20 22:40:16 dkhoros Exp $";
#endif

 /*
  * $Log: putimage.c,v $
 * Revision 1.3  1992/03/20  22:40:16  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: putimage.c
 >>>>
 >>>>      Program Name: putimage
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	This is a non-interactive image display program.
 >>>>	
 >>>>	

 >>>>            Author: Stephanie Hallett and Mark Young
 >>>>
 >>>> Date Last Updated: Tue Feb 11 22:33:58 1992
 >>>>
 >>>>          Routines: main- the main program for putimage
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "putimage.h"


/****************************************************************
 *
 * Routine Name:  main program for putimage
 *
 *       Input:  
 *          -i  input image filename 
 *
 *
 *          [-ov] overlay image filename
 *          [-s] shape mask filename
 *          [-c] clip mask filename
 *          [-cmap_image] image with alternate colormap filename
 *          [-x] x value of upper-left corner of image  (-1 < value < 1000)
 *          [-y] y value of upper-left corner of image  (-1 < value < 1000)
 *          [-update] update time  (value >= 0.0)
 *          [-display] host:display.screen
 *          [-use_cmap] use colormap?
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        float   update = 0.0;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        consolidate_args();
/* -main_before_lib_call_end */

/* -main_library_call */

        if (putimage->update_flag)
           update = putimage->update;

        if (! lputimage(putimage->i, putimage->ov, putimage->s,
                        putimage->c, putimage->x, putimage->y, update,
                        putimage->display, putimage->use_cmap,
                        putimage->cmap_image))
        {
            fprintf(stderr, "putimage:\n");
            fprintf(stderr, "unable to display image\n");
            exit(1);
        }

/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for putimage 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "putimage :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tThis is a non-interactive image display program.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image filename  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-ov]  overlay image filename (infile) [null]\n");
	fprintf(stderr,"\t[-s]  shape mask filename (infile) [null]\n");
	fprintf(stderr,"\t[-c]  clip mask filename (infile) [null]\n");
	fprintf(stderr,"\t[-cmap_image]  image with alternate colormap filename (infile) [null]\n");
	fprintf(stderr,"\t[-x]  x value of upper-left corner of image (integer, -1 to 1000) [-1]\n");
	fprintf(stderr,"\t[-y]  y value of upper-left corner of image (integer, -1 to 1000) [-1]\n");
	fprintf(stderr,"\t[-update]  update time (float, >= 0.0) [0]\n");
	fprintf(stderr,"\t[-display]  host:display.screen (string) [null]\n");
	fprintf(stderr,"\t[-use_cmap]  use colormap? (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-jr filename.jp] creates a journal recording\n");
	fprintf(stderr, "\t[-jp filename.jp] executes a journal playback \n");
	fprintf(stderr, "\t[-fn] specifies the font for putimage\n");
	fprintf(stderr, "\t[-V] Gives the version for putimage\n");
	fprintf(stderr, "\t[-U] Gives the usage for putimage\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called putimage.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses putimage.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for putimage
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*ov_pstr = 
	"\nEnter: (ov) overlay image filename \n        {infile}: "; 
char	*s_pstr = 
	"\nEnter: (s) shape mask filename \n        {infile}: "; 
char	*c_pstr = 
	"\nEnter: (c) clip mask filename \n        {infile}: "; 
char	*cmap_image_pstr = 
	"\nEnter: (cmap_image) image with alternate colormap filename \n        {infile}: "; 
char	*x_pstr = 
	"\nEnter: (x) x value of upper-left corner of image \n        {integer, -1 to 1000 [-1] }: "; 
char	*y_pstr = 
	"\nEnter: (y) y value of upper-left corner of image \n        {integer, -1 to 1000 [-1] }: "; 
char	*update_pstr = 
	"\nEnter: (update) update time \n        {float, >= 0.0 [0.000000] }: "; 
char	*display_pstr = 
	"\nEnter: (display) host:display.screen \n        {string}: "; 
char	*display_def = NULL;
char	*use_cmap_pstr = 
	"\nEnter: (use_cmap) use colormap? \n        {boolean, (y/n)  [yes] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "putimage", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "putimage.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "putimage: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "putimage.ans");
		}

	     }

	}

	/*
	 * allocate the putimage structure
	 */
	putimage = (putimage_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (putimage_struct));

	/*
	 * get required arguments for putimage
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(putimage->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(putimage->i))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(putimage->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    putimage->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(putimage->i))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for putimage
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	putimage->ov_flag = vget_infile(fid, prompt_flag,
	"-ov", ov_pstr, &(putimage->ov))
;

	putimage->s_flag = vget_infile(fid, prompt_flag,
	"-s", s_pstr, &(putimage->s))
;

	putimage->c_flag = vget_infile(fid, prompt_flag,
	"-c", c_pstr, &(putimage->c))
;

	putimage->cmap_image_flag = vget_infile(fid, prompt_flag,
	"-cmap_image", cmap_image_pstr, &(putimage->cmap_image))
;

	putimage->x_flag = vget_int(fid, prompt_flag,
	"-x", x_pstr, &(putimage->x),
	-1, -1, 1000);

	putimage->y_flag = vget_int(fid, prompt_flag,
	"-y", y_pstr, &(putimage->y),
	-1, -1, 1000);

	putimage->update_flag = vget_float(fid, prompt_flag,
	"-update", update_pstr, &(putimage->update),
	0.000000, 1.000000, 1.000000);

	putimage->display_flag = vget_string(fid, prompt_flag,
	"-display", display_pstr, &(putimage->display),
	display_def);

	if (prompt_flag == FALSE)
	{
	    if ((putimage->display_flag == 1)&&(putimage->display == NULL))
    	{
		fprintf(stderr, "putimage:\n");
		fprintf(stderr, "you must specify a name following '-display'\n");
		gw_usage();
		exit(1);
		}
	}
	putimage->use_cmap_flag = vget_logic(fid, prompt_flag,
	"-use_cmap", use_cmap_pstr, &(putimage->use_cmap), 1);


}



