 /*
  * Khoros: $Id: lpreview.c,v 1.2 1991/12/18 09:07:40 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lpreview.c,v 1.2 1991/12/18 09:07:40 dkhoros Exp $";
#endif

 /*
  * $Log: lpreview.c,v $
 * Revision 1.2  1991/12/18  09:07:40  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lpreview.c
 >>>>
 >>>>      Program Name: preview
 >>>>
 >>>> Date Last Updated: Fri Apr 26 14:32:14 1991 
 >>>>
 >>>>          Routines: lpreview - the library call for preview
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "xvinclude.h"


/* -library_includes */
#include "preview.h"
#include "form_info.h"
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lpreview - library call for preview
*
* Purpose:
*
* Input:
* Output:
*
* Written By: John Rasure, Mark Young
****************************************************************/


/* -library_def */
int lpreview(argc, argv, program, flag, input_file)

int     argc;           /* copy of argc */
char    *argv[];        /* copy of argv */
char    *program;
char    *input_file;
int     flag;

/* -library_def_end */

/* -library_code */
{

        xvf_form  *menu_form, *form;
        UI_view UI_view_info;
        char    *form_filestring, *vfullpath();
        char    temp[MaxLength];
        int     update_file();

        /*
         * initialize the display & the forms - 
         * NOTE: assuming a global 'Display *display'
         */
        display = xvf_initialize(ac, av, program);
        if (display == NULL)
        {
             fprintf(stderr, "Could not open connection to server");
             exit(0);
        }

        /*
         *  Turn on xpression handler.
         */
         xve_init();
         XVF_EXPRESSION = true;
         XVF_ECHO_CMD   = true;

        /*
         * Get the User Interface Description file to be used
         */
        form_filestring = xvf_strcpy("KHOROS_HOME/repos/preview/preview.form");
        form_filestring = vfullpath(form_filestring, NULL, NULL);

        /*
         * Create the forms 
         */
        if (!(menu_form = xvf_create_form(form_filestring, av, ac, SIMPLE, NULL,-1,-1)))
           exit(0);

        /*
         * Initialize the auto-generated information structure
         */
        _xvf_init_UI_view(menu_form,  &UI_view_info);

        /*
           if there was an input file on the command line,
           then intialize the form to reflect the filename, and
           map the demo form so that when run_form is called it gets
           displayed.
        */

        if (flag) {
            xvf_change_input(menu_form, UI_view_info.show->preview->i_index,
                             xvf_inputfile_chng, input_file, 0);

            demo_form = xvf_create_form(input_file, av, ac, 
				        SIMPLE, NULL,-1,-1);
	    if (demo_form != NULL)
            {
		if (demo_form->subform != NULL)
		{
                   xvf_change_active (demo_form, true);
                   demo_id = xvf_detect_file(input_file, PREVIEW_DELAY, 
                                             update_file, NULL);
		}
	        else
		{
		   xvf_error_wait("Empty UIS definition - nothing to display.",
				   NULL, NULL);
		}
            }
        }
        else
        {
            demo_form = NULL;
            demo_id   = 0;
        }

        /*
         * Map the forms
         */
        xvf_change_active(menu_form, true);

        do
        {
             /*
              * run the forms
              */
             form = xvf_run_form();

             /* make sure that run_form is returning from an action of
             the actual driving form, not the form being shown.
             */

             if (form == NULL) continue;

             if (form != menu_form && form->quit == true) {
                 if (demo_form == form)
                    demo_form = NULL;

                 xvf_destroy_form(form);

                 if (demo_id != 0)
                    xvf_delete_detect(demo_id);
             }
             else {
                 /*
                  * get information from the master
                  */
                 _xvf_get_UI_view(menu_form, &UI_view_info);
    
                 /*
                  * action came from the 'show' subform
                  */
                 if (UI_view_info.show_selected)
                 {
                      run_show(menu_form, UI_view_info.show);
                 }
                 xvf_clear_selections(menu_form->db, menu_form->line_num);
             }
          /* end user interface loop */
        } while (!UI_view_info.show->preview->quit);
        return(TRUE);
}
/* -library_code_end */
