 /*
  * Khoros: $Id: lcomposer.c,v 1.2 1991/10/02 00:19:17 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lcomposer.c,v 1.2 1991/10/02 00:19:17 khoros Exp $";
#endif

 /*
  * $Log: lcomposer.c,v $
 * Revision 1.2  1991/10/02  00:19:17  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lcomposer.c
 >>>>
 >>>>      Program Name: composer
 >>>>
 >>>> Date Last Updated: Sat Sep 28 12:45:41 1991 
 >>>>
 >>>>          Routines: lcomposer - the library call for composer
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "xvinclude.h"


/* -library_includes */
#include "composer.h"
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lcomposer - library call for composer
*
* Purpose:
*    
*    Creates the GUI and drives the master form.
*    
*    

* Input:
*    
*    argc           number of arguments on command line
*    
*    argv           arguments from command line
*    
*    program        name of program or executable
*    
*    

* Output:
*    
*    none
*    
*    

*
* Written By: John Rasure
*    
*    

****************************************************************/


/* -library_def */
run_Composer(argc, argv, program)
int     argc;           /* copy of argc */
char    *argv[];        /* copy of argv */
char    *program;

/* -library_def_end */

/* -library_code */
{
        xvf_form  *comp_form,   /* composer form */
                  *xvf_build_form(),    
                  *form;        /* form returned from run_form */
        char    **xvf_copy_database(), **spec;

        Composer Composer_info;
        char    temp[MaxLength];
        char    *form_filestring;
        int     run_pane(),
                run_prog(),
                run_conf_manage();


        /*
         * initialize the display & the forms - 
         * NOTE: assuming a global 'Display *display'
         */
        display = xvf_initialize(ac, av, program);
        if (display == NULL)
        {
             (void) fprintf(stderr, "Could not open connection to server");
             exit(0);
        }

        /*
         * Substitute below the correct path & filename
         * of the User Interface Description file to be used
         */
        form_filestring = xvf_strcpy("KHOROS_HOME/repos/composer/composer.form");
        form_filestring = vfullpath(form_filestring, NULL, NULL);

        /*
         * Create the forms 
         */
        if (!(comp_form = xvf_create_form(form_filestring, av, ac, SIMPLE, NULL, -1, -1)))
           exit(0);

        /*
         * Initialize the auto-generated information structure
         */
        _xvf_init_Composer(comp_form,  &Composer_info);

        /* take care of command line input:
           1.  change composer form to reflect routine name
           2.  change composer form to reflect pane specification name
           3.  change composer form to reflect prog specification name
           4.  create the demo_form for gui_spec
           5.  initialize the composer form for editing the prog_spec
           */

        if (glob_routine_name != NULL) {
            xvf_change_input(comp_form, 
                             Composer_info.pane->edit_pane->name_index,
                             xvf_stringval_chng, glob_routine_name, 0);
            xvf_change_input(comp_form, 
                          Composer_info.conf_manage->ghost_routines->name_index,
                             xvf_stringval_chng, glob_routine_name, 0);
        }

        if (valid_pane_file == TRUE) {
            xvf_change_input(comp_form,
                         Composer_info.pane->edit_pane->pane_file_index,
                          xvf_inputfile_chng, glob_pane_name, 0);

            /* create the demo form, it has already been read in and checked
              by get_pane() and is now in gui_spec.  So, now build the form
              and then activate it.
              */
            spec = xvf_copy_database(gui_spec);
            if (spec == NULL) {
                (void) sprintf(temp, "Unable to copy user interface specification");
                xvf_error_wait(temp, "COMPOSER WARNING!", "OK");
                return;
            }

            if (!(demo_form = xvf_build_form(spec, gui_spec_lines,
                                            gui_spec_size, av, ac,
                                            SIMPLE, NULL,-1,-1))){
                (void) sprintf(temp, "Unable to build forms to preview the user interface specification");
                xvf_error_wait(temp, "COMPOSER WARNING!", "OK");
            }
            else {
                xvf_change_active (demo_form, true);
            }
        }
        else init_pane_edit(comp_form, Composer_info.pane->edit_pane);

        if (valid_prog_file == TRUE) {
            xvf_change_input(comp_form,
                         Composer_info.prog->edit_prog->prog_file_index,
                          xvf_inputfile_chng, glob_prog_name, 0);
            /* change the the string in the edit text widget */
            xvf_change_input(comp_form,
                         Composer_info.prog->edit_prog->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[Authors], 0);
        }

        /*
         * Map the forms
         */
        xvf_change_active(comp_form, true);

        do
        {
             /* set global names across all panes */

            if (glob_routine_name != NULL) {
                xvf_change_input(comp_form, 
                             Composer_info.pane->edit_pane->name_index,
                             xvf_stringval_chng, glob_routine_name, 0);
                xvf_change_input(comp_form, 
                      Composer_info.conf_manage->ghost_routines->name_index,
                      xvf_stringval_chng, glob_routine_name, 0);
            }

            if (glob_pane_name != NULL) {
                xvf_change_input(comp_form,
                         Composer_info.pane->edit_pane->pane_file_index,
                          xvf_inputfile_chng, glob_pane_name, 0);
            }

            if (glob_prog_name != NULL) {
                xvf_change_input(comp_form,
                         Composer_info.prog->edit_prog->prog_file_index,
                          xvf_inputfile_chng, glob_prog_name, 0);
            }
             /* run the forms */

             form = xvf_run_form();

             /* make sure that run_form is returning from an action of
                the actual driving form, not the form being shown.
                */

             if (form == NULL) continue;

             if (form != comp_form && form->quit == true) {
                 if (demo_form == form) demo_form = NULL;
                 xvf_destroy_form(form);
             }
             else {

                 /*
                  * get information from the master
                  */
                 _xvf_get_Composer(comp_form, &Composer_info);
    
                 /*
                  * action came from the 'pane' subform
                  */
                 if (Composer_info.pane_selected)
                 {
                      run_pane(comp_form, Composer_info.pane);
                 }
    
                 /*
                  * action came from the 'prog' subform
                  */
                 if (Composer_info.prog_selected)
                 {
                      run_prog(comp_form, Composer_info.prog);
                 }
    
                 /*
                  * action came from the 'conf_manage' subform
                  */
                 if (Composer_info.conf_manage_selected)
                 {
                      run_conf_manage(comp_form, Composer_info.conf_manage);
                 }

                xvf_clear_selections(comp_form->db, comp_form->line_num);
             }
        } while (!Composer_info.quit);    /* end user interface loop */

}    /* end run_Composer */

/* -library_code_end */
