 /*
  * Khoros: $Id: lcantata.c,v 1.2 1991/12/18 09:01:35 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lcantata.c,v 1.2 1991/12/18 09:01:35 dkhoros Exp $";
#endif

 /*
  * $Log: lcantata.c,v $
 * Revision 1.2  1991/12/18  09:01:35  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lcantata.c
 >>>>
 >>>>      Program Name: cantata
 >>>>
 >>>> Date Last Updated: Fri Apr 26 14:36:20 1991 
 >>>>
 >>>>          Routines: lcantata - the library call for cantata
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "xvinclude.h"


/* -library_includes */
#include "cantata.h"
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lcantata - library call for cantata
*
* Purpose:
*
* Input:
* Output:
*
* Written By: Stephanie Hallett, Mark Young, & Carla Williams
****************************************************************/


/* -library_def */
int lcantata(argc, argv)

unsigned int argc;
char     **argv;

/* -library_def_end */

/* -library_code */
{
	int	        done;
        char            temp[50];


        if (cantata->display_flag == True)
        {
           (void) sprintf(temp,"DISPLAY=%s", cantata->display);
           vputenv(xvf_strcpy(temp));
        }

        display = xvf_initialize(argc, argv, "cantata");
        if (display == NULL)
           exit(0);

	/*
	 *  Kludge:  added to allow cantata to have distinct toplevel names..
	 */
	xvf_set_cantata();

        /*
         * set some of the defaults from the command line
         */
        if ((cantata->dir_flag == True) && (cantata->dir != NULL))
           XVF_FILE_DIR = xvf_strcpy(cantata->dir);

        if (cantata->verbose_flag == True)
        {
           if (cantata->verbose)
              (void) sprintf(temp, "KHOROS_VERBOSE=on");
           else
              (void) sprintf(temp, "KHOROS_VERBOSE=off");
           vputenv(xvf_strcpy(temp));
        }

        if (cantata->log_flag == True)
        {
           (void) sprintf(temp,"KHOROS_LOG=%s", cantata->log);
           vputenv(xvf_strcpy(temp));
        }


        if (!xvl_init_menus(display))
        {
           return(False);
        }

	/*
	 *  Get current hostname and domain name of the machine that
	 *  we are on.  The current hostname will be the short name
	 *  minus the domain.  Where the domain name will be the rest
	 *  if such a thing exists.
	 */
	if (kgethostname(NULL, current_hostname, MaxLength) == 0)
	{
	   if ((current_domain = strchr(current_hostname, '.')) != NULL)
	   {
	      *current_domain = '\0';
	      current_domain++;
	   }
	}
	else
	{
	   strcpy(current_hostname, "localhost");
	   current_domain = NULL;
	}
	   

        /*
         *  If the user specifies the saved workspace then restore the
         *  workspace before continuing.  The name of the workspace file
         *  and true is passed to xvl_restore_workspace().  The true
         *  indicates that we are also to restore the temporary files
         *  if they exist.
         */
        if ((cantata->restore_flag == true) && (cantata->restore != NULL))
           xvl_restore_workspace(main_workspace, cantata->restore, True);

        /*
	 *  run cantata....  we should never return since xvf_run_form()
	 *  will directly callback the menu or user iterface subroutines
	 *  located in menu.c
	 */
	done = False;
	while (!done)
	{
           xvf_run_form();
	}
	return(True);
}
/* -library_code_end */
