 /*
  * Khoros: $Id: animate.c,v 1.3 1991/12/18 09:05:09 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: animate.c,v 1.3 1991/12/18 09:05:09 dkhoros Exp $";
#endif

 /*
  * $Log: animate.c,v $
 * Revision 1.3  1991/12/18  09:05:09  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: animate.c
 >>>>
 >>>>      Program Name: animate
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	displays an image sequence from a  single  VIFF  image  with
 >>>>	multiple bands, or from several single band VIFF images with
 >>>>	the same basename.
 >>>>	
 >>>>	


 >>>> 
 >>>> Date Last Updated: Thu Dec  5 16:24:41 1991
 >>>>
 >>>>          Routines: main- the main program for animate
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "animate.h"


/****************************************************************
 *
 * Routine Name:  main program for animate
 *
 *       Input:  
 *
 *
 *         [-c] input clip mask filename
 *         [-s] input shape mask filename
 *         [-cmap_image] image with alternate colormap filename
 *         [-use_pixmap] Use pixmap memory
 *         [-use_root] Use rootwindow to display animation
 *         [-use_iconic] Creates an iconic animation when iconified
 *         [-use_cmap] use colormap?
 *         [-x] x location of GUI  (-1 < value < 1000)
 *         [-y] y location of GUI  (-1 < value < 1000)
 *         [-update] initial update time  (value > 0.0)
 *         [-display] host:display.screen
 *
 *         [-base  basename to a set of images   -OR-
 *          -i  image to do slide show animation   ]
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        float  update = 0.0;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        (void) consolidate_args();

/* -main_before_lib_call_end */

/* -main_library_call */
        if (animate->update_flag)
           update = animate->update;

        /* read_from_memory = animate->method */
        read_from_memory = true;

        if (!lanimate(animate->i, animate->base, read_from_memory, 
                      animate->s, animate->c, animate->cmap_image,
                      animate->x, animate->y, update, animate->display, 
                      animate->use_pixmap, animate->use_iconic,
                      animate->use_cmap, animate->use_root))
        {
           fprintf(stderr, "lanimate failed\n");
           exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for animate 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "animate :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tdisplays an image sequence from a  single  VIFF  image  with\n");
	fprintf(stderr, "\tmultiple bands, or from several single band VIFF images with\n");
	fprintf(stderr, "\tthe same basename.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-c]  input clip mask filename (infile) [null]\n");
	fprintf(stderr,"\t[-s]  input shape mask filename (infile) [null]\n");
	fprintf(stderr,"\t[-cmap_image]  image with alternate colormap filename (infile) [null]\n");
	fprintf(stderr,"\t[-use_pixmap]  Use pixmap memory (boolean) [true]\n");
	fprintf(stderr,"\t[-use_root]  Use rootwindow to display animation (boolean) [false]\n");
	fprintf(stderr,"\t[-use_iconic]  Creates an iconic animation when iconified (boolean) [true]\n");
	fprintf(stderr,"\t[-use_cmap]  use colormap? (boolean) [true]\n");
	fprintf(stderr,"\t[-x]  x location of GUI (integer, -1 to 1000) [-1]\n");
	fprintf(stderr,"\t[-y]  y location of GUI (integer, -1 to 1000) [-1]\n");
	fprintf(stderr,"\t[-update]  initial update time (float, > 0.0) [2]\n");
	fprintf(stderr,"\t[-display]  host:display.screen (string) [null]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\t[ ");
	fprintf(stderr,"-base  basename to a set of images  (string) -OR- \n");
	fprintf(stderr,"\t  -i  image to do slide show animation  (infile) ]\n\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-jr filename.jp] creates a journal recording\n");
	fprintf(stderr, "\t[-jp filename.jp] executes a journal playback \n");
	fprintf(stderr, "\t[-fn] specifies the font for animate\n");
	fprintf(stderr, "\t[-V] Gives the version for animate\n");
	fprintf(stderr, "\t[-U] Gives the usage for animate\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called animate.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses animate.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for animate
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*c_pstr = 
	"\nEnter: (c) input clip mask filename \n        {infile}: "; 
char	*s_pstr = 
	"\nEnter: (s) input shape mask filename \n        {infile}: "; 
char	*cmap_image_pstr = 
	"\nEnter: (cmap_image) image with alternate colormap filename \n        {infile}: "; 
char	*use_pixmap_pstr = 
	"\nEnter: (use_pixmap) Use pixmap memory \n        {boolean, (y/n)  [yes] }: "; 
char	*use_root_pstr = 
	"\nEnter: (use_root) Use rootwindow to display animation \n        {boolean, (y/n)  [no] }: "; 
char	*use_iconic_pstr = 
	"\nEnter: (use_iconic) Creates an iconic animation when iconified \n        {boolean, (y/n)  [yes] }: "; 
char	*use_cmap_pstr = 
	"\nEnter: (use_cmap) use colormap? \n        {boolean, (y/n)  [yes] }: "; 
char	*x_pstr = 
	"\nEnter: (x) x location of GUI \n        {integer, -1 to 1000 [-1] }: "; 
char	*y_pstr = 
	"\nEnter: (y) y location of GUI \n        {integer, -1 to 1000 [-1] }: "; 
char	*update_pstr = 
	"\nEnter: (update) initial update time \n        {float, > 0.0 [2.000000] }: "; 
char	*display_pstr = 
	"\nEnter: (display) host:display.screen \n        {string}: "; 
char	*display_def = NULL;
char	*base_pstr = 
	"\nEnter: (base) basename to a set of images \n        {string}: "; 
char	*base_def = NULL;
char	*i_pstr = 
	"\nEnter: (i) image to do slide show animation \n        {infile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "animate", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "animate.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "animate: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "animate.ans");
		}

	     }

	}

	/*
	 * allocate the animate structure
	 */
	animate = (animate_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (animate_struct));

	/*
	 * get optional arguments for animate
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	animate->c_flag = vget_infile(fid, prompt_flag,
	"-c", c_pstr, &(animate->c))
;

	animate->s_flag = vget_infile(fid, prompt_flag,
	"-s", s_pstr, &(animate->s))
;

	animate->cmap_image_flag = vget_infile(fid, prompt_flag,
	"-cmap_image", cmap_image_pstr, &(animate->cmap_image))
;

	animate->use_pixmap_flag = vget_logic(fid, prompt_flag,
	"-use_pixmap", use_pixmap_pstr, &(animate->use_pixmap), 1);

	animate->use_root_flag = vget_logic(fid, prompt_flag,
	"-use_root", use_root_pstr, &(animate->use_root), 0);

	animate->use_iconic_flag = vget_logic(fid, prompt_flag,
	"-use_iconic", use_iconic_pstr, &(animate->use_iconic), 1);

	animate->use_cmap_flag = vget_logic(fid, prompt_flag,
	"-use_cmap", use_cmap_pstr, &(animate->use_cmap), 1);

	animate->x_flag = vget_int(fid, prompt_flag,
	"-x", x_pstr, &(animate->x),
	-1, -1, 1000);

	animate->y_flag = vget_int(fid, prompt_flag,
	"-y", y_pstr, &(animate->y),
	-1, -1, 1000);

	animate->update_flag = vget_float(fid, prompt_flag,
	"-update", update_pstr, &(animate->update),
	2.000000, 2.000000, 2.000000);

	animate->display_flag = vget_string(fid, prompt_flag,
	"-display", display_pstr, &(animate->display),
	display_def);

	if (prompt_flag == FALSE)
	{
	    if ((animate->display_flag == 1)&&(animate->display == NULL))
    	{
		fprintf(stderr, "animate:\n");
		fprintf(stderr, "you must specify a name following '-display'\n");
		gw_usage();
		exit(1);
		}
	}
	/*
	 * get optional mutually exclusive groups for animate
	 */
	if (prompt_flag == TRUE)
	{
		   fprintf(stderr, "\nThe following prompts are mutually exclusive.\n");
		   fprintf(stderr, "\nHit <cr> until the desired prompt appears.\n");
		animate->base_flag = vget_string(fid, prompt_flag,
		    "-base", base_pstr, &(animate->base),
		    base_def);

    		if(!( (animate->base_flag)))
		    animate->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(animate->i))
;

		   fprintf(stderr, "\n ------\n");
	}
	else
	{
		count = 0;
		if(animate->base_flag = vget_string(fid, prompt_flag,
		    "-base", base_pstr, &(animate->base),
		    base_def))
		    count++;

		if(animate->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(animate->i))
)
		    count++;

		if (count > 1)
		{
		    fprintf(stderr, "Error: You may specify ONLY ONE of :\n");
		    fprintf(stderr, " -base  -i \n");
		    gw_usage();
		    exit(1);
		}

	}


}



