 /*
  * Khoros: $Id: create_util.c,v 1.3 1992/03/20 22:49:01 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: create_util.c,v 1.3 1992/03/20 22:49:01 dkhoros Exp $";
#endif

 /*
  * $Log: create_util.c,v $
 * Revision 1.3  1992/03/20  22:49:01  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 *            Copyright 1990 University of New Mexico
 *  
 *  Permission to use, copy, modify, distribute, and sell this
 *  software and its documentation for any purpose is hereby
 *  granted without fee, provided that the above copyright
 *  notice appear in all copies and that both that copyright
 *  notice and this permission notice appear in supporting docu-
 *  mentation, and that the name of UNM not be used in advertis-
 *  ing or publicity pertaining to distribution of the software
 *  without specific, written prior permission.  UNM makes no
 *  representations about the suitability of this software for
 *  any purpose.  It is provided "as is" without express or
 *  implied warranty.
 *  
 *  UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 *  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 *  NESS, IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 *  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 *  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 *  ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 *  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 *  OF THIS SOFTWARE.
 *  
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xvdisplay.h"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>            Image Display Utility Routines             <<<<
   >>>>                                                       <<<<
   >>>>		    xvd_create_image()			      <<<<
   >>>>		    xvd_create_raster()			      <<<<
   >>>>		    xvd_create_icon()			      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/************************************************************
*
*  MODULE NAME: xvd_create_image
*
*      PURPOSE: creates & initializes the xvdisplay structure
*		and all associated resources.  (Obsolete.  Please
*               use xvd_create_xvdisplay()).
*
*	 INPUT: display - pointer to X11 Display structure
*		image	- viff image to use
*	        shape   - viff image to use as shape mask (if desired)
*		private_cmap - False if application can only use default
*			       colormap
*		read_only - False if application needs color cells
*			       to be Read/Write; True otherwise
*		name - name for raster widget
*		xpos & ypos - position on screen to place image.
*			      (-1,-1) will allow user to place image using 
*			      the window manager.
*		position_widget - indicates whether or not to put a position
*				  widget at the bottom.
*
*       OUTPUT: the DisplayStructure
*
*    CALLED BY: the application program *
*
*   WRITTEN BY: Mark Young
*
*
*************************************************************/


DisplayStructure *xvd_create_image(display, image, shape, clip, overlay,
		private_cmap, read_only, name, xpos, ypos, position_widget)
Display 	*display;
struct xvimage  *image, *shape, *clip, *overlay;
int 		 private_cmap, read_only;
char 		*name;
int   		 xpos, ypos;
int		 position_widget;
{
	return(xvd_create_xvdisplay(display, image, shape, clip, overlay,
		private_cmap, read_only, name, xpos, ypos, position_widget));
}



/************************************************************
*
*  MODULE NAME: xvd_create_raster
*
*      PURPOSE: creates & initializes a raster widget for the
*		xvdisplay structure.  The Display Structure
*		must already be initialized and all X resources
*		created.
*
*	 INPUT: display    - pointer to X11 Display structure
*		xvdisplay  - an xvdisplay structure with the
*			     structure already initialized.
*		parent     - the parent widget in which the
*			     raster widget will be placed.
*		position_widget - indicates whether or not to put a position
*				  widget at the bottom.
*
*       OUTPUT: none
*
*    CALLED BY: the application program
*
*   WRITTEN BY: Mark Young & Danielle Argiro
*
*
*************************************************************/


xvd_create_raster(display, parent, xvdisplay, position_widget)

Display *display;
Widget  parent;
DisplayStructure *xvdisplay;
int     position_widget;
{
	int       i;
	Arg       args[MaxArgs];
	Dimension width = 256, height = 256;
	unsigned  long mask, foreground, background;


        /*
         *  Create the raster widget
         */
        i = 0;
        XtSetArg(args[i], XtNresizable, True);			        i++;
        XtSetArg(args[i], XtNshape, xvdisplay->shape_mask);		i++;
        XtSetArg(args[i], XtNshapeParent, xvdisplay->shape_parent);	i++;
        XtSetArg(args[i], XtNclip, xvdisplay->clip_mask);		i++;
	XtSetArg(args[i], XtNcolormap, xvdisplay->colormap);		i++;
        XtSetArg(args[i], XtNimage, xvdisplay->ximage);			i++;
        XtSetArg(args[i], XtNpanBox, True);				i++;
        XtSetArg(args[i], XtNpanImage, True);				i++;
        XtSetArg(args[i], XtNpixmap, xvdisplay->pixmap);		i++;
	XtSetArg(args[i], XtNoverlay, xvdisplay->overlay_pixmap);	i++;
	XtSetArg(args[i], XtNoverlayMask, xvdisplay->overlay_mask);	i++;
	XtSetArg(args[i], XtNvisual, xvdisplay->visual);		i++;
	XtSetArg(args[i], XtNdepth, xvdisplay->depth);			i++;

	foreground = xvd_white;
	background = xvd_black;
	if (xvdisplay->disp_image != NULL)
	{
	   if (xvdisplay->disp_image->data_storage_type  == VFF_TYP_BIT)
	   {
	      background = xvdisplay->xcolors[0].pixel;
	      foreground = xvdisplay->xcolors[1].pixel;
	   }
           width = xvdisplay->disp_image->row_size;
           height = xvdisplay->disp_image->col_size;
	   if (width  > 800) width  = 800;
	   if (height > 750) height = 750;
	}
	XtSetArg(args[i], XtNbackground, background);			i++;
	XtSetArg(args[i], XtNforeground, foreground);			i++;
        XtSetArg(args[i], XtNwidth,  width);			i++;
        XtSetArg(args[i], XtNheight, height);			i++;
        XtSetArg(args[i], XtNcursor, display_cursor);		i++;
        xvdisplay->raster = XtCreateManagedWidget("raster",
                                       xImageWidgetClass, parent, args, i);

	/*
	 *  if desired, create widget at the bottom which
	 *  will give the value of the pixel at the cursor position
	 */
	if (position_widget)
	{
	   i = 0;
	   XtSetArg(args[i], XtNlabel,
		    VStrcpy("     x                       "));		 i++;
           XtSetArg(args[i], XtNfromVert, xvdisplay->raster);            i++;
           XtSetArg(args[i], XtNfromHoriz, NULL);                        i++;
           xvdisplay->position = XtCreateManagedWidget("position", 
			         labelWidgetClass, parent, args, i);

	   mask = PointerMotionHintMask | PointerMotionMask;
           XtInsertEventHandler(xvdisplay->raster, mask, FALSE, 
		     xvd_update_position, (caddr_t) xvdisplay, XtListTail);
	}
	

	if (XtIsRealized(parent))
	{
	   XtRealizeWidget(xvdisplay->raster);
	   if (position_widget)
	      XtRealizeWidget(xvdisplay->position);

	   if (xvdisplay->shape != NULL)
	      xvd_update_shape(xvdisplay, NULL);
	}
}



/************************************************************
*
*  MODULE NAME: xvd_create_icon
*
*      PURPOSE: creates & initializes a icon widget for when
*		the user iconifies the xvdisplay raster widget.
*		This routine should be called after initializing
*		the xvdisplay structure.
*
*		Note:  the width and height is used as a desired width
*		       & height, not actual width and height.  Since
*		       giving 
*
*	 INPUT: display    - pointer to X11 Display structure
*		xvdisplay  - an xvdisplay structure with the
*			     structure already initialized.
*
*		desired_width  - 
*		desired_height - the desired width and height of icon.
*
*       OUTPUT: none
*
*    CALLED BY: the application program
*
*   WRITTEN BY: Mark Young & Danielle Argiro
*
*
*************************************************************/


xvd_create_icon(display, xvdisplay, desired_width, desired_height)

Display *display;
DisplayStructure *xvdisplay;
int	desired_width, desired_height;
{
	int      i;
	static	 int count = 0;
	Arg      args[MaxArgs];
	XImage   *icon_ximage;
	Pixmap   icon_pixmap = None;
	char	 icon_name[MaxLength], *name = "Display Icon";
	char	 tname[MaxLength];
	Window	 rootwindow = XDefaultRootWindow(display);


	/*
	 *  Create a sub-sampled ximage from the xvdisplay ximage.
	 */
	if (xvdisplay->ximage != NULL)
	{
	   icon_ximage = xvd_shrink_ximage(display, xvdisplay->ximage,
					desired_width, desired_height, NULL);

	   if (icon_ximage->depth > 1 || icon_ximage->depth == xvdisplay->depth)
	   {
	      icon_pixmap = xvd_create_pixmap(xvdisplay, icon_ximage, None);
	   }
	   else
	   {
	      icon_pixmap = XCreatePixmapFromBitmapData(display, rootwindow,
			icon_ximage->data, icon_ximage->width,
			icon_ximage->height, xvdisplay->xcolors[1].pixel,
			xvdisplay->xcolors[0].pixel, xvdisplay->depth);
	   }

	   if (icon_ximage != NULL)
	   {
	      desired_width  = icon_ximage->width;
	      desired_height = icon_ximage->height;
	   }
	   xvdisplay->icon_ximage = icon_ximage;
	   xvdisplay->icon_pixmap = icon_pixmap;
	}

	/*
         *  Create top level transient icon shell widget
         */
	if (xvdisplay->name != NULL)
	   name = xvdisplay->name;

	(void) sprintf(icon_name,"%s_icon", name);
	(void) sprintf(tname,"%s%d", icon_name, count++);

        i = 0;
        XtSetArg(args[i], XtNwidth, desired_width);		i++;
        XtSetArg(args[i], XtNheight, desired_height);		i++;
        XtSetArg(args[i], XtNtitle, xvf_strcpy(name));	      	i++;
        XtSetArg(args[i], XtNcolormap, xvdisplay->colormap); 	i++;
        XtSetArg(args[i], XtNiconic, True);	i++;
	XtSetArg(args[i], XtNmappedWhenManaged, false);		i++;
	XtSetArg(args[i], XtNvisual, xvdisplay->visual);	i++;
        XtSetArg(args[i], XtNdepth, xvdisplay->depth);	i++;
        if (icon_pixmap != None)
	{
	   XtSetArg(args[i], XtNbackgroundPixmap, icon_pixmap);	i++;
	}
	xvdisplay->icon = XtAppCreateShell(icon_name, icon_name,
				transientShellWidgetClass, display, args, i);
	XtRealizeWidget(xvdisplay->icon);
	xvf_add_toplevel(xvdisplay->icon);
}
