 /*
  * Khoros: $Id: varviff.h,v 1.1 1991/05/10 15:49:44 khoros Exp $
  */

 /*
  * $Log: varviff.h,v $
 * Revision 1.1  1991/05/10  15:49:44  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: varviff.h
 >>>>            Author: John Rasure and Carla Williams
 >>>> Date Last Updated: Fri Mar 22 14:36:50 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _varviff_h_
#define _varviff_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    varviff Argument Structure
*
****************************************************************/

typedef struct _varviff  {

/*
 *  input file (Required infile)
 */
char	*i1_file;	/* input file FILENAME */
int	 i1_flag;	/* input file FLAG */

/*
 *  x location (Required integer)
 */
int	 x_int; 	/* x location INT */
int	 x_flag;	/* x location FLAG */

/*
 *  y location (Required integer)
 */
int	 y_int; 	/* y location INT */
int	 y_flag;	/* y location FLAG */

/*
 *  band number (Required integer)
 */
int	 b_int; 	/* band number INT */
int	 b_flag;	/* band number FLAG */

/*
 *  variable (Required string)
 */
char	*v_string;	/* variable STRING */
int	 v_flag;   	/* variable FLAG */

/*
 *  input file that is passed to output unmodified (used to gate operation) (Optional infile)
 */
char	*i2_file;	/* input file that is passed to output unmodified (used to gate operation) FILENAME */
int	 i2_flag;	/* input file that is passed to output unmodified (used to gate operation) FLAG */

/*
 *  connecting file (Optional outfile)
 */
char	*o_file;	/* connecting file FILENAME */
int	 o_flag;	/* connecting file FLAG */

}  varviff_struct;

varviff_struct *varviff;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define CHECKINPUT(program, img) \
        (void) proper_num_images(program,img,1,TRUE); \
        (void) proper_map_enable(program,img,VFF_MAP_OPTIONAL,TRUE)
/* -include_macros_end */

#endif
