 /*
  * Khoros: $Id: vresize.c,v 1.1 1991/05/10 15:49:09 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vresize.c,v 1.1 1991/05/10 15:49:09 khoros Exp $";
#endif

 /*
  * $Log: vresize.c,v $
 * Revision 1.1  1991/05/10  15:49:09  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vresize.c
 >>>>
 >>>>      Program Name: vresize
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Magnify or reduce an image using bilinear interpolation
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:48:14 1991
 >>>>
 >>>>          Routines: main- the main program for vresize
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vresize.h"


/****************************************************************
 *
 * Routine Name:  main program for vresize
 *
 *       Input:  
 *         -i  input image 
 *         -o  resulting output image 
 *
 *
 *         [-x] x coordinate of the center of action  (value >= 0.0)
 *         [-y] y coordinate of the center of action  (value >= 0.0)
 *         [-h] magnification in the horizontal direction  (value > 0.0)
 *         [-v] magnification in the vertical direction  (value > 0.0)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        struct xvimage *image,*readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);
        image = readimage(vresize->i_file);
        if (image == NULL) exit(1);
        CHECKINPUT(program, image);

        /* Default view field is dead center if center is not specified.*/
        if (vresize->x_flag == 0) vresize->x_float = (image->row_size-1)/2.0;
        if (vresize->x_flag == 0) vresize->y_float = (image->col_size-1)/2.0;
/* -main_before_lib_call_end */

/* -main_library_call */
        if(!lvresize(image,vresize->h_float,
                           vresize->v_float,
                           vresize->x_float,
                           vresize->y_float))
          {
            (void) fprintf(stderr, "lvresize Failed\n");
            exit(1);
          }
/* -main_library_call_end */

/* -main_after_lib_call */
        (void) writeimage(vresize->o_file, image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vresize 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vresize :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tMagnify or reduce an image using bilinear interpolation\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
fprintf(stderr,"Note: if the center of action coordinates are not specified\n");
fprintf(stderr,"      then the center of action is taken to be the center of\n");
fprintf(stderr,"      the image, regardless of the size of the particular image.\n\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-x]  x coordinate of the center of action (float, >= 0.0) [0]\n");
	fprintf(stderr,"\t[-y]  y coordinate of the center of action (float, >= 0.0) [0]\n");
	fprintf(stderr,"\t[-h]  magnification in the horizontal direction (float, > 0.0) [2]\n");
	fprintf(stderr,"\t[-v]  magnification in the vertical direction (float, > 0.0) [2]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vresize\n");
	fprintf(stderr, "\t[-U] Gives the usage for vresize\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vresize.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vresize.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vresize
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*x_pstr = 
	"\nEnter: (x) x coordinate of the center of action \n        {float, >= 0.0 [0.000000] }: "; 
char	*y_pstr = 
	"\nEnter: (y) y coordinate of the center of action \n        {float, >= 0.0 [0.000000] }: "; 
char	*h_pstr = 
	"\nEnter: (h) magnification in the horizontal direction \n        {float, > 0.0 [2.000000] }: "; 
char	*v_pstr = 
	"\nEnter: (v) magnification in the vertical direction \n        {float, > 0.0 [2.000000] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vresize", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vresize.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vresize: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vresize.ans");
		}

	     }

	}

	/*
	 * allocate the vresize structure
	 */
	vresize = (vresize_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vresize_struct));

	/*
	 * get required arguments for vresize
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vresize->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vresize->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vresize->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vresize->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vresize->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vresize->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vresize->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vresize->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vresize->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vresize->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vresize
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vresize->x_flag = vget_float(fid, prompt_flag,
	"-x", x_pstr, &(vresize->x_float),
	0.000000, 1.000000, 1.000000);

	vresize->y_flag = vget_float(fid, prompt_flag,
	"-y", y_pstr, &(vresize->y_float),
	0.000000, 1.000000, 1.000000);

	vresize->h_flag = vget_float(fid, prompt_flag,
	"-h", h_pstr, &(vresize->h_float),
	2.000000, 2.000000, 2.000000);

	vresize->v_flag = vget_float(fid, prompt_flag,
	"-v", v_pstr, &(vresize->v_float),
	2.000000, 2.000000, 2.000000);


}



