 /*
  * Khoros: $Id: vreplace.c,v 1.1 1991/05/10 15:45:26 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vreplace.c,v 1.1 1991/05/10 15:45:26 khoros Exp $";
#endif

 /*
  * $Log: vreplace.c,v $
 * Revision 1.1  1991/05/10  15:45:26  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vreplace.c
 >>>>
 >>>>      Program Name: vreplace
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Replace pixels in an image with pixels  from  another  image
 >>>>	using a mask.
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:55:12 1991
 >>>>
 >>>>          Routines: main- the main program for vreplace
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vreplace.h"


/****************************************************************
 *
 * Routine Name:  main program for vreplace
 *
 *       Input:  
 *          -i1  first input image 
 *          -i2  second input image 
 *          -o  resulting output image 
 *          -m  replace operation masking image 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *img1,*img2,*img3,*images[3],*readimage();
    int  num_images, up_type;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);

    num_images = 0;              /* initialize image counter */

    img1 = readimage(vreplace->i1_file);
    if (img1 == NULL)
        exit(1);                   /* Quit if bad image */
    images[num_images++] = img1;

    img2 = readimage(vreplace->i2_file);
    if (img2 == NULL)
        exit(1);                   /* Quit if bad image */
    images[num_images++] = img2;

    img3 = readimage(vreplace->m_file);
    if (img3 == NULL)
        exit(1);                   /* Quit if bad image */
    images[num_images++] = img3;

    CHECKINPUT(program,img1,img2,img3); /* Verify input images */

    up_type = -1;       /* call lvcast with auto upconvert set */

    if (! lvcast(images, num_images, up_type) )
    {
      (void) fprintf(stderr, "ERROR: images could not be cast to the same type\n");
      exit(1);
    }

/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvreplace(img1,img2,img3) )
    {
        (void) fprintf(stderr, "lvreplace Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vreplace->o_file,img1);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vreplace 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vreplace :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tReplace pixels in an image with pixels  from  another  image\n");
	fprintf(stderr, "\tusing a mask.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  first input image  (infile)\n");
	fprintf(stderr,"\t-i2  second input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr,"\t-m  replace operation masking image  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vreplace\n");
	fprintf(stderr, "\t[-U] Gives the usage for vreplace\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vreplace.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vreplace.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vreplace
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) first input image \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) second input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*m_pstr = 
	"\nEnter: (m) replace operation masking image \n        {infile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vreplace", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vreplace.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vreplace: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vreplace.ans");
		}

	     }

	}

	/*
	 * allocate the vreplace structure
	 */
	vreplace = (vreplace_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vreplace_struct));

	/*
	 * get required arguments for vreplace
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vreplace->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(vreplace->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vreplace->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    vreplace->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(vreplace->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vreplace->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(vreplace->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vreplace->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    vreplace->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(vreplace->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vreplace->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vreplace->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vreplace->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vreplace->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vreplace->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vreplace->m_flag = vget_infile(fid, prompt_flag,
			"-m", m_pstr, &(vreplace->m_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vreplace->m_flag))
		{
		    fprintf(stderr, "\t\tm is required, please re-enter: \n");
		    vreplace->m_flag = vget_infile(fid, prompt_flag,
		    "-m", m_pstr, &(vreplace->m_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-m' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



