 /*
  * Khoros: $Id: lvshrink.c,v 1.3 1991/12/18 09:26:31 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvshrink.c,v 1.3 1991/12/18 09:26:31 dkhoros Exp $";
#endif

 /*
  * $Log: lvshrink.c,v $
 * Revision 1.3  1991/12/18  09:26:31  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvshrink.c
 >>>>
 >>>>      Program Name: vshrink
 >>>>
 >>>> Date Last Updated: Fri Nov 15 01:16:51 1991 
 >>>>
 >>>>          Routines: lvshrink - the library call for vshrink
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */

/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvshrink - library call for vshrink
*
* Purpose:
*    
*    Shrink an image by skipping pixels (subsampling)
*    
*    

* Input:
*    
*    image          pointer to xvimage structure to be processed
*    
*    scale          size reduction factor (integer),  must  be  posti-
*                   tive, non-zero
*    
*    

* Output:
*    
*    image          holds the result of  the  operation.   The  output
*                   data type is the same as the input data type.
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    

*
* Written By: Scott Wilson
*    
*    Add multiband processing, Mar/28/91, Shirley Lee
*    
*    20-May-91 Scott Wilson - corrected size calculation
*    
*    Mark Young and John Rasure fixed malloc problem for shrinking bit
*    images with an odd scale factor. Fri Nov 15 01:15:32 MST 1991
*    
*    

****************************************************************/


/* -library_def */
int
lvshrink(image,scale)
struct xvimage *image;
int  scale;
/* -library_def_end */

/* -library_code */
{

    int j,k,x,y,bands;
    char *malloc();
    unsigned char *c1,*c2,*c3;
    short *s1,*s2,*s3;
    int *i1,*i2,*i3;
    float *f1,*f2,*f3;
    int size;
    int rows,cols,nb,b;
    int xsize;
    register int  pos, n;

    if(scale < 1){
        (void) fprintf(stderr,"lvshrink: Invalid shrink factor\n");
        return(0);}

    rows = image->col_size;
    cols = image->row_size;
    nb = image->num_data_bands;
    b = rows*cols;

    switch (image->data_storage_type)
      {
        case VFF_TYP_BIT :
          n = (cols+7)/8;
          b = n*rows;
          /*  This does not give enough space size = b*nb/(scale*scale); */
          size = ceil(((double) n)/scale) * ceil(((double) rows)/scale) * nb;
          c1 = (unsigned char *)(image->imagedata);
          c2 = (unsigned char *) calloc(1,size);
          if (c2 == NULL)
          {
                fprintf(stderr,"vshrink: unable to allocate memory.\n");
                return(0);
          }
          c3 = c2;
          for (bands=0; bands<nb; bands++)
            {
              for (j = 0; j < rows; j += scale)
              {
                 pos = 0;
                 for (k = 0; k < cols; k += scale)
                 {
                    if (c1[bands*b+k/8 + n*j] & (1 << (k%8)))
                       *c3 = (*c3 | (1 << pos));
                    else
                       *c3 = (*c3 & ~(1 << pos));
    
                    if (pos == 7)
                    {
                       c3++;
                       pos = 0;
                    }
                    else pos++;
                 }

                 if (pos != 0)
                    c3++;
              }
            }
          image->row_size = cols/scale;
          image->col_size = rows/scale;
          free(image->imagedata);
          image->imagedata = (char *)c2;
          break;
        case VFF_TYP_1_BYTE : 
          size = sizeof(unsigned char)*sze(rows,scale)*sze(cols,scale)*nb;
          c1 = (unsigned char *)(image->imagedata);
          c2 = (unsigned char *)malloc(size);
          if (c2 == NULL)
          {
                fprintf(stderr,"vshrink: unable to allocate memory.\n");
                return(0);
          }
          x = 0; y = 0; c3 = c2;
          xsize = 0; 
          for (bands=0; bands<nb; bands++)
              {
              y=0;
              for (j=0; j<rows; j+=scale)
                {
                  for (k=0; k<cols; k+=scale)
                     {
                        *(c3++) = *(c1+bands*b+j*cols+k);
                        x++; xsize = x;
                     }
                x = 0;  y++;
                }
              }
          image->row_size = xsize;
          image->col_size = y;
          free(image->imagedata);
          image->imagedata = (char *)c2;
          break;
        case VFF_TYP_2_BYTE :
          size = sizeof(short)*sze(rows,scale)*sze(cols,scale)*nb;
          s1 = (short *)(image->imagedata);
          s2 = (short *)malloc(size);
          if (s2 == NULL)
          {
                fprintf(stderr,"vshrink: unable to allocate memory.\n");
                return(0);
          }
          x = 0; y = 0; s3 = s2;
          for (bands=0; bands<nb; bands++)
              {
                y=0;
                for (j=0; j<rows; j+=scale)
                  {
                    for (k=0; k<cols; k+=scale)
                      {
                        *(s3++) = *(s1+b*bands+j*cols+k);
                        x++; xsize = x;
                      }
                    x = 0; y++;
                  }
               }
          image->row_size = xsize;
          image->col_size = y;
          free(image->imagedata);
          image->imagedata = (char *)s2;
          break;
        case VFF_TYP_4_BYTE :
          size = sizeof(int)*sze(rows,scale)*sze(cols,scale)*nb;
          i1 = (int *)(image->imagedata);
          i2 = (int *)malloc(size);
          if (i2 == NULL)
          {
                fprintf(stderr,"vshrink: unable to allocate memory.\n");
                return(0);
          }
          x = 0; y = 0; i3 = i2;
          for (bands=0; bands<nb; bands++)
            {
              y=0;
              for (j=0; j<rows; j+=scale)
                {
                  for (k=0; k<cols; k+=scale)
                    {
                      *(i3++) = *(i1+b*bands+j*cols+k);
                      x++; xsize = x;
                    }
                  x = 0; y++;
                }
            }
          image->row_size = xsize;
          image->col_size = y;
          free(image->imagedata);
          image->imagedata = (char *)i2;
          break;
        case VFF_TYP_FLOAT :
          size = sizeof(float)*sze(rows,scale)*sze(cols,scale)*nb;
          f1 = (float *)(image->imagedata);
          f2 = (float *)malloc(size);
          if (f2 == NULL)
          {
                fprintf(stderr,"vshrink: unable to allocate memory.\n");
                return(0);
          }
          x = 0; y = 0; f3 = f2;
          for (bands=0; bands<nb; bands++)
            {
              y=0;
              for (j=0; j<rows; j+=scale)
                {
                  for (k=0; k<cols; k+=scale)
                    {
                      *(f3++) = *(f1+b*bands+j*cols+k);
                      x++; xsize = x;
                    }
                  x = 0; y++;
                }
            }
          image->row_size = xsize;
          image->col_size = y;
          free(image->imagedata);
          image->imagedata = (char *)f2;
          break;
        case VFF_TYP_COMPLEX :
          fprintf(stderr,"lvshrink: COMPLEX not supported (yet)\n");
          return(0);
          break;
        default:
          fprintf(stderr,"lvshrink: Unknown data storage type, %d\n",image->data_storage_type);
          return(0);
          break;
      }
      return(1);
}

static
sze(len,interval)
int len,interval;
  {
    int i;
    i = (len + (interval-1))/interval;
    return(i);
  }

/* -library_code_end */
