 /*
  * Khoros: $Id: lvresize.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvresize.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvresize.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvresize.c
 >>>>
 >>>>      Program Name: vresize
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:48:15 1991 
 >>>>
 >>>>          Routines: lvresize - the library call for vresize
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvresize - library call for vresize
*
* Purpose:
*    
*    Magnify or reduce an image using bilinear interpolation
*    
*    
* Input:
*    
*    image          pointer to xvimage structure to be processed
*    
*    hmag           magnification factor in the horizontal (X)  direc-
*                   tion (float)
*    
*    vmag           magnification factor in the vertical (Y) direction
*                   (float)
*    
*    xc             X coordinate of center of action (float)
*    
*    yc             Y coordinate of center of action (float)
*    
*    
* Output:
*    
*    image          holds the result of  the  resize  operation.   The
*                   output  data  type  is  the same as the input data
*                   type.
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    
*
* Written By: Scott Wilson
*    
*    John Rasure
*    Scott Wilson 18-Sep-90 Added multiband support
*    
*    
****************************************************************/


/* -library_def */
int
lvresize(image,hmag,vmag,xc,yc)
struct xvimage *image;
float  hmag,vmag;
float  xc,yc;
/* -library_def_end */

/* -library_code */
{
    int i,j,k,nc,nr,il,ih,jl,jh;
    float ctrx,ctry,in,jn;
    float z1,z2,z3,z4,za,zb,zp;
    char * malloc();
    unsigned char *cptr,*p;
    short *sptr,*s;
    int *iptr,*ip;
    float *fptr,*f;
    int nb,bo;

    if (hmag <= 0.0) {
        (void) fprintf(stderr,"lvresize: Cannot magnify the horizontal direction by zero!\n");
        return(0); }
    if (vmag <= 0.0) {
        (void) fprintf(stderr,"lvresize: Cannot magnify the vertical direction by zero!\n");
        return(0); }

    nc = image->row_size;
    nr = image->col_size;
    nb = image->num_data_bands;
    bo = nc*nr;
    ctrx = (nc-1)/2.0;
    ctry = (nr-1)/2.0;

    switch(image->data_storage_type)
      {
        case VFF_TYP_BIT:
          (void) fprintf(stderr,"lvresize: Cannot magnify a BIT image!\n");
          return(0);
          break;
          case VFF_TYP_1_BYTE:
          cptr = (unsigned char *)malloc(nb*nr*nc*sizeof(unsigned char));
          if (cptr == NULL)
            { 
              (void) fprintf(stderr,"lvresize: Could not allocate enough memory!\n");
              return(0);
            }
          bzero(cptr,nb*nr*nc*sizeof(unsigned char));
          p = (unsigned char *)image->imagedata;
          for (i=0; i<nr; i++)
            {
              for (j=0; j<nc; j++)
                {
                  jn = xc + (j-ctrx)/hmag; /* Note: Inverse mapping! */
                  in = yc + (i-ctry)/vmag;
                  jl = floor((double)jn);
                  jh = jl+1;
                  il = floor((double)in);
                  ih = il+1;
                  if (in >= 0 && in < nr &&
                      jn >= 0 && jn < nc &&
                      jl >= 0 && jl < nc &&
                      jh >= 0 && jh < nc &&
                      il >= 0 && il < nr &&
                      ih >= 0 && ih < nr)
                    {
                      for (k=0; k<nb; k++)
                        {
                          z1 = p[k*bo+il*nc+jl];
                          z2 = p[k*bo+il*nc+jh];
                          z3 = p[k*bo+ih*nc+jh];
                          z4 = p[k*bo+ih*nc+jl];
                          za = z1*(ih-in)+z4*(in-il);
                          zb = z2*(ih-in)+z3*(in-il);
                          zp = za*(jh-jn)+zb*(jn-jl);
                          cptr[k*bo+i*nc+j] = zp;
                        }
                    }
                }
            }
          image->imagedata = (char *)cptr;
          image->pixsizx /= hmag;
          image->pixsizy /= vmag;
          break;
        case VFF_TYP_2_BYTE:
          sptr = (short *)malloc(nb*nr*nc*sizeof(short));
          if (sptr == NULL)
            { 
              (void) fprintf(stderr,"lvresize: Could not allocate enough memory!\n");
              return(0);
            }
          bzero(sptr,nb*nr*nc*sizeof(short));
          s = (short *)image->imagedata;
          for (i=0; i<nr; i++)
            {
              for (j=0; j<nc; j++)
                {
                  jn = xc + (j-ctrx)/hmag; /* Note: Inverse mapping! */
                  in = yc + (i-ctry)/vmag;
                  jl = floor((double)jn);
                  jh = jl+1;
                  il = floor((double)in);
                  ih = il+1;
                  if (in >= 0 && in < nr &&
                      jn >= 0 && jn < nc &&
                      jl >= 0 && jl < nc &&
                      jh >= 0 && jh < nc &&
                      il >= 0 && il < nr &&
                      ih >= 0 && ih < nr)
                    {
                      for (k=0; k<nb; k++)
                        {
                          z1 = s[k*bo+il*nc+jl];
                          z2 = s[k*bo+il*nc+jh];
                          z3 = s[k*bo+ih*nc+jh];
                          z4 = s[k*bo+ih*nc+jl];
                          za = z1*(ih-in)+z4*(in-il);
                          zb = z2*(ih-in)+z3*(in-il);
                          zp = za*(jh-jn)+zb*(jn-jl);
                          sptr[k*bo+i*nc+j] = zp;
                        }
                    }
                }
            }
          image->imagedata = (char *)sptr;
          image->pixsizx /= hmag;
          image->pixsizy /= vmag;
          break;
        case VFF_TYP_4_BYTE:
          iptr = (int *)malloc(nb*nr*nc*sizeof(int));
          if (iptr == NULL)
            { 
              (void) fprintf(stderr,"lvresize: Could not allocate enough memory!\n");
              return(0);
            }
          bzero(iptr,nb*nr*nc*sizeof(int));
          ip = (int *)image->imagedata;
          for (i=0; i<nr; i++)
            {
              for (j=0; j<nc; j++)
                {
                  jn = xc + (j-ctrx)/hmag; /* Note: Inverse mapping! */
                  in = yc + (i-ctry)/vmag;
                  jl = floor((double)jn);
                  jh = jl+1;
                  il = floor((double)in);
                  ih = il+1;
                  if (in >= 0 && in < nr &&
                      jn >= 0 && jn < nc &&
                      jl >= 0 && jl < nc &&
                      jh >= 0 && jh < nc &&
                      il >= 0 && il < nr &&
                      ih >= 0 && ih < nr)
                    {
                      for (k=0; k<nb; k++)
                        {
                          z1 = ip[k*bo+il*nc+jl];
                          z2 = ip[k*bo+il*nc+jh];
                          z3 = ip[k*bo+ih*nc+jh];
                          z4 = ip[k*bo+ih*nc+jl];
                          za = z1*(ih-in)+z4*(in-il);
                          zb = z2*(ih-in)+z3*(in-il);
                          zp = za*(jh-jn)+zb*(jn-jl);
                          iptr[k*bo+i*nc+j] = zp;
                        }
                    }
                }
            }
          image->imagedata = (char *)iptr;
          image->pixsizx /= hmag;
          image->pixsizy /= vmag;
          break;
        case VFF_TYP_FLOAT:
          fptr = (float *)malloc(nb*nr*nc*sizeof(float));
          if (fptr == NULL)
            { 
              (void) fprintf(stderr,"lvresize: Could not allocate enough memory!\n");
              return(0);
            }
          bzero(fptr,nb*nr*nc*sizeof(float));
          f = (float *)image->imagedata;
          for (i=0; i<nr; i++)
            {
              for (j=0; j<nc; j++)
                {
                  jn = xc + (j-ctrx)/hmag; /* Note: Inverse mapping! */
                  in = yc + (i-ctry)/vmag;
                  jl = floor((double)jn);
                  jh = jl+1;
                  il = floor((double)in);
                  ih = il+1;
                  if (in >= 0 && in < nr &&
                      jn >= 0 && jn < nc &&
                      jl >= 0 && jl < nc &&
                      jh >= 0 && jh < nc &&
                      il >= 0 && il < nr &&
                      ih >= 0 && ih < nr)
                    {
                      for(k=0; k<nb; k++)
                        {
                          z1 = f[k*bo+il*nc+jl];
                          z2 = f[k*bo+il*nc+jh];
                          z3 = f[k*bo+ih*nc+jh];
                          z4 = f[k*bo+ih*nc+jl];
                          za = z1*(ih-in)+z4*(in-il);
                          zb = z2*(ih-in)+z3*(in-il);
                          zp = za*(jh-jn)+zb*(jn-jl);
                          fptr[k*bo+i*nc+j] = zp;
                        }
                    }
                }
            }
          image->imagedata = (char *)fptr;
          image->pixsizx /= hmag;
          image->pixsizy /= vmag;
          break;
        case VFF_TYP_COMPLEX:
        case VFF_TYP_DOUBLE:
        default:
          {
           (void)  fprintf(stderr,"lvresize: Only type not supported!\n");
            return(0);
            break;
          }
      }
      return(1);
}
/* -library_code_end */
