 /*
  * Khoros: $Id: lvmopen.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvmopen.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvmopen.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvmopen.c
 >>>>
 >>>>      Program Name: vmopen
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:31:25 1991 
 >>>>
 >>>>          Routines: lvmopen - the library call for vmopen
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvmopen - library call for vmopen
*
* Purpose:
*    
*    computes the opening of an image by a structuring element
*    
*    
* Input:
*    
*         1. image - pointer to xvimage structure
*         2. kernel- pointer to ximage structure (morhological kernel)
*    
*    
* Output:
*    
*         1. image - hold the opening of the input image by the  input
*         kernel
*    
*    
*
* Written By: Pascal ADAM
*    
*    Ghosted by Pascal ADAM Fri May 25 11:19:18 MDT 1990
*    
*    
****************************************************************/


/* -library_def */
int
lvmopen(image,kernel)
struct xvimage *image, *kernel;
/* -library_def_end */

/* -library_code */
{
int lvmerode();
int lvmdilate();

char   *program = "lvmopen";

    /* Check type,IMAGE of image */
    if (!(propertype(program, image, VFF_TYP_1_BYTE, FALSE))) {
        (void) fprintf (stderr, "\n\n%s:   ", program);
        (void) fprintf (stderr, "lvmopen: image must be of type byte\n");
        return (0);
    }
    if (!(proper_num_images (program, image, 1, FALSE))) {
        (void) fprintf (stderr, "\n\n%s:   ", program);
        (void) fprintf (stderr, "Can only work on files with one image\n\n");
        return (0);
    }
    if (!(proper_num_bands (program, image, 1, FALSE))) {
        (void) fprintf (stderr,"\n\n%s:   ", program);
        (void) fprintf (stderr,"Can only work on images with 1 data band\n\n");
        return (0);
    }


    /* Check type,KERNEL of image */
    if (!(propertype(program, kernel, VFF_TYP_1_BYTE, FALSE))) {
        (void) fprintf (stderr,"\n\n%s:   ", program);
        (void) fprintf (stderr,"lvmopen: image must be of type byte/n");
        return (0);
    }
    if (!(proper_num_images (program, kernel, 1, FALSE))) {
        (void) fprintf (stderr,"\n\n%s:   ", program);
        (void) fprintf (stderr,"Can only work on files with one image\n\n");
        return (0);
    }
    if (!(proper_num_bands (program, kernel, 1, FALSE))) {
        (void) fprintf (stderr,"\n\n%s:   ", program);
        (void) fprintf (stderr,"Can only work on images with 1 data band\n\n");
        return (0);
    }

    if(! lvmerode(image,kernel))
    {
        (void) fprintf(stderr, "vmopen : lvmerode Failed\n");
        return(0);
    }

    if(! lvmdilate(image,kernel))
    {
        (void) fprintf(stderr, "vmopen : lvmdilate Failed\n");
        return(0);
    }


    return(1);
}
/* -library_code_end */
