 /*
  * Khoros: $Id: lvinverse.c,v 1.2 1992/03/20 23:06:15 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvinverse.c,v 1.2 1992/03/20 23:06:15 dkhoros Exp $";
#endif

 /*
  * $Log: lvinverse.c,v $
 * Revision 1.2  1992/03/20  23:06:15  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvinverse.c
 >>>>
 >>>>      Program Name: vinverse
 >>>>
 >>>> Date Last Updated: Mon Mar  9 18:44:00 1992 
 >>>>
 >>>>          Routines: lvinverse - the library call for vinverse
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvinverse - library call for vinverse
*
* Purpose:
*    
*    Perform  image  restoration  by  inverse  filtering  in  the
*    frequency domain.
*    
*    

* Input:
*    
*         1. f1 --  first  xvimage  structure;  FFT  of  image  to  be
*         restored
*         2. f2 -- second xvimage structure; FFT of reference image
*                  (optional)
*         3. f3 -- third xvimage structure; FFT of PSF function
*         4. bflg -- a flag set if reference image is available
*         5. thresh -- minimum PSF threshold (optional)
*    
*         The input xvimage structures must be of the same  data  type
*         and size.
*    
*    

* Output:
*    
*         1. f1 -- holds the result of the inverse filtering
*                  operation.
*         2. f3 -- holds the effective Point Spread Function
*                  (PSF) xvimage structure.
*    
*         The output data type is the same as the input data type.
*    
*         f1 is used for both the input xvimage structure and the out-
*         put result xvimage structure. This is done to save space.
*    
*         lvinverse returns a zero upon failure and a  one  upon  suc-
*         cess.
*    
*    

*
* Written By: Scott Wilson
*    
*    Scott Wilson - Removed redundant call to cang(),  added  if()  on
*    p2+=2 21-Aug-90
*    
*    Scott Wilson - 27-Jan-91 - Removed FFT data type processing
*    
*    

****************************************************************/


/* -library_def */
int
lvinverse(f1,f2,f3,bflg,thresh)
struct xvimage *f1, *f2, *f3;
int  bflg;
float thresh;
/* -library_def_end */

/* -library_code */
{
    int    i,j;
    float  *p1,*p2,*p3;
    double a;
    float  tr,ti,r1,i1,r2,i2;

    if (f1->row_size != f3->row_size || f1->col_size != f3->col_size
        || (bflg && (f1->row_size != f2->row_size))
        || (bflg && (f1->col_size != f2->col_size)))
    {
        (void) fprintf(stderr,"lvinverse: Input images are of different size!\n");
        return(0);
    }

    if (f1->data_storage_type != VFF_TYP_COMPLEX ||
        f3->data_storage_type != VFF_TYP_COMPLEX ||
        (bflg && (f2->data_storage_type != VFF_TYP_COMPLEX)))
    {
        (void) fprintf(stderr,"lvinverse: Input images must be VFF_TYP_COMPLEX!\n");
        return(0);
    }

    p1 = (float *)(f1->imagedata);
    if (bflg) 
    {
       p2 = (float *)(f2->imagedata);
    }
    p3 = (float *)(f3->imagedata);

    for (i = 0; i < f1->col_size; i++)             /* Rows of FFT */
    { 
        for (j = 0; j < f1->row_size; j++)
        {
            if (vcabs(*p3,*(p3+1)) > thresh)
            {
                tr = *p3;
                ti = *(p3+1);
            }
            else
            {
                a = cang(*p3,*(p3+1));
                tr = cos(a)*thresh;
                ti = sin(a)*thresh;
             }
            *p3 = tr;                        /* Save effective PSF */
            *(p3+1) = ti;
            r1 = *p1;                        /* Get source image */
            if (bflg) r1 -= *p2;             /* and subtract ref if needed */
            i1 = *(p1+1);
            if (bflg) i1 -= *(p2+1);
            cdiv(&r2,&i2,r1,i1,tr,ti);       /* Perform division */
            *p1 = r2;                        /* Save result image */
            *(p1+1) = i2;
            p1 += 2;
            if (bflg) p2 += 2;
            p3 += 2;
        }
    }
    return(1);
}
/* -library_code_end */
